/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.firmware.model;

import com.jgoodies.binding.beans.Model;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.exchange.firmware.FilenameType;
import org.bidib.jbidibc.exchange.firmware.FirmwareStatusType;
import org.bidib.wizard.mvc.firmware.model.FirmwareRepoEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirmwareUpdateModel
extends Model {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(FirmwareUpdateModel.class);
    public static final String PROPERTYNAME_NODE_NAME = "nodeName";
    public static final String PROPERTYNAME_PRODUCT_NAME = "productName";
    public static final String PROPERTYNAME_UUID = "uuid";
    public static final String PROPERTYNAME_INSTALLED_VERSION = "installedVersion";
    public static final String PROPERTYNAME_SELECTED_ARCHIVE = "firmwareArchivePath";
    public static final String PROPERTYNAME_SELECTED_ARCHIVE_NAME = "firmwareArchiveName";
    public static final String PROPERTYNAME_SELECTED_UPDATES = "selectedUpdates";
    public static final String PROPERTYNAME_EXPERT_MODE = "expertMode";
    public static final String PROPERTYNAME_CAN_UPDATE = "canUpdate";
    public static final String PROPERTYNAME_NODE_LOST = "nodeLost";
    public static final String PROPERTYNAME_CV_DEFINITION_FILES = "cvDefinitionFiles";
    public static final String PROPERTYNAME_DEFAULT_LABELS_FILES = "defaultLabelsFiles";
    public static final String PROPERTYNAME_UPDATE_VERSION = "updateVersion";
    public static final String PROPERTYNAME_FIRMWARE_STATUS = "firmwareStatus";
    public static final String PROPERTYNAME_VENDOR_IMAGE_FILES = "vendorImageFiles";
    public static final String PROPERTYNAME_REPO_ENTRY = "repoEntry";
    private String nodeName;
    private String productName;
    private String uuid;
    private String installedVersion;
    private String firmwareArchivePath;
    private String firmwareArchiveName;
    private List<String> selectedUpdates;
    private boolean expertMode;
    private boolean firmwareUpdateInProgress;
    private boolean firmwareFilesSelected;
    private boolean nodeLost;
    private List<String> cvDefinitionFiles;
    private List<FilenameType> defaultLabelsFiles;
    private List<String> vendorImageFiles;
    private FirmwareRepoEntry repoEntry;
    private String updateVersion;
    private FirmwareStatusType firmwareStatus;

    public boolean isFirmwareUpdateInProgress() {
        return this.firmwareUpdateInProgress;
    }

    public void setFirmwareUpdateInProgress(boolean firmwareUpdateInProgress) {
        boolean oldCanUpdate = this.isCanUpdate();
        LOGGER.info("Set the new firmwareUpdateInProgress value: {}, old: {} ", (Object)firmwareUpdateInProgress, (Object)this.firmwareUpdateInProgress);
        this.firmwareUpdateInProgress = firmwareUpdateInProgress;
        this.fireCanUpdate(oldCanUpdate);
    }

    public boolean isFirmwareFilesSelected() {
        return this.firmwareFilesSelected;
    }

    public void setFirmwareFilesSelected(boolean firmwareFilesSelected) {
        boolean oldCanUpdate = this.isCanUpdate();
        this.firmwareFilesSelected = firmwareFilesSelected;
        this.fireCanUpdate(oldCanUpdate);
    }

    private void fireCanUpdate(boolean oldValue) {
        LOGGER.info("fire canUpdate, oldValue: {}", (Object)oldValue);
        this.firePropertyChange(PROPERTYNAME_CAN_UPDATE, oldValue, this.isCanUpdate());
    }

    public boolean isCanUpdate() {
        boolean isCanUpdate = StringUtils.isNotBlank((CharSequence)this.firmwareArchiveName) && !this.firmwareUpdateInProgress && this.firmwareFilesSelected && !this.nodeLost;
        LOGGER.info("Current isCanUpdate: {}", (Object)isCanUpdate);
        return isCanUpdate;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        String oldValue = this.nodeName;
        this.nodeName = nodeName;
        this.firePropertyChange(PROPERTYNAME_NODE_NAME, (Object)oldValue, (Object)nodeName);
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        String oldValue = this.productName;
        this.productName = productName;
        this.firePropertyChange(PROPERTYNAME_PRODUCT_NAME, (Object)oldValue, (Object)productName);
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        String oldValue = this.uuid;
        this.uuid = uuid;
        this.firePropertyChange(PROPERTYNAME_UUID, (Object)oldValue, (Object)uuid);
    }

    public String getInstalledVersion() {
        return this.installedVersion;
    }

    public void setInstalledVersion(String installedVersion) {
        String oldValue = this.installedVersion;
        this.installedVersion = installedVersion;
        this.firePropertyChange(PROPERTYNAME_INSTALLED_VERSION, (Object)oldValue, (Object)installedVersion);
    }

    public String getFirmwareArchivePath() {
        return this.firmwareArchivePath;
    }

    public void setFirmwareArchivePath(String firmwareArchivePath) {
        String oldValue = this.firmwareArchivePath;
        this.firmwareArchivePath = firmwareArchivePath;
        this.firePropertyChange(PROPERTYNAME_SELECTED_ARCHIVE, (Object)oldValue, (Object)firmwareArchivePath);
        this.setFirmwareArchiveName(FilenameUtils.getName((String)firmwareArchivePath));
    }

    public String getFirmwareArchiveName() {
        return this.firmwareArchiveName;
    }

    public void setFirmwareArchiveName(String firmwareArchiveName) {
        boolean oldCanUpdate = this.isCanUpdate();
        String oldValue = this.firmwareArchiveName;
        this.firmwareArchiveName = firmwareArchiveName;
        this.firePropertyChange(PROPERTYNAME_SELECTED_ARCHIVE_NAME, (Object)oldValue, (Object)firmwareArchiveName);
        this.fireCanUpdate(oldCanUpdate);
    }

    public List<String> getSelectedUpdates() {
        return this.selectedUpdates;
    }

    public void setSelectedUpdates(List<String> selectedUpdates) {
        boolean oldCanUpdate = this.isCanUpdate();
        List oldValue = this.selectedUpdates;
        this.selectedUpdates = selectedUpdates;
        this.firePropertyChange(PROPERTYNAME_SELECTED_UPDATES, (Object)oldValue, selectedUpdates);
        this.fireCanUpdate(oldCanUpdate);
    }

    public boolean isExpertMode() {
        return this.expertMode;
    }

    public void setExpertMode(boolean expertMode) {
        boolean oldValue = this.expertMode;
        this.expertMode = expertMode;
        this.firePropertyChange(PROPERTYNAME_EXPERT_MODE, oldValue, expertMode);
    }

    public boolean isNodeLost() {
        return this.nodeLost;
    }

    public void setNodeLost(boolean nodeLost) {
        boolean oldCanUpdate = this.isCanUpdate();
        boolean oldValue = this.nodeLost;
        this.nodeLost = nodeLost;
        this.firePropertyChange(PROPERTYNAME_NODE_LOST, (Object)oldValue, (Object)this.selectedUpdates);
        this.fireCanUpdate(oldCanUpdate);
    }

    public List<String> getCvDefinitionFiles() {
        if (this.cvDefinitionFiles == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.cvDefinitionFiles);
    }

    public void setCvDefinitionFiles(List<String> cvDefinitionFiles) {
        List oldValue = this.cvDefinitionFiles;
        this.cvDefinitionFiles = cvDefinitionFiles;
        this.firePropertyChange(PROPERTYNAME_CV_DEFINITION_FILES, (Object)oldValue, cvDefinitionFiles);
    }

    public List<FilenameType> getDefaultLabelsFiles() {
        return this.defaultLabelsFiles;
    }

    public void setDefaultLabelsFiles(List<FilenameType> defaultLabelsFiles) {
        List oldValue = this.defaultLabelsFiles;
        this.defaultLabelsFiles = defaultLabelsFiles;
        this.firePropertyChange(PROPERTYNAME_DEFAULT_LABELS_FILES, (Object)oldValue, defaultLabelsFiles);
    }

    public List<String> getVendorImageFiles() {
        if (this.vendorImageFiles == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.vendorImageFiles);
    }

    public void setVendorImageFiles(List<String> vendorImageFiles) {
        List oldValue = this.vendorImageFiles;
        this.vendorImageFiles = vendorImageFiles;
        this.firePropertyChange(PROPERTYNAME_VENDOR_IMAGE_FILES, (Object)oldValue, vendorImageFiles);
    }

    public FirmwareRepoEntry getRepoEntry() {
        return this.repoEntry;
    }

    public void setRepoEntry(FirmwareRepoEntry repoEntry) {
        FirmwareRepoEntry oldValue = this.repoEntry;
        this.repoEntry = repoEntry;
        this.firePropertyChange(PROPERTYNAME_REPO_ENTRY, (Object)oldValue, (Object)repoEntry);
    }

    public String getUpdateVersion() {
        return this.updateVersion;
    }

    public void setUpdateVersion(String updateVersion) {
        String oldValue = this.updateVersion;
        this.updateVersion = updateVersion;
        this.firePropertyChange(PROPERTYNAME_UPDATE_VERSION, (Object)oldValue, (Object)updateVersion);
    }

    public FirmwareStatusType getFirmwareStatus() {
        return this.firmwareStatus;
    }

    public void setFirmwareStatus(FirmwareStatusType firmwareStatus) {
        FirmwareStatusType oldValue = this.firmwareStatus;
        this.firmwareStatus = firmwareStatus;
        this.firePropertyChange(PROPERTYNAME_FIRMWARE_STATUS, (Object)oldValue, (Object)firmwareStatus);
    }
}

