/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.firmware.view.panel;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.api.json.types.firmware.FirmwareVersionType;
import org.bidib.jbidibc.exchange.bidib.FirmwareFactory;
import org.bidib.jbidibc.exchange.firmware.DeviceNode;
import org.bidib.jbidibc.exchange.firmware.Firmware;
import org.bidib.jbidibc.exchange.firmware.FirmwareDefinitionType;
import org.bidib.jbidibc.exchange.firmware.FirmwareNode;
import org.bidib.jbidibc.exchange.firmware.FirmwareStatusType;
import org.bidib.jbidibc.exchange.firmware.ImageType;
import org.bidib.jbidibc.exchange.firmware.NodeType;
import org.bidib.jbidibc.exchange.firmware.SimpleNode;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.utils.XmlLocaleUtils;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.TaskDialogsUtils;
import org.bidib.wizard.core.model.firmware.UpdateStatus;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.mvc.common.view.checkboxtree.AddCheckBoxToTree;
import org.bidib.wizard.mvc.common.view.checkboxtree.IconCellRenderer;
import org.bidib.wizard.mvc.common.view.checkboxtree.IconData;
import org.bidib.wizard.mvc.common.view.checkboxtree.InvisibleNode;
import org.bidib.wizard.mvc.common.view.checkboxtree.InvisibleTreeModel;
import org.bidib.wizard.mvc.firmware.model.FirmwareModel;
import org.bidib.wizard.mvc.firmware.model.FirmwareRepoEntry;
import org.bidib.wizard.mvc.firmware.model.FirmwareUpdateModel;
import org.bidib.wizard.mvc.firmware.model.listener.FirmwareModelListener;
import org.bidib.wizard.mvc.firmware.view.panel.BidibFirmwareFileFilter;
import org.bidib.wizard.mvc.firmware.view.panel.DeviceData;
import org.bidib.wizard.mvc.firmware.view.panel.FirmwareData;
import org.bidib.wizard.mvc.firmware.view.panel.FirmwareRepoEntryRenderer;
import org.bidib.wizard.mvc.firmware.view.panel.FirmwareUpdateIconConverter;
import org.bidib.wizard.mvc.firmware.view.panel.FirmwareUpdatePanel;
import org.bidib.wizard.mvc.firmware.view.panel.FirmwareUpdateStateConverter;
import org.oxbow.swingbits.dialog.task.TaskDialog;
import org.oxbow.swingbits.list.CheckList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class FirmwareUpdatePanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(FirmwareUpdatePanel.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, fill:50dlu:grow, 3dlu, pref";
    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, 100dlu, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, fill:100dlu:grow, 3dlu, pref, 3dlu, pref";
    private static final String NEWLINE = "\n";
    private static final String TOP_NODE_TEXT = "Firmware";
    private ValueModel nodeNameValueModel;
    private ValueModel productNameValueModel;
    private ValueModel uuidValueModel;
    private ValueModel versionValueModel;
    private ValueModel selectedFileValueModel;
    private final JButton selectFirmwareButton = new JButton(Resources.getString(this.getClass(), (String)"select-firmware"));
    private final JProgressBar progressBar = new JProgressBar(0, 100);
    private final JButton startButton = new JButton(Resources.getString(this.getClass(), (String)"startUpdate"));
    private final JButton clearButton = new JButton(Resources.getString(this.getClass(), (String)"clearLogArea"));
    private JButton closeButton;
    public static final ImageIcon ICON_FIRMWARE = new ImageIcon("");
    private ValueModel currentOperationModel;
    private JLabel currentOperationLabel;
    private JTree firmwareTree;
    private DefaultTreeModel firmwareTreeModel;
    private AddCheckBoxToTree addCheckBoxToTree = new AddCheckBoxToTree();
    private AddCheckBoxToTree.CheckTreeManager checkTreeManager;
    private JComboBox<FirmwareRepoEntry> comboRepoEntry;
    private JTextPane loggerArea;
    private SimpleAttributeSet[] attrs;
    private FirmwareUpdateModel firmwareUpdateModel = new FirmwareUpdateModel();
    private FirmwareModel firmwareModel;
    private JPanel contentPanel;
    private final SettingsService settingsService;

    public FirmwareUpdatePanel(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    public FirmwareModel getFirmwareModel() {
        return this.firmwareModel;
    }

    public void setFirmwareModel(FirmwareModel firmwareModel) {
        this.firmwareModel = firmwareModel;
        this.firmwareUpdateModel.setNodeName(firmwareModel.getNodeName());
        this.firmwareUpdateModel.setProductName(firmwareModel.getProductName());
        this.firmwareUpdateModel.setUuid(firmwareModel.getUniqueId());
        this.firmwareUpdateModel.setInstalledVersion(firmwareModel.getNodeCurrentVersion());
        firmwareModel.addPropertyChangeListener("inProgress", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        firmwareModel.addPropertyChangeListener("updateStatus", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        firmwareModel.addFirmwareModelListener((FirmwareModelListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setCloseButton(JButton closeButton) {
        this.closeButton = closeButton;
    }

    public JPanel createPanel() {
        String firmwareArchivePath;
        Object panel;
        FormBuilder builder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel();
            builder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            builder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        builder.border((Border)Paddings.DIALOG);
        int row = 1;
        builder.addSeparator(Resources.getString(this.getClass(), (String)"node-info"), new Object[0]).xyw(1, row, 5);
        this.nodeNameValueModel = new PropertyAdapter((Object)this.firmwareUpdateModel, "nodeName", true);
        JTextField nodeNameText = WizardComponentFactory.createTextField((ValueModel)this.nodeNameValueModel, (boolean)true);
        nodeNameText.setEditable(false);
        builder.add(Resources.getString(this.getClass(), (String)"name"), new Object[0]).xy(1, row += 2);
        builder.add((Component)nodeNameText).xyw(3, row, 3);
        this.productNameValueModel = new PropertyAdapter((Object)this.firmwareUpdateModel, "productName", true);
        JTextField productNameText = WizardComponentFactory.createTextField((ValueModel)this.productNameValueModel, (boolean)true);
        productNameText.setEditable(false);
        builder.add(Resources.getString(this.getClass(), (String)"productname"), new Object[0]).xy(1, row += 2);
        builder.add((Component)productNameText).xyw(3, row, 3);
        this.uuidValueModel = new PropertyAdapter((Object)this.firmwareUpdateModel, "uuid", true);
        JTextField uuidText = WizardComponentFactory.createTextField((ValueModel)this.uuidValueModel, (boolean)true);
        uuidText.setEditable(false);
        builder.add(Resources.getString(this.getClass(), (String)"uuid"), new Object[0]).xy(1, row += 2);
        builder.add((Component)uuidText).xyw(3, row, 3);
        this.versionValueModel = new PropertyAdapter((Object)this.firmwareUpdateModel, "installedVersion", true);
        JTextField versionText = WizardComponentFactory.createTextField((ValueModel)this.versionValueModel, (boolean)true);
        versionText.setEditable(false);
        builder.add(Resources.getString(this.getClass(), (String)"firmware"), new Object[0]).xy(1, row += 2);
        builder.add((Component)versionText).xyw(3, row, 3);
        builder.addSeparator(Resources.getString(this.getClass(), (String)"firmware-update"), new Object[0]).xyw(1, row += 2, 5);
        builder.add(Resources.getString(this.getClass(), (String)"repository"), new Object[0]).xy(1, row += 2);
        FirmwareVersionType.FirmwareStatusType thresholdLevel = this.settingsService.getFirmwareRepoSettings().getFirmwareStatusLevel();
        LinkedList<FirmwareRepoEntry> firmwareRepoEntries = new LinkedList<FirmwareRepoEntry>();
        for (FirmwareDefinitionType firmwareDefinition : this.firmwareModel.getFirmwareDefinitions()) {
            if (firmwareDefinition.getStatus().ordinal() >= thresholdLevel.ordinal()) {
                LOGGER.info("Add firmwareDefinition: {}", (Object)firmwareDefinition);
                firmwareRepoEntries.add(new FirmwareRepoEntry(new FirmwareDefinitionType().withFirmwareArchive(firmwareDefinition.getFirmwareArchive()).withVersion(firmwareDefinition.getVersion()).withStatus(firmwareDefinition.getStatus())));
                continue;
            }
            LOGGER.warn("Skip firmwareDefinition because threshld level exceeded: {}", (Object)firmwareDefinition);
        }
        Collections.sort(firmwareRepoEntries, (o1, o2) -> o2.getFirmwareDefintion().getVersion().compareTo(o1.getFirmwareDefintion().getVersion()));
        SelectionInList repoEntrySelection = new SelectionInList(firmwareRepoEntries);
        PropertyAdapter selectionHolderRepoEntry = new PropertyAdapter((Object)this.firmwareUpdateModel, "repoEntry", true);
        ComboBoxAdapter comboBoxAdapterRepoEntry = new ComboBoxAdapter((ListModel)repoEntrySelection, (ValueModel)selectionHolderRepoEntry);
        this.comboRepoEntry = new JComboBox();
        this.comboRepoEntry.setModel(comboBoxAdapterRepoEntry);
        this.comboRepoEntry.setRenderer(new FirmwareRepoEntryRenderer());
        if (!firmwareRepoEntries.isEmpty()) {
            FirmwareDefinitionType selectedFirmwareDefinition = this.firmwareModel.getSelectedFirmware();
            if (selectedFirmwareDefinition != null) {
                FirmwareRepoEntry selectedEntry = firmwareRepoEntries.stream().filter(fre -> fre.getFirmwareDefintion().getVersion().equals(selectedFirmwareDefinition.getVersion())).findFirst().orElse(null);
                LOGGER.info("Set the selectedEntry: {}", (Object)selectedEntry);
                this.comboRepoEntry.setSelectedItem(selectedEntry);
            } else {
                this.comboRepoEntry.setSelectedIndex(0);
            }
        }
        builder.add((Component)this.comboRepoEntry).xyw(3, row, 3);
        this.selectedFileValueModel = new PropertyAdapter((Object)this.firmwareUpdateModel, "firmwareArchiveName", true);
        JTextField selectedFileText = WizardComponentFactory.createTextField((ValueModel)this.selectedFileValueModel, (boolean)true);
        selectedFileText.setEditable(false);
        builder.add(Resources.getString(this.getClass(), (String)"file"), new Object[0]).xy(1, row += 2);
        builder.add((Component)selectedFileText).xy(3, row);
        builder.add((Component)this.selectFirmwareButton).xy(5, row);
        row += 2;
        InvisibleNode top = new InvisibleNode((Object)new IconData((Icon)ICON_FIRMWARE, null, (Object)TOP_NODE_TEXT));
        this.firmwareTreeModel = new InvisibleTreeModel((TreeNode)top);
        this.firmwareTree = new /* Unavailable Anonymous Inner Class!! */;
        this.firmwareTree.putClientProperty("JTree.lineStyle", "Angled");
        IconCellRenderer renderer = new IconCellRenderer();
        this.firmwareTree.setCellRenderer((TreeCellRenderer)renderer);
        this.firmwareTree.getSelectionModel().setSelectionMode(1);
        this.firmwareTree.setShowsRootHandles(false);
        this.firmwareTree.setEditable(false);
        AddCheckBoxToTree addCheckBoxToTree = this.addCheckBoxToTree;
        Objects.requireNonNull(addCheckBoxToTree);
        this.checkTreeManager = new AddCheckBoxToTree.CheckTreeManager(addCheckBoxToTree, this.firmwareTree, null);
        this.checkTreeManager.setClickInCheckBoxOnly(false);
        JScrollPane scrollTree = new JScrollPane();
        scrollTree.getViewport().add(this.firmwareTree);
        builder.add((Component)scrollTree).xyw(1, row, 5);
        PropertyAdapter exportModeValueModel = new PropertyAdapter((Object)this.firmwareUpdateModel, "expertMode", true);
        JCheckBox checkExpertMode = WizardComponentFactory.createCheckBox((ValueModel)exportModeValueModel, (String)Resources.getString(this.getClass(), (String)"expert-mode"));
        builder.add((Component)checkExpertMode).xyw(1, row += 2, 5);
        row += 2;
        this.currentOperationModel = new PropertyAdapter((Object)this.firmwareModel, "updateStatus", true);
        ConverterValueModel valueConverterModel = new ConverterValueModel(this.currentOperationModel, (BindingConverter)new FirmwareUpdateStateConverter());
        this.currentOperationLabel = WizardComponentFactory.createLabel((ValueModel)valueConverterModel);
        ConverterValueModel iconConverterModel = new ConverterValueModel(this.currentOperationModel, (BindingConverter)new FirmwareUpdateIconConverter());
        Bindings.bind((JComponent)this.currentOperationLabel, (String)"icon", (ValueModel)iconConverterModel);
        builder.add((Component)this.currentOperationLabel).xyw(1, row, 5);
        builder.add((Component)this.progressBar).xyw(1, row += 2, 3);
        this.progressBar.setStringPainted(true);
        this.startButton.setEnabled(false);
        builder.add((Component)this.startButton).xy(5, row);
        row += 2;
        this.loggerArea = new JTextPane();
        this.loggerArea.setPreferredSize(new Dimension(450, 100));
        Font font = UIManager.getDefaults().getFont("Label.font");
        this.loggerArea.setFont(font);
        this.loggerArea.setEditable(false);
        this.attrs = new SimpleAttributeSet[2];
        this.attrs[0] = new SimpleAttributeSet();
        this.attrs[1] = new SimpleAttributeSet(this.attrs[0]);
        StyleConstants.setForeground(this.attrs[1], Color.red);
        JScrollPane scrollLog = new JScrollPane();
        scrollLog.getViewport().add(this.loggerArea);
        builder.add((Component)scrollLog).xyw(1, row, 5);
        JPanel buttons = new ButtonBarBuilder().addButton((JComponent)this.clearButton).addGlue().addButton((JComponent)this.closeButton).build();
        builder.add((Component)buttons).xyw(1, row += 2, 5);
        this.selectFirmwareButton.addActionListener(evt -> this.selectFirmware());
        this.startButton.addActionListener(evt -> this.fireStart());
        this.clearButton.addActionListener(evt -> this.fireClear());
        PropertyConnector.connect((Object)this.firmwareUpdateModel, (String)"canUpdate", (Object)this.startButton, (String)"enabled");
        PropertyConnector.connect((Object)this.firmwareModel, (String)"idle", (Object)this.closeButton, (String)"enabled");
        PropertyConnector.connect((Object)this.firmwareModel, (String)"idleAndValid", (Object)this.selectFirmwareButton, (String)"enabled");
        exportModeValueModel.addValueChangeListener((PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.checkTreeManager.addPropertyChangeListener((PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.firmwareUpdateModel.addPropertyChangeListener("repoEntry", evt -> {
            FirmwareRepoEntry firmwareRepoEntry = this.firmwareUpdateModel.getRepoEntry();
            this.setSelectedFirmwareArchive(firmwareRepoEntry);
        });
        this.contentPanel = builder.build();
        FirmwareRepoEntry selectedEntry = (FirmwareRepoEntry)this.comboRepoEntry.getSelectedItem();
        if (selectedEntry != null && StringUtils.isNotBlank((CharSequence)(firmwareArchivePath = selectedEntry.getFirmwareDefintion().getFirmwareArchive()))) {
            try {
                File firmwareArchive = new File(firmwareArchivePath);
                if (firmwareArchive != null && firmwareArchive.exists()) {
                    LOGGER.info("Set the firmware archive path: {}", (Object)firmwareArchive.getPath());
                    this.prepareFirmware(firmwareArchive, null);
                    this.postPrepareFirmwareActions();
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Failed to load firmware from firmware archive: {}", (Object)firmwareArchivePath, (Object)ex);
            }
        }
        return this.contentPanel;
    }

    private void setSelectedFirmwareArchive(FirmwareRepoEntry firmwareRepoEntry) {
        File file = null;
        if (firmwareRepoEntry != null) {
            LOGGER.info("Prepare the firmware from achive: {}", (Object)firmwareRepoEntry.getFirmwareDefintion().getFirmwareArchive());
            if (StringUtils.isNotBlank((CharSequence)firmwareRepoEntry.getFirmwareDefintion().getFirmwareArchive())) {
                try {
                    file = new File(firmwareRepoEntry.getFirmwareDefintion().getFirmwareArchive());
                }
                catch (Exception ex) {
                    LOGGER.warn("Create file with firmware archive failed.", (Throwable)ex);
                }
            }
        }
        this.prepareFirmware(file, firmwareRepoEntry);
        this.postPrepareFirmwareActions();
    }

    private void hideChildren(DefaultMutableTreeNode parent, boolean expertMode) {
        Enumeration<TreeNode> e = parent.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)e.nextElement();
            if (childNode instanceof InvisibleNode) {
                InvisibleNode node = (InvisibleNode)childNode;
                LOGGER.info("Found InvisibleNode instance: {}, expertMode: {}", (Object)node, (Object)expertMode);
                if (!(node.getUserObject() instanceof DeviceData)) {
                    node.setVisible(expertMode);
                }
            }
            this.hideChildren(childNode, expertMode);
        }
    }

    private void updateTreeElementsVisibility() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.firmwareTreeModel.getRoot();
        boolean expertMode = this.firmwareUpdateModel.isExpertMode();
        LOGGER.info("Update the visibility of the tree elements, expertMode: {}", (Object)expertMode);
        this.hideChildren(root, expertMode);
        ((InvisibleTreeModel)this.firmwareTreeModel).activateFilter(!expertMode);
        this.firmwareTreeModel.reload();
        for (int i = 0; i < this.firmwareTree.getRowCount(); ++i) {
            this.firmwareTree.expandRow(i);
        }
    }

    public AddCheckBoxToTree.CheckTreeManager getCheckTreeManager() {
        return this.checkTreeManager;
    }

    private void selectFirmware() {
        BidibFirmwareFileFilter ff = new BidibFirmwareFileFilter();
        String storedWorkingDirectory = this.settingsService.getWizardSettings().getFirmwareDirectory();
        7 dialog = new /* Unavailable Anonymous Inner Class!! */;
        dialog.showDialog();
        this.postPrepareFirmwareActions();
    }

    private void postPrepareFirmwareActions() {
        LOGGER.info("Check if we have to import vendor images and CV definition files.");
        this.firmwareModel.setUpdateVersion(this.firmwareUpdateModel.getUpdateVersion());
        int result = 1;
        if (!this.firmwareModel.isPreventAskOverrideFile()) {
            if (CollectionUtils.isNotEmpty((Collection)this.firmwareUpdateModel.getCvDefinitionFiles()) || CollectionUtils.isNotEmpty((Collection)this.firmwareUpdateModel.getVendorImageFiles())) {
                result = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(this.contentPanel), Resources.getString(FirmwareUpdatePanel.class, (String)"import-vendor-files.message"), Resources.getString(FirmwareUpdatePanel.class, (String)"import-vendor-files.title"), 0);
            }
        } else {
            LOGGER.info("Do not ask if user wants to import CV definition files and vendor images.");
            result = 0;
        }
        if (CollectionUtils.isNotEmpty((Collection)this.firmwareUpdateModel.getCvDefinitionFiles()) && result == 0) {
            this.firmwareModel.setCvDefinitionFiles(this.firmwareUpdateModel.getFirmwareArchivePath(), null);
            List cvDefinitionFiles = this.firmwareUpdateModel.getCvDefinitionFiles();
            LOGGER.info("Set the CV definition files in the firmware model.");
            this.firmwareModel.setCvDefinitionFiles(this.firmwareUpdateModel.getFirmwareArchivePath(), cvDefinitionFiles);
        }
        if (result == 0 && CollectionUtils.isNotEmpty((Collection)this.firmwareUpdateModel.getDefaultLabelsFiles())) {
            this.firmwareModel.setDefaultLabelsFiles(this.firmwareUpdateModel.getFirmwareArchivePath(), this.firmwareUpdateModel.getDefaultLabelsFiles());
        }
        if (CollectionUtils.isNotEmpty((Collection)this.firmwareUpdateModel.getVendorImageFiles()) && result == 0) {
            this.firmwareModel.setVendorImageFiles(this.firmwareUpdateModel.getFirmwareArchivePath(), null);
            List vendorImageFiles = this.firmwareUpdateModel.getVendorImageFiles();
            LOGGER.info("Set the vendor image files in the firmware model.");
            this.firmwareModel.setVendorImageFiles(this.firmwareUpdateModel.getFirmwareArchivePath(), vendorImageFiles);
        }
    }

    private void prepareFirmware(File file, FirmwareRepoEntry firmwareRepoEntry) {
        this.firmwareModel.setPreventAskOverrideFile(true);
        if (file != null && file.exists()) {
            String selectedFile = file.getName();
            String extension = FilenameUtils.getExtension((String)selectedFile);
            if (!"zip".equalsIgnoreCase(extension)) {
                String[] parts = selectedFile.split("\\.");
                int destIdentifier = -1;
                try {
                    destIdentifier = Integer.parseInt(parts[parts.length - 2]);
                }
                catch (Exception ex) {
                    LOGGER.warn("Auto-detect destination for firmware failed.", (Throwable)ex);
                }
                if (destIdentifier < 0 || destIdentifier > 127) {
                    LOGGER.warn("Invalid destination detected: {}", (Object)destIdentifier);
                    Object[] options = new Object[]{"Flash", "Eeprom"};
                    int n = JOptionPane.showOptionDialog(this.contentPanel, "Select the destination.", "Firmware Update", 1, 3, null, options, options[0]);
                    switch (n) {
                        case 0: {
                            destIdentifier = 0;
                            break;
                        }
                        case 1: {
                            destIdentifier = 1;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Invalid destination detected: " + destIdentifier);
                        }
                    }
                }
                this.loadFirmware(file, destIdentifier);
            } else {
                this.loadFirmware(file);
            }
        } else {
            InvisibleNode topNode;
            DefaultMutableTreeNode top = (DefaultMutableTreeNode)this.firmwareTreeModel.getRoot();
            top.removeAllChildren();
            if (top instanceof InvisibleNode && (topNode = (InvisibleNode)top).getUserObject() instanceof IconData) {
                IconData iconData = (IconData)topNode.getUserObject();
                iconData.setObject((Object)TOP_NODE_TEXT);
            }
            this.firmwareTreeModel.reload(top);
            this.firmwareUpdateModel.setUpdateVersion("unknown");
            this.firmwareUpdateModel.setFirmwareStatus(null);
        }
        this.firmwareUpdateModel.setFirmwareArchivePath(file != null ? file.toString() : null);
        this.firmwareModel.setInProgress(false);
        this.firmwareModel.setProgressValue(0);
        this.firmwareModel.setUpdateStatus(UpdateStatus.NONE);
        if (file != null) {
            this.firmwareModel.addProcessingStatus(Resources.getString(FirmwareUpdatePanel.class, (String)"status.file-selected"), 0, new Object[]{file.toString()});
        }
        this.updateTreeElementsVisibility();
        if (file != null) {
            this.updateFirmwareDirectory(file);
        }
    }

    protected void updateFirmwareDirectory(File firmwareDirectory) {
        LOGGER.info("Update the firmware directory: {}", (Object)firmwareDirectory);
        if (firmwareDirectory != null) {
            this.settingsService.getWizardSettings().setFirmwareDirectory(firmwareDirectory.getParent());
            this.settingsService.storeSettings();
        }
    }

    private void fireClear() {
        this.loggerArea.setText(null);
    }

    private void fireStart() {
        LOGGER.info("Start was pressed.");
        TreePath[] paths = this.getCheckTreeManager().getSelectionModel().getSelectionPaths();
        if (paths != null) {
            Collection checkedItems;
            boolean result;
            Color listColor;
            CheckList checkList;
            JList list;
            TaskDialog dlg;
            String color;
            StringBuilder sb;
            LinkedList selectedNodes = new LinkedList();
            for (TreePath tp : paths) {
                LOGGER.info("Selected path is: {}", (Object)tp);
                TreeNode treeNode = (TreeNode)tp.getLastPathComponent();
                this.collectSelectedFirmwareFiles(treeNode, selectedNodes);
            }
            boolean isCompatibleFirmware = this.checkCompatibleFirmwareUpdate(selectedNodes);
            if (!isCompatibleFirmware) {
                return;
            }
            NodeInterface nodeToUpdate = this.firmwareModel.getNode();
            boolean showUnplugServoWarning = this.settingsService.getWizardSettings().isShowFirmwareUpdateUnplugServoWarning();
            boolean showFirmwareUpdateWarning = this.settingsService.getWizardSettings().isShowFirmwareUpdateWarning();
            if (showUnplugServoWarning && nodeToUpdate != null) {
                sb = new StringBuilder();
                color = String.format("#%06x", UIManager.getColor("FirmwareUpdatePanel.warn").getRGB() & 0xFFFFFF);
                sb.append("<b><font color=" + color + ">");
                if (nodeToUpdate.hasServoPorts() || ProductUtils.isOneBootloader((long)nodeToUpdate.getUniqueId())) {
                    LOGGER.info("The node to update has servo ports. Show the info to unplug the servo before update!");
                    sb.append(Resources.getString(FirmwareUpdatePanel.class, (String)"unplug-servo.message"));
                    sb.append("<br/><br/>");
                }
                sb.append(Resources.getString(FirmwareUpdatePanel.class, (String)"warning-firmware-update"));
                sb.append("</font></b><br/><br/>");
                sb.append(Resources.getString(FirmwareUpdatePanel.class, (String)"continue.message"));
                dlg = TaskDialogsUtils.questionDialog((Window)JOptionPane.getFrameForComponent(this.contentPanel), (String)Resources.getString(FirmwareUpdatePanel.class, (String)"firmware-update.title"), (Icon)TaskDialog.StandardIcon.QUESTION, (String)Resources.getString(FirmwareUpdatePanel.class, (String)"backup-node.message"), (String)sb.toString().replaceAll("\r\n", "<br/>"));
                list = new JList();
                checkList = new CheckList.Builder(list).build();
                checkList.setData(Arrays.asList(Resources.getString(FirmwareUpdatePanel.class, (String)"prevent-show-warning.choice")));
                listColor = UIManager.getColor("TaskDialog.messageBackground");
                list.setBackground(listColor);
                list.setSelectionBackground(listColor);
                list.setSelectionForeground(list.getForeground());
                dlg.setFixedComponent(list);
                result = dlg.show().equals(TaskDialog.StandardCommand.OK);
                checkedItems = checkList.getCheckedItems();
                if (!result) {
                    LOGGER.info("User cancelled update operation.");
                    return;
                }
                if (CollectionUtils.isNotEmpty((Collection)checkedItems)) {
                    LOGGER.info("User selected to no longer show the warning dialog.");
                    this.settingsService.getWizardSettings().setShowFirmwareUpdateUnplugServoWarning(false);
                    this.settingsService.storeSettings();
                }
            } else if (showFirmwareUpdateWarning) {
                sb = new StringBuilder();
                color = String.format("#%06x", UIManager.getColor("FirmwareUpdatePanel.warn").getRGB() & 0xFFFFFF);
                sb.append("<b><font color=" + color + ">");
                sb.append(Resources.getString(FirmwareUpdatePanel.class, (String)"warning-firmware-update"));
                sb.append("</font></b><br/><br/>");
                sb.append(Resources.getString(FirmwareUpdatePanel.class, (String)"continue.message"));
                dlg = TaskDialogsUtils.questionDialog((Window)JOptionPane.getFrameForComponent(this.contentPanel), (String)Resources.getString(FirmwareUpdatePanel.class, (String)"firmware-update.title"), (Icon)TaskDialog.StandardIcon.QUESTION, (String)Resources.getString(FirmwareUpdatePanel.class, (String)"backup-node.message"), (String)sb.toString().replaceAll("\r\n", "<br/>"));
                list = new JList();
                checkList = new CheckList.Builder(list).build();
                checkList.setData(Arrays.asList(Resources.getString(FirmwareUpdatePanel.class, (String)"prevent-show-warning.choice")));
                listColor = UIManager.getColor("TaskDialog.messageBackground");
                list.setBackground(listColor);
                list.setSelectionBackground(listColor);
                list.setSelectionForeground(list.getForeground());
                dlg.setFixedComponent(list);
                result = dlg.show().equals(TaskDialog.StandardCommand.OK);
                checkedItems = checkList.getCheckedItems();
                if (!result) {
                    LOGGER.info("User cancelled update operation.");
                    return;
                }
                if (CollectionUtils.isNotEmpty((Collection)checkedItems)) {
                    LOGGER.info("User selected to no longer show the firmware update warning dialog.");
                    this.settingsService.getWizardSettings().setShowFirmwareUpdateWarning(false);
                    this.settingsService.storeSettings();
                }
            }
            LOGGER.info("Selected firmware nodes: {}", selectedNodes);
            for (FirmwareNode node : selectedNodes) {
                this.addLogText(Resources.getString(FirmwareUpdatePanel.class, (String)"status.selected-dest"), 0, new Object[]{node.getDestinationNumber(), node.getFilename()});
            }
            if (CollectionUtils.isNotEmpty(selectedNodes)) {
                LOGGER.info("Set the firmware update files in the firmware model.");
                this.firmwareModel.setInProgress(true);
                this.firmwareModel.setFirmwareFiles(this.firmwareUpdateModel.getFirmwareArchivePath(), selectedNodes);
            }
        }
    }

    private boolean checkCompatibleFirmwareUpdate(List<FirmwareNode> selectedNodes) {
        boolean isCompatibleFirmware = true;
        for (FirmwareNode node : selectedNodes) {
            if (!node.getFilename().toLowerCase().contains("update")) continue;
            long uniqueId = this.firmwareModel.getNode().getUniqueId();
            if (ProductUtils.isLightControl((long)uniqueId)) {
                if (node.getFilename().toLowerCase().contains("standard")) {
                    if (this.firmwareModel.getNode().getStorableMacroCount() == 40) continue;
                    isCompatibleFirmware = false;
                    LOGGER.warn("The selected firmware update does not match the installed firmware.");
                    this.addLogText(Resources.getString(FirmwareUpdatePanel.class, (String)"selected-firmware-incompatible"), 1, new Object[]{"SIGNALS"});
                    continue;
                }
                if (this.firmwareModel.getNode().getStorableMacroCount() == 64) continue;
                isCompatibleFirmware = false;
                LOGGER.warn("The selected firmware update does not match the installed firmware.");
                this.addLogText(Resources.getString(FirmwareUpdatePanel.class, (String)"selected-firmware-incompatible"), 1, new Object[]{"STANDARD"});
                continue;
            }
            if (!ProductUtils.isNeoControl((long)uniqueId)) continue;
            if (node.getFilename().toLowerCase().contains("light")) {
                if (this.firmwareModel.getNode().getStorableMacroCount() == 32) continue;
                isCompatibleFirmware = false;
                LOGGER.warn("The selected firmware update does not match the installed firmware.");
                this.addLogText(Resources.getString(FirmwareUpdatePanel.class, (String)"selected-firmware-incompatible"), 1, new Object[]{"SIGNAL"});
                continue;
            }
            if (this.firmwareModel.getNode().getStorableMacroCount() == 80) continue;
            isCompatibleFirmware = false;
            LOGGER.warn("The selected firmware update does not match the installed firmware.");
            this.addLogText(Resources.getString(FirmwareUpdatePanel.class, (String)"selected-firmware-incompatible"), 1, new Object[]{"STANDARD"});
        }
        return isCompatibleFirmware;
    }

    private void collectSelectedFirmwareFiles(TreeNode treeNode, List<FirmwareNode> selectedNodes) {
        DefaultMutableTreeNode mutableChild;
        if (!treeNode.isLeaf()) {
            LOGGER.info("The current treeNode is not a leaf: {}", (Object)treeNode);
            for (int index = 0; index < treeNode.getChildCount(); ++index) {
                TreeNode child = treeNode.getChildAt(index);
                LOGGER.info("The current child: {}", (Object)child);
                if (child instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode mutableChild2 = (DefaultMutableTreeNode)child;
                    if (mutableChild2.getUserObject() instanceof FirmwareData) {
                        FirmwareData firmwareData = (FirmwareData)mutableChild2.getUserObject();
                        LOGGER.info("The current node has firmware data: {}", (Object)firmwareData.getFirmwareNode());
                        selectedNodes.add(firmwareData.getFirmwareNode());
                        continue;
                    }
                    this.collectSelectedFirmwareFiles(child, selectedNodes);
                    continue;
                }
                this.collectSelectedFirmwareFiles(child, selectedNodes);
            }
        } else if (treeNode instanceof DefaultMutableTreeNode && (mutableChild = (DefaultMutableTreeNode)treeNode).getUserObject() instanceof FirmwareData) {
            FirmwareData firmwareData = (FirmwareData)mutableChild.getUserObject();
            LOGGER.info("The current node has firmware data: {}", (Object)firmwareData.getFirmwareNode());
            selectedNodes.add(firmwareData.getFirmwareNode());
        }
    }

    public void addLogText(String logLine, int style, Object ... args) {
        LOGGER.info("Add text to loggerArea, logLine: {}, args: {}", (Object)logLine, (Object)args);
        if (args != null) {
            logLine = MessageFormatter.arrayFormat((String)logLine, (Object[])args).getMessage();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS - ");
        StringBuffer message = new StringBuffer(sdf.format(new Date()));
        message.append(logLine).append(NEWLINE);
        if (SwingUtilities.isEventDispatchThread()) {
            StyledDocument doc = this.loggerArea.getStyledDocument();
            try {
                doc.insertString(doc.getLength(), message.toString(), this.attrs[style]);
            }
            catch (Exception ex) {
                LOGGER.warn("Add new log text failed.");
            }
            this.loggerArea.setCaretPosition(this.loggerArea.getDocument().getLength());
        } else {
            SwingUtilities.invokeLater(() -> {
                StyledDocument doc = this.loggerArea.getStyledDocument();
                try {
                    doc.insertString(doc.getLength(), message.toString(), this.attrs[style]);
                }
                catch (Exception ex) {
                    LOGGER.warn("Add new log text failed.");
                }
                this.loggerArea.setCaretPosition(this.loggerArea.getDocument().getLength());
            });
        }
    }

    public void loadFirmware(File firmwareFile) {
        LOGGER.info("Load firmware from firmwareFile: {}", (Object)firmwareFile);
        String lang = XmlLocaleUtils.getXmlLocaleVendorCV();
        DefaultMutableTreeNode top = (DefaultMutableTreeNode)this.firmwareTreeModel.getRoot();
        top.removeAllChildren();
        Firmware firmware = FirmwareFactory.createInstance().getFirmware(firmwareFile);
        if (firmware != null && firmware.getFirmwareDefinition() != null) {
            List cvFilenamesLegacy;
            InvisibleNode topNode;
            this.firmwareUpdateModel.setUpdateVersion("unknown");
            this.firmwareUpdateModel.setFirmwareStatus(null);
            ArrayList<String> vendorImageFilenames = new ArrayList<String>();
            ArrayList<String> cvFilenames = new ArrayList<String>();
            FirmwareDefinitionType firmwareDefinition = firmware.getFirmwareDefinition();
            Optional<String> firmwareVersion = Optional.ofNullable(firmwareDefinition.getVersion());
            FirmwareStatusType firmwareStatus = Optional.ofNullable(firmwareDefinition.getStatus()).orElse(FirmwareStatusType.STABLE);
            this.firmwareUpdateModel.setFirmwareStatus(firmwareStatus);
            List nodes = firmwareDefinition.getNode();
            for (NodeType node : nodes) {
                if (!(node instanceof DeviceNode)) continue;
                DeviceNode deviceNode = (DeviceNode)node;
                DefaultMutableTreeNode deviceNodeItem = this.createDeviceNode(top, deviceNode, lang);
                top.add(deviceNodeItem);
                if (firmwareVersion.isPresent()) {
                    this.firmwareUpdateModel.setUpdateVersion(firmwareVersion.get());
                } else {
                    for (NodeType firmwareNode : deviceNode.getNode()) {
                        if (!(firmwareNode instanceof FirmwareNode)) continue;
                        FirmwareNode fwNode = (FirmwareNode)firmwareNode;
                        String filename = fwNode.getFilename();
                        try {
                            String[] parts = filename.split("[-]|[_]|[ ]");
                            LOGGER.info("Current parts: {}, from filename: {}", (Object)new Object[]{parts}, (Object)filename);
                            if (parts[parts.length - 1].indexOf(".000") < 0) continue;
                            String version = parts[parts.length - 1].substring(0, parts[parts.length - 1].indexOf(".000"));
                            LOGGER.info("Found update version: {}", (Object)version);
                            this.firmwareUpdateModel.setUpdateVersion(version);
                            break;
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Find update version in name of firmware file failed.", (Throwable)ex);
                        }
                    }
                }
                if (deviceNode.getCvFilename() != null && StringUtils.isNotBlank((CharSequence)deviceNode.getCvFilename().getValue())) {
                    cvFilenames.add(deviceNode.getCvFilename().getValue());
                }
                if (deviceNode.getNodeImages() == null || !CollectionUtils.isNotEmpty((Collection)deviceNode.getNodeImages().getImage())) continue;
                for (ImageType image : deviceNode.getNodeImages().getImage()) {
                    LOGGER.info("Add node image: {}", (Object)image);
                    vendorImageFilenames.add(image.getValue());
                }
            }
            if (top instanceof InvisibleNode && (topNode = (InvisibleNode)top).getUserObject() instanceof IconData) {
                IconData iconData = (IconData)topNode.getUserObject();
                iconData.setObject((Object)("Firmware, Version: " + this.firmwareUpdateModel.getUpdateVersion() + ", Status: " + firmwareStatus.name()));
            }
            if (CollectionUtils.isNotEmpty((Collection)(cvFilenamesLegacy = firmwareDefinition.getCvFilename()))) {
                cvFilenames.addAll(cvFilenamesLegacy);
            }
            if (CollectionUtils.isNotEmpty(cvFilenames)) {
                this.firmwareUpdateModel.setCvDefinitionFiles(cvFilenames);
            }
            if (StringUtils.isBlank((CharSequence)this.firmwareUpdateModel.getUpdateVersion()) && firmware.getVersion() != null) {
                LOGGER.info("Set the update version: {}", (Object)firmware.getVersion());
                this.firmwareUpdateModel.setUpdateVersion(firmware.getVersion().getVersion());
            }
            if (firmwareDefinition.getDefaultLabels() != null) {
                List defaultLabelsFiles = firmwareDefinition.getDefaultLabels().getDefaultLabelsFile();
                LOGGER.info("Found default labels files: {}", (Object)defaultLabelsFiles);
                this.firmwareUpdateModel.setDefaultLabelsFiles(defaultLabelsFiles);
            }
            if (firmwareDefinition.getNodeImages() != null && CollectionUtils.isNotEmpty((Collection)firmwareDefinition.getNodeImages().getImage())) {
                for (ImageType image : firmwareDefinition.getNodeImages().getImage()) {
                    LOGGER.info("Add node image: {}", (Object)image);
                    vendorImageFilenames.add(image.getValue());
                }
            }
            if (CollectionUtils.isNotEmpty(vendorImageFilenames)) {
                this.firmwareUpdateModel.setVendorImageFiles(vendorImageFilenames);
            }
        }
        this.firmwareTreeModel.reload(top);
        for (int i = 0; i < this.firmwareTree.getRowCount(); ++i) {
            this.firmwareTree.expandRow(i);
        }
    }

    public void loadFirmware(File firmwareFile, int destination) {
        InvisibleNode topNode;
        LOGGER.info("Load firmware from single file: {}, destination: {}", (Object)firmwareFile, (Object)destination);
        String lang = XmlLocaleUtils.getXmlLocaleVendorCV();
        DefaultMutableTreeNode top = (DefaultMutableTreeNode)this.firmwareTreeModel.getRoot();
        top.removeAllChildren();
        String filename = firmwareFile.getName();
        String[] parts = filename.split("[-]|[_]|[ ]");
        LOGGER.info("prepared parts of filename: {}", Arrays.asList(parts));
        StringBuffer firmwareDescription = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        firmwareDescription.append("<Firmware xsi:schemaLocation=\"http://www.bidib.org/schema/firmware firmware.xsd\" xmlns:firmware=\"http://www.bidib.org/schema/firmware\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.bidib.org/schema/firmware\">");
        firmwareDescription.append("<Version Version=\"0.1\" Lastupdate=\"20140411\" Author=\"BiDiB.org\" Pid=\"000\" Vendor=\"013\" Description=\"Firmware Definition\"/>");
        firmwareDescription.append("<FirmwareDefinition>");
        firmwareDescription.append("<Node xsi:type=\"DeviceNode\" Comment=\"Temporary Node\" VID=\"013\" PID=\"000\" >");
        if (parts != null && parts.length > 0) {
            int index;
            firmwareDescription.append("<Nodetext Lang=\"de-DE\" Text=\"");
            if (parts.length > 1) {
                for (index = 0; index < parts.length - 1; ++index) {
                    firmwareDescription.append(parts[index]).append(" ");
                }
            } else {
                firmwareDescription.append(parts[0]).append(" -> ");
                switch (destination) {
                    case 0: {
                        firmwareDescription.append("FLASH");
                        break;
                    }
                    case 1: {
                        firmwareDescription.append("EEPROM");
                        break;
                    }
                    default: {
                        firmwareDescription.append(destination);
                    }
                }
            }
            firmwareDescription.append("\"/>");
            firmwareDescription.append("<Nodetext Lang=\"en-EN\" Text=\"");
            for (index = 0; index < parts.length - 1; ++index) {
                firmwareDescription.append(parts[index]).append(" ");
            }
            firmwareDescription.append("\"/>");
        } else {
            firmwareDescription.append("<Nodetext Lang=\"de-DE\" Text=\"Nicht erkannte Firmware\"/>");
            firmwareDescription.append("<Nodetext Lang=\"en-EN\" Text=\"Unknown Firmware\"/>");
        }
        String destinationName = null;
        switch (destination) {
            case 0: 
            case 1: {
                destinationName = Resources.getString(FirmwareUpdatePanel.class, (String)("memoryType-" + destination));
                break;
            }
            default: {
                destinationName = Resources.getString(FirmwareUpdatePanel.class, (String)"memoryType-other");
            }
        }
        firmwareDescription.append("<Node xsi:type=\"FirmwareNode\" Comment=\"The Temporary Firmware\" DestinationNumber=\"").append(destination).append("\" >");
        firmwareDescription.append("<Nodetext Lang=\"de-DE\" Text=\"Firmware Destination: ").append(destinationName).append("\"/>");
        firmwareDescription.append("<Nodetext Lang=\"en-EN\" Text=\"Firmware Destination: ").append(destinationName).append("\"/>");
        firmwareDescription.append("<Filename>").append(firmwareFile.getName()).append("</Filename>");
        firmwareDescription.append("</Node>");
        firmwareDescription.append("</Node>");
        firmwareDescription.append("</FirmwareDefinition>");
        firmwareDescription.append("</Firmware>");
        Firmware firmware = FirmwareFactory.createInstance().getFirmware(firmwareDescription);
        if (firmware != null && firmware.getFirmwareDefinition() != null) {
            List nodes = firmware.getFirmwareDefinition().getNode();
            for (NodeType node : nodes) {
                if (!(node instanceof DeviceNode)) continue;
                DeviceNode deviceNode = (DeviceNode)node;
                DefaultMutableTreeNode deviceNodeItem = this.createDeviceNode(top, deviceNode, lang);
                top.add(deviceNodeItem);
            }
        } else {
            LOGGER.warn("No valid firmware description available.");
        }
        if (top instanceof InvisibleNode && (topNode = (InvisibleNode)top).getUserObject() instanceof IconData) {
            IconData iconData = (IconData)topNode.getUserObject();
            iconData.setObject((Object)TOP_NODE_TEXT);
        }
        this.firmwareTreeModel.reload(top);
        for (int i = 0; i < this.firmwareTree.getRowCount(); ++i) {
            this.firmwareTree.expandRow(i);
        }
    }

    protected DefaultMutableTreeNode createDeviceNode(DefaultMutableTreeNode parent, DeviceNode deviceNode, String lang) {
        InvisibleNode deviceNodeItem = new InvisibleNode((Object)new DeviceData((Icon)ICON_FIRMWARE, null, (Object)FirmwareFactory.NodetextUtils.getText((List)deviceNode.getNodetext(), (String)lang)));
        List subNodes = deviceNode.getNode();
        for (NodeType subNode : subNodes) {
            if (subNode instanceof FirmwareNode) {
                FirmwareNode firmwareNode = (FirmwareNode)subNode;
                DefaultMutableTreeNode firmwareNodeItem = this.createFirmwareNode((DefaultMutableTreeNode)deviceNodeItem, firmwareNode, lang);
                deviceNodeItem.add(firmwareNodeItem);
                continue;
            }
            if (!(subNode instanceof SimpleNode)) continue;
            SimpleNode simpleNode = (SimpleNode)subNode;
            DefaultMutableTreeNode simpleNodeItem = this.createSimpleNode((DefaultMutableTreeNode)deviceNodeItem, simpleNode, lang);
            deviceNodeItem.add(simpleNodeItem);
        }
        return deviceNodeItem;
    }

    protected DefaultMutableTreeNode createSimpleNode(DefaultMutableTreeNode parent, SimpleNode simpleNode, String lang) {
        InvisibleNode simpleNodeItem = new InvisibleNode((Object)new IconData((Icon)ICON_FIRMWARE, null, (Object)FirmwareFactory.NodetextUtils.getText((List)simpleNode.getNodetext(), (String)lang)));
        List subNodes = simpleNode.getNode();
        for (NodeType subNode : subNodes) {
            if (subNode instanceof FirmwareNode) {
                FirmwareNode firmwareNode = (FirmwareNode)subNode;
                DefaultMutableTreeNode firmwareNodeItem = this.createFirmwareNode((DefaultMutableTreeNode)simpleNodeItem, firmwareNode, lang);
                simpleNodeItem.add(firmwareNodeItem);
                continue;
            }
            if (!(subNode instanceof SimpleNode)) continue;
            SimpleNode simpleSubNode = (SimpleNode)subNode;
            DefaultMutableTreeNode simpleSubNodeItem = this.createSimpleNode((DefaultMutableTreeNode)simpleNodeItem, simpleSubNode, lang);
            simpleNodeItem.add(simpleSubNodeItem);
        }
        return simpleNodeItem;
    }

    protected DefaultMutableTreeNode createFirmwareNode(DefaultMutableTreeNode parent, FirmwareNode firmwareNode, String lang) {
        InvisibleNode firmwareNodeItem = new InvisibleNode((Object)new FirmwareData((Icon)ICON_FIRMWARE, null, (Object)FirmwareFactory.NodetextUtils.getText((List)firmwareNode.getNodetext(), (String)lang), firmwareNode));
        return firmwareNodeItem;
    }
}

