/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import java.awt.event.ActionListener;
import javax.swing.Timer;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.model.BoosterNodeInterface;
import org.bidib.wizard.api.model.CommandStationNodeInterface;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.BoosterStatusListener;
import org.bidib.wizard.api.model.listener.CommandStationStatusListener;
import org.bidib.wizard.api.model.listener.DefaultNodeListListener;
import org.bidib.wizard.api.service.node.BoosterService;
import org.bidib.wizard.api.service.node.CommandStationService;
import org.bidib.wizard.model.status.CommandStationStatus;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.BoosterPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.StatusListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BoosterPanelController
extends DefaultNodeListListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoosterPanelController.class);
    private final MainModel mainModel;
    private BoosterPanel boosterPanel;
    private Timer boosterCurrentTimer;
    private NodeInterface selectedNode;
    private final BoosterStatusListener boosterStatusListener;
    private final CommandStationStatusListener commandStationStatusListener;
    @Autowired
    private BoosterService boosterService;
    @Autowired
    private CommandStationService commandStationService;
    private static final long CURRENT_UPDATE_TIMEOUT = 3000L;

    public BoosterPanelController(MainModel mainModel) {
        this.mainModel = mainModel;
        this.boosterStatusListener = new /* Unavailable Anonymous Inner Class!! */;
        this.commandStationStatusListener = new /* Unavailable Anonymous Inner Class!! */;
    }

    public BoosterPanel createPanel(TabVisibilityListener tabVisibilityListener) {
        LOGGER.info("Create new booster panel.");
        BoosterPanel boosterPanel = new BoosterPanel(this.mainModel);
        boosterPanel.addStatusListener((StatusListener)new /* Unavailable Anonymous Inner Class!! */);
        try {
            this.boosterCurrentTimer = new Timer(1000, (ActionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.boosterCurrentTimer.setCoalesce(true);
            this.boosterCurrentTimer.start();
        }
        catch (Exception ex) {
            LOGGER.warn("Start the booster current timer failed.", (Throwable)ex);
        }
        this.boosterPanel = boosterPanel;
        return boosterPanel;
    }

    public void nodeChanged(NodeInterface node) {
        this.updateComponentState();
    }

    private void updateComponentState() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (this.selectedNode != null && this.selectedNode.equals(node)) {
            LOGGER.debug("Node is selected already: {}", (Object)node);
            return;
        }
        if (this.selectedNode != null) {
            BoosterNodeInterface boosterNode = this.selectedNode.getBoosterNode();
            if (boosterNode != null) {
                LOGGER.debug("Remove booster status listener from boosterNode: {}", (Object)boosterNode);
                boosterNode.removeBoosterStatusListener(this.boosterStatusListener);
            } else {
                LOGGER.debug("The selected node has no booster functions.");
            }
            CommandStationNodeInterface commandStationNode = this.selectedNode.getCommandStationNode();
            if (commandStationNode != null) {
                commandStationNode.removeCommandStationStatusListener(this.commandStationStatusListener);
            } else {
                LOGGER.debug("The selected node has no command station functions.");
            }
        }
        this.selectedNode = null;
        boolean isBooster = false;
        if (node != null && NodeUtils.hasBoosterFunctions((long)node.getUniqueId())) {
            isBooster = true;
        }
        boolean isCommandStation = false;
        if (node != null && NodeUtils.hasCommandStationFunctions((long)node.getUniqueId())) {
            isCommandStation = true;
        }
        if (isBooster || isCommandStation) {
            this.selectedNode = node;
        }
        LOGGER.info("The selected node has booster functions: {}, has command station functions: {}, node: {}", new Object[]{isBooster, isCommandStation, node});
        BoosterNodeInterface boosterNode = null;
        CommandStationNodeInterface commandStationNode = null;
        if (this.selectedNode != null) {
            boosterNode = this.selectedNode.getBoosterNode();
            if (boosterNode != null) {
                LOGGER.debug("Add booster status listener to boosterNode: {}", (Object)boosterNode);
                boosterNode.addBoosterStatusListener(this.boosterStatusListener);
            } else {
                LOGGER.debug("The new selected node has no booster functions.");
            }
            commandStationNode = this.selectedNode.getCommandStationNode();
            if (commandStationNode != null) {
                LOGGER.debug("Adding command station status listener to node: {}", (Object)commandStationNode);
                commandStationNode.addCommandStationStatusListener(this.commandStationStatusListener);
            } else {
                LOGGER.debug("The new selected node has no command station functions.");
            }
        }
        if (this.boosterPanel != null) {
            this.boosterPanel.nodeChanged();
        }
        if (boosterNode != null) {
            Integer voltage = boosterNode.getBoosterVoltage();
            LOGGER.debug("Set the voltage: {}", (Object)voltage);
            this.boosterStatusListener.voltageChanged(this.selectedNode, voltage);
            this.boosterStatusListener.stateChanged(node, boosterNode.getBoosterStatus());
            this.boosterStatusListener.maximumCurrentChanged(node, boosterNode.getBoosterMaximumCurrent());
            this.boosterStatusListener.currentChanged(node, boosterNode.getBoosterCurrent(), System.currentTimeMillis());
            this.boosterStatusListener.temperatureChanged(node, boosterNode.getBoosterTemperature());
        }
        if (commandStationNode != null) {
            CommandStationState csState = commandStationNode.getCommandStationState();
            if (csState == null) {
                LOGGER.warn("The command station status is not available. Use OFF as state.");
                csState = CommandStationState.OFF;
            }
            CommandStationStatus csStatus = CommandStationStatus.valueOf((CommandStationState)csState);
            this.commandStationStatusListener.statusChanged(node, csStatus);
        }
    }
}

