/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.StyledLabelBuilder;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.listener.PortListListener;
import org.bidib.wizard.api.model.listener.PortListener;
import org.bidib.wizard.api.model.listener.PortListenerProvider;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.model.SimpleHierarchicalPortTableModel;
import org.bidib.wizard.client.common.model.SimplePortTableModel;
import org.bidib.wizard.client.common.model.listener.PortModelListener;
import org.bidib.wizard.client.common.table.AbstractHierarchicalEmptyTable;
import org.bidib.wizard.client.common.table.AbstractPortHierarchicalTable;
import org.bidib.wizard.client.common.view.menu.listener.PortListMenuListener;
import org.bidib.wizard.common.script.node.types.TargetType;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.mvc.main.controller.InsertPortsAware;
import org.bidib.wizard.mvc.main.view.panel.PendingChangesAware;
import org.bidib.wizard.mvc.main.view.panel.SimpleHierarchicalPortListPanel;
import org.bidib.wizard.nodescript.script.node.ChangeLabelSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleHierarchicalPortListPanel<TM extends SimpleHierarchicalPortTableModel<S, P, M>, S extends BidibStatus, P extends Port<S>, L extends PortListener<P>, M extends PortModelListener<P>>
extends JPanel
implements PortListListener,
ChangeLabelSupport,
PortListenerProvider<P>,
PendingChangesAware {
    private static final long serialVersionUID = 1L;
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected TM tableModel;
    protected AbstractPortHierarchicalTable<P> table;
    protected L portListener;

    public SimpleHierarchicalPortListPanel(TM tableModel, String emptyTableText, PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject, NodeSelectionProvider nodeSelectionProvider) {
        this.tableModel = tableModel;
        this.setLayout((LayoutManager)new BorderLayout());
        this.setBorder((Border)new EmptyBorder(5, 5, 5, 5));
        this.createTable(tableModel, emptyTableText, portConfigChangeEventSubject, nodeSelectionProvider);
        DefaultOverlayable overlayTable = new DefaultOverlayable((JComponent)new JScrollPane((Component)this.table));
        this.table.getModel().addTableModelListener((TableModelListener)new /* Unavailable Anonymous Inner Class!! */);
        overlayTable.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)("{" + this.table.getEmptyTableText() + ":f:gray}")));
        this.add((Component)overlayTable, (Object)"Center");
    }

    protected SimplePortTableModel<S, P, M> getTableModel() {
        return this.tableModel;
    }

    protected void createTable(TM tableModel, String emptyTableText, PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject, NodeSelectionProvider nodeSelectionProvider) {
        this.table = this.createPortTable(tableModel, emptyTableText);
        this.table.createComponentFactory(portConfigChangeEventSubject, nodeSelectionProvider);
        this.table.setSortingEnabled(false);
        this.table.setAutoResort(true);
        this.table.setRestoreSelectionAndRowHeightAutomatically(true);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener((ListSelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.table.adjustRowHeight();
        this.table.prepareTableColumns();
        JTableHeader header = this.table.getTableHeader();
        JideSwingUtilities.insertMouseListener((Component)header, (MouseListener)new /* Unavailable Anonymous Inner Class!! */, (int)0);
    }

    protected AbstractPortHierarchicalTable<P> createPortTable(TM tableModel, String emptyTableText) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected PortListMenuListener createPortListMenuListener(AbstractPortHierarchicalTable<P> portTable, NodeSelectionProvider nodeSelectionProvider, Supplier<InsertPortsAware<TM>> insertPortsAware) {
        5 listener = new /* Unavailable Anonymous Inner Class!! */;
        return listener;
    }

    public void setPortListener(L listener) {
        this.portListener = listener;
    }

    @Override
    public String getName() {
        return Resources.getString(this.getClass(), (String)"name");
    }

    protected void collapseAllRows() {
        this.tableModel.setCollapsed(true);
        this.table.collapseAllRows();
    }

    protected void expandAllRows() {
        this.tableModel.setCollapsed(false);
        this.table.expandAllRows();
        this.scrollToTop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listChanged() {
        if (this.tableModel == null) {
            return;
        }
        this.collapseAllRows();
        this.tableModel.setRowCount(0);
        LinkedList ports = new LinkedList();
        ports.addAll(this.getPorts());
        LinkedList linkedList = ports;
        synchronized (linkedList) {
            for (Port port : ports) {
                this.LOGGER.debug("Adding row for port: {}", (Object)port);
                this.tableModel.addRow(port);
            }
        }
        if (AbstractHierarchicalEmptyTable.PackLastColumnEnum.NONE != this.isPackLastColumn()) {
            this.packColumn();
        }
        this.scrollToTop();
        this.LOGGER.debug("The port list has changed has finished in SimplePortListPanel.");
    }

    protected void packColumn() {
        if (this.table.getColumnCount() > 1) {
            this.table.packColumn(this.table.getColumnCount() - 1, 2, this.isPackLastColumn());
        }
    }

    protected AbstractHierarchicalEmptyTable.PackLastColumnEnum isPackLastColumn() {
        return AbstractHierarchicalEmptyTable.PackLastColumnEnum.FIXED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeLabel(TargetType portType) {
        List ports;
        int portNum = portType.getPortNum();
        String label = portType.getLabel();
        Port port = null;
        List list = ports = this.getPorts();
        synchronized (list) {
            port = PortListUtils.findPortByPortNumber((List)ports, (int)portNum);
        }
        if (port != null) {
            this.LOGGER.info("Set the port label: {}", (Object)label);
            port.setLabel(label);
            try {
                this.portListener.labelChanged(port, label);
            }
            catch (Exception ex) {
                this.LOGGER.warn("Change port label failed.", (Throwable)ex);
            }
        }
    }

    protected abstract List<P> getPorts();

    public PortListener<P> getPortListener() {
        return this.portListener;
    }

    private void scrollToTop() {
        this.table.scrollToTop();
    }

    public boolean hasPendingChanges() {
        return this.table != null && this.table.hasPendingChanges();
    }

    public void savePendingChanges() {
        this.LOGGER.info("Save pending changes.");
        if (this.table != null) {
            this.table.savePendingChanges();
        }
    }
}

