/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.ping.controller;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.RelativeDockablePosition;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import com.vlsolutions.swing.docking.event.DockableStateChangeListener;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.client.common.view.DockUtils;
import org.bidib.wizard.common.exception.ConnectionException;
import org.bidib.wizard.common.model.settings.MiscSettingsInterface;
import org.bidib.wizard.core.model.connection.MessageAdapter;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.core.service.node.NodeService;
import org.bidib.wizard.mvc.main.controller.MainControllerInterface;
import org.bidib.wizard.mvc.ping.controller.PingTableController;
import org.bidib.wizard.mvc.ping.model.NodePingModel;
import org.bidib.wizard.mvc.ping.model.NodePingState;
import org.bidib.wizard.mvc.ping.model.PingTableModel;
import org.bidib.wizard.mvc.ping.view.PingTableView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PingTableController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PingTableController.class);
    private final MainControllerInterface mainController;
    private PingTableView pingTableView;
    private PingTableModel pingTableModel;
    @Autowired
    private ConnectionService connectionService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private MiscSettingsInterface miscSettings;
    private MessageAdapter messageAdapter;
    private PropertyChangeListener pingIntervalListener;
    private PropertyChangeListener nodePingStatusListener;
    private ScheduledExecutorService pingWorkers;
    private Map<NodeInterface, ScheduledFuture<?>> scheduledPingWorkers = new HashMap();

    public PingTableController(MainControllerInterface mainController) {
        this.mainController = mainController;
    }

    public void start(DockingDesktop desktop) {
        String searchKey = "PingTableView";
        LOGGER.info("Search for view with key: {}", (Object)searchKey);
        Dockable view = desktop.getContext().getDockableByKey(searchKey);
        if (view != null) {
            LOGGER.info("Select the existing ping table view.");
            DockUtils.selectWindow((Dockable)view);
            return;
        }
        LOGGER.info("Create new PingTableView.");
        int pingInterval = this.miscSettings.getPingInterval();
        this.pingTableModel = new PingTableModel();
        this.pingTableModel.setPingInterval(pingInterval);
        this.pingTableView = new PingTableView(this.pingTableModel);
        DockableState[] dockables = desktop.getDockables();
        LOGGER.info("Current dockables: {}", new Object[]{dockables});
        if (dockables.length > 1) {
            DockableState boosterTableView = null;
            for (DockableState dockable : dockables) {
                if (!DockKeys.DOCKKEY_BOOSTER_TABLE_VIEW.equals((Object)dockable.getDockable().getDockKey())) continue;
                LOGGER.info("Found the booster table view dockable.");
                boosterTableView = dockable;
                break;
            }
            Dockable dock = desktop.getDockables()[1].getDockable();
            if (boosterTableView != null) {
                LOGGER.info("Add the ping table view to the booster table view panel.");
                dock = boosterTableView.getDockable();
                TabbedDockableContainer container = DockingUtilities.findTabbedDockableContainer((Dockable)dock);
                int order = 0;
                if (container != null) {
                    order = container.getTabCount();
                }
                LOGGER.info("Add new ping table panel at order: {}", (Object)order);
                desktop.createTab(dock, (Dockable)this.pingTableView, order, true);
            } else {
                desktop.split(dock, (Dockable)this.pingTableView, DockingConstants.SPLIT_RIGHT);
            }
        } else {
            desktop.addDockable((Dockable)this.pingTableView, RelativeDockablePosition.RIGHT);
        }
        this.pingIntervalListener = evt -> {
            int currentPingInterval = this.miscSettings.getPingInterval();
            this.pingTableModel.setPingInterval(currentPingInterval);
        };
        this.miscSettings.addPropertyChangeListener("pingInterval", this.pingIntervalListener);
        1 nodeListListener = new /* Unavailable Anonymous Inner Class!! */;
        this.mainController.addNodeListListener((NodeListListener)nodeListListener);
        try {
            this.connectionService.subscribeConnectionStatusChanges(connectionInfo -> {
                if (connectionInfo.getConnectionId().equals("main")) {
                    LOGGER.info("Current state: {}", (Object)connectionInfo.getConnectionState());
                    switch (6.$SwitchMap$org$bidib$api$json$types$ConnectionPhase[connectionInfo.getConnectionState().getActualPhase().ordinal()]) {
                        case 1: {
                            LOGGER.info("The communication was opened.");
                            break;
                        }
                        case 2: {
                            LOGGER.info("The communication was closed. Remove all nodes from the ping table.");
                            if (this.pingWorkers != null) {
                                LOGGER.info("Shutdown and free the ping workers.");
                                this.pingWorkers.shutdownNow();
                                try {
                                    this.pingWorkers.awaitTermination(2L, TimeUnit.SECONDS);
                                }
                                catch (InterruptedException ex) {
                                    LOGGER.warn("Wait for termination of ping workers failed.", (Throwable)ex);
                                }
                                this.pingWorkers = null;
                            }
                            LinkedList pingNodes = new LinkedList(this.pingTableModel.getNodes());
                            if (SwingUtilities.isEventDispatchThread()) {
                                for (NodePingModel pingNode : pingNodes) {
                                    this.pingTableModel.removeNode(pingNode.getNode());
                                }
                                break;
                            }
                            SwingUtilities.invokeLater(() -> {
                                for (NodePingModel pingNode : pingNodes) {
                                    this.pingTableModel.removeNode(pingNode.getNode());
                                }
                            });
                            break;
                        }
                    }
                }
            }, error -> LOGGER.warn("The connection status change caused an error.", error));
        }
        catch (Exception ex) {
            LOGGER.warn("Register controller as connection status listener failed.", (Throwable)ex);
        }
        this.messageAdapter = new /* Unavailable Anonymous Inner Class!! */;
        this.messageAdapter.start();
        try {
            List nodes = this.nodeService.getAllNodes("main");
            if (CollectionUtils.isNotEmpty((Collection)nodes)) {
                for (NodeInterface node : nodes) {
                    LOGGER.info("Initially add node.");
                    this.nodeNew(node);
                }
            }
        }
        catch (ConnectionException ex) {
            LOGGER.warn("Get the nodes from the main connection failed: {}", (Object)ex.getMessage());
        }
        catch (Exception ex) {
            LOGGER.warn("Get the nodes from the main connection failed.", (Throwable)ex);
        }
        this.nodePingStatusListener = evt -> {
            LOGGER.info("The node ping state has changed, node: {}", evt.getNewValue());
            NodeInterface node = (NodeInterface)evt.getNewValue();
            NodePingModel nodePingModel = this.pingTableModel.getNodes().stream().filter(npm -> npm.getNode().equals(node)).findFirst().orElse(null);
            if (nodePingModel != null) {
                NodePingState nodePingState = nodePingModel.getNodePingState();
                switch (6.$SwitchMap$org$bidib$wizard$mvc$ping$model$NodePingState[nodePingState.ordinal()]) {
                    case 1: {
                        this.startPingWorker(nodePingModel);
                        break;
                    }
                    default: {
                        this.stopPingWorker(nodePingModel);
                    }
                }
            }
        };
        this.pingTableModel.addPropertyChangeListener("nodePingStatus", this.nodePingStatusListener);
        desktop.addDockableStateChangeListener((DockableStateChangeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void startPingWorker(NodePingModel nodePingModel) {
        if (this.pingWorkers == null) {
            LOGGER.info("Create the ping workers thread pool.");
            this.pingWorkers = Executors.newScheduledThreadPool(0, new ThreadFactoryBuilder().setNameFormat("pingWorkers-thread-%d").build());
        }
        this.stopPingWorker(nodePingModel);
        long period = nodePingModel.getPingInterval().intValue();
        if (period < 100L) {
            period = 100L;
        }
        Runnable command = () -> {
            try {
                long now = System.currentTimeMillis();
                int data = nodePingModel.getNextIncData();
                LOGGER.info("Ping the node: {}, data: {}", (Object)nodePingModel, (Object)data);
                this.nodeService.ping("main", nodePingModel.getNode(), ByteUtils.getLowByte((int)data));
                nodePingModel.setLastPing(now);
            }
            catch (Exception ex) {
                LOGGER.warn("Ping node failed: {}", (Object)nodePingModel, (Object)ex);
            }
        };
        ScheduledFuture<?> pingFuture = this.pingWorkers.scheduleAtFixedRate(command, 500L, period, TimeUnit.MILLISECONDS);
        this.scheduledPingWorkers.put(nodePingModel.getNode(), pingFuture);
    }

    private void stopPingWorker(NodePingModel nodePingModel) {
        ScheduledFuture oldWorker = (ScheduledFuture)this.scheduledPingWorkers.remove(nodePingModel.getNode());
        if (oldWorker != null) {
            LOGGER.info("Cancel the ping worker: {}", (Object)oldWorker);
            oldWorker.cancel(true);
        }
    }

    private void nodeLost(NodeInterface node) {
        LOGGER.info("Remove node from model: {}", (Object)node);
        if (node != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.pingTableModel.removeNode(node);
            } else {
                SwingUtilities.invokeLater((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    private void nodeNew(NodeInterface node) {
        LOGGER.info("New node in system detected: {}", (Object)node);
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalNewNode(node);
        } else {
            SwingUtilities.invokeLater((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void internalNewNode(NodeInterface node) {
        if (node != null) {
            this.pingTableModel.addNode(node);
        }
    }
}

