/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.ping.model;

import com.jgoodies.binding.beans.Model;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.mvc.ping.model.NodePingState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodePingModel
extends Model {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodePingModel.class);
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_NODE_PING_STATUS = "nodePingStatus";
    public static final String PROPERTY_PING_INTERVAL = "pingInterval";
    public static final String PROPERTY_LAST_PING = "lastPing";
    public static final String PROPERTY_NODE_LABEL = "nodeLabel";
    private final NodeInterface node;
    private String nodeLabel;
    private NodePingState nodePingState;
    private Integer pingInterval;
    private long lastPing;
    private int data;
    private PropertyChangeListener propertyChangeListener;

    public NodePingModel(NodeInterface node) {
        this.node = node;
        LOGGER.info("Create new NodePingModel for node: {}", (Object)node);
    }

    public void registerNode() {
        this.propertyChangeListener = new /* Unavailable Anonymous Inner Class!! */;
        this.node.addPropertyChangeListener("label", this.propertyChangeListener);
        this.node.addPropertyChangeListener("node.userName", this.propertyChangeListener);
    }

    public void freeNode() {
        this.node.removePropertyChangeListener("label", this.propertyChangeListener);
        this.node.removePropertyChangeListener("node.userName", this.propertyChangeListener);
    }

    public NodeInterface getNode() {
        return this.node;
    }

    public NodePingState getNodePingState() {
        return this.nodePingState;
    }

    public void setNodePingState(NodePingState nodePingState) {
        NodePingState oldValue = this.nodePingState;
        this.nodePingState = nodePingState;
        this.firePropertyChange(PROPERTY_NODE_PING_STATUS, (Object)oldValue, (Object)this.nodePingState);
    }

    public void setNodeLabel(String nodeLabel) {
        String oldValue = this.nodeLabel;
        this.nodeLabel = nodeLabel;
        this.firePropertyChange(PROPERTY_NODE_LABEL, (Object)oldValue, (Object)this.nodeLabel);
    }

    public String getNodeLabel() {
        return this.nodeLabel;
    }

    public Integer getPingInterval() {
        return this.pingInterval;
    }

    public void setPingInterval(Integer pingInterval) {
        Integer oldValue = this.pingInterval;
        this.pingInterval = pingInterval;
        this.firePropertyChange(PROPERTY_PING_INTERVAL, (Object)oldValue, (Object)this.pingInterval);
    }

    public long getLastPing() {
        return this.lastPing;
    }

    public void setLastPing(long lastPing) {
        long oldValue = this.lastPing;
        this.lastPing = lastPing;
        SwingUtilities.invokeLater(() -> this.firePropertyChange(PROPERTY_LAST_PING, oldValue, this.lastPing));
    }

    public void setData(int data) {
        this.data = data;
    }

    public int getData() {
        return this.data;
    }

    public int getNextIncData() {
        int data;
        if ((data = this.data++) > 255) {
            this.data = data = 0;
        }
        return data;
    }

    public boolean equals(Object obj) {
        NodePingModel other;
        return obj instanceof NodePingModel && this.node.equals((other = (NodePingModel)obj).getNode());
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public String prepareNodeLabel() {
        String productString;
        String nodeLabel = this.node.getLabel();
        if (StringUtils.isBlank((CharSequence)nodeLabel) && StringUtils.isNotBlank((CharSequence)(productString = this.node.getNode().getStoredString(0)))) {
            nodeLabel = productString;
        }
        return nodeLabel;
    }

    public String toString() {
        return this.node.toString();
    }
}

