package org.bidib.wizard.mvc.firmware.view.panel;

import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import org.bidib.wizard.mvc.firmware.model.FirmwareRepoEntry;

public class FirmwareRepoEntryRenderer extends JLabel implements ListCellRenderer<FirmwareRepoEntry> {

    private static final long serialVersionUID = 1L;

    public FirmwareRepoEntryRenderer() {
        setOpaque(true);
    }

    @Override
    public Component getListCellRendererComponent(
        JList<? extends FirmwareRepoEntry> list, FirmwareRepoEntry value, int index, boolean isSelected,
        boolean cellHasFocus) {

        if (isSelected) {
            setBackground(list.getSelectionBackground());
            setForeground(list.getSelectionForeground());
        }
        else {
            setBackground(list.getBackground());
            setForeground(list.getForeground());
        }

        if (value instanceof FirmwareRepoEntry) {
            FirmwareRepoEntry entry = value;
            setText("Version: " + entry.getFirmwareDefintion().getVersion() + ", Status: "
                + entry.getFirmwareDefintion().getStatus());
        }
        else {
            setText(null);
        }
        return this;
    }

}
