package org.bidib.wizard.mvc.worklist.controller;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;

import org.assertj.core.api.Assertions;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.mvc.worklist.model.WorkItemListModel;
import org.bidib.wizard.mvc.worklist.model.WorkItemModel;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WorkListControllerTest {

    private static final Logger LOGGER = LoggerFactory.getLogger(WorkListControllerTest.class);

    @Test
    void loadWorkListTest() throws URISyntaxException {

        URL url = WorkListControllerTest.class.getResource("/worklist/workList.json");
        Assertions.assertThat(url).isNotNull();

        String path = new File(url.toURI()).getParentFile().getParentFile().getPath();

        LOGGER.info("Current path: {}", path);

        Assertions.assertThat(path).isNotBlank();

        final WorkItemListModel workListItemModel = new WorkItemListModel();

        final WizardSettingsInterface wizardSettings = Mockito.mock(WizardSettingsInterface.class);
        Mockito.when(wizardSettings.getWorkingDirectory(Mockito.anyString())).thenReturn(path);

        final WorkListController controller =
            new WorkListController(null, null, workListItemModel, wizardSettings, null, null);
        controller.loadWorkList();

        Assertions.assertThat(workListItemModel.getWorkItems()).isNotEmpty();

        Assertions.assertThat(workListItemModel.getWorkItems().get(0)).isInstanceOf(WorkItemModel.class);
    }

}
