/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.dialog;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.dialog.EscapeDialog;
import org.bidib.wizard.client.common.view.BidibNodeNameUtils;
import org.bidib.wizard.dialog.NodeLabelModel;
import org.bidib.wizard.dialog.NodeLabelPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NodeLabelView
extends EscapeDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeLabelView.class);
    private final NodeLabelModel nodeLabelModel;
    private final JButton applyButton = new JButton(Resources.getString(NodeLabelPanel.class, (String)"apply"));
    private final JButton cancelButton = new JButton(Resources.getString(NodeLabelPanel.class, (String)"cancel"));

    public NodeLabelView(Frame parent, NodeInterface node, NodeLabels nodeLabels) {
        super(parent, Resources.getString(NodeLabelView.class, (String)"title"), true);
        LOGGER.info("Open the NodeLabelView.");
        this.nodeLabelModel = new NodeLabelModel();
        this.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        this.setDefaultCloseOperation(0);
        String label = BidibNodeNameUtils.prepareLabel((NodeInterface)node, (NodeLabels)nodeLabels, (boolean)false, (boolean)false).getNodeLabel();
        this.nodeLabelModel.setNodeName(label);
        this.nodeLabelModel.setProductName(node.getNode().getStoredString(0));
        this.nodeLabelModel.setUid(ByteUtils.getUniqueIdAsString((long)node.getUniqueId()));
        NodeLabelPanel mainPanel = new NodeLabelPanel();
        mainPanel.setNodeLabelModel(this.nodeLabelModel);
        mainPanel.setApplyButton(this.applyButton);
        mainPanel.setCancelButton(this.cancelButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(mainPanel.createPanel());
        this.pack();
        this.setMinimumSize(mainPanel.getPreferredSize());
        this.applyButton.addActionListener(evt -> {
            LOGGER.info("The user pressed apply.");
            this.labelChanged(this.nodeLabelModel.getNodeName().trim());
            this.tryCloseDialog();
        });
        this.cancelButton.addActionListener(evt -> {
            LOGGER.info("The user pressed cancel.");
            this.tryCloseDialog();
        });
        this.getRootPane().setDefaultButton(this.applyButton);
    }

    public abstract void labelChanged(String var1);

    private void tryCloseDialog() {
        this.setVisible(false);
    }
}

