/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.common.view.editor;

import java.awt.Component;
import javax.swing.JTable;
import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.mvc.common.view.editor.NumberRangeEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmxChannelCellEditor
extends NumberRangeEditor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DmxChannelCellEditor.class);
    private static final int DMX_MAPPING_OFFSET = 1;

    public DmxChannelCellEditor(int minimum, int maximum) {
        super(minimum, maximum);
    }

    public Object getCellEditorValue() {
        try {
            if (StringUtils.isNotBlank((CharSequence)this.textField.getText())) {
                int value = Integer.parseInt(this.textField.getText());
                return Integer.max(value - 1, 0);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Parse textfield value failed.", (Throwable)ex);
        }
        return 0;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof Integer) {
            Integer integerValue = (Integer)value;
            this.textField.setText(Integer.toString(integerValue + 1));
        } else {
            this.textField.setText(value != null ? value.toString() : "");
        }
        return this.textField;
    }
}

