/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.common.view.list;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import org.bidib.wizard.mvc.common.view.list.JListMutable;
import org.bidib.wizard.mvc.common.view.list.ListCellEditor;
import org.bidib.wizard.mvc.common.view.list.MutableListModel;

public class JListMutable<T>
extends JList<T>
implements CellEditorListener {
    protected Component editorComp = null;
    protected int editingIndex = -1;
    protected ListCellEditor editor = null;
    private PropertyChangeListener editorRemover = null;

    public JListMutable(ListModel dataModel) {
        super(dataModel);
        this.init();
    }

    private void init() {
        this.getActionMap().put("startEditing", (Action)new StartEditingAction());
        this.getActionMap().put("cancel", (Action)new CancelEditingAction(this));
        this.addMouseListener((java.awt.event.MouseListener)new MouseListener(this));
        this.getInputMap().put(KeyStroke.getKeyStroke(113, 0), "startEditing");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this);
    }

    public void setListCellEditor(ListCellEditor editor) {
        this.editor = editor;
    }

    public ListCellEditor getListCellEditor() {
        return this.editor;
    }

    public boolean isEditing() {
        return this.editorComp != null;
    }

    public Component getEditorComponent() {
        return this.editorComp;
    }

    public int getEditingIndex() {
        return this.editingIndex;
    }

    public Component prepareEditor(int index) {
        JComponent jComp;
        boolean isSelected;
        Object value = this.getModel().getElementAt(index);
        Component comp = this.editor.getListCellEditorComponent((JList)this, value, isSelected = this.isSelectedIndex(index), index);
        if (comp instanceof JComponent && (jComp = (JComponent)comp).getNextFocusableComponent() == null) {
            jComp.setNextFocusableComponent((Component)this);
        }
        return comp;
    }

    public void removeEditor() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        if (this.editor != null) {
            this.editor.removeCellEditorListener((CellEditorListener)this);
            if (this.editorComp != null) {
                this.remove(this.editorComp);
            }
            Rectangle cellRect = this.getCellBounds(this.editingIndex, this.editingIndex);
            this.editingIndex = -1;
            this.editorComp = null;
            this.repaint(cellRect);
        }
    }

    public boolean editCellAt(int index, EventObject e) {
        if (this.editor != null && !this.editor.stopCellEditing()) {
            return false;
        }
        if (index < 0 || index >= this.getModel().getSize()) {
            return false;
        }
        if (!this.isCellEditable(index)) {
            return false;
        }
        if (this.editorRemover == null) {
            KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.editorRemover = new CellEditorRemover(this, fm);
            fm.addPropertyChangeListener("permanentFocusOwner", this.editorRemover);
        }
        if (this.editor != null && this.editor.isCellEditable(e)) {
            this.editorComp = this.prepareEditor(index);
            if (this.editorComp == null) {
                this.removeEditor();
                return false;
            }
            this.editorComp.setBounds(this.getCellBounds(index, index));
            this.add(this.editorComp);
            this.editorComp.validate();
            this.editingIndex = index;
            this.editor.addCellEditorListener((CellEditorListener)this);
            return true;
        }
        return false;
    }

    @Override
    public void removeNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        super.removeNotify();
    }

    public boolean isCellEditable(int index) {
        if (this.getModel() instanceof MutableListModel) {
            return ((MutableListModel)this.getModel()).isCellEditable(index);
        }
        return false;
    }

    public void setValueAt(Object value, int index) {
        ((MutableListModel)this.getModel()).setValueAt(value, index);
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        if (this.editor != null) {
            Object value = this.editor.getCellEditorValue();
            this.setValueAt(value, this.editingIndex);
            this.removeEditor();
        }
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        this.removeEditor();
    }
}

