/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.common.view.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.table.TableCellEditor;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.mvc.common.view.table.ColorCheckBoxUI;
import org.bidib.wizard.mvc.common.view.table.ColorEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ColorEditor.class);
    private Color currentColor;
    private JCheckBox checkBox = new JCheckBox();
    JColorChooser colorChooser;
    JDialog dialog;
    protected static final String EDIT = "edit";
    protected static final String OK = "ok";
    private ColorChooserValueUpdate chooserValueUpdate;

    public ColorEditor() {
        this.checkBox.setUI((ButtonUI)new ColorCheckBoxUI());
        this.checkBox.setActionCommand(EDIT);
        this.checkBox.addActionListener((ActionListener)this);
        this.colorChooser = new JColorChooser();
        this.colorChooser.setPreviewPanel(new JPanel());
        ArrayList<AbstractColorChooserPanel> chooserPanelsToRemove = new ArrayList<AbstractColorChooserPanel>();
        for (AbstractColorChooserPanel chooserPanel : this.colorChooser.getChooserPanels()) {
            if (!chooserPanel.getClass().getName().contains("SwatchChooserPanel")) continue;
            LOGGER.info("Found the SwatchChooserPanel to remove.");
            chooserPanelsToRemove.add(chooserPanel);
        }
        if (CollectionUtils.isNotEmpty(chooserPanelsToRemove)) {
            for (AbstractColorChooserPanel chooserPanel : chooserPanelsToRemove) {
                LOGGER.info("Remove chooserPanel: {}", (Object)chooserPanel);
                this.colorChooser.removeChooserPanel(chooserPanel);
            }
        }
        this.dialog = JColorChooser.createDialog(this.checkBox, Resources.getString(ColorEditor.class, (String)"title"), true, this.colorChooser, (ActionListener)this, (ActionListener)this);
        this.colorChooser.getSelectionModel().addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setColorChooserValueUpdate(ColorChooserValueUpdate chooserValueUpdate) {
        this.chooserValueUpdate = chooserValueUpdate;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (EDIT.equals(e.getActionCommand())) {
            Container container = null;
            if (e.getSource() instanceof JCheckBox) {
                container = ((JCheckBox)e.getSource()).getParent();
            }
            this.checkBox.setBackground(this.currentColor);
            this.colorChooser.setColor(this.currentColor);
            this.colorChooser.setForeground(this.currentColor);
            this.dialog.setVisible(true);
            if (container != null) {
                container.requestFocusInWindow();
            }
        } else if (OK.equalsIgnoreCase(e.getActionCommand())) {
            this.currentColor = this.colorChooser.getColor();
            LOGGER.info("User pressed ok.");
            this.stopCellEditing();
        } else {
            LOGGER.info("User pressed cancel.");
            this.stopCellEditing();
        }
    }

    public byte reduceColor(Color color) {
        int r = (color.getRGB() & 0xFF0000) >> 16;
        int g = (color.getRGB() & 0xFF00) >> 8;
        int b = color.getRGB() & 0xFF;
        byte rgb = (byte)(r & 0xE0 | (g & 0xE0) >> 3 | (b & 0xC0) >> 6);
        return rgb;
    }

    @Override
    public Object getCellEditorValue() {
        return this.currentColor;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof Color) {
            this.currentColor = (Color)value;
        } else if (value instanceof Integer) {
            this.currentColor = new Color((Integer)value);
        }
        this.checkBox.setBackground(this.currentColor);
        return this.checkBox;
    }
}

