/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.dmx.view.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Paint;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.mvc.dmx.model.DmxModel;
import org.bidib.wizard.mvc.dmx.view.panel.AutoRangeLimitedValueAxis;
import org.bidib.wizard.mvc.dmx.view.panel.DmxChartPanel;
import org.bidib.wizard.mvc.dmx.view.panel.axis.LabeledNumberTickUnit;
import org.bidib.wizard.mvc.dmx.view.panel.renderer.DmxDrawingSupplier;
import org.bidib.wizard.mvc.dmx.view.panel.renderer.DmxLineRenderer;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.RangeType;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DmxModelerPanel
extends JPanel
implements ChartMouseListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmxModelerPanel.class);
    private static final long serialVersionUID = 1L;
    private XYDataset channelData;
    private DmxLineRenderer dmxLineRenderer;
    private JFreeChart lineChart;
    private DmxChartPanel dmxChartPanel;
    List<JFreeChart> charts;
    private final DmxModel dmxModel;
    private static final int MAX_MINUTES = 10;

    public DmxModelerPanel(DmxModel dmxModel) {
        super(new BorderLayout());
        this.dmxModel = dmxModel;
        this.charts = new ArrayList();
        this.channelData = new XYSeriesCollection();
        this.add((Component)this.createContent());
    }

    public void cleanup() {
        if (this.dmxChartPanel != null) {
            this.dmxChartPanel.cleanup();
        }
    }

    public void addChart(JFreeChart chart) {
        this.charts.add(chart);
    }

    public JFreeChart[] getCharts() {
        int chartCount = this.charts.size();
        JFreeChart[] charts = new JFreeChart[chartCount];
        for (int i = 0; i < chartCount; ++i) {
            charts[i] = (JFreeChart)this.charts.get(i);
        }
        return charts;
    }

    private JComponent createContent() {
        this.dmxChartPanel = this.createChartPanel();
        return this.dmxChartPanel;
    }

    private DmxChartPanel createChartPanel() {
        Color backgroundColor = UIManager.getColor("Chart.background");
        Font titleFont = UIManager.getDefaults().getFont("Label.font");
        AutoRangeLimitedValueAxis xAxis = new AutoRangeLimitedValueAxis(Resources.getString(DmxModelerPanel.class, (String)"time-seconds"));
        xAxis.setFixedAutoRange(-600000.0);
        xAxis.setRange(0.0, 600000.0);
        xAxis.setRangeType(RangeType.POSITIVE);
        xAxis.setStandardTickUnits(DmxModelerPanel.createIntegerTickUnits((Locale)this.getLocale()));
        AutoRangeLimitedValueAxis yAxis = new AutoRangeLimitedValueAxis(Resources.getString(DmxModelerPanel.class, (String)"brightness"));
        yAxis.setFixedZoomAxis(true);
        yAxis.setAutoRange(false);
        yAxis.setFixedAutoRange(-100.0);
        yAxis.setRange(0.0, 100.0);
        yAxis.setRangeType(RangeType.POSITIVE);
        yAxis.setTickUnit(new NumberTickUnit(25.0));
        yAxis.setMinorTickCount(5);
        xAxis.setLabelFont(titleFont);
        yAxis.setLabelFont(titleFont);
        xAxis.setLabelPaint((Paint)UIManager.getColor("Chart.title.foreground"));
        yAxis.setLabelPaint((Paint)UIManager.getColor("Chart.title.foreground"));
        xAxis.setTickLabelPaint((Paint)UIManager.getColor("Chart.title.foreground"));
        xAxis.setTickMarkPaint((Paint)UIManager.getColor("Chart.title.foreground"));
        yAxis.setTickLabelPaint((Paint)UIManager.getColor("Chart.title.foreground"));
        yAxis.setTickMarkPaint((Paint)UIManager.getColor("Chart.title.foreground"));
        this.dmxLineRenderer = new DmxLineRenderer();
        this.dmxLineRenderer.setDrawOutlines(true);
        this.dmxLineRenderer.setUseOutlinePaint(true);
        this.dmxLineRenderer.setDefaultToolTipGenerator((XYToolTipGenerator)new /* Unavailable Anonymous Inner Class!! */);
        XYPlot plot = new XYPlot(this.channelData, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)this.dmxLineRenderer);
        plot.setBackgroundPaint((Paint)backgroundColor);
        plot.setDomainGridlinePaint((Paint)Color.lightGray);
        plot.setRangeGridlinePaint((Paint)Color.lightGray);
        plot.setAxisOffset(new RectangleInsets(4.0, 4.0, 4.0, 4.0));
        plot.setDomainPannable(true);
        plot.setRangePannable(false);
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        this.lineChart = new JFreeChart(null, null, (Plot)plot, false);
        this.addChart(this.lineChart);
        if (this.lineChart.getTitle() != null) {
            this.lineChart.getTitle().setPaint((Paint)UIManager.getColor("Chart.title.foreground"));
            this.lineChart.getTitle().setFont(titleFont.deriveFont(1));
        }
        plot.setDrawingSupplier((DrawingSupplier)new DmxDrawingSupplier());
        DmxChartPanel chartPanel = new DmxChartPanel(this.lineChart, this.dmxModel);
        chartPanel.addChartMouseListener((ChartMouseListener)this);
        return chartPanel;
    }

    public static TickUnitSource createIntegerTickUnits(Locale locale) {
        TickUnits units = new TickUnits();
        DecimalFormat numberFormat = new DecimalFormat("####0");
        DecimalFormat numberFormat2 = new DecimalFormat("####0.0");
        String timeSeconds = Resources.getString(DmxModelerPanel.class, (String)"time-seconds");
        String timeMilliSeconds = Resources.getString(DmxModelerPanel.class, (String)"time-milliseconds");
        units.add((TickUnit)new LabeledNumberTickUnit(1.0, (NumberFormat)numberFormat, 2, timeMilliSeconds, 1));
        units.add((TickUnit)new LabeledNumberTickUnit(2.0, (NumberFormat)numberFormat, 2, timeMilliSeconds, 1));
        units.add((TickUnit)new LabeledNumberTickUnit(5.0, (NumberFormat)numberFormat, 5, timeMilliSeconds, 1));
        units.add((TickUnit)new LabeledNumberTickUnit(10.0, (NumberFormat)numberFormat, 2, timeMilliSeconds, 1));
        units.add((TickUnit)new LabeledNumberTickUnit(20.0, (NumberFormat)numberFormat, 2, timeMilliSeconds, 1));
        units.add((TickUnit)new LabeledNumberTickUnit(50.0, (NumberFormat)numberFormat, 5, timeMilliSeconds, 1));
        units.add((TickUnit)new LabeledNumberTickUnit(100.0, (NumberFormat)numberFormat, 2, timeMilliSeconds, 1));
        units.add((TickUnit)new LabeledNumberTickUnit(200.0, (NumberFormat)numberFormat, 2, timeMilliSeconds, 1));
        units.add((TickUnit)new LabeledNumberTickUnit(500.0, (NumberFormat)numberFormat2, 5, timeSeconds, 1000));
        units.add((TickUnit)new LabeledNumberTickUnit(1000.0, (NumberFormat)numberFormat, 2, timeSeconds, 1000));
        units.add((TickUnit)new LabeledNumberTickUnit(2000.0, (NumberFormat)numberFormat, 2, timeSeconds, 1000));
        units.add((TickUnit)new LabeledNumberTickUnit(5000.0, (NumberFormat)numberFormat, 5, timeSeconds, 1000));
        units.add((TickUnit)new LabeledNumberTickUnit(10000.0, (NumberFormat)numberFormat, 2, timeSeconds, 1000));
        units.add((TickUnit)new LabeledNumberTickUnit(20000.0, (NumberFormat)numberFormat, 2, timeSeconds, 1000));
        units.add((TickUnit)new LabeledNumberTickUnit(50000.0, (NumberFormat)numberFormat, 5, timeSeconds, 1000));
        units.add((TickUnit)new LabeledNumberTickUnit(100000.0, (NumberFormat)numberFormat, 2, timeSeconds, 1000));
        units.add((TickUnit)new LabeledNumberTickUnit(200000.0, (NumberFormat)numberFormat, 2, timeSeconds, 1000));
        units.add((TickUnit)new LabeledNumberTickUnit(500000.0, (NumberFormat)numberFormat, 5, timeSeconds, 1000));
        units.add((TickUnit)new LabeledNumberTickUnit(1000000.0, (NumberFormat)numberFormat, 2, timeSeconds, 1000));
        return units;
    }

    public void chartMouseClicked(ChartMouseEvent event) {
    }

    public void chartMouseMoved(ChartMouseEvent event) {
        ChartEntity entity = event.getEntity();
        JFreeChart chart = event.getChart();
        if (entity instanceof XYItemEntity) {
            LOGGER.trace("moved, entity: {}", (Object)entity);
            XYItemEntity xyie = (XYItemEntity)entity;
            int series = xyie.getSeriesIndex();
            XYDataset dataset = xyie.getDataset();
            LOGGER.trace("seriesKey: {}", (Object)dataset.getSeriesKey(series));
            if (chart.equals((Object)this.lineChart)) {
                this.dmxLineRenderer.setHighlightedItem(xyie.getSeriesIndex(), xyie.getItem());
            }
        } else if (chart.equals((Object)this.lineChart)) {
            this.dmxLineRenderer.setHighlightedItem(-1, -1);
        }
    }

    public void loadSceneryPoints() {
        if (this.dmxChartPanel != null) {
            this.dmxChartPanel.loadSceneryPoints();
        }
    }

    public void storeSceneryPoints() {
        if (this.dmxChartPanel != null) {
            this.dmxChartPanel.storeSceneryPoints();
        }
    }
}

