/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.dmx.view.panel;

import java.awt.Point;
import java.awt.event.ActionEvent;
import org.bidib.wizard.model.ports.DmxChannel;
import org.bidib.wizard.model.status.LightPortStatus;
import org.bidib.wizard.mvc.dmx.view.panel.DmxChartPanel;
import org.bidib.wizard.mvc.dmx.view.panel.DmxDataItem;
import org.bidib.wizard.mvc.dmx.view.panel.LocationAwareAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightPortAction
extends LocationAwareAction<DmxChannel> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LightPortAction.class);
    private LightPortStatus lightPortStatus;
    private DmxChannel dmxChannel;
    private DmxDataItem originalDataItem;

    public LightPortAction(LightPortStatus lightPortStatus, DmxChannel dmxChannel, DmxChartPanel dmxChartPanel, DmxDataItem originalDataItem) {
        super(lightPortStatus.toString(), (Object)dmxChannel, dmxChartPanel);
        this.dmxChannel = dmxChannel;
        this.lightPortStatus = lightPortStatus;
        this.originalDataItem = originalDataItem;
    }

    public void actionPerformed(ActionEvent event) {
        Point currentMousePoint = this.dmxChartPanel.getCurrentMousePoint();
        String seriesKey = Integer.toString(this.dmxChannel.getChannelId());
        LOGGER.info("Selected key: {}, currentMousePoint: {}", (Object)seriesKey, (Object)currentMousePoint);
        if (this.originalDataItem != null) {
            LOGGER.info("Set action on port for item: {}, lightPortStatus: {}", (Object)this.originalDataItem, (Object)this.lightPortStatus);
            this.dmxChartPanel.setLightPortAction(seriesKey, this.originalDataItem, this.lightPortStatus);
        }
    }
}

