/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.firmware.view;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.awt.event.WindowListener;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.dialog.EscapeDialog;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.mvc.firmware.model.FirmwareModel;
import org.bidib.wizard.mvc.firmware.model.listener.FirmwareModelListener;
import org.bidib.wizard.mvc.firmware.view.listener.FirmwareViewListener;
import org.bidib.wizard.mvc.firmware.view.panel.FirmwareUpdatePanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirmwareView
extends EscapeDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(FirmwareView.class);
    private static final long serialVersionUID = 1L;
    private final Collection<FirmwareViewListener> listeners = new LinkedList();
    private final JButton closeButton = new JButton(Resources.getString(this.getClass(), (String)"close"));
    private final FirmwareModel firmwareModel;

    public FirmwareView(JFrame parent, FirmwareModel firmwareModel, SettingsService settingsService) {
        super((Frame)parent, Resources.getString(FirmwareView.class, (String)"title"), true);
        this.firmwareModel = firmwareModel;
        this.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        this.setDefaultCloseOperation(0);
        FirmwareUpdatePanel firmwareUpdatePanel = new FirmwareUpdatePanel(settingsService);
        firmwareUpdatePanel.setCloseButton(this.closeButton);
        firmwareUpdatePanel.setFirmwareModel(firmwareModel);
        JPanel panel = firmwareUpdatePanel.createPanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(panel);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        this.closeButton.addActionListener(evt -> this.tryCloseDialog());
        firmwareModel.addFirmwareModelListener((FirmwareModelListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void performCancelAction(KeyEvent e) {
        this.tryCloseDialog();
    }

    private void tryCloseDialog() {
        if (!this.firmwareModel.isInProgress()) {
            LOGGER.info("No firmware update in progress. Close the firmware update dialog.");
            this.setVisible(false);
            try {
                this.fireClose();
            }
            catch (Exception ex) {
                LOGGER.warn("Close firmware update dialog failed.", (Throwable)ex);
            }
        } else {
            LOGGER.warn("Firmware update is in progress! Dialog is not closed!");
        }
    }

    public void addFirmwareViewListener(FirmwareViewListener l) {
        this.listeners.add(l);
    }

    private void fireClose() {
        LOGGER.info("Close the firmware view.");
        for (FirmwareViewListener l : this.listeners) {
            l.close();
        }
    }

    private void fireUpdate() {
        for (FirmwareViewListener l : this.listeners) {
            l.updateFirmware();
        }
    }
}

