/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.model;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.common.collect.ArrayListModel;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.mvc.main.model.AccessoryAspect;
import org.bidib.wizard.mvc.main.model.AccessoryAspectParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessoryStartupAspectModel
extends Model {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessoryStartupAspectModel.class);
    public static final String PROPERTY_SELECTED_STARTUP_ASPECT = "selectedStartupAspect";
    private static final int STARTUP_ASPECT_INDEX_INVALID = 0;
    private static final int STARTUP_ASPECT_INDEX_UNCHANGED = 1;
    private static final int STARTUP_ASPECT_INDEX_RESTORE = 2;
    private AccessoryAspect selectedStartupAspect;
    private ArrayListModel<AccessoryAspect> accessoryAspectList = new ArrayListModel();

    public ArrayListModel<AccessoryAspect> getAccessoryAspectList() {
        return this.accessoryAspectList;
    }

    public void clearAccessoryAspects() {
        this.accessoryAspectList.clear();
        AccessoryAspectParam unknown = new AccessoryAspectParam(-1, Resources.getString(this.getClass(), (String)"aspectParam-unknown") + " ");
        unknown.setInvalid(true);
        this.accessoryAspectList.add(0, (Object)unknown);
        this.accessoryAspectList.add(1, (Object)new AccessoryAspectParam(255, Resources.getString(this.getClass(), (String)"aspectParam-unchanged")));
        this.accessoryAspectList.add(2, (Object)new AccessoryAspectParam(254, Resources.getString(this.getClass(), (String)"aspectParam-restore")));
    }

    public void addAccessoryAspect(AccessoryAspect accessoryAspect) {
        this.accessoryAspectList.add((Object)accessoryAspect);
    }

    public void setSelectedStartupAspect(AccessoryAspect selectedStartupAspect) {
        LOGGER.info("Set the selected startup aspect: {}", (Object)selectedStartupAspect);
        AccessoryAspect oldValue = this.selectedStartupAspect;
        this.selectedStartupAspect = selectedStartupAspect;
        this.firePropertyChange(PROPERTY_SELECTED_STARTUP_ASPECT, (Object)oldValue, (Object)selectedStartupAspect);
    }

    public AccessoryAspect getSelectedStartupAspect() {
        return this.selectedStartupAspect;
    }

    public AccessoryAspect getAssignedAspect(int value, int aspectCount) {
        LOGGER.info("Get the assigned aspect, value: {}, aspectCount: {}", (Object)value, (Object)aspectCount);
        AccessoryAspect accessoryAspect = null;
        switch (value) {
            case 255: {
                accessoryAspect = (AccessoryAspect)this.accessoryAspectList.get(1);
                break;
            }
            case 254: {
                accessoryAspect = (AccessoryAspect)this.accessoryAspectList.get(2);
                break;
            }
            default: {
                if (value >= aspectCount) {
                    LOGGER.error("An invalid aspect is assigned, aspectId: {}, aspectCount: {}", (Object)value, (Object)aspectCount);
                } else {
                    accessoryAspect = (AccessoryAspect)IterableUtils.find((Iterable)this.accessoryAspectList, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
                }
                if (accessoryAspect != null) break;
                LOGGER.warn("No matching accessoryAspect found. Use the first in the list as default value.");
                accessoryAspect = (AccessoryAspect)this.accessoryAspectList.get(0);
            }
        }
        return accessoryAspect;
    }
}

