/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.model;

import javax.swing.SwingUtilities;
import org.bidib.jbidibc.core.node.listener.TransferListener;
import org.bidib.wizard.api.service.console.ConsoleColor;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.mvc.console.controller.ConsoleController;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTransferListener
implements TransferListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTransferListener.class);
    private MainModel model;
    private final ConsoleService consoleService;

    public DefaultTransferListener(MainModel model, ConsoleService consoleService) {
        this.model = model;
        this.consoleService = consoleService;
    }

    public void receiveStarted() {
        this.model.getStatusModel().setRx(true);
    }

    public void receiveStopped() {
        this.model.getStatusModel().setRx(false);
    }

    public void sendStarted() {
        this.model.getStatusModel().setTx(true);
    }

    public void sendStopped() {
        this.model.getStatusModel().setTx(false);
    }

    public void ctsChanged(boolean cts, boolean manualEvent) {
        try {
            this.model.getStatusModel().setCts(cts);
            if (!manualEvent) {
                SwingUtilities.invokeLater(() -> {
                    ConsoleController.ensureConsoleVisible();
                    this.consoleService.addConsoleLine(ConsoleColor.blue, "CTS has changed: " + cts);
                });
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Signal CTS changed failed.", (Throwable)ex);
        }
    }
}

