/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.model;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import com.jgoodies.binding.beans.Model;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.FeedbackAddressData;
import org.bidib.jbidibc.messages.FeedbackAddressDataWithDynState;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.mvc.main.controller.GlobalDetectorStatusChangeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalDetectorModel
extends Model
implements GlobalDetectorStatusChangeProvider {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalDetectorModel.class);
    private NodeInterface selectedNode;
    private PropertyChangeListener pclFeedbackAddresses;
    private PropertyChangeListener pclFeedbackDynState;
    private EventList<FeedbackAddressDataWithDynState> addressDataEventList = new BasicEventList();

    public GlobalDetectorModel() {
        this.pclFeedbackAddresses = new /* Unavailable Anonymous Inner Class!! */;
        this.pclFeedbackDynState = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void updateDynStateData(FeedbackPort globalDetectorPort, EventList<FeedbackAddressDataWithDynState> addressDataEventList) {
        Set dynStates = globalDetectorPort.getDynStates();
        if (CollectionUtils.isNotEmpty((Collection)dynStates)) {
            LOGGER.info("Add new dynStates: {}", (Object)dynStates);
            for (int index = 0; index < addressDataEventList.size(); ++index) {
                FeedbackAddressDataWithDynState addressDataWithDynState = (FeedbackAddressDataWithDynState)addressDataEventList.get(index);
                int decoderAddress = addressDataWithDynState.getAddress();
                List decoderDynStates = dynStates.stream().filter(dyn -> dyn.getDecoderAddress() == decoderAddress).collect(Collectors.toList());
                addressDataWithDynState.setDynStates(decoderDynStates);
                addressDataEventList.set(index, (Object)addressDataWithDynState);
            }
        } else {
            LOGGER.info("No dynStates available.");
        }
    }

    public NodeInterface getSelectedNode() {
        return this.selectedNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedNode(NodeInterface selectedNode) {
        if (this.selectedNode != null) {
            LOGGER.info("Remove pcl from previous selected node: {}", (Object)selectedNode);
            this.selectedNode.removePropertyChangeListener("globalDetectorFeedbackPort", this.pclFeedbackAddresses);
            this.selectedNode.removePropertyChangeListener("dynStates", this.pclFeedbackDynState);
        }
        this.selectedNode = selectedNode;
        if (this.selectedNode != null) {
            LOGGER.info("Add pcl to currently selected node: {}", (Object)selectedNode);
            this.selectedNode.addPropertyChangeListener("globalDetectorFeedbackPort", this.pclFeedbackAddresses);
            this.selectedNode.addPropertyChangeListener("dynStates", this.pclFeedbackDynState);
            this.addressDataEventList.getReadWriteLock().writeLock().lock();
            try {
                this.addressDataEventList.clear();
                List addresses = this.selectedNode.getGlobalDetectorFeedbackPort().getAddresses();
                if (CollectionUtils.isNotEmpty((Collection)addresses)) {
                    LOGGER.info("Add new addresses: {}", (Object)addresses);
                    for (FeedbackAddressData address : addresses) {
                        FeedbackAddressDataWithDynState addressDataWithDynState = new FeedbackAddressDataWithDynState(address.getAddress(), address.getType(), address.getSpeed());
                        this.addressDataEventList.add((Object)addressDataWithDynState);
                    }
                } else {
                    LOGGER.info("No addresses available.");
                }
                this.updateDynStateData(this.selectedNode.getGlobalDetectorFeedbackPort(), this.addressDataEventList);
            }
            finally {
                this.addressDataEventList.getReadWriteLock().writeLock().unlock();
            }
        }
        LOGGER.info("No node selected, clear the addressDataEventList.");
        this.addressDataEventList.getReadWriteLock().writeLock().lock();
        try {
            this.addressDataEventList.clear();
        }
        finally {
            this.addressDataEventList.getReadWriteLock().writeLock().unlock();
        }
    }

    public EventList<FeedbackAddressDataWithDynState> getAddressDataEventList() {
        return this.addressDataEventList;
    }
}

