/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.exchange;

import com.jidesoft.grid.DefaultExpandableRow;
import com.jidesoft.grid.TreeTableModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeHelper;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeTableModel;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.core.service.node.NodeService;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.ports.SwitchPairPort;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.mvc.common.view.cvdefinition.CvDefinitionPanelProvider;
import org.bidib.wizard.mvc.common.view.cvdefinition.CvValueUtils;
import org.bidib.wizard.mvc.main.view.exchange.SaveConfigOnNodeHelper;
import org.bidib.wizard.utils.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveConfigOnNodeHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveConfigOnNodeHelper.class);

    public void saveOnNode(String connectionId, NodeService nodeService, SwitchingNodeService switchingNodeService, NodeInterface node, Map<String, Object> params) {
        LOGGER.info("Save the configuration to the node: {}", (Object)node);
        if (params == null) {
            params = new HashMap<String, Object>();
            params.put("saveMacros", Boolean.TRUE);
            params.put("saveAccessories", Boolean.TRUE);
            params.put("saveBacklightPorts", Boolean.TRUE);
            params.put("saveLightPorts", Boolean.TRUE);
            params.put("saveServoPorts", Boolean.TRUE);
            params.put("saveSwitchPorts", Boolean.TRUE);
            params.put("saveFeatures", Boolean.FALSE);
            params.put("saveConfigurationVariables", Boolean.FALSE);
        }
        if (params.get("saveFeatures") != null && ((Boolean)params.get("saveFeatures")).booleanValue()) {
            LOGGER.info("Save the features on the node.");
            LinkedList features = node.getNode().getFeatures();
            if (CollectionUtils.isNotEmpty((Collection)features)) {
                features = new LinkedList(features);
                for (Feature feature : features) {
                    try {
                        nodeService.setFeatures(connectionId, node, Arrays.asList(feature));
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Write feature to node failed: {}", (Object)feature, (Object)ex);
                        StringBuffer sb = new StringBuffer("Save Feature ").append(feature.getFeatureName()).append(" on node failed, value: ").append(feature.getValue());
                        this.addError(params, sb.toString());
                    }
                }
            } else {
                LOGGER.warn("No features to transfer available.");
            }
        }
        if (params.get("saveConfigurationVariables") != null && ((Boolean)params.get("saveConfigurationVariables")).booleanValue()) {
            LOGGER.info("Save the CVs on the node.");
            ApplicationContext applicationContext = DefaultApplicationContext.getInstance();
            CvDefinitionTreeTableModel treeModel = NodeUtils.getCvDefinitionTreeTableModel((NodeInterface)node, (ApplicationContext)applicationContext);
            if (treeModel != null) {
                boolean hasPendingCVChanges = CvDefinitionTreeHelper.hasPendingChanges((TreeTableModel)treeModel);
                LOGGER.info("Before transfer CV values to node, hasPendingCVChanges: {}", (Object)hasPendingCVChanges);
                1 provider = new /* Unavailable Anonymous Inner Class!! */;
                DefaultExpandableRow root = (DefaultExpandableRow)treeModel.getRoot();
                CvValueUtils.writeCvValues((NodeInterface)node, (DefaultExpandableRow)root, (Map)NodeUtils.getCvNumberToNodeMap((NodeInterface)node, (ApplicationContext)applicationContext), (CvDefinitionPanelProvider)provider);
            }
        }
        if (params.get("saveLightPorts") != null && ((Boolean)params.get("saveLightPorts")).booleanValue()) {
            for (LightPort lightPort : node.getLightPorts()) {
                try {
                    switchingNodeService.setPortConfig(connectionId, node.getSwitchingNode(), (Port)lightPort);
                }
                catch (Exception ex) {
                    LOGGER.warn("Save lightport configuration on node failed: {}", (Object)lightPort, (Object)ex);
                    this.addError(params, "Save lightport configuration on node failed: " + lightPort);
                }
            }
        } else {
            LOGGER.info("Don't save lightports.");
        }
        if (params.get("saveBacklightPorts") != null && ((Boolean)params.get("saveBacklightPorts")).booleanValue()) {
            for (BacklightPort backlightPort : node.getBacklightPorts()) {
                try {
                    switchingNodeService.setPortConfig(connectionId, node.getSwitchingNode(), (Port)backlightPort);
                }
                catch (Exception ex) {
                    LOGGER.warn("Save backlightport configuration on node failed: {}", (Object)backlightPort, (Object)ex);
                    this.addError(params, "Save backlightport configuration on node failed: " + backlightPort);
                }
            }
        } else {
            LOGGER.info("Don't save backlightports.");
        }
        if (params.get("saveServoPorts") != null && ((Boolean)params.get("saveServoPorts")).booleanValue()) {
            LOGGER.info("Set the servo port configuration on the node.");
            for (ServoPort servoPort : node.getServoPorts()) {
                try {
                    switchingNodeService.setPortConfig(connectionId, node.getSwitchingNode(), (Port)servoPort);
                }
                catch (Exception ex) {
                    LOGGER.warn("Save servoport configuration on node failed: {}", (Object)servoPort, (Object)ex);
                    this.addError(params, "Save servoport configuration on node failed: " + servoPort);
                }
            }
        } else {
            LOGGER.info("Don't save servoports.");
        }
        boolean hasSwitchPortConfig = true;
        if (hasSwitchPortConfig) {
            if (params.get("saveSwitchPorts") != null && ((Boolean)params.get("saveSwitchPorts")).booleanValue()) {
                LOGGER.info("Set the switch port configuration on the node.");
                if (node != null && node.getNode().isPortFlatModelAvailable() && node.getNode().getProtocolVersion().isHigherThan(ProtocolVersion.VERSION_0_5)) {
                    LOGGER.info("The current node supports the flat port model.");
                    LinkedList genericPorts = new LinkedList();
                    genericPorts.addAll(node.getGenericPorts());
                    for (GenericPort genericPort : genericPorts) {
                        LOGGER.info("Prepare the generic port: {}", (Object)genericPort);
                        Map values = genericPort.getPortConfigX();
                        switchingNodeService.setPortConfig(connectionId, node.getSwitchingNode(), genericPort, genericPort.getCurrentPortType(), values);
                    }
                } else {
                    LOGGER.info("The current node supports the typed port model.");
                    if (node.getNode().getProtocolVersion().isLowerThan(ProtocolVersion.VERSION_0_6)) {
                        hasSwitchPortConfig = false;
                        Feature switchPortConfigAvailable = Feature.findFeature((Collection)node.getNode().getFeatures(), (int)67);
                        if (switchPortConfigAvailable != null) {
                            boolean bl = hasSwitchPortConfig = switchPortConfigAvailable.getValue() > 0;
                        }
                    }
                    if (hasSwitchPortConfig) {
                        LinkedList switchPorts = new LinkedList();
                        switchPorts.addAll(node.getSwitchPorts());
                        for (Object switchPort : switchPorts) {
                            try {
                                if (switchPort.isEnabled()) {
                                    switchingNodeService.setPortConfig(connectionId, node.getSwitchingNode(), (Port)switchPort);
                                    continue;
                                }
                                LOGGER.info("The current switchPort is not enabled: {}", switchPort);
                            }
                            catch (Exception ex) {
                                LOGGER.warn("Save switchPort configuration on node failed: {}", switchPort, (Object)ex);
                                this.addError(params, "Save switchPort configuration on node failed: " + (SwitchPort)switchPort);
                            }
                        }
                        LinkedList switchPairPorts = new LinkedList();
                        switchPairPorts.addAll(node.getSwitchPairPorts());
                        for (SwitchPairPort switchPairPort : switchPairPorts) {
                            try {
                                if (switchPairPort.isEnabled()) {
                                    switchingNodeService.setPortConfig(connectionId, node.getSwitchingNode(), (Port)switchPairPort);
                                    continue;
                                }
                                LOGGER.info("The current switchPairPort is not enabled: {}", (Object)switchPairPort);
                            }
                            catch (Exception ex) {
                                LOGGER.warn("Save switchPairPort configuration on node failed: {}", (Object)switchPairPort, (Object)ex);
                                this.addError(params, "Save switchPairPort configuration on node failed: " + switchPairPort);
                            }
                        }
                        LinkedList inputPorts = new LinkedList();
                        inputPorts.addAll(node.getInputPorts());
                        for (InputPort inputPort : inputPorts) {
                            try {
                                if (inputPort.isEnabled()) {
                                    switchingNodeService.setPortConfig(connectionId, node.getSwitchingNode(), (Port)inputPort);
                                    continue;
                                }
                                LOGGER.info("The current inputPort is not enabled: {}", (Object)inputPort);
                            }
                            catch (Exception ex) {
                                LOGGER.warn("Save inputPort configuration on node failed: {}", (Object)inputPort, (Object)ex);
                                this.addError(params, "Save inputPort configuration on node failed: " + inputPort);
                            }
                        }
                    } else {
                        LOGGER.info("Don't save switchports because the node does not support it.");
                    }
                }
            } else {
                LOGGER.info("Don't save switchports.");
            }
        } else {
            LOGGER.info("Node does not support switch port configuration.");
        }
        if (node.getNode().getStringSize() > 0) {
            LOGGER.info("Transfer the node strings.");
            String userName = node.getNode().getStoredString(1);
            LOGGER.info("Transfer the node string username: {}", (Object)userName);
            try {
                nodeService.setNodeDetails(connectionId, node, userName);
            }
            catch (Exception ex) {
                LOGGER.warn("Save userName on node failed: {}", (Object)userName, (Object)ex);
                this.addError(params, "Save userName on node failed: " + userName);
            }
        } else {
            LOGGER.info("The node does not support store node string values.");
        }
        if (params.get("saveMacros") != null && ((Boolean)params.get("saveMacros")).booleanValue()) {
            LOGGER.info("Save macros on the node.");
            for (Macro macro : node.getMacros()) {
                LOGGER.info("Save macro: {}", (Object)macro);
                try {
                    Macro macroClone = Macro.cloneMacro((Macro)macro);
                    switchingNodeService.saveMacro(connectionId, node.getSwitchingNode(), macroClone);
                }
                catch (Exception ex) {
                    LOGGER.warn("Save macro on node failed: {}", (Object)macro, (Object)ex);
                    this.addError(params, "Save macro on node failed: " + macro);
                }
            }
        } else {
            LOGGER.info("Don't save macros.");
        }
        if (params.get("saveAccessories") != null && ((Boolean)params.get("saveAccessories")).booleanValue()) {
            LOGGER.info("Save accessories on the node.");
            for (Accessory accessory : node.getAccessories()) {
                try {
                    Accessory accessoryClone = Accessory.cloneAccessoryData((Accessory)accessory);
                    switchingNodeService.saveAccessory(connectionId, node.getSwitchingNode(), accessoryClone);
                }
                catch (Exception ex) {
                    LOGGER.warn("Save accessory on node failed: {}", (Object)accessory, (Object)ex);
                    this.addError(params, "Save accessory on node failed: " + accessory);
                }
            }
        } else {
            LOGGER.info("Don't save accessories.");
        }
    }

    private void addError(Map<String, Object> params, String message) {
        LinkedList<String> saveErrors = (LinkedList<String>)params.get("saveErrors");
        if (saveErrors == null) {
            saveErrors = new LinkedList<String>();
            params.put("saveErrors", saveErrors);
        }
        saveErrors.add(message);
    }
}

