/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jidesoft.grid.TableColumnChooser;
import java.awt.Component;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.PortValueListener;
import org.bidib.wizard.client.common.model.SimplePortTableModel;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.listener.ButtonListener;
import org.bidib.wizard.client.common.view.renderer.PortConfigErrorAwareRenderer;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.model.status.MotorPortStatus;
import org.bidib.wizard.mvc.main.controller.MotorPortPanelController;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.MotorPortTableModel;
import org.bidib.wizard.mvc.main.model.listener.MotorPortModelListener;
import org.bidib.wizard.mvc.main.view.panel.MotorPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.SimplePortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabComponentCreator;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;

public class MotorPortListPanel
extends SimplePortListPanel<MotorPortStatus, MotorPort, PortValueListener<MotorPort>, MotorPortModelListener>
implements TabVisibilityProvider,
TabPanelProvider,
TabComponentCreator {
    private static final long serialVersionUID = 1L;
    private final MainModel mainModel;
    private final TabVisibilityListener tabVisibilityListener;

    public MotorPortListPanel(MotorPortPanelController controller, MotorPortTableModel tableModel, MainModel mainModel, TabVisibilityListener tabVisibilityListener) {
        super((SimplePortTableModel)tableModel, Resources.getString(MotorPortListPanel.class, (String)"emptyTable"));
        this.mainModel = mainModel;
        this.tabVisibilityListener = tabVisibilityListener;
    }

    protected void createTable(SimplePortTableModel<MotorPortStatus, MotorPort, MotorPortModelListener> tableModel, String emptyTableText) {
        this.table = new /* Unavailable Anonymous Inner Class!! */;
        this.table.adjustRowHeight();
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        this.table.setSortable(false);
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(109, 0), "left");
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(37, 0), "left");
        this.table.getActionMap().put("left", (Action)new /* Unavailable Anonymous Inner Class!! */);
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(107, 0), "right");
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(39, 0), "right");
        this.table.getActionMap().put("right", (Action)new /* Unavailable Anonymous Inner Class!! */);
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(96, 0), "stop");
        this.table.getActionMap().put("stop", (Action)new /* Unavailable Anonymous Inner Class!! */);
        TableColumn tc = this.table.getColumnModel().getColumn(0);
        tc.setCellRenderer((TableCellRenderer)new PortConfigErrorAwareRenderer(0));
        tc.setIdentifier(0);
        tc = this.table.getColumnModel().getColumn(2);
        tc.setIdentifier(2);
        tc.setCellRenderer((TableCellRenderer)new /* Unavailable Anonymous Inner Class!! */);
        tc.setMinWidth(100);
        tc.setMaxWidth(120);
        TableColumn buttonColumn = this.table.getColumnModel().getColumn(3);
        buttonColumn.setIdentifier(3);
        buttonColumn.setMinWidth(180);
        buttonColumn.setMaxWidth(200);
        6 editor = new /* Unavailable Anonymous Inner Class!! */;
        editor.addButtonListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        buttonColumn.setCellEditor((TableCellEditor)editor);
        buttonColumn.setCellRenderer((TableCellRenderer)editor);
        TableColumnChooser.hideColumn((JTable)this.table, (int)4);
    }

    public JPanel getComponent() {
        return this;
    }

    public Object getCreator() {
        return this;
    }

    public boolean equals(Object other) {
        TabComponentCreator creator;
        return other instanceof TabComponentCreator && (creator = (TabComponentCreator)other).getCreator() instanceof MotorPortListPanel;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void listChanged() {
        this.LOGGER.info("Update model has started, call clearTable.");
        super.listChanged();
        this.tabVisibilityListener.setTabVisible((Component)this, this.isTabVisible());
    }

    public Class<?> getPortClass() {
        return MotorPort.class;
    }

    public boolean isTabVisible() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = node.hasMotorPorts();
            this.LOGGER.debug("Check if tab is visible: {}", (Object)isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    protected List<MotorPort> getPorts() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            LinkedList<MotorPort> ports = new LinkedList<MotorPort>();
            ports.addAll(node.getMotorPorts());
            return ports;
        }
        return Collections.emptyList();
    }

    public void refreshView() {
        this.listChanged();
    }
}

