/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;

public class NumberWithLabelRenderer
implements TableCellRenderer {
    private final JPanel panel = new JPanel();
    private final JTextField textField = new JTextField(3);
    private final JLabel leftLabel;
    private JLabel rightLabel;

    public NumberWithLabelRenderer(String leftText, String rightText) {
        this.textField.setHorizontalAlignment(4);
        Dimension currentDim = this.textField.getPreferredSize();
        this.textField.setPreferredSize(new Dimension(40, currentDim.height));
        this.textField.setMinimumSize(new Dimension(40, currentDim.height));
        this.leftLabel = new JLabel(leftText);
        if (StringUtils.isNotBlank((CharSequence)rightText)) {
            this.rightLabel = new JLabel(rightText);
        }
        this.panel.setFocusCycleRoot(true);
        this.panel.setLayout(new BoxLayout(this.panel, 2));
        this.panel.add(this.leftLabel);
        this.panel.add(this.textField);
        if (this.rightLabel != null) {
            this.panel.add(this.rightLabel);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            Color foreground = hasFocus ? table.getSelectionForeground() : table.getSelectionForeground();
            this.panel.setForeground(foreground);
            this.leftLabel.setForeground(foreground);
            if (this.rightLabel != null) {
                this.rightLabel.setForeground(foreground);
            }
            this.panel.setBackground(hasFocus ? table.getSelectionBackground() : table.getSelectionBackground());
        } else {
            this.panel.setForeground(table.getForeground());
            this.leftLabel.setForeground(table.getForeground());
            if (this.rightLabel != null) {
                this.rightLabel.setForeground(table.getForeground());
            }
            this.panel.setBackground(table.getBackground());
        }
        TableModel model = table.getModel();
        boolean editable = model.isCellEditable(row, column);
        this.textField.setEnabled(editable);
        this.textField.setText(value != null ? value.toString() : "");
        return this.panel;
    }
}

