/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pom.model;

import com.jgoodies.binding.beans.Model;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.enums.PomProgState;
import org.bidib.wizard.mvc.pom.model.listener.ConfigVariableListener;
import org.bidib.wizard.mvc.pom.model.listener.ProgCommandListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PomProgrammerModel
extends Model {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PomProgrammerModel.class);
    public static final String PROPERTYNAME_COMMANDSTATIONSTATE = "commandStationState";
    public static final String PROPERTYNAME_POMPROGSTATE = "pomProgState";
    public static final String PROPERTYNAME_CVNUMBER = "cvNumber";
    public static final String PROPERTYNAME_CVVALUE = "cvValue";
    private final List<ConfigVariableListener> listeners = new LinkedList();
    private final List<ProgCommandListener> progCommandListeners = new LinkedList();
    private Integer cvNumber;
    private Integer cvValue;
    private CommandStationState commandStationState;
    private PomProgState pomProgState;

    public void addConfigVariableListener(ConfigVariableListener l) {
        this.listeners.add(l);
    }

    public void removeConfigVariableListener(ConfigVariableListener l) {
        this.listeners.remove(l);
    }

    public void addProgCommandListener(ProgCommandListener l) {
        this.progCommandListeners.add(l);
    }

    public void removeProgCommandListener(ProgCommandListener l) {
        this.progCommandListeners.remove(l);
    }

    public Integer getCvNumber() {
        return this.cvNumber;
    }

    public void setCvNumber(Integer cvNumber) {
        LOGGER.info("Set the CV number: {}", (Object)cvNumber);
        Integer oldNumber = this.cvNumber;
        this.cvNumber = cvNumber;
        this.firePropertyChange(PROPERTYNAME_CVNUMBER, (Object)oldNumber, (Object)cvNumber);
    }

    public Integer getCvValue() {
        return this.cvValue;
    }

    public void setCvValue(Integer value) {
        LOGGER.info("Set the CV value: {}", (Object)value);
        Integer oldValue = this.cvValue;
        this.cvValue = value;
        this.firePropertyChange(PROPERTYNAME_CVVALUE, (Object)oldValue, (Object)this.cvValue);
    }

    public void clearCvValue() {
        LOGGER.debug("Clear the CV value.");
        Integer oldValue = this.cvValue;
        this.cvValue = null;
        this.firePropertyChange(PROPERTYNAME_CVVALUE, (Object)oldValue, (Object)this.cvValue);
    }

    public CommandStationState getCommandStationState() {
        return this.commandStationState;
    }

    public void setCommandStationState(CommandStationState commandStationState) {
        LOGGER.info("Set the new command station state: {}", (Object)commandStationState);
        CommandStationState oldCommandStationState = this.commandStationState;
        this.commandStationState = commandStationState;
        this.firePropertyChange(PROPERTYNAME_COMMANDSTATIONSTATE, (Object)oldCommandStationState, (Object)commandStationState);
    }

    public PomProgState getPomProgState() {
        return this.pomProgState;
    }

    public void setPomProgState(PomProgState pomProgState) {
        PomProgState oldValue = this.pomProgState;
        LOGGER.info("Set the POM prog state: {}, oldValue: {}", (Object)pomProgState, (Object)oldValue);
        this.pomProgState = pomProgState;
        this.firePropertyChange(PROPERTYNAME_POMPROGSTATE, (Object)oldValue, (Object)pomProgState);
    }

    public void updatePomProgResult(PomProgState pomProgState, PomAddressData decoderAddress, int cvNumber, int cvValue) {
        LOGGER.info("update the POM prog result: {}, decoderAddress: {}, cvNumber: {}, cvValue: {}", new Object[]{pomProgState, decoderAddress, cvNumber, cvValue});
        if (SwingUtilities.isEventDispatchThread()) {
            this.notifyPomProgResult(pomProgState, decoderAddress, cvNumber, cvValue);
        } else {
            SwingUtilities.invokeLater((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void notifyPomProgResult(PomProgState pomProgState, PomAddressData decoderAddress, int cvNumber, int cvValue) {
        if (this.cvNumber != null && cvNumber == this.cvNumber) {
            if (PomProgState.POM_PROG_OKAY.equals((Object)pomProgState)) {
                LOGGER.info("The POM prog was successful, cvNumber: {}, cvValue: {}", (Object)cvNumber, (Object)cvValue);
                this.setCvValue(Integer.valueOf(cvValue));
            }
            this.setPomProgState(pomProgState);
            this.fireProgCommandFinished(pomProgState);
        } else {
            LOGGER.warn("The provided CV number ({}) does not match the processing cvNumber: {}", (Object)cvNumber, (Object)this.cvNumber);
        }
    }

    private void fireProgCommandFinished(PomProgState pomProgState) {
        for (ProgCommandListener l : this.progCommandListeners) {
            l.progPomFinished(pomProgState);
        }
    }
}

