/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pom.view.panel;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.validation.Severity;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.view.ValidationComponentUtils;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.PomOperation;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringConverter;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.mvc.pom.model.CurrentAddressBeanModel;
import org.bidib.wizard.mvc.pom.model.DirectAccessProgBeanModel;
import org.bidib.wizard.mvc.pom.model.PomMode;
import org.bidib.wizard.mvc.pom.model.PomProgrammerModel;
import org.bidib.wizard.mvc.pom.model.ProgCommandAwareBeanModel;
import org.bidib.wizard.mvc.pom.model.command.PomDirectAccessCommand;
import org.bidib.wizard.mvc.pom.view.panel.AbstractPomPanel;
import org.bidib.wizard.mvc.pom.view.panel.CvWritePanel;
import org.bidib.wizard.mvc.pom.view.panel.DirectAccessPanel;
import org.bidib.wizard.mvc.pom.view.panel.PomValidationResultModel;

public class DirectAccessPanel
extends AbstractPomPanel<DirectAccessProgBeanModel> {
    public static final int MIN_SUSI_CV = 897;
    private final DirectAccessProgBeanModel directAccessProgBeanModel = new DirectAccessProgBeanModel();
    private ValueModel cvNumberValueModel;
    private ValueModel cvValueValueModel;
    private JTextField cvNumber;
    private JTextField cvValue;
    private InputValidationDocument cvValueDocument;
    private PomValidationResultModel directValidationModel;
    private CvWritePanel cvWritePanel;
    private JComponent[] modeButtons;

    public DirectAccessPanel(PomProgrammerModel cvProgrammerModel, CurrentAddressBeanModel currentAddressBeanModel) {
        super(cvProgrammerModel, currentAddressBeanModel);
        this.setProgCommandAwareBeanModel((ProgCommandAwareBeanModel)this.directAccessProgBeanModel);
    }

    protected void postConstruct() {
        if (this.currentAddressBeanModel.getDccAddress() != null) {
            this.LOGGER.info("The address is available already. Trigger the validation.");
            this.triggerValidation();
        }
    }

    protected void createWorkerPanel(FormBuilder builder, int[] rowHolder, PomValidationResultModel parentValidationModel) {
        int row = rowHolder[0];
        builder.add((Component)new JLabel(Resources.getString(this.getClass(), (String)"direct-message"))).xyw(1, row, 7);
        builder.appendRows("p, 3dlu", new Object[0]);
        builder.add(Resources.getString(this.getClass(), (String)"mode"), new Object[0]).xy(1, row += 2);
        PropertyAdapter modeModel = new PropertyAdapter((Object)this.directAccessProgBeanModel, "mode", true);
        this.modeButtons = new JComponent[PomMode.values().length];
        int index = 0;
        int column = 3;
        for (PomMode mode : PomMode.values()) {
            JRadioButton radio = WizardComponentFactory.createRadioButton((ValueModel)modeModel, (Object)mode, (String)Resources.getString(PomMode.class, (String)mode.getKey()));
            this.modeButtons[index++] = radio;
            builder.add((Component)radio).xy(column, row);
            column += 2;
        }
        modeModel.addValueChangeListener((PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        builder.appendRows("p, 3dlu", new Object[0]);
        builder.add(Resources.getString(this.getClass(), (String)"cv-number"), new Object[0]).xy(1, row += 2);
        this.cvNumberValueModel = new PropertyAdapter((Object)this.directAccessProgBeanModel, "cvNumber", true);
        ConverterValueModel cvNumberConverterModel = new ConverterValueModel(this.cvNumberValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        this.cvNumber = new JTextField();
        this.cvNumber.setDocument((Document)new InputValidationDocument(4, "0123456789"));
        this.cvNumber.setColumns(4);
        Bindings.bind((JTextField)this.cvNumber, (ValueModel)cvNumberConverterModel, (boolean)false);
        builder.add((Component)this.cvNumber).xy(3, row);
        ValidationComponentUtils.setMandatory((JComponent)this.cvNumber, (boolean)true);
        ValidationComponentUtils.setMessageKey((JComponent)this.cvNumber, (Object)"validation.cvnumber_key");
        this.directValidationModel = new PomValidationResultModel(parentValidationModel);
        this.directAccessProgBeanModel.addPropertyChangeListener("cvNumber", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        builder.appendRows("p, 3dlu", new Object[0]);
        builder.add(Resources.getString(this.getClass(), (String)"cv-value"), new Object[0]).xy(1, row += 2);
        this.cvValueValueModel = new PropertyAdapter((Object)this.directAccessProgBeanModel, "cvValue", true);
        ConverterValueModel cvValueConverterModel = new ConverterValueModel(this.cvValueValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        this.cvValue = new JTextField();
        this.cvValueDocument = new InputValidationDocument(3, "0123456789");
        this.cvValue.setDocument((Document)this.cvValueDocument);
        this.cvValue.setColumns(3);
        Bindings.bind((JTextField)this.cvValue, (ValueModel)cvValueConverterModel, (boolean)false);
        builder.add((Component)this.cvValue).xy(3, row);
        ValidationComponentUtils.setMessageKey((JComponent)this.cvValue, (Object)"validation.cvvalue_key");
        this.directAccessProgBeanModel.addPropertyChangeListener("mode", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.directAccessProgBeanModel.addPropertyChangeListener("cvValue", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.cvWritePanel = new CvWritePanel(this.cvProgrammerModel, this.directAccessProgBeanModel);
        builder.add((Component)this.cvWritePanel.createPanel()).xyw(5, row, 3);
        this.cvNumberValueModel.addValueChangeListener((PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.readButtonEnabled = new ValueHolder(false);
        this.readButton.setEnabled(false);
        this.readButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.writeButtonEnabled = new ValueHolder(false);
        this.writeButton.setEnabled(false);
        this.writeButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.cvValueValueModel.addValueChangeListener((PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel progActionButtons = new ButtonBarBuilder().addGlue().addButton(new JComponent[]{this.readButton, this.writeButton}).build();
        builder.appendRows("p, 3dlu", new Object[0]);
        builder.add((Component)progActionButtons).xyw(1, row += 2, 7);
        rowHolder[0] = row;
    }

    protected ValidationResultModel getValidationResultModel() {
        return this.directValidationModel;
    }

    private ValidationResult validate() {
        PropertyValidationI18NSupport support = new PropertyValidationI18NSupport((Object)this.cvNumberValueModel, "validation");
        if (this.directAccessProgBeanModel.getCvNumber() == null) {
            support.addError("cvnumber_key", "not_empty");
        } else if (this.directAccessProgBeanModel.getCvNumber() < 1 || this.directAccessProgBeanModel.getCvNumber() > 1023) {
            support.addError("cvnumber_key", "invalid_value;min=1,max=1023");
        }
        if (this.directAccessProgBeanModel.getCvValue() == null) {
            if (PomMode.BYTE.equals((Object)this.directAccessProgBeanModel.getMode())) {
                support.add(Severity.INFO, "cvvalue_key", "not_empty_for_write");
            } else {
                support.addError("cvvalue_key", "not_empty_for_bit_verify");
            }
        } else if (this.directAccessProgBeanModel.getCvValue() < 0 || this.directAccessProgBeanModel.getCvValue() > 255) {
            support.addError("cvvalue_key", "invalid_value;min=0,max=255");
        }
        ValidationResult validationResult = support.getResult();
        this.LOGGER.info("Prepared validationResult: {}", (Object)validationResult);
        return validationResult;
    }

    protected void triggerValidation() {
        ValidationResult validationResult = this.validate();
        this.directValidationModel.setResult(validationResult);
        this.LOGGER.debug("Set the writeButtonEnabled, validStateNoWarnOrErrors: {}, validState: {}", (Object)this.directValidationModel.getValidStateNoWarnOrErrors(), (Object)this.directValidationModel.getValidState());
        this.writeButtonEnabled.setValue((Object)this.directValidationModel.getValidState());
        this.readButtonEnabled.setValue((Object)this.directValidationModel.getValidStateNoWarnOrErrors());
    }

    protected void disableInputElements() {
        this.cvWritePanel.setEnabled(false);
        this.cvValue.setEnabled(false);
        this.cvNumber.setEnabled(false);
        for (JComponent comp : this.modeButtons) {
            comp.setEnabled(false);
        }
        super.disableInputElements();
    }

    protected void enableInputElements() {
        this.cvWritePanel.setEnabled(true);
        this.cvValue.setEnabled(true);
        this.cvNumber.setEnabled(true);
        for (JComponent comp : this.modeButtons) {
            comp.setEnabled(true);
        }
        this.triggerValidation();
    }

    private int prepareBitCvValue(boolean write) {
        int intVal;
        int cvValue = this.cvWritePanel.getSelectedBit();
        int n = intVal = this.directAccessProgBeanModel.getCvValue() != null ? this.directAccessProgBeanModel.getCvValue() : 0;
        if (intVal != 0) {
            cvValue = (byte)(cvValue | 8);
        }
        if (write) {
            cvValue |= 0x10;
        }
        this.LOGGER.info("Prepared bit-based cvValue: {}", (Object)ByteUtils.byteToHex((int)(cvValue |= 0xE0)));
        return cvValue;
    }

    private int prepareByteCvValue() {
        int cvValue = this.directAccessProgBeanModel.getCvValue() != null ? this.directAccessProgBeanModel.getCvValue() : 0;
        this.LOGGER.info("Prepared byte-based cvValue: {}", (Object)ByteUtils.byteToHex((int)cvValue));
        return cvValue;
    }

    private void fireWrite() {
        this.disableInputElements();
        this.LOGGER.info("Prepare the write request for model: {}", (Object)this.directAccessProgBeanModel);
        this.directAccessProgBeanModel.getExecutedProgCommands().clear();
        List progCommands = this.directAccessProgBeanModel.getProgCommands();
        progCommands.clear();
        int cvValue = 0;
        switch (9.$SwitchMap$org$bidib$wizard$mvc$pom$model$PomMode[this.directAccessProgBeanModel.getMode().ordinal()]) {
            case 1: {
                cvValue = this.prepareBitCvValue(true);
                break;
            }
            default: {
                cvValue = this.prepareByteCvValue();
            }
        }
        int cvNumber = this.directAccessProgBeanModel.getCvNumber();
        int directDccAddress = this.currentAddressBeanModel.getDccAddress();
        this.LOGGER.info("Prepared DCC address: {}", (Object)directDccAddress);
        PomAddressData addressData = new PomAddressData(directDccAddress, this.currentAddressBeanModel.getAddressType());
        PomOperation operation = PomMode.BIT.equals((Object)this.directAccessProgBeanModel.getMode()) ? PomOperation.WR_BIT : PomOperation.WR_BYTE;
        this.directAccessProgBeanModel.setCurrentOperation(operation);
        this.directAccessProgBeanModel.setExecution(ProgCommandAwareBeanModel.ExecutionType.WRITE);
        progCommands.add(new PomDirectAccessCommand(addressData, operation, cvNumber, cvValue));
        this.startTimeoutControl(1000);
        this.fireNextCommand();
    }

    private void fireRead() {
        this.disableInputElements();
        this.directAccessProgBeanModel.getExecutedProgCommands().clear();
        List progCommands = this.directAccessProgBeanModel.getProgCommands();
        progCommands.clear();
        this.LOGGER.info("Prepare the read request for model: {}", (Object)this.directAccessProgBeanModel);
        int cvValue = 0;
        switch (9.$SwitchMap$org$bidib$wizard$mvc$pom$model$PomMode[this.directAccessProgBeanModel.getMode().ordinal()]) {
            case 1: {
                cvValue = this.prepareBitCvValue(false);
                break;
            }
            default: {
                cvValue = this.prepareByteCvValue();
            }
        }
        int cvNumber = this.directAccessProgBeanModel.getCvNumber();
        int directDccAddress = this.currentAddressBeanModel.getDccAddress();
        this.LOGGER.info("Prepared DCC address: {}", (Object)directDccAddress);
        PomAddressData addressData = new PomAddressData(directDccAddress, this.currentAddressBeanModel.getAddressType());
        PomOperation operation = PomMode.BIT.equals((Object)this.directAccessProgBeanModel.getMode()) ? PomOperation.RD_BYTE : PomOperation.RD_BYTE;
        this.directAccessProgBeanModel.setCurrentOperation(operation);
        this.directAccessProgBeanModel.setExecution(ProgCommandAwareBeanModel.ExecutionType.READ);
        PomDirectAccessCommand command = new PomDirectAccessCommand(addressData, operation, cvNumber, cvValue);
        progCommands.add(command);
        int timeout = 1000;
        if (cvNumber > 897) {
            this.LOGGER.info("SUSI CV detected, set the retry count member to 1 to execute command once again if timeout is received.");
            command.setRetryCount(1);
            timeout = 300;
        }
        if (operation.equals((Object)PomOperation.RD_BYTE)) {
            this.cvValueValueModel.setValue(null);
        }
        this.startTimeoutControl(timeout);
        this.fireNextCommand();
    }

    protected Object getCurrentOperation() {
        return this.directAccessProgBeanModel.getCurrentOperation();
    }
}

