/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.worklist.view;

import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jidesoft.grid.RolloverTableUtils;
import com.jidesoft.grid.SortableTableModel;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingDesktop;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.bidib.wizard.api.event.WorkListItemEvent;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.table.AbstractEmptyTable;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.mvc.worklist.controller.listener.WorkListControllerListener;
import org.bidib.wizard.mvc.worklist.model.ActionTableCellRenderer;
import org.bidib.wizard.mvc.worklist.model.WorkItemListModel;
import org.bidib.wizard.mvc.worklist.model.WorkItemModel;
import org.bidib.wizard.mvc.worklist.model.WorkListItemTableModel;
import org.bidib.wizard.mvc.worklist.view.ButtonActionData;
import org.bidib.wizard.mvc.worklist.view.ButtonsCellEditorRenderer;
import org.bidib.wizard.mvc.worklist.view.WorkListView;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkListView
implements Dockable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkListView.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, fill:50dlu:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "fill:50dlu:grow";
    private JPanel contentPanel;
    private final DockingDesktop desktop;
    private final WorkItemListModel workItemListModel;
    private final WorkListControllerListener controller;
    private SelectionInList<WorkItemModel> workItemSelection;
    private ButtonsCellEditorRenderer buttonEditor;

    public WorkListView(DockingDesktop desktop, WorkListControllerListener controller, WorkItemListModel workItemListModel) {
        this.desktop = desktop;
        this.controller = controller;
        this.workItemListModel = workItemListModel;
        DockKeys.DOCKKEY_WORK_LIST_VIEW.setName(Resources.getString(this.getClass(), (String)"title"));
        DockKeys.DOCKKEY_WORK_LIST_VIEW.setLocation(DockableState.Location.HIDDEN);
    }

    private JPanel createPanel() {
        Object panel;
        LOGGER.info("Create the content panel.");
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel();
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        this.workItemSelection = new SelectionInList((ListModel)this.workItemListModel.getWorkItemListModel());
        SortableTableModel tableModel = new SortableTableModel((TableModel)new WorkListItemTableModel(this.workItemSelection));
        1 workItemsTable = new /* Unavailable Anonymous Inner Class!! */;
        workItemsTable.adjustRowHeight();
        this.buttonEditor = new ButtonsCellEditorRenderer(arg_0 -> this.lambda$createPanel$0(tableModel, (AbstractEmptyTable)workItemsTable, arg_0));
        workItemsTable.getColumnModel().getColumn(0).setPreferredWidth(60);
        workItemsTable.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)new ActionTableCellRenderer());
        workItemsTable.getColumnModel().getColumn(2).setCellEditor((TableCellEditor)this.buttonEditor);
        workItemsTable.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)this.buttonEditor);
        int columnWidth = 35;
        workItemsTable.getColumnModel().getColumn(2).setPreferredWidth(columnWidth);
        workItemsTable.getColumnModel().getColumn(2).setMaxWidth(100);
        workItemsTable.getColumnModel().getColumn(2).setMinWidth(columnWidth);
        RolloverTableUtils.install((JTable)workItemsTable);
        JScrollPane positionsTableScrollPane = new JScrollPane((Component)workItemsTable);
        dialogBuilder.add((Component)positionsTableScrollPane).xyw(1, 1, 3);
        this.contentPanel = dialogBuilder.build();
        AnnotationProcessor.process((Object)this);
        return this.contentPanel;
    }

    public Component getComponent() {
        if (this.contentPanel == null) {
            this.contentPanel = this.createPanel();
        }
        return this.contentPanel;
    }

    public DockKey getDockKey() {
        return DockKeys.DOCKKEY_WORK_LIST_VIEW;
    }

    public void addWorkListItem(WorkListItemEvent item) {
        LOGGER.info("Received worklist item event: {}", (Object)item);
        this.workItemListModel.addWorkListItem(item);
    }

    private /* synthetic */ void lambda$createPanel$0(SortableTableModel tableModel, AbstractEmptyTable workItemsTable, ButtonActionData d) {
        LOGGER.info("Pressed button on row: {}, action: {}", (Object)d.getRow(), (Object)d.getAction());
        int selectedRow = d.getRow();
        int sortedRow = tableModel.getSortedRowAt(selectedRow);
        WorkListItemTableModel workListItemTableModel = (WorkListItemTableModel)tableModel.getActualModel();
        WorkItemModel selected = (WorkItemModel)workListItemTableModel.getRow(sortedRow);
        switch (2.$SwitchMap$org$bidib$wizard$mvc$worklist$view$ButtonActionData$ActionEnum[d.getAction().ordinal()]) {
            case 1: {
                LOGGER.info("Remove selected: {}", (Object)selected);
                int result = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(this.desktop.getRootPane()), Resources.getString(WorkListView.class, (String)"delete-item.text"), Resources.getString(WorkListView.class, (String)"delete-item.title"), 2);
                if (result != 0) break;
                try {
                    this.workItemListModel.removeWorkListItem(selected);
                    if (!this.workItemListModel.getWorkItems().isEmpty()) break;
                    RolloverTableUtils.cancelRollover((JTable)workItemsTable, null);
                    workItemsTable.updateUI();
                }
                catch (Exception ex) {
                    LOGGER.warn("Remove item or cancel rollover failed.", (Throwable)ex);
                }
                break;
            }
            case 2: {
                LOGGER.info("Perform action on row: {}", (Object)d.getRow());
                try {
                    this.controller.applyAction(selected);
                    RolloverTableUtils.cancelRollover((JTable)workItemsTable, null);
                    workItemsTable.updateUI();
                    break;
                }
                catch (Exception ex) {
                    LOGGER.warn("Perform action of item failed.", (Throwable)ex);
                }
            }
        }
    }
}

