package org.bidib.wizard.config;

import java.awt.Point;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

import javax.swing.JFrame;

import org.bidib.wizard.api.LookupService;
import org.bidib.wizard.api.event.DefaultLabelsWorkListItemEvent;
import org.bidib.wizard.api.event.FirmwareUpdateWorkListItemEvent;
import org.bidib.wizard.api.model.CommandStationNodeInterface;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.NodeProvider;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.service.node.BoosterService;
import org.bidib.wizard.api.service.node.NodeService;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.client.common.controller.CvDefinitionPanelControllerInterface;
import org.bidib.wizard.client.common.mvc.firmware.controller.FirmwareArchiveValidationController;
import org.bidib.wizard.client.common.mvc.firmware.controller.FirmwareController;
import org.bidib.wizard.client.common.preferences.view.panel.SettingsPanelInterface;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeModelRegistry;
import org.bidib.wizard.client.common.view.cvdef.DefaultCvDefinitionTreeModelRegistry;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.model.settings.FirmwareRepoSettingsInterface;
import org.bidib.wizard.common.model.settings.MiscSettingsInterface;
import org.bidib.wizard.common.model.settings.TracerServiceSettingsInterface;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.script.node.NodeScripting;
import org.bidib.wizard.core.model.connection.ConnectionRegistry;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.core.service.firmware.FirmwareArchiveValidationService;
import org.bidib.wizard.dcca.client.controller.DccAdvController;
import org.bidib.wizard.firmwarerepo.client.controller.FirmwareRepoController;
import org.bidib.wizard.firmwarerepo.core.FirmwareRepoService;
import org.bidib.wizard.firmwarerepo.core.NodeFirmwareRepoService;
import org.bidib.wizard.mvc.accessory.controller.AccessoryController;
import org.bidib.wizard.mvc.backup.controller.BackupController;
import org.bidib.wizard.mvc.booster.controller.BoosterTableController;
import org.bidib.wizard.mvc.comparison.controller.ComparisonController;
import org.bidib.wizard.mvc.console.controller.ConsoleController;
import org.bidib.wizard.mvc.console.controller.DefaultConsoleService;
import org.bidib.wizard.mvc.debug.controller.DebugInterfaceController;
import org.bidib.wizard.mvc.dmx.controller.DmxModelerController;
import org.bidib.wizard.mvc.features.controller.FeaturesController;
import org.bidib.wizard.mvc.loco.controller.LocoController;
import org.bidib.wizard.mvc.locolist.controller.LocoTableController;
import org.bidib.wizard.mvc.logger.controller.LogPanelController;
import org.bidib.wizard.mvc.main.controller.AccessoryPanelController;
import org.bidib.wizard.mvc.main.controller.AlertController;
import org.bidib.wizard.mvc.main.controller.BacklightPortPanelController;
import org.bidib.wizard.mvc.main.controller.BoosterPanelController;
import org.bidib.wizard.mvc.main.controller.CvDefinitionPanelController;
import org.bidib.wizard.mvc.main.controller.DefaultMainMenuListener;
import org.bidib.wizard.mvc.main.controller.DefaultNodeScripting;
import org.bidib.wizard.mvc.main.controller.DefaultPairingController;
import org.bidib.wizard.mvc.main.controller.FeedbackPortPanelController;
import org.bidib.wizard.mvc.main.controller.FeedbackPositionPanelController;
import org.bidib.wizard.mvc.main.controller.FlagPanelController;
import org.bidib.wizard.mvc.main.controller.InputPortPanelController;
import org.bidib.wizard.mvc.main.controller.LightPortPanelController;
import org.bidib.wizard.mvc.main.controller.LocoPanelController;
import org.bidib.wizard.mvc.main.controller.MacroPanelController;
import org.bidib.wizard.mvc.main.controller.MainController;
import org.bidib.wizard.mvc.main.controller.MainControllerInterface;
import org.bidib.wizard.mvc.main.controller.MotorPortPanelController;
import org.bidib.wizard.mvc.main.controller.PairingController;
import org.bidib.wizard.mvc.main.controller.ReverserPanelController;
import org.bidib.wizard.mvc.main.controller.ServoPortPanelController;
import org.bidib.wizard.mvc.main.controller.SoundPortPanelController;
import org.bidib.wizard.mvc.main.controller.SwitchPairPortPanelController;
import org.bidib.wizard.mvc.main.controller.SwitchPortPanelController;
import org.bidib.wizard.mvc.main.controller.docking.DefaultDockableResolver;
import org.bidib.wizard.mvc.main.model.ConnectionPhaseModel;
import org.bidib.wizard.mvc.main.model.FeedbackPortModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.StatusModel;
import org.bidib.wizard.mvc.main.view.MainNodeListActionListener;
import org.bidib.wizard.mvc.main.view.MainView;
import org.bidib.wizard.mvc.main.view.menu.listener.MainMenuListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.statusbar.DefaultJideStatusBar;
import org.bidib.wizard.mvc.netdebug.controller.NetDebugController;
import org.bidib.wizard.mvc.nodedebug.controller.DebugConsoleController;
import org.bidib.wizard.mvc.nodedebug.model.DebugConsoleModel;
import org.bidib.wizard.mvc.ping.controller.PingTableController;
import org.bidib.wizard.mvc.pom.controller.PomProgrammerController;
import org.bidib.wizard.mvc.position.controller.FeedbackPositionController;
import org.bidib.wizard.mvc.preferences.controller.PreferencesController;
import org.bidib.wizard.mvc.pt.controller.PtProgrammerController;
import org.bidib.wizard.mvc.stepcontrol.controller.StepControlController;
import org.bidib.wizard.mvc.tips.controller.TipOfDayController;
import org.bidib.wizard.mvc.worklist.controller.WorkListController;
import org.bidib.wizard.mvc.worklist.controller.actions.ApplyDefaultLabelsAction;
import org.bidib.wizard.mvc.worklist.controller.actions.DownloadFirmwareAction;
import org.bidib.wizard.mvc.worklist.controller.actions.WorkListAction;
import org.bidib.wizard.mvc.worklist.model.WorkItemListModel;
import org.bidib.wizard.nodes.client.controller.NodesClientController;
import org.bidib.wizard.nodescript.client.controller.NodeScriptController;
import org.bidib.wizard.nodescript.script.node.NodeScriptingSupportProvider;
import org.bidib.wizard.script.client.controller.ScriptClientController;
import org.bidib.wizard.simulation.client.controller.SimulationController;
import org.bidib.wizard.tracer.client.controller.TracerClientController;
import org.bidib.wizard.tracer.service.BidibTracerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;

import com.vlsolutions.swing.docking.DockableResolver;
import com.vlsolutions.swing.docking.DockingContext;
import com.vlsolutions.swing.docking.DockingDesktop;

@Configuration
public class StandaloneConfig {

    private static final Logger LOGGER = LoggerFactory.getLogger(StandaloneConfig.class);

    @Bean
    @Lazy
    public AlertController alertController() {
        return new AlertController(mainView());
    }

    @Bean
    @Lazy
    public TipOfDayController tipOfDayController() {
        return new TipOfDayController(mainView());
    }

    @Bean
    @Lazy
    public NodeScriptController nodeScriptController(
        final SettingsService settingsService, final SwitchingNodeService switchingNodeService,
        final NodeScripting nodeScripting, final MainControllerInterface mainController,
        final WizardLabelWrapper wizardLabelWrapper, final ConsoleService consoleService) {
        return new NodeScriptController(settingsService, switchingNodeService, nodeScripting, wizardLabelWrapper,
            consoleService);
    }

    @Bean
    public DebugInterfaceControllerFactory debugInterfaceControllerFactory() {
        DebugInterfaceControllerFactory factory = new DebugInterfaceControllerFactory() {
            @Override
            public DebugInterfaceController createController(final DockingDesktop desktop) {
                return debugInterfaceController(desktop);
            }
        };
        return factory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    public DebugInterfaceController debugInterfaceController(final DockingDesktop desktop) {

        DebugInterfaceController controller = new DebugInterfaceController(desktop);
        return controller;
    }

    @Bean
    public DebugConsoleControllerFactory debugConsoleControllerFactory() {
        DebugConsoleControllerFactory factory = new DebugConsoleControllerFactory() {
            @Override
            public DebugConsoleController createController() {
                DebugConsoleController controller = debugConsoleController();
                return controller;
            }
        };
        return factory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    public DebugConsoleController debugConsoleController() {
        DebugConsoleController debugConsoleController = new DebugConsoleController();

        return debugConsoleController;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    public DebugConsoleModel debugConsoleModel() {
        DebugConsoleModel debugConsoleModel = new DebugConsoleModel();

        return debugConsoleModel;
    }

    @Bean
    public NetDebugControllerFactory netDebugControllerFactory() {
        NetDebugControllerFactory factory = new NetDebugControllerFactory() {
            @Override
            public NetDebugController createController(final DockingDesktop desktop) {
                return netDebugController(desktop);
            }
        };
        return factory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    public NetDebugController netDebugController(final DockingDesktop desktop) {

        NetDebugController controller = new NetDebugController(desktop);
        return controller;
    }

    @Bean
    @Lazy
    public FirmwareRepoController firmwareRepoController(
        final DockingDesktop desktop, final FirmwareRepoSettingsInterface firmwareRepoSettings,
        final LookupService lookupService, final StatusBar statusBar,
        final NodeFirmwareRepoService firmwareRepoService) {

        final FirmwareRepoController controller =
            new FirmwareRepoController(desktop, firmwareRepoSettings, lookupService, statusBar, firmwareRepoService);
        return controller;
    }

    @Bean
    @Lazy
    public FirmwareArchiveValidationController firmwareArchiveValidationController(
        final DockingDesktop desktop, final FirmwareArchiveValidationService firmwareArchiveValidationService,
        final SettingsService settingsService) {

        final FirmwareArchiveValidationController controller =
            new FirmwareArchiveValidationController(desktop, firmwareArchiveValidationService, settingsService);
        return controller;
    }

    @Bean
    @Lazy
    public NodesClientController nodesClientController(
        final DockingDesktop desktop, final MainModel mainModel, final SettingsService settingsSevice,
        final NodeService nodeService, final WizardLabelWrapper wizardLabelWrapper) {

        String connectionId = ConnectionRegistry.CONNECTION_ID_MAIN;

        final NodesClientController controller =
            new NodesClientController(desktop, () -> mainModel.getNodeProvider(), () -> mainModel, settingsSevice,
                nodeService, connectionId, wizardLabelWrapper);
        return controller;
    }

    @Bean
    @Lazy
    public ScriptClientController scriptClientController(
        final DockingDesktop desktop, final SettingsService settingsSevice, final NodeService nodeService,
        final SwitchingNodeService switchingNodeService, final BoosterService boosterService, final MainModel mainModel,
        final ConsoleService consoleService) {

        final ScriptClientController controller =
            new ScriptClientController(desktop, settingsSevice.getWizardSettings(), nodeService, switchingNodeService,
                boosterService, consoleService, () -> mainModel.getNodeProvider());
        return controller;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    public TracerClientController tracerClientController(
        final DockingDesktop desktop, final TracerServiceSettingsInterface tracerServiceSettings,
        final BidibTracerService bidibTracerService) {

        TracerClientController controller =
            new TracerClientController(desktop, tracerServiceSettings, bidibTracerService);
        return controller;
    }

    @Bean
    public DccAdvControllerFactory dccAdvControllerFactory() {
        DccAdvControllerFactory factory = new DccAdvControllerFactory() {
            @Override
            public DccAdvController createController(final NodeInterface node, final DockingDesktop desktop) {
                return dccAdvController(node, desktop);
            }
        };
        return factory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    public DccAdvController dccAdvController(final NodeInterface node, final DockingDesktop desktop) {

        DccAdvController controller = new DccAdvController(node, desktop);
        return controller;
    }

    @Bean
    public SimulationControllerFactory simulationControllerFactory() {
        SimulationControllerFactory factory = new SimulationControllerFactory() {
            @Override
            public SimulationController createController(final DockingDesktop desktop) {
                SimulationController controller = simulationController(desktop);
                return controller;
            }
        };
        return factory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    public SimulationController simulationController(final DockingDesktop desktop) {
        SimulationController simulationController = new SimulationController(desktop);
        return simulationController;
    }

    @Bean
    public ComparisonControllerFactory comparisonControllerFactory() {
        ComparisonControllerFactory factory = new ComparisonControllerFactory() {
            @Override
            public ComparisonController createController(final DockingDesktop desktop) {
                ComparisonController controller = comparisonController(desktop);
                return controller;
            }
        };
        return factory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    public ComparisonController comparisonController(final DockingDesktop desktop) {
        ComparisonController comparisonController = new ComparisonController(desktop);
        return comparisonController;
    }

    @Bean
    public BackupControllerFactory backupControllerFactory() {
        BackupControllerFactory factory = new BackupControllerFactory() {
            @Override
            public BackupController createController(final DockingDesktop desktop, final MainModel mainModel) {
                BackupController controller = backupController(desktop, mainModel);
                return controller;
            }
        };
        return factory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    public BackupController backupController(final DockingDesktop desktop, final MainModel mainModel) {
        BackupController backupController = new BackupController(desktop, () -> mainModel.getNodeProvider(), mainModel);

        return backupController;
    }

    @Bean
    public CvDefinitionPanelControllerFactory cvDefinitionPanelControllerFactory() {
        CvDefinitionPanelControllerFactory factory = new CvDefinitionPanelControllerFactory() {
            @Override
            public CvDefinitionPanelController createController(MainModel mainModel) {
                return cvDefinitionPanelController(mainModel);
            }
        };
        return factory;
    }

    @Bean
    @Lazy
    public CvDefinitionPanelController cvDefinitionPanelController(final MainModel mainModel) {
        String connectionId = ConnectionRegistry.CONNECTION_ID_MAIN;

        CvDefinitionPanelController controller =
            new CvDefinitionPanelController(mainModel, feedbackPortModel(), connectionId);
        return controller;
    }

    @Bean
    @Lazy
    NodeScriptingSupportProvider nodeScriptingSupportProvider() {
        return new NodeScriptingSupportProvider();
    }

    @Bean
    @Primary
    @Lazy
    NodeScripting nodeScripting(
        final MainModel mainModel, final MainControllerInterface mainController,
        CvDefinitionPanelControllerInterface cvDefinitionPanelController,
        final SwitchingNodeService switchingNodeService, final NodeService nodeService,
        final NodeScriptingSupportProvider nodeScriptingSupportProvider) {
        LOGGER.info("Create new NodeScripting.");
        NodeScripting nodeScripting =
            new DefaultNodeScripting(mainModel, mainController, cvDefinitionPanelController, switchingNodeService,
                nodeService, nodeScriptingSupportProvider);
        return nodeScripting;
    }

    @Bean
    @Lazy
    public ReverserPanelControllerFactory reverserPanelControllerFactory() {
        ReverserPanelControllerFactory factory = new ReverserPanelControllerFactory() {
            @Override
            public ReverserPanelController createController(
                final MainModel mainModel, TabVisibilityListener tabVisibilityListener) {
                return reverserPanelController(mainModel, feedbackPortModel(), tabVisibilityListener);
            }
        };
        return factory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    public ReverserPanelController reverserPanelController(
        final MainModel mainModel, final FeedbackPortModel feedbackPortModel,
        final TabVisibilityListener tabVisibilityListener) {

        ReverserPanelController controller =
            new ReverserPanelController(mainModel, feedbackPortModel, tabVisibilityListener);
        return controller;
    }

    @Bean
    public LocoControllerFactory locoControllerFactory() {

        LocoControllerFactory locoControllerFactory = new LocoControllerFactory() {

            @Override
            public LocoController createLocoController(
                CommandStationNodeInterface node, JFrame parent, final NodeProvider nodeProvider) {
                return locoController(node, parent, nodeProvider);
            }
        };

        return locoControllerFactory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    public LocoController locoController(
        CommandStationNodeInterface node, JFrame parent, final NodeProvider nodeProvider) {
        LocoController locoController = new LocoController(node, parent, nodeProvider);

        return locoController;
    }

    @Bean
    public LocoTableControllerFactory locoTableControllerFactory() {

        LocoTableControllerFactory locoTableControllerFactory = new LocoTableControllerFactory() {

            @Override
            public LocoTableController createLocoTableController(NodeInterface node, JFrame parent) {
                return locoTableController(node, parent);
            }
        };

        return locoTableControllerFactory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    public LocoTableController locoTableController(NodeInterface node, JFrame parent) {
        LocoTableController locoTableController = new LocoTableController(node, parent, mainModel());

        return locoTableController;
    }

    @Bean
    public FeaturesControllerFactory featuresControllerFactory() {

        FeaturesControllerFactory featuresControllerFactory = new FeaturesControllerFactory() {

            @Override
            public FeaturesController createFeaturesController(
                final NodeInterface node, final JFrame parent, final WizardSettingsInterface wizardSettings) {
                return featuresController(node, parent, wizardSettings);
            }
        };

        return featuresControllerFactory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    public FeaturesController featuresController(
        final NodeInterface node, final JFrame parent, final WizardSettingsInterface wizardSettings) {
        final FeaturesController featuresController = new FeaturesController(parent, node, wizardSettings);
        return featuresController;
    }

    @Bean
    public FirmwareControllerFactory firmwareControllerFactory() {

        FirmwareControllerFactory firmwareControllerFactory = new FirmwareControllerFactory() {

            @Override
            public FirmwareController createFirmwareController(
                final FirmwareRepoService firmwareRepoService, final NodeInterface node, JFrame parent) {
                return firmwareController(firmwareRepoService, node, parent);
            }
        };

        return firmwareControllerFactory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    public FirmwareController firmwareController(
        final FirmwareRepoService firmwareRepoService, final NodeInterface node, JFrame parent) {
        FirmwareController firmwareController = new FirmwareController(firmwareRepoService, node, mainModel(), parent);

        return firmwareController;
    }

    @Bean
    public PtProgrammerControllerFactory ptProgrammerControllerFactory() {

        PtProgrammerControllerFactory ptProgrammerControllerFactory = new PtProgrammerControllerFactory() {

            @Override
            public PtProgrammerController createPtProgrammerController(
                NodeInterface node, JFrame parent, Point location) {
                return ptProgrammerController(node, parent, location);
            }
        };

        return ptProgrammerControllerFactory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    public PtProgrammerController ptProgrammerController(NodeInterface node, JFrame parent, Point location) {
        PtProgrammerController ptProgrammerController =
            new PtProgrammerController(node, parent, location.x, location.y);

        return ptProgrammerController;
    }

    @Bean
    public PomProgrammerControllerFactory pomProgrammerControllerFactory() {

        PomProgrammerControllerFactory pomProgrammerControllerFactory = new PomProgrammerControllerFactory() {

            @Override
            public PomProgrammerController createPomProgrammerController(
                CommandStationNodeInterface node, JFrame parent, Point location) {
                return pomProgrammerController(node, parent, location);
            }
        };

        return pomProgrammerControllerFactory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    public PomProgrammerController pomProgrammerController(
        CommandStationNodeInterface node, JFrame parent, Point location) {
        PomProgrammerController pomProgrammerController =
            new PomProgrammerController(node, parent, location.x, location.y);

        return pomProgrammerController;
    }

    @Bean
    public AccessoryControllerFactory accessoryControllerFactory() {

        AccessoryControllerFactory accessoryControllerFactory = new AccessoryControllerFactory() {

            @Override
            public AccessoryController createAccessoryController(NodeInterface node, JFrame parent, Point location) {
                return accessoryController(node, parent, location);
            }
        };

        return accessoryControllerFactory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    public AccessoryController accessoryController(NodeInterface node, JFrame parent, Point location) {
        AccessoryController accessoryController = new AccessoryController(node, parent, location.x, location.y);

        return accessoryController;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    public PingTableController pingTableController(final MainControllerInterface mainController) {
        PingTableController pingTableController = new PingTableController(mainController);

        return pingTableController;
    }

    @Bean
    public DmxModelerControllerFactory dmxModelerControllerFactory() {

        DmxModelerControllerFactory dmxModelerControllerFactory = new DmxModelerControllerFactory() {

            @Override
            public DmxModelerController createDmxModelerController(NodeInterface node, JFrame parent) {
                return dmxModelerController(node, parent);
            }
        };

        return dmxModelerControllerFactory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    public DmxModelerController dmxModelerController(NodeInterface node, JFrame parent) {
        DmxModelerController dmxModelerController = new DmxModelerController(node, parent);

        return dmxModelerController;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    public PreferencesController preferencesController(final List<SettingsPanelInterface> settingsPanelInterfaces) {

        JFrame parent = mainView().getFrame();
        PreferencesController preferencesController = new PreferencesController(parent, settingsPanelInterfaces);
        return preferencesController;
    }

    @Autowired
    private ApplicationContext applicationContext;

    @Bean
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    public MainModel mainModel() {
        String connectionId = ConnectionRegistry.CONNECTION_ID_MAIN;
        return new MainModel(statusModel(), connectionId, applicationContext);
    }

    // TODO the status model should be attached to the connection ...
    @Bean
    public StatusModel statusModel() {
        return new StatusModel();
    }

    @Bean
    @Lazy
    public StatusBar statusBar() {
        return new DefaultJideStatusBar(statusModel());
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    public MainController mainController() {
        String connectionId = ConnectionRegistry.CONNECTION_ID_MAIN;
        return new MainController(mainModel(), connectionPhaseModel(), connectionId);
    }

    @Bean
    PairingControllerFactory pairingControllerFactory() {

        final PairingControllerFactory pairingControllerFactory = new PairingControllerFactory() {

            @Override
            public PairingController create(final StatusBar statusBar, final ConnectionService connectionService) {
                final MainModel mainModel = mainModel();
                final Supplier<JFrame> parent = () -> mainView().getFrame();
                return new DefaultPairingController(parent, statusBar, connectionService,
                    () -> mainModel.getConnectionId());
            }

        };

        return pairingControllerFactory;
    }

    @Bean
    MainViewFactory mainViewFactory() {

        final MainViewFactory mainViewFactory = new MainViewFactory() {

            @Override
            public MainView create(final SettingsService settingsService) {
                final MainView mainView = mainView();

                final MainMenuListener mainMenuListener =
                    mainMenuListener(dockingDesktop(), settingsService, StandaloneConfig.this.applicationContext);
                mainView.setMainMenuListener(mainMenuListener);
                return mainView;
            }

        };
        return mainViewFactory;
    }

    @Bean
    @Lazy
    MainView mainView() {
        return new MainView(mainModel(), connectionPhaseModel(), nodeScriptingSupportProvider(),
            workListControllerFactory());
    }

    @Bean
    @Lazy
    public MainNodeListActionListener mainNodeListActionListener(final MainView mainView) {
        return new MainNodeListActionListener(mainView, mainModel());
    }

    @Bean
    @Lazy
    public DefaultMainMenuListener mainMenuListener(
        final DockingDesktop dockingDesktop, final SettingsService settingsService,
        final ApplicationContext applicationContext) {

        return new DefaultMainMenuListener(mainView(), dockingDesktop, mainModel(), settingsService,
            applicationContext);
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    public DockingContext dockingContext() {
        final DockingContext dockingContext = new DockingContext();

        // set the dockable resolver
        // this will allow to load the dockables dynamically
        dockingContext.setDockableResolver(dockableResolver());

        return dockingContext;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    public DockingDesktop dockingDesktop() {
        final DockingDesktop dockingDesktop = new DockingDesktop();

        dockingDesktop.setContext(dockingContext());
        // add the desktop to the context
        dockingContext().addDesktop(dockingDesktop);

        return dockingDesktop;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    public DockableResolver dockableResolver() {
        return new DefaultDockableResolver();
    }

    @Bean
    @Lazy
    public ConsoleControllerFactory consoleControllerFactory() {
        ConsoleControllerFactory factory = new ConsoleControllerFactory() {
            @Override
            public ConsoleController createController(
                final DockingDesktop desktop, final ConsoleService consoleService) {
                return consoleController(desktop, consoleService);
            }
        };
        return factory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    public ConsoleController consoleController(final DockingDesktop desktop, final ConsoleService consoleService) {
        LOGGER.info("Create the ConsoleController instance.");
        ConsoleController controller = new ConsoleController(desktop, mainModel(), consoleService);
        return controller;
    }

    @Bean
    ConsoleService consoleService() {
        return new DefaultConsoleService();
    }

    @Bean
    public WorkItemListModel workListItemModel() {
        return new WorkItemListModel();
    }

    @Bean
    public ConnectionPhaseModel connectionPhaseModel() {
        return new ConnectionPhaseModel();
    }

    @Bean
    public AccessoryPanelController accessoryPanelController() {
        return new AccessoryPanelController(mainModel());
    }

    @Bean
    public BoosterPanelController boosterPanelController() {
        return new BoosterPanelController(mainModel());
    }

    @Bean
    WorkListControllerFactory workListControllerFactory() {

        final WorkListControllerFactory workListControllerFactory = new WorkListControllerFactory() {

            @Override
            public WorkListController createWorkListController(
                final DockingDesktop desktop, final WizardSettingsInterface wizardSettings,
                final MiscSettingsInterface miscSettings, final ApplicationContext applicationContext) {
                return workListController(desktop, wizardSettings, miscSettings, applicationContext);
            }
        };
        return workListControllerFactory;
    }

    @Bean
    @Lazy
    // @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    public WorkListController workListController(
        final DockingDesktop desktop, final WizardSettingsInterface wizardSettings,
        final MiscSettingsInterface miscSettings, final ApplicationContext applicationContext) {
        LOGGER.info("Create the WorkListController instance.");

        final Map<String, Supplier<WorkListAction>> actionMap = new LinkedHashMap<>();
        actionMap
            .put(DefaultLabelsWorkListItemEvent.ACTION_IDENTIFIER,
                () -> applicationContext.getBean(ApplyDefaultLabelsAction.class));
        actionMap
            .put(FirmwareUpdateWorkListItemEvent.ACTION_IDENTIFIER,
                () -> applicationContext.getBean(DownloadFirmwareAction.class));

        return new WorkListController(desktop, mainController(), workListItemModel(), wizardSettings, miscSettings,
            actionMap);
    }

    @Bean
    @Lazy
    ApplyDefaultLabelsAction applyDefaultLabelsAction(
        final ConnectionService connectionService, final WizardLabelWrapper wizardLabelWrapper,
        final ApplicationEventPublisher applicationEventPublisher, final ConsoleService consoleService) {
        final ApplyDefaultLabelsAction action =
            new ApplyDefaultLabelsAction(connectionService, wizardLabelWrapper, applicationEventPublisher,
                consoleService);
        return action;
    }

    @Bean
    @Lazy
    DownloadFirmwareAction downloadFirmwareAction(final ApplicationContext applicationContext) {
        return new DownloadFirmwareAction(applicationContext);
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    public BoosterTableController boosterTableController(final DockingDesktop desktop, final MainModel mainModel) {
        LOGGER.info("Create the BoosterTableController instance.");
        return new BoosterTableController(desktop, () -> mainModel.getNodeProvider(), mainModel);
    }

    @Bean
    public BacklightPortPanelController backlightPortPanelController() {
        return new BacklightPortPanelController(mainModel());
    }

    @Bean
    public FeedbackPortModel feedbackPortModel() {
        return new FeedbackPortModel();
    }

    @Bean
    public FeedbackPortPanelController feedbackPortPanelController() {
        return new FeedbackPortPanelController(mainModel(), feedbackPortModel());
    }

    @Lazy
    @Bean
    public FeedbackPositionPanelController feedbackPositionPanelController(
        final WizardSettingsInterface wizardSettings) {
        return new FeedbackPositionPanelController(mainModel(), wizardSettings);
    }

    @Bean
    public FeedbackPositionControllerFactory feedbackPositionControllerFactory() {
        FeedbackPositionControllerFactory factory = new FeedbackPositionControllerFactory() {
            @Override
            public FeedbackPositionController createController(
                final DockingDesktop desktop, final MainModel mainModel) {
                return feedbackPositionController(desktop, mainModel);
            }
        };
        return factory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    public FeedbackPositionController feedbackPositionController(
        final DockingDesktop desktop, final MainModel mainModel) {
        LOGGER.info("Create the feedbackPositionController instance.");
        FeedbackPositionController controller =
            new FeedbackPositionController(desktop, () -> mainModel.getNodeProvider(), mainController());
        return controller;
    }

    @Bean
    public FlagPanelController flagPanelController() {
        return new FlagPanelController(mainModel());
    }

    @Bean
    public InputPortPanelController inputPortPanelController() {
        return new InputPortPanelController(mainModel());
    }

    @Bean
    public LightPortPanelController lightPortPanelController() {
        return new LightPortPanelController(mainModel());
    }

    @Bean
    @Lazy
    public LocoPanelController locoPanelController() {
        return new LocoPanelController(mainModel());
    }

    @Bean
    public MacroPanelController macroPanelController() {
        return new MacroPanelController(mainModel());
    }

    @Bean
    public MotorPortPanelController motorPortPanelController() {
        return new MotorPortPanelController(mainModel());
    }

    @Bean
    public ServoPortPanelController servoPortPanelController() {
        return new ServoPortPanelController(mainModel());
    }

    @Bean
    public SoundPortPanelController soundPortPanelController() {
        return new SoundPortPanelController(mainModel());
    }

    @Bean
    public StepControlController stepControlController() {
        return new StepControlController(mainModel(), feedbackPortModel(), statusBar());
    }

    @Bean
    public SwitchPortPanelController switchPortPanelController() {
        return new SwitchPortPanelController(mainModel());
    }

    @Bean
    public SwitchPairPortPanelController switchPairPortPanelController() {
        return new SwitchPairPortPanelController(mainModel());
    }

    // @Bean
    // public FirmwareUpdateStatusPublisher firmwareUpdateStatusPublisher() {
    // return new FirmwareUpdateStatusPublisher() {
    //
    // @Override
    // public void publishProgress(
    // String connectionId, String destinationQualifier, String address, Long uniqueId, Integer progress,
    // SimpleUpdateStatusEnum simpleStatus, String msgKey) {
    //
    // }
    //
    // @Override
    // public void publishProgress(
    // String destinationQualifier, Long uniqueId, FirmwareUpdateProgressInfo progressInfo) {
    //
    // }
    //
    // @Override
    // public void publishStatus(
    // String destinationQualifier, Long uniqueId, ProcessingStatusType processingStatus) {
    //
    // }
    //
    // };
    // }

    @Bean
    public CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry() {
        return new DefaultCvDefinitionTreeModelRegistry();
    }

    @Bean
    @Lazy
    public LogPanelController logPanelController(final DockingDesktop desktop) {
        return new LogPanelController(desktop);
    }
}
