package org.bidib.wizard.mvc.main.view.component;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.jbidibc.messages.enums.AccessoryExecutionState;
import org.bidib.jbidibc.messages.enums.IdentifyState;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.api.model.BoosterNodeInterface;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.SwitchingNodeInterface;
import org.bidib.wizard.api.script.ScriptCommand;
import org.bidib.wizard.api.script.ScriptEngineListener;
import org.bidib.wizard.api.script.ScriptStatus;
import org.bidib.wizard.api.script.Scripting;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.service.node.BoosterService;
import org.bidib.wizard.api.service.node.NodeService;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.api.utils.AccessoryListUtils;
import org.bidib.wizard.client.common.dialog.EscapeDialog;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.script.DefaultScriptContext;
import org.bidib.wizard.common.script.booster.BoosterScripting;
import org.bidib.wizard.common.script.engine.ScriptEngine;
import org.bidib.wizard.common.script.node.NodeScripting;
import org.bidib.wizard.common.script.node.types.CvType;
import org.bidib.wizard.common.script.node.types.FeatureType;
import org.bidib.wizard.common.script.node.types.ScriptingTargetType;
import org.bidib.wizard.common.script.node.types.TargetType;
import org.bidib.wizard.common.script.switching.AccessoryScripting;
import org.bidib.wizard.common.script.switching.NodeTreeScripting;
import org.bidib.wizard.common.script.switching.PortScripting;
import org.bidib.wizard.common.script.switching.SwitchFunctionsScriptCommandFactory;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.core.dialog.FileDialog;
import org.bidib.wizard.core.model.connection.ConnectionRegistry;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.ports.SwitchPairPort;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.BoosterStatus;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.bidib.wizard.mvc.loco.view.ScriptPanel;
import org.oxbow.swingbits.dialog.task.TaskDialogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.vlsolutions.swing.docking.DockingDesktop;

public class BulkSwitchNodeOperationsDialog extends EscapeDialog
    implements PortScripting, AccessoryScripting, NodeTreeScripting, NodeScripting, BoosterScripting,
    ScriptEngineListener<Scripting> {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(BulkSwitchNodeOperationsDialog.class);

    private static final String ENCODED_COLUMN_SPECS = "60dlu, 3dlu, 60dlu, 3dlu, 0dlu:grow";

    private static final String ENCODED_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";

    private static final String WORKING_DIR_BULK_SWITCHING_KEY = "bulkSwitching";

    // suffix for script files
    private static final String SCRIPT_EXTENSION = "bidibt";

    private final FileFilter scriptFilter;

    private ValueModel selectedScriptModel = new ValueHolder();

    private ValueModel currentCommandModel = new ValueHolder();

    private JButton startScript;

    private JButton stopScript;

    private JLabel executionStateIconLabel;

    private ImageIcon executionPendingIcon;

    private ImageIcon executionRunningIcon;

    private ImageIcon executionFinishedIcon;

    private ImageIcon executionErrorIcon;

    private ValueModel checkRepeatingModel = new ValueHolder();

    private AtomicBoolean scriptRepeating = new AtomicBoolean(false);

    private final NodeInterface node;

    private ScriptEngine<Scripting> scriptEngine;

    private final SwitchingNodeService switchingNodeService;

    private final BoosterService boosterService;

    private final NodeService nodeService;

    private final DefaultScriptContext scriptContext;

    private final ConsoleService consoleService;

    public BulkSwitchNodeOperationsDialog(final DockingDesktop desktop, final NodeInterface node,
        final NodeService nodeService, final SwitchingNodeService switchingNodeService,
        final BoosterService boosterService, final SettingsService settingsService,
        final ConsoleService consoleService) {
        super(JOptionPane.getFrameForComponent(desktop),
            Resources.getString(BulkSwitchNodeOperationsDialog.class, "title"), true);
        this.node = node;
        this.nodeService = nodeService;
        this.switchingNodeService = switchingNodeService;
        this.boosterService = boosterService;
        this.consoleService = consoleService;

        String scriptDescription = Resources.getString(ScriptPanel.class, "scriptDescription");
        scriptFilter = new FileNameExtensionFilter(scriptDescription, SCRIPT_EXTENSION);

        this.scriptContext = new DefaultScriptContext();

        // Set the icon for accessory execution
        executionPendingIcon =
            ImageUtils.createImageIcon(BulkSwitchNodeOperationsDialog.class, "/icons/accessory-wait.png");
        executionRunningIcon =
            ImageUtils.createImageIcon(BulkSwitchNodeOperationsDialog.class, "/icons/accessory-wait.png");
        executionFinishedIcon =
            ImageUtils.createImageIcon(BulkSwitchNodeOperationsDialog.class, "/icons/accessory-successful.png");
        executionErrorIcon =
            ImageUtils.createImageIcon(BulkSwitchNodeOperationsDialog.class, "/icons/accessory-error.png");

        boolean debugDialog = false;
        final JPanel panel = debugDialog ? new FormDebugPanel() : new JPanel();

        final FormBuilder formBuilder =
            FormBuilder.create().columns(ENCODED_COLUMN_SPECS).rows(ENCODED_ROW_SPECS).panel(panel);

        final JButton btnSelectScript = new JButton(Resources.getString(ScriptPanel.class, "selectScript"));
        btnSelectScript.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {

                final WizardSettingsInterface wizardSettings = settingsService.getWizardSettings();
                String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_BULK_SWITCHING_KEY);

                // select the script file
                FileDialog dialog =
                    new FileDialog(BulkSwitchNodeOperationsDialog.this, FileDialog.OPEN, storedWorkingDirectory,
                        "*." + SCRIPT_EXTENSION, scriptFilter) {

                        @Override
                        public void approve(final String fileName) {
                            LOGGER.info("Load script: {}", fileName);
                            try {
                                File file = new File(fileName);
                                if (file.exists()) {
                                    LOGGER.info("The script file exists: {}", file);
                                    selectedScriptModel.setValue(file.getName());

                                    prepareScript(fileName);

                                    startScript.setEnabled(true);
                                }
                                else {
                                    selectedScriptModel.setValue("no script selected");
                                    startScript.setEnabled(false);
                                }

                                final String workingDir = Paths.get(fileName).getParent().toString();
                                LOGGER.info("Save current workingDir: {}", workingDir);

                                wizardSettings.setWorkingDirectory(WORKING_DIR_BULK_SWITCHING_KEY, workingDir);
                            }
                            catch (IllegalArgumentException | IOException ex) {
                                LOGGER.info("Load and process script file failed.", ex);
                                startScript.setEnabled(false);

                                // show error
                                TaskDialogs
                                    .build(JOptionPane.getFrameForComponent(desktop),
                                        Resources
                                            .getString(BulkSwitchNodeOperationsDialog.class,
                                                "load-script-failed.instruction", ex.getMessage()),
                                        Resources
                                            .getString(BulkSwitchNodeOperationsDialog.class, "load-script-failed.text"))
                                    .error();

                            }
                        }
                    };
                dialog.showDialog();
            }
        });
        formBuilder.add(btnSelectScript).xy(1, 1);

        JLabel scriptLabel = WizardComponentFactory.createLabel(selectedScriptModel);
        formBuilder.add(scriptLabel).xyw(3, 1, 3);

        JCheckBox repeatingCheck =
            WizardComponentFactory
                .createCheckBox(checkRepeatingModel, Resources.getString(ScriptPanel.class, "repeating"));
        // formBuilder.nextLine();
        formBuilder.add(repeatingCheck).xyw(1, 3, 3);

        // formBuilder.nextLine();

        startScript = new JButton(Resources.getString(ScriptPanel.class, "startScript"));
        startScript.setEnabled(false);
        startScript.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                scriptContext.unregister(Scripting.KEY_SCRIPT_ERRORS);
                executionStateIconLabel.setIcon(executionPendingIcon);
                scriptEngine.startScript();
            }
        });
        formBuilder.add(startScript).xy(1, 5);

        stopScript = new JButton(Resources.getString(ScriptPanel.class, "stopScript"));
        stopScript.setEnabled(false);
        stopScript.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                stopScript();
            }
        });
        formBuilder.add(stopScript).xy(3, 5);

        executionStateIconLabel = new JLabel();
        formBuilder.add(executionStateIconLabel).xy(5, 5);

        JLabel currentCommandLabel = WizardComponentFactory.createLabel(currentCommandModel);
        formBuilder.add(currentCommandLabel).xyw(1, 7, 5);

        checkRepeatingModel.addValueChangeListener(new PropertyChangeListener() {

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LOGGER.info("Repeating has changed: {}", checkRepeatingModel.getValue());
                Boolean repeating = (Boolean) checkRepeatingModel.getValue();

                scriptRepeating.set(repeating);
                scriptEngine.setScriptRepeating(repeating);
            }
        });

        JPanel mainPanel = formBuilder.border(Paddings.DIALOG).build();

        JButton cancelButton = new JButton(Resources.getString(BulkSwitchNodeOperationsDialog.class, "cancel"));
        cancelButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                setVisible(false);
                fireCancel(node);
            }
        });

        JPanel buttonBar = new ButtonBarBuilder().addButton(cancelButton).build();
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add(buttonBar, BorderLayout.EAST);
        southPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        getContentPane().setLayout(new BorderLayout());
        getContentPane().add(mainPanel, BorderLayout.CENTER);
        getContentPane().add(southPanel, BorderLayout.SOUTH);

        getContentPane().setPreferredSize(new Dimension(400, 300));

        // create the script engine
        scriptEngine = new ScriptEngine<>(this, this.scriptContext);
        scriptEngine.addScriptEngineListener(this);

    }

    public void showDialog() {
        pack();
        setLocationRelativeTo(getParent());
        setMinimumSize(getSize());
        setVisible(true);
    }

    private void fireCancel(final NodeInterface node) {
        LOGGER.info("Stop the script on press cancel button.");
        stopScript();
    }

    private void stopScript() {
        LOGGER.info("Stop the script.");
        scriptEngine.stopScript();
    }

    @Override
    public void scriptStatusChanged(final ScriptStatus scriptStatus) {
        SwingUtilities.invokeLater(() -> {
            switch (scriptStatus) {
                case RUNNING:
                    startScript.setEnabled(false);
                    stopScript.setEnabled(true);
                    executionStateIconLabel.setIcon(executionRunningIcon);
                    break;
                case STOPPED:
                case FINISHED:
                    startScript.setEnabled(true);
                    stopScript.setEnabled(false);
                    executionStateIconLabel.setIcon(executionFinishedIcon);
                    break;
                case FINISHED_WITH_ERRORS:
                case ABORTED:
                    startScript.setEnabled(true);
                    stopScript.setEnabled(false);

                    // TODO set the error icon
                    executionStateIconLabel.setIcon(executionErrorIcon);
                    break;
                default:
                    break;
            }
            currentCommandChanged(null);
        });
    }

    private final static Charset ENCODING = StandardCharsets.UTF_8;

    private void prepareScript(String fileName) throws IOException {
        Path fFilePath = Paths.get(fileName);

        // create the factory to parse the script
        SwitchFunctionsScriptCommandFactory factory = new SwitchFunctionsScriptCommandFactory(this.consoleService);
        List<ScriptCommand<Scripting>> scriptCommands = new LinkedList<>();

        try (Scanner scanner = new Scanner(fFilePath, ENCODING.name())) {
            while (scanner.hasNextLine()) {
                processLine(scanner.nextLine().trim(), factory, scriptCommands);
            }
        }

        LOGGER.info("Prepared list of commands: {}", scriptCommands);

        scriptEngine.setScriptCommands(scriptCommands);
    }

    private void processLine(
        String line, SwitchFunctionsScriptCommandFactory factory, List<ScriptCommand<Scripting>> scriptCommands) {
        LOGGER.info("Process line: {}", line);

        if (line.startsWith("#") || StringUtils.isBlank(line)) {
            LOGGER.info("Skip comment or empty line.");
        }
        else {
            LOGGER.info("Current line: {}", line);
            ScriptCommand<Scripting> command = factory.parse(line);
            if (command != null) {
                scriptCommands.add(command);
            }
        }
    }

    @Override
    public void sendPortStatusAction(final SwitchingNodeInterface node, int port, BidibStatus status) {
        SwitchPortStatus switchPortStatus = (SwitchPortStatus) status;

        final SwitchingNodeInterface selectedNode = node != null ? node : this.node.getSwitchingNode();

        SwitchPort switchPort = new SwitchPort();
        switchPort.setId(port);
        switchPort.setStatus(switchPortStatus);
        switchingNodeService.setPortStatus(ConnectionRegistry.CONNECTION_ID_MAIN, selectedNode, switchPort);
    }

    @Override
    public void sendPortValueAction(final SwitchingNodeInterface node, int port, int position) {

        final SwitchingNodeInterface selectedNode = node != null ? node : this.node.getSwitchingNode();

        ServoPort servoPort = new ServoPort();
        servoPort.setId(port);
        servoPort.setValue(position);
        switchingNodeService.setPortStatus(ConnectionRegistry.CONNECTION_ID_MAIN, selectedNode, servoPort);
    }

    @Override
    public void currentCommandChanged(final ScriptCommand<Scripting> command) {

        if (SwingUtilities.isEventDispatchThread()) {
            currentCommandModel.setValue((command != null ? command.toString() : null));
        }
        else {
            try {
                SwingUtilities.invokeAndWait(new Runnable() {

                    @Override
                    public void run() {
                        currentCommandModel.setValue((command != null ? command.toString() : null));
                    }
                });
            }
            catch (InvocationTargetException | InterruptedException e) {
                LOGGER.warn("Update current command failed.", e);
            }
        }
    }

    @Override
    public void setActiveAspect(final SwitchingNodeInterface node, int accessoryNumber, int aspectNumber) {
        LOGGER
            .info("Activate the aspect, node: {}, accessoryNumber: {}, aspectNumber: {}", node, accessoryNumber,
                aspectNumber);

        final Accessory accessory =
            AccessoryListUtils.findAccessoryByAccessoryNumber(node.getNode().getAccessories(), accessoryNumber);

        // final Accessory accessory = new Accessory();
        // accessory.setId(accessoryNumber);

        switchingNodeService.setAccessoryAspect(ConnectionRegistry.CONNECTION_ID_MAIN, node, accessory, aspectNumber);
    }

    @Override
    public AccessoryExecutionState getAccessoryExecutionState(SwitchingNodeInterface node, int accessoryNumber) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public List<NodeInterface> getNodesByVidAndPid(int vid, int pid) {

        List<NodeInterface> nodes = this.nodeService.getAllNodes(ConnectionRegistry.CONNECTION_ID_MAIN);
        return nodes
            .stream().filter(n -> NodeUtils.isMatchingVidAndPid(n.getUniqueId(), vid, pid))
            .collect(Collectors.toList());
    }

    @Override
    public void setCv(Long uuid, CvType... cvTypes) {
        // TODO Auto-generated method stub

    }

    @Override
    public List<ConfigurationVariable> getCv(Long uniqueId, CvType... cvTypes) {
        LOGGER.info("Get the CV directly from the node, uniqueId: {}, cvTypes: {}", uniqueId, cvTypes);
        // TODO Auto-generated method stub

        return Collections.emptyList();
    }

    @Override
    public void setFeature(Long uuid, FeatureType... features) {
        // TODO Auto-generated method stub

    }

    @Override
    public void setLabel(Long uuid, TargetType portType) {
        // TODO Auto-generated method stub

    }

    @Override
    public void setMacro(Long uuid, Macro macro) {
        // TODO Auto-generated method stub

    }

    @Override
    public void setAccessory(Long uuid, Accessory accessory) {
        // TODO Auto-generated method stub

    }

    @Override
    public boolean isNodeHasRestartPending(Long uuid) {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public void resetNode(Long uuid) {
        // TODO Auto-generated method stub

    }

    @Override
    public void reselectNode(Long uuid) {
        // TODO Auto-generated method stub

    }

    @Override
    public void setPortConfig(Long uniqueId, TargetType targetType, Map<Byte, PortConfigValue<?>> portConfig) {
        LOGGER
            .info("Set the port scripting, uuid: {}, targetType: {}, portConfig: {}",
                ByteUtils.formatHexUniqueId(uniqueId), targetType, portConfig);

        final NodeInterface node = this.nodeService.getNode(ConnectionRegistry.CONNECTION_ID_MAIN, uniqueId);

        int portId = targetType.getPortNum();
        ScriptingTargetType scriptingTargetType = targetType.getScriptingTargetType();

        Port<?> port = null;
        switch (scriptingTargetType) {
            case SWITCHPAIRPORT:
                port = new SwitchPairPort();
                port.setId(portId);
                break;
            default:
                break;
        }

        switchingNodeService
            .setPortConfig(ConnectionRegistry.CONNECTION_ID_MAIN, node.getSwitchingNode(), port, (LcOutputType) null,
                portConfig);

        // TODO Auto-generated method stub

    }

    @Override
    public void assertPortType(Long uuid, TargetType portType) {
        // TODO Auto-generated method stub

    }

    @Override
    public void setBoosterStatus(BoosterNodeInterface boosterNode, BoosterStatus requestedStatus) {
        LOGGER.info("Set the booster status, node: {}, requestedStatus: {}", boosterNode, requestedStatus);

        this.boosterService.setBoosterState(ConnectionRegistry.CONNECTION_ID_MAIN, boosterNode, requestedStatus);

    }

    @Override
    public void setIdentifyState(Long uniqueId, IdentifyState identifyState) {
        final NodeInterface node = this.nodeService.getNode(ConnectionRegistry.CONNECTION_ID_MAIN, uniqueId);
        this.nodeService.identify(ConnectionRegistry.CONNECTION_ID_MAIN, node, identifyState);
    }

    @Override
    public IdentifyState queryIdentifyState(Long uniqueId) {
        final NodeInterface node = this.nodeService.getNode(ConnectionRegistry.CONNECTION_ID_MAIN, uniqueId);
        return node.getIdentifyState();
    }

    @Override
    public String setString(Long uniqueId, int namespace, int index, String value) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public String getString(Long uniqueId, int namespace, int index) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public NodeInterface getNodesByUniqueId(long uniqueId) {
        // TODO Auto-generated method stub
        return null;
    }
}
