package org.bidib.wizard.mvc.main.view.panel;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.PortValueListener;
import org.bidib.wizard.client.common.model.SimplePortTableModel;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.listener.ButtonListener;
import org.bidib.wizard.client.common.view.renderer.BidibStatusTableRenderer;
import org.bidib.wizard.client.common.view.renderer.PortConfigErrorAwareRenderer;
import org.bidib.wizard.client.common.view.slider.SliderEditor;
import org.bidib.wizard.model.ports.ConfigurablePort;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.MotorPortStatus;
import org.bidib.wizard.mvc.main.controller.MotorPortPanelController;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.MotorPortTableModel;
import org.bidib.wizard.mvc.main.model.listener.MotorPortModelListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabComponentCreator;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.bidib.wizard.mvc.main.view.table.MotorPortTable;
import org.bidib.wizard.mvc.main.view.table.MotorSliderEditor;
import org.bidib.wizard.mvc.main.view.table.PortComboBoxWithButtonEditorRenderer;

import com.jidesoft.grid.TableColumnChooser;

public class MotorPortListPanel
    extends SimplePortListPanel<MotorPortStatus, MotorPort, PortValueListener<MotorPort>, MotorPortModelListener>
    implements TabVisibilityProvider, TabPanelProvider, TabComponentCreator {
    private static final long serialVersionUID = 1L;

    private final MainModel mainModel;

    private final TabVisibilityListener tabVisibilityListener;

    public MotorPortListPanel(final MotorPortPanelController controller, final MotorPortTableModel tableModel,
        MainModel mainModel, final TabVisibilityListener tabVisibilityListener) {
        super(tableModel, Resources.getString(MotorPortListPanel.class, "emptyTable"));

        this.mainModel = mainModel;
        this.tabVisibilityListener = tabVisibilityListener;
    }

    @Override
    protected void createTable(
        final SimplePortTableModel<MotorPortStatus, MotorPort, MotorPortModelListener> tableModel,
        String emptyTableText) {

        table = new MotorPortTable(tableModel, emptyTableText) {
            private static final long serialVersionUID = 1L;

            // @Override
            // protected void sliderStateChanged(MotorPort motorPort) {
            // // if (!updateModelInProgress.get()) {
            // // fireTestButtonPressed(motorPort);
            // // }
            // // else {
            // // LOGGER.info("Do not send new port status to motor because the model was updated: {}", motorPort);
            // // }
            // }
        };

        table.adjustRowHeight();
        // do not allow drag columns to other position
        table.getTableHeader().setReorderingAllowed(false);

        table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);

        // disabled sorting
        table.setSortable(false);

        // let the left and right key change the slider value and <numeric block +> and <numeric block ->
        table
            .getInputMap(JTable.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
            .put(KeyStroke.getKeyStroke(KeyEvent.VK_SUBTRACT, 0), "left");
        table
            .getInputMap(JTable.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
            .put(KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, 0), "left");
        table.getActionMap().put("left", new AbstractAction() {
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JTable table = (JTable) e.getSource();
                TableCellEditor editor = table.getCellEditor(table.getSelectedRow(), table.getSelectedColumn());

                if (editor instanceof SliderEditor) {
                    table.editCellAt(table.getSelectedRow(), table.getSelectedColumn());
                    ((SliderEditor) editor).stepDown();
                }
            }
        });
        // slider value up with <numeric block +> and <cursor right>
        table
            .getInputMap(JTable.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
            .put(KeyStroke.getKeyStroke(KeyEvent.VK_ADD, 0), "right");
        table
            .getInputMap(JTable.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
            .put(KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, 0), "right");
        table.getActionMap().put("right", new AbstractAction() {
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JTable table = (JTable) e.getSource();
                TableCellEditor editor = table.getCellEditor(table.getSelectedRow(), table.getSelectedColumn());

                if (editor instanceof SliderEditor) {
                    table.editCellAt(table.getSelectedRow(), table.getSelectedColumn());
                    ((SliderEditor) editor).stepUp();
                }
            }
        });

        // slider stop with <numeric block 0>
        table
            .getInputMap(JTable.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
            .put(KeyStroke.getKeyStroke(KeyEvent.VK_NUMPAD0, 0), "stop");
        table.getActionMap().put("stop", new AbstractAction() {
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JTable table = (JTable) e.getSource();
                TableCellEditor editor = table.getCellEditor(table.getSelectedRow(), table.getSelectedColumn());

                if (editor instanceof SliderEditor) {
                    table.editCellAt(table.getSelectedRow(), table.getSelectedColumn());
                    ((MotorSliderEditor) editor).stop();
                }
            }
        });

        TableColumn tc = table.getColumnModel().getColumn(MotorPortTableModel.COLUMN_LABEL);
        tc.setCellRenderer(new PortConfigErrorAwareRenderer(MotorPortTableModel.COLUMN_LABEL));
        tc.setIdentifier(Integer.valueOf(MotorPortTableModel.COLUMN_LABEL));

        // Set the status renderer
        tc = table.getColumnModel().getColumn(MotorPortTableModel.COLUMN_STATUS);
        tc.setIdentifier(Integer.valueOf(MotorPortTableModel.COLUMN_STATUS));
        tc
            .setCellRenderer(new BidibStatusTableRenderer(MotorPortStatus.class, "status.",
                MotorPortTableModel.COLUMN_PORT_INSTANCE) {
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean isPortEnabled(ConfigurablePort<?> port) {
                    if (port instanceof Port) {
                        if (Port.getConfiguredPortType((Port<?>) port) != LcOutputType.MOTORPORT) {
                            return false;
                        }
                    }
                    return true;
                }
            });
        tc.setMinWidth(100);
        tc.setMaxWidth(120);

        final TableColumn buttonColumn = table.getColumnModel().getColumn(MotorPortTableModel.COLUMN_TEST);
        buttonColumn.setIdentifier(Integer.valueOf(MotorPortTableModel.COLUMN_TEST));
        buttonColumn.setMinWidth(180);
        buttonColumn.setMaxWidth(200);

        // buttonColumn
        // .setCellRenderer(new PortComboBoxWithButtonRenderer<BidibStatus>(table.getActions(MotorPortStatus.FORWARD),
        // ">", MotorPortStatus.class, MotorPortTableModel.COLUMN_PORT_INSTANCE) {
        // private static final long serialVersionUID = 1L;
        //
        // @Override
        // protected void setSelectedValue(Port<?> port) {
        // MotorPortStatus portStatus = null;
        // if (port != null) {
        // portStatus = (MotorPortStatus) port.getStatus();
        // }
        // comboBox.setSelectedItem(portStatus);
        // }
        //
        // @Override
        // protected boolean isPortEnabled(ConfigurablePort<?> port) {
        // if (port instanceof Port) {
        // if (Port.getConfiguredPortType((Port<?>) port) != LcOutputType.MOTORPORT) {
        // return false;
        // }
        // }
        // return true;
        // }
        // });

        final PortComboBoxWithButtonEditorRenderer<BidibStatus> editor =
            new PortComboBoxWithButtonEditorRenderer<BidibStatus>(table.getActions(MotorPortStatus.FORWARD), ">",
                MotorPortStatus.class, MotorPortTableModel.COLUMN_PORT_INSTANCE) {
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean isPortEnabled(ConfigurablePort<?> port) {
                    if (port instanceof Port) {
                        if (Port.getConfiguredPortType((Port<?>) port) != LcOutputType.MOTORPORT) {
                            return false;
                        }
                    }
                    return true;
                }
            };
        editor.addButtonListener(new ButtonListener() {

            @Override
            public void buttonPressed(int row, int column, Object value) {
                LOGGER.info("The test button was pressed, row: {}, column: {}", row, column);
                tableModel.setValueAt(value, row, MotorPortTableModel.COLUMN_TEST);
            }
        });

        buttonColumn.setCellEditor(editor);
        buttonColumn.setCellRenderer(editor);

        TableColumnChooser.hideColumn(table, MotorPortTableModel.COLUMN_PORT_INSTANCE);
    }

    @Override
    public JPanel getComponent() {
        return this;
    }

    @Override
    public Object getCreator() {
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof TabComponentCreator) {
            TabComponentCreator creator = (TabComponentCreator) other;
            // TODO if more than a single instance is available this must be changed
            if (creator.getCreator() instanceof MotorPortListPanel) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void listChanged() {
        LOGGER.info("Update model has started, call clearTable.");

        super.listChanged();

        tabVisibilityListener.setTabVisible(this, isTabVisible());
    }

    @Override
    public Class<?> getPortClass() {
        return MotorPort.class;
    }

    @Override
    public boolean isTabVisible() {
        final NodeInterface node = mainModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = node.hasMotorPorts();
            LOGGER.debug("Check if tab is visible: {}", isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    @Override
    protected List<MotorPort> getPorts() {
        final NodeInterface node = mainModel.getSelectedNode();
        if (node != null) {
            List<MotorPort> ports = new LinkedList<>();
            ports.addAll(node.getMotorPorts());
            return ports;
        }
        return Collections.emptyList();
    }

    public void refreshView() {
        listChanged();
    }
}
