/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.dialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.view.WindowUtils;

public class NodeDetailsDialog {
    public NodeDetailsDialog(NodeInterface node, int x, int y) {
        String label = node.toString();
        byte[] address = node.getNode().getAddr();
        String uuid = ByteUtils.getUniqueIdAsString((long)node.getNode().getUniqueId());
        SoftwareVersion swVersion = node.getNode().getSoftwareVersion();
        ProtocolVersion pVersion = node.getNode().getProtocolVersion();
        List features = null;
        if (!node.isBootloaderNode()) {
            features = node.getNode().getFeatures();
        }
        JOptionPane pane = new JOptionPane(this.getPanel(label, address, swVersion, pVersion, uuid, (Collection)features), 1);
        JDialog dialog = pane.createDialog(null, Resources.getString(this.getClass(), (String)"title"));
        WindowUtils.centerOnCurrentScreen((Component)JOptionPane.getFrameForComponent(null), (Component)dialog);
        dialog.setVisible(true);
    }

    private String getFeatureName(String name) {
        String result = name;
        if (result.startsWith("FEATURE_")) {
            result = result.substring(8);
        }
        return result;
    }

    private JPanel getPanel(String label, byte[] address, SoftwareVersion swVersion, ProtocolVersion pVersion, String uuid, Collection<Feature> features) {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 5, 5, 5);
        result.add((Component)new JLabel(Resources.getString(this.getClass(), (String)"label") + ":"), c);
        c.fill = 2;
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)new JLabel(label), c);
        c.fill = 0;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel(Resources.getString(this.getClass(), (String)"address") + ":"), c);
        c.fill = 2;
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)new JLabel(Arrays.toString(address)), c);
        c.fill = 0;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel(Resources.getString(this.getClass(), (String)"software") + ":"), c);
        c.fill = 2;
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)new JLabel(String.valueOf(swVersion)), c);
        c.fill = 0;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel(Resources.getString(this.getClass(), (String)"protocol") + ":"), c);
        c.fill = 2;
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)new JLabel(String.valueOf(pVersion)), c);
        c.fill = 0;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel(Resources.getString(this.getClass(), (String)"uuid") + ":"), c);
        c.fill = 2;
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)new JLabel(uuid), c);
        if (features != null) {
            c.fill = 0;
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            result.add((Component)new JLabel(Resources.getString(this.getClass(), (String)"features") + ":"), c);
            StringBuilder featuresString = new StringBuilder();
            for (Feature feature : features) {
                featuresString.append(this.getFeatureName(feature.getFeatureName()));
                featuresString.append(" : ");
                featuresString.append(feature.getValue());
                featuresString.append('\n');
            }
            JTextArea featuresTextArea = new JTextArea(featuresString.toString());
            featuresTextArea.setEditable(false);
            featuresTextArea.setOpaque(false);
            featuresTextArea.setFont(UIManager.getFont("Label.font"));
            featuresTextArea.setEditable(false);
            c.fill = 2;
            ++c.gridx;
            c.weightx = 1.0;
            result.add((Component)featuresTextArea, c);
        }
        return result;
    }
}

