/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.dmx.view.panel;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import org.bidib.wizard.api.model.function.MacroFunction;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.mvc.dmx.view.panel.DmxDataItem;
import org.jfree.chart.util.Args;
import org.jfree.data.general.SeriesException;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmxSeries
extends XYSeries {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmxSeries.class);
    private static final long serialVersionUID = 1L;
    public static final int BRIGHTNESS_MIN = 0;
    public static final int BRIGHTNESS_MAX = 100;
    private static AtomicLong UNIQUEID = new AtomicLong(0L);
    private MethodHandle findBoundsByIterationMethod;
    private MethodHandle updateBoundsForAddedItemMethod;
    private MethodHandle updateBoundsForRemovedItemMethod;

    public DmxSeries(Comparable<String> key, boolean autoSort) {
        super(key, autoSort, true);
    }

    public DmxDataItem getNewDmxDataItem(double x, double y) {
        long uniqueId = UNIQUEID.incrementAndGet();
        return new DmxDataItem((Number)x, (Number)y, uniqueId, (Port)null);
    }

    public void add(Number x, Number y, Port<?> port) {
        if (y.intValue() < 0) {
            LOGGER.info("Y value is out of range!");
            y = 0;
        } else if (y.intValue() > 100) {
            LOGGER.info("Y value is out of range!");
            y = 100;
        }
        if (x.intValue() < 0) {
            x = 0;
        }
        long uniqueId = UNIQUEID.incrementAndGet();
        super.add((XYDataItem)new DmxDataItem(x, y, uniqueId, port));
    }

    public DmxDataItem add(int x, int y, Port<?> port) {
        if (y < 0) {
            LOGGER.info("Y value is out of range!");
            y = 0;
        } else if (y > 100) {
            LOGGER.info("Y value is out of range!");
            y = 100;
        }
        if (x < 0) {
            x = 0;
        }
        long uniqueId = UNIQUEID.incrementAndGet();
        DmxDataItem dmxDataItem = new DmxDataItem((Number)x, (Number)y, uniqueId, port);
        super.add((XYDataItem)dmxDataItem);
        return dmxDataItem;
    }

    public void add(int x, int y, MacroFunction macro) {
        if (y < 0) {
            LOGGER.info("Y value is out of range!");
            y = 0;
        } else if (y > 100) {
            LOGGER.info("Y value is out of range!");
            y = 100;
        }
        if (x < 0) {
            x = 0;
        }
        long uniqueId = UNIQUEID.incrementAndGet();
        super.add((XYDataItem)new DmxDataItem((Number)x, (Number)y, uniqueId, macro));
    }

    public void add(double x, double y, Port<?> port) {
        if (y < 0.0) {
            LOGGER.info("Y value is out of range!");
            y = 0.0;
        } else if (y > 100.0) {
            LOGGER.info("Y value is out of range!");
            y = 100.0;
        }
        if (x < 0.0) {
            x = 0.0;
        }
        long uniqueId = UNIQUEID.incrementAndGet();
        super.add((XYDataItem)new DmxDataItem((Number)x, (Number)y, uniqueId, port));
    }

    public XYDataItem addOrUpdate(Number x, Number y, DmxDataItem item) {
        if (y.intValue() < 0) {
            LOGGER.info("Y value is out of range!");
            y = 0;
        } else if (y.intValue() > 100) {
            LOGGER.info("Y value is out of range!");
            y = 100;
        }
        if (x.intValue() < 0) {
            x = 0;
        }
        item.setTimeOffset(x.intValue());
        item.setBrightness(y.intValue());
        DmxDataItem overwritten = (DmxDataItem)this.addOrUpdate(item);
        return overwritten;
    }

    public int indexOf(Number x) {
        LOGGER.error("Called old indexOf!!!!");
        if (this.getAutoSort()) {
            return Collections.binarySearch(this.data, new DmxDataItem(x, null, -1L, (Port)null));
        }
        for (int i = 0; i < this.data.size(); ++i) {
            DmxDataItem item = (DmxDataItem)this.data.get(i);
            if (item.getTimeOffset() != x.intValue()) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(Number x, long uniqueId) {
        if (this.getAutoSort()) {
            int index = Collections.binarySearch(this.data, new DmxDataItem(x, null, uniqueId, (Port)null));
            LOGGER.info("indexOf, index: {}", (Object)index);
            return index;
        }
        LOGGER.info("Search index for unique id: {}", (Object)uniqueId);
        for (int i = 0; i < this.data.size(); ++i) {
            DmxDataItem item = (DmxDataItem)this.data.get(i);
            if (item.getUniqueId() != uniqueId) continue;
            LOGGER.info("The unique id matches: {}", (Object)item);
            return i;
        }
        return -1;
    }

    public void moveItem(DmxDataItem dmxDataItem, int newX, int newY) {
        if (dmxDataItem != null) {
            int index = this.indexOf(dmxDataItem.getX(), dmxDataItem.getUniqueId());
            LOGGER.info("moveItem, index of item: {}, dmxDataItem: {}", (Object)index, (Object)dmxDataItem);
            if (index > -1) {
                DmxDataItem dmxDataItem2 = (DmxDataItem)this.data.remove(index);
                dmxDataItem.setTimeOffset(newX);
                dmxDataItem.setBrightness(newY);
                LOGGER.info("binary search returned index: {}", (Object)index);
                if (index < 0) {
                    this.data.add(-index - 1, dmxDataItem);
                } else if (this.getAllowDuplicateXValues()) {
                    int size = this.data.size();
                    for (index = Collections.binarySearch(this.data, dmxDataItem); index < size && dmxDataItem.compareTo(this.data.get(index)) == 0; ++index) {
                    }
                    LOGGER.info("index after iterate over existing: {}", (Object)index);
                    if (index < this.data.size()) {
                        this.data.add(index, dmxDataItem);
                    } else {
                        this.data.add(dmxDataItem);
                    }
                } else {
                    throw new SeriesException("X-value already exists.");
                }
                this.doUpdateBoundsForAddedItem((XYDataItem)dmxDataItem);
                this.fireSeriesChanged();
            }
        }
    }

    public XYDataItem addOrUpdate(DmxDataItem item) {
        Args.nullNotPermitted((Object)item, (String)"item");
        if (this.getAllowDuplicateXValues()) {
            this.add((XYDataItem)item);
            return null;
        }
        XYDataItem overwritten = null;
        int index = this.indexOf(item.getX(), item.getUniqueId());
        if (index >= 0) {
            DmxDataItem existing = (DmxDataItem)this.data.get(index);
            overwritten = (XYDataItem)existing.clone();
            boolean iterate = false;
            double oldY = existing.getYValue();
            if (!Double.isNaN(oldY)) {
                iterate = oldY <= this.getMinY() || oldY >= this.getMaxY();
            }
            existing.setY(item.getY());
            existing.setTimeOffset(item.getTimeOffset());
            if (iterate) {
                this.doFindBoundsByIteration();
            } else if (item.getY() != null) {
                double yy = item.getY().doubleValue();
                this.setMinY(this.minIgnoreNaN(this.getMinY(), yy));
                this.setMaxY(this.maxIgnoreNaN(this.getMaxY(), yy));
            }
        } else {
            item = (DmxDataItem)item.clone();
            if (this.getAutoSort()) {
                this.data.add(-index - 1, item);
            } else {
                this.data.add(item);
            }
            this.doUpdateBoundsForAddedItem((XYDataItem)item);
            if (this.getItemCount() > this.getMaximumItemCount()) {
                XYDataItem removed = (XYDataItem)this.data.remove(0);
                this.doUpdateBoundsForRemovedItem(removed);
            }
        }
        this.fireSeriesChanged();
        return overwritten;
    }

    private void doFindBoundsByIteration() {
        try {
            if (this.findBoundsByIterationMethod == null) {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                MethodType mt = MethodType.methodType(Void.TYPE);
                this.findBoundsByIterationMethod = MethodHandles.privateLookupIn(XYSeries.class, lookup).findVirtual(XYSeries.class, "findBoundsByIteration", mt);
            }
            this.findBoundsByIterationMethod.invoke(this, null);
        }
        catch (Throwable ex) {
            LOGGER.warn("Invoke findBoundsByIteration failed.", ex);
        }
    }

    private void doUpdateBoundsForAddedItem(XYDataItem item) {
        try {
            if (this.updateBoundsForAddedItemMethod == null) {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                MethodType mt = MethodType.methodType(Void.TYPE, XYDataItem.class);
                this.updateBoundsForAddedItemMethod = MethodHandles.privateLookupIn(XYSeries.class, lookup).findVirtual(XYSeries.class, "updateBoundsForAddedItem", mt);
            }
            this.updateBoundsForAddedItemMethod.invoke(this, item);
        }
        catch (Throwable ex) {
            LOGGER.warn("Invoke updateBoundsForAddedItem failed.", ex);
        }
    }

    private void doUpdateBoundsForRemovedItem(XYDataItem item) {
        try {
            if (this.updateBoundsForRemovedItemMethod == null) {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                MethodType mt = MethodType.methodType(Void.TYPE, XYDataItem.class);
                this.updateBoundsForRemovedItemMethod = MethodHandles.privateLookupIn(XYSeries.class, lookup).findVirtual(XYSeries.class, "updateBoundsForRemovedItem", mt);
            }
            this.updateBoundsForRemovedItemMethod.invoke(this, item);
        }
        catch (Throwable ex) {
            LOGGER.warn("Invoke updateBoundsForRemovedItem failed.", ex);
        }
    }

    private double maxIgnoreNaN(double a, double b) {
        if (Double.isNaN(a)) {
            return b;
        }
        if (Double.isNaN(b)) {
            return a;
        }
        return Math.max(a, b);
    }

    private double minIgnoreNaN(double a, double b) {
        if (Double.isNaN(a)) {
            return b;
        }
        if (Double.isNaN(b)) {
            return a;
        }
        return Math.min(a, b);
    }

    private void setMinY(double minY) {
        LOGGER.debug("Set the new minY value: {}", (Object)minY);
        try {
            Field fieldMinY = XYSeries.class.getDeclaredField("minY");
            fieldMinY.setAccessible(true);
            fieldMinY.set(this, minY);
        }
        catch (Exception ex) {
            LOGGER.warn("Set the minY value failed.", (Throwable)ex);
        }
    }

    private void setMaxY(double maxY) {
        LOGGER.debug("Set the new maxY value: {}", (Object)maxY);
        try {
            Field fieldMaxY = XYSeries.class.getDeclaredField("maxY");
            fieldMaxY.setAccessible(true);
            fieldMaxY.set(this, maxY);
        }
        catch (Exception ex) {
            LOGGER.warn("Set the maxY value failed.", (Throwable)ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(XYDataItem item, boolean notify) {
        Args.nullNotPermitted((Object)item, (String)"item");
        item = (XYDataItem)item.clone();
        if (this.getAutoSort()) {
            int index = Collections.binarySearch(this.data, item);
            if (index < 0) {
                this.data.add(-index - 1, item);
            } else {
                if (!this.getAllowDuplicateXValues()) throw new SeriesException("X-value already exists.");
                int size = this.data.size();
                while (index < size && item.compareTo(this.data.get(index)) == 0) {
                    ++index;
                }
                if (index < this.data.size()) {
                    this.data.add(index, item);
                } else {
                    this.data.add(item);
                }
            }
        } else {
            if (!this.getAllowDuplicateXValues()) {
                DmxDataItem dmxDataItem = (DmxDataItem)item;
                int index = this.indexOf(item.getX(), dmxDataItem.getUniqueId());
                if (index >= 0) {
                    throw new SeriesException("X-value already exists.");
                }
            }
            this.data.add(item);
        }
        this.doUpdateBoundsForAddedItem(item);
        if (this.getItemCount() > this.getMaximumItemCount()) {
            XYDataItem removed = (XYDataItem)this.data.remove(0);
            this.doUpdateBoundsForRemovedItem(removed);
        }
        if (!notify) return;
        this.fireSeriesChanged();
    }
}

