/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.jbidibc.exchange.vendorcv.VendorCvData;
import org.bidib.jbidibc.exchange.vendorcv.VendorCvFactory;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.service.node.NodeService;
import org.bidib.wizard.client.common.controller.CvDefinitionPanelControllerInterface;
import org.bidib.wizard.client.common.controller.FeedbackPortStatusChangeProvider;
import org.bidib.wizard.client.common.view.cvdef.CvContainer;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeModelRegistry;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeTableModel;
import org.bidib.wizard.client.common.view.cvdef.CvNode;
import org.bidib.wizard.common.model.settings.MiscSettingsInterface;
import org.bidib.wizard.common.utils.SearchPathUtils;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.CvDefinitionPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabStatusListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CvDefinitionPanelController
implements CvDefinitionPanelControllerInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(CvDefinitionPanelController.class);
    private final MainModel mainModel;
    private final FeedbackPortStatusChangeProvider feedbackPortStatusChangeProvider;
    private CvDefinitionPanel cvDefinitionPanel;
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private MiscSettingsInterface miscSettings;
    private final String connectionId;
    @Autowired
    private CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry;

    public CvDefinitionPanelController(MainModel mainModel, FeedbackPortStatusChangeProvider feedbackPortStatusChangeProvider, String connectionId) {
        this.mainModel = mainModel;
        this.feedbackPortStatusChangeProvider = feedbackPortStatusChangeProvider;
        this.connectionId = connectionId;
    }

    public void start(TabStatusListener tabStatusListener) {
        this.cvDefinitionPanel = new CvDefinitionPanel((CvDefinitionPanelControllerInterface)this, this.feedbackPortStatusChangeProvider, this.mainModel, tabStatusListener, this.settingsService);
        this.mainModel.addNodeListListener((NodeListListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public CvDefinitionPanel getCvDefinitionPanel() {
        return this.cvDefinitionPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CvDefinitionTreeTableModel getCvDefinitionTreeTableModel(NodeInterface node) {
        LOGGER.info("Get the cvDefinitionTreeTableModel for node: {}", (Object)node);
        long uniqueId = node.getUniqueId();
        CvContainer cvContainer = null;
        CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry = this.cvDefinitionTreeModelRegistry;
        synchronized (cvDefinitionTreeModelRegistry) {
            cvContainer = this.cvDefinitionTreeModelRegistry.getCvContainer(uniqueId);
            if (cvContainer == null && node.getVendorCV() != null) {
                LOGGER.info("No cvContainer found but vendorCV available. Prepare the vendorCV tree for node: {}", (Object)node);
                VendorCvData vendorCV = node.getVendorCV();
                this.cvDefinitionTreeModelRegistry.prepareVendorCVTree(node, vendorCV, false);
                cvContainer = this.cvDefinitionTreeModelRegistry.getCvContainer(uniqueId);
            }
        }
        if (cvContainer != null) {
            return cvContainer.getCvTreeModel();
        }
        return null;
    }

    public List<ConfigurationVariable> getConfigVariables(NodeInterface node) {
        LOGGER.info("Get the confiuration variables for node: {}", (Object)node);
        long uniqueId = node.getUniqueId();
        CvContainer cvContainer = this.cvDefinitionTreeModelRegistry.getCvContainer(uniqueId);
        if (cvContainer != null) {
            return cvContainer.getConfigVariables();
        }
        return Collections.emptyList();
    }

    public Map<String, CvNode> getCvNumberToNodeMap(NodeInterface node) {
        LOGGER.info("Get the cvNumberToNodeMap for node: {}", (Object)node);
        long uniqueId = node.getUniqueId();
        CvContainer cvContainer = this.cvDefinitionTreeModelRegistry.getCvContainer(uniqueId);
        if (cvContainer != null) {
            return cvContainer.getCvNumberToNodeMap();
        }
        return Collections.emptyMap();
    }

    public void replaceVendorCVTree(NodeInterface node) {
        this.cvDefinitionTreeModelRegistry.prepareVendorCVTree(node, node.getVendorCV(), true);
    }

    public VendorCvData copyCvDefinitionToUserDir(Context context, NodeInterface node) {
        VendorCvData vendorCV = null;
        if (node != null) {
            try {
                String labelPath = this.miscSettings.getBidibConfigDir();
                File targetPath = new File(labelPath, "data/BiDiBNodeVendorData");
                vendorCV = VendorCvFactory.getCvDefinition((Node)node.getNode(), (Context)context, SearchPathUtils::lookupFilesInClasspath, (String[])new String[]{"classpath:/bidib"});
                LOGGER.info("Copy the vendorCV: {}", (Object)vendorCV);
                if (vendorCV != null) {
                    String fileName = vendorCV.getFilename();
                    LOGGER.info("Save to target filename: {}", (Object)fileName);
                    FileUtils.forceMkdir((File)targetPath);
                    VendorCvFactory.saveCvDefinition((VendorCvData)vendorCV, (File)new File(targetPath, fileName));
                } else {
                    LOGGER.warn("No vendorCV available for node: {}", (Object)node);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Get CV definition for node failed.", (Throwable)ex);
                throw new RuntimeException("Copy VendorCV to user dir failed.", ex);
            }
            if (vendorCV != null) {
                node.setVendorCV(vendorCV);
                this.replaceVendorCVTree(node);
            } else if (ProductUtils.isOneBootloader((long)node.getUniqueId())) {
                LOGGER.info("The current node is a OneBootloader.");
            } else {
                LOGGER.warn("No CV definition available for node: {}", (Object)node);
            }
        }
        this.mainModel.setCvDefinition(vendorCV);
        return vendorCV;
    }

    public VendorCvData loadCvDefinition(Context context, NodeInterface node) {
        VendorCvData vendorCV = null;
        LOGGER.info("Load the CV definition for node: {}", (Object)node);
        if (node != null) {
            vendorCV = node.getVendorCV();
            if (vendorCV == null) {
                try {
                    String installationPath = this.settingsService.getInstallationPath();
                    LOGGER.info("Current installation path: {}", (Object)installationPath);
                    File file = new File(installationPath);
                    file = new File(file.getAbsoluteFile(), "data/BiDiBNodeVendorData");
                    String userHome = System.getProperty("user.home");
                    File searchPathUserHomeWizard = new File(userHome, ".BiDiBWizard/data/BiDiBNodeVendorData");
                    String labelPath = this.miscSettings.getBidibConfigDir();
                    File searchPathLabelPath = new File(labelPath, "data/BiDiBNodeVendorData");
                    vendorCV = VendorCvFactory.getCvDefinition((Node)node.getNode(), (Context)context, SearchPathUtils::lookupFilesInClasspath, (String[])new String[]{searchPathLabelPath.getAbsolutePath(), file.getAbsolutePath(), "classpath:/bidib", searchPathUserHomeWizard.getAbsolutePath()});
                }
                catch (Exception ex) {
                    LOGGER.warn("Get CV definition for node failed.", (Throwable)ex);
                }
            }
            if (vendorCV != null) {
                if (node.getVendorCV() == null) {
                    node.setVendorCV(vendorCV);
                }
                LOGGER.info("Prepare the CvDefinitionTreeTableModel in the CvDefinitionPanelController for node: {}", (Object)node);
                this.getCvDefinitionTreeTableModel(node);
                List configurationVariables = this.getConfigVariables(node);
                node.setConfigVariables(configurationVariables);
            } else if (ProductUtils.isOneBootloader((long)node.getUniqueId())) {
                LOGGER.info("The current node is a OneBootloader.");
            } else {
                LOGGER.warn("No CV definition available for node: {}", (Object)node);
            }
        }
        this.mainModel.setCvDefinition(vendorCV);
        return vendorCV;
    }

    public void reloadCvDefinition(Context context, NodeInterface node) {
        LOGGER.info("Reload the CV definition for node: {}", (Object)node);
        node.setVendorCV(null);
        this.cvDefinitionTreeModelRegistry.removeCvContainer(node.getUniqueId());
        this.loadCvDefinition(context, node);
    }

    public List<ConfigurationVariable> setConfigVariables(NodeInterface node, List<ConfigurationVariable> configVariables) {
        return this.nodeService.setConfigVariables(this.connectionId, node, configVariables);
    }
}

