/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import java.awt.Component;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.message.netbidib.NetBidibLinkData;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.jbidibc.netbidib.client.pairingstates.PairingStateEnum;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.dialog.PairingDialog;
import org.bidib.wizard.mvc.main.controller.PairingController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPairingController
implements PairingController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPairingController.class);
    private final Supplier<JFrame> parent;
    private final StatusBar statusBar;
    private PairingDialog pairingDialog;
    private final ConnectionService connectionService;
    private final Supplier<String> connectionId;
    private final ScheduledExecutorService netBidibPublisherWorker;

    public DefaultPairingController(Supplier<JFrame> parent, StatusBar statusBar, ConnectionService connectionService, Supplier<String> connectionId) {
        LOGGER.info("Created PairingController, provided connectionId: {}", connectionId);
        this.parent = parent;
        this.statusBar = statusBar;
        this.connectionService = connectionService;
        this.connectionId = connectionId;
        this.netBidibPublisherWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("netBidibPublisherWorkers-thread-%d").build());
    }

    public void publishAction(String connectionId, String messageKey, Context context) {
        LOGGER.info("Notify the action, connectionId: {}, messageKey: {}, context: {}", new Object[]{connectionId, messageKey, context});
        if (connectionId.equals(this.connectionId.get()) && messageKey.startsWith("pairing-")) {
            LOGGER.info("This is a pairing action: {}", (Object)messageKey);
            SwingUtilities.invokeLater(() -> {
                Long uniqueId = (Long)context.get("DESCRIPTOR_UID", Long.class, null);
                String connectionType = (String)context.get("CONNECTION_TYPE", String.class, null);
                LOGGER.info("Current uniqueId: {}, connectionType: {}", (Object)ByteUtils.formatHexUniqueId((Long)uniqueId), (Object)connectionType);
                switch (messageKey) {
                    case "pairing-state": {
                        if (context.get("PAIRING_STATE", PairingStateEnum.class, (Object)PairingStateEnum.Unpaired) == PairingStateEnum.Unpaired) {
                            LOGGER.info("Unpaired status was signalled. Send the pairing request to the remote partner.");
                            if (!"server".equals(connectionType)) {
                                this.signalPairingRequest(connectionId);
                            } else {
                                LOGGER.info("Don't send pairing request to remote partner if we are server.");
                            }
                            if (this.pairingDialog == null) {
                                LOGGER.info("Show the pairing dialog.");
                                String statusText = Resources.getString(DefaultPairingController.class, (String)messageKey);
                                this.statusBar.setStatusText(statusText, -1);
                                this.pairingDialog = new PairingDialog((Component)this.parent.get(), PairingDialog.PairingDialogType.PairingRequired, context, true, accepted -> {
                                    if (Boolean.FALSE == accepted) {
                                        LOGGER.info("Disconnect the connection because the user cancelled the pairing dialog. Current connectionId: {}", (Object)connectionId);
                                        this.connectionService.disconnect(connectionId);
                                    }
                                });
                                this.pairingDialog.setAlwaysOnTop(true);
                                this.pairingDialog.setVisible(true);
                                this.statusBar.setStatusText(null, -1);
                                break;
                            }
                            LOGGER.warn("Pairing dialog is already assigned.");
                            break;
                        }
                        LOGGER.info("Paired status was signalled. Hide the pairing dialog if shown, pairingDialog: {}", (Object)this.pairingDialog);
                        if (this.pairingDialog == null) break;
                        LOGGER.info("The pairing has passed. Hide the pairing dialog.");
                        this.pairingDialog.setVisible(false);
                        this.pairingDialog = null;
                        break;
                    }
                    case "pairing-required": {
                        if (this.pairingDialog == null) {
                            LOGGER.info("Show the pairing dialog.");
                            String statusText = Resources.getString(DefaultPairingController.class, (String)messageKey);
                            this.statusBar.setStatusText(statusText, -1);
                            this.pairingDialog = new PairingDialog((Component)this.parent.get(), PairingDialog.PairingDialogType.PairingRequired, context, true, accepted -> {
                                if (Boolean.FALSE == accepted) {
                                    LOGGER.info("Disconnect the connection because the user cancelled the pairing dialog. Current connectionId: {}", (Object)connectionId);
                                    this.connectionService.disconnect(connectionId);
                                }
                            });
                            this.pairingDialog.setAlwaysOnTop(true);
                            this.pairingDialog.setVisible(true);
                            this.statusBar.setStatusText(null, -1);
                            break;
                        }
                        LOGGER.warn("Pairing dialog is already assigned.");
                        break;
                    }
                    case "pairing-requested": {
                        if ("server".equals(connectionType)) {
                            if (this.pairingDialog != null) {
                                LOGGER.info("The pairing is requested. Hide the existing pairing dialog.");
                                this.pairingDialog.setVisible(false);
                                this.pairingDialog = null;
                            }
                            if (this.pairingDialog == null) {
                                LOGGER.info("Show the pairing requested dialog.");
                                String statusText = Resources.getString(DefaultPairingController.class, (String)messageKey);
                                this.statusBar.setStatusText(statusText, -1);
                                this.pairingDialog = new PairingDialog((Component)this.parent.get(), PairingDialog.PairingDialogType.PairingRequested, context, true, accepted -> {
                                    if (Boolean.FALSE == accepted) {
                                        LOGGER.info("Disconnect the connection because the user cancelled the pairing dialog.");
                                        this.signalPairingStatus(connectionId, uniqueId, NetBidibLinkData.PairingStatus.UNPAIRED);
                                        LOGGER.info("Disconnect the connection because the user cancelled the pairing dialog. Current connectionId: {}", (Object)connectionId);
                                        this.connectionService.disconnect(connectionId);
                                    } else {
                                        LOGGER.info("We accepted the pairing.");
                                        this.signalPairingStatus(connectionId, uniqueId, NetBidibLinkData.PairingStatus.PAIRED);
                                    }
                                });
                                this.pairingDialog.setAlwaysOnTop(true);
                                this.pairingDialog.setVisible(true);
                                this.statusBar.setStatusText(null, -1);
                                break;
                            }
                            LOGGER.warn("Pairing dialog is already assigned.");
                            LOGGER.info("We accept the pairing immediately.");
                            this.signalPairingStatus(connectionId, uniqueId, NetBidibLinkData.PairingStatus.PAIRED);
                            break;
                        }
                        LOGGER.info("We accept the pairing immediately.");
                        this.signalPairingStatus(connectionId, uniqueId, NetBidibLinkData.PairingStatus.PAIRED);
                        break;
                    }
                    case "pairing-passed": {
                        if (this.pairingDialog == null) break;
                        LOGGER.info("The pairing has passed. Hide the pairing dialog.");
                        this.pairingDialog.setVisible(false);
                        this.pairingDialog = null;
                        break;
                    }
                    case "pairing-failed": {
                        if (this.pairingDialog == null) break;
                        LOGGER.info("The pairing has failed. Hide the pairing dialog.");
                        this.pairingDialog.setVisible(false);
                        this.pairingDialog = null;
                        break;
                    }
                }
            });
        }
    }

    private void signalPairingStatus(String connectionId, Long uniqueId, NetBidibLinkData.PairingStatus pairingStatus) {
        LOGGER.info("Signal the pairing status to the connection: {}, uniqueId: {}", (Object)pairingStatus, (Object)ByteUtils.getUniqueIdAsString((Long)uniqueId));
        this.netBidibPublisherWorker.submit(() -> this.connectionService.signalPairingStatus(connectionId, uniqueId, pairingStatus));
    }

    private void signalPairingRequest(String connectionId) {
        LOGGER.info("Signal the pairing request to the connection.");
        this.netBidibPublisherWorker.submit(() -> this.connectionService.signalPairingRequest(connectionId));
    }

    public void closeDialogs() {
        LOGGER.info("Close the pairing dialogs.");
        if (this.pairingDialog != null) {
            LOGGER.info("The pairing has passed. Hide the pairing dialog.");
            this.pairingDialog.setVisible(false);
            this.pairingDialog = null;
        }
    }
}

