/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import com.vlsolutions.swing.docking.DockingDesktop;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.FeedbackAddressData;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.EnrailmentDirectionEnum;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.CommandStationNodeInterface;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.FeedbackPortListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.model.listener.PortListener;
import org.bidib.wizard.api.service.node.CommandStationService;
import org.bidib.wizard.api.utils.NodeUtils;
import org.bidib.wizard.client.common.model.listener.PortModelListener;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.labels.LabelsChangedEvent;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.config.LocoControllerFactory;
import org.bidib.wizard.config.PomProgrammerControllerFactory;
import org.bidib.wizard.mvc.loco.controller.LocoController;
import org.bidib.wizard.mvc.main.controller.FeedbackPortPanelController;
import org.bidib.wizard.mvc.main.controller.listener.FeedbackPortPanelListener;
import org.bidib.wizard.mvc.main.model.FeedbackPortModel;
import org.bidib.wizard.mvc.main.model.FeedbackPortTableModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.FeedbackPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.pom.controller.PomProgrammerController;
import org.bidib.wizard.mvc.pom.controller.listener.PomProgrammerControllerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

public class FeedbackPortPanelController
implements FeedbackPortPanelListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedbackPortPanelController.class);
    private final MainModel mainModel;
    private final NodeListListener nodeListListener;
    private FeedbackPortListPanel feedbackPortListPanel;
    private FeedbackPortModel feedbackPortModel;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    @Autowired
    private CommandStationService commandStationService;

    public FeedbackPortPanelController(MainModel mainModel, FeedbackPortModel feedbackPortModel) {
        this.mainModel = mainModel;
        this.feedbackPortModel = feedbackPortModel;
        this.nodeListListener = new /* Unavailable Anonymous Inner Class!! */;
        this.mainModel.addNodeListListener(this.nodeListListener);
    }

    public NodeInterface getSelectedNode() {
        return this.feedbackPortModel.getSelectedNode();
    }

    public FeedbackPortListPanel createPanel(TabVisibilityListener tabVisibilityListener) {
        LOGGER.info("Create new feedbackPortListPanel.");
        FeedbackPortTableModel tableModel = new FeedbackPortTableModel();
        this.feedbackPortListPanel = new FeedbackPortListPanel(this, tableModel, this.feedbackPortModel, this.mainModel, tabVisibilityListener);
        2 feedbackPortListener = new /* Unavailable Anonymous Inner Class!! */;
        this.feedbackPortModel.addFeedbackPortListener((FeedbackPortListener)feedbackPortListener);
        this.feedbackPortListPanel.setPortListener((PortListener)feedbackPortListener);
        tableModel.setPortListener((PortModelListener)new /* Unavailable Anonymous Inner Class!! */);
        return this.feedbackPortListPanel;
    }

    public void openLocoDialog(FeedbackAddressData addressData) {
        LOGGER.info("Open the loco controller dialog, addressData: {}", (Object)addressData);
        CommandStationNodeInterface node = NodeUtils.findRelatedCommandStationNode((Iterable)this.mainModel.getNodeProvider().getNodes(), (NodeInterface)this.getSelectedNode());
        if (node != null) {
            ApplicationContext applicationContext = DefaultApplicationContext.getInstance();
            org.springframework.context.ApplicationContext ctx = (org.springframework.context.ApplicationContext)applicationContext.get("SpringContext", org.springframework.context.ApplicationContext.class);
            LocoControllerFactory locoControllerFactory = (LocoControllerFactory)ctx.getBean(LocoControllerFactory.class);
            LocoController locoController = locoControllerFactory.createLocoController(node, (JFrame)JOptionPane.getFrameForComponent((Component)this.feedbackPortListPanel), this.mainModel.getNodeProvider());
            AddressData initialAddress = null;
            if (addressData != null) {
                EnrailmentDirectionEnum enrailmentDirection = addressData.getType();
                AddressTypeEnum addressType = null;
                switch (5.$SwitchMap$org$bidib$jbidibc$messages$enums$EnrailmentDirectionEnum[enrailmentDirection.ordinal()]) {
                    case 1: 
                    case 2: {
                        addressType = AddressTypeEnum.LOCOMOTIVE_FORWARD;
                        break;
                    }
                    case 3: {
                        addressType = AddressTypeEnum.ACCESSORY;
                        break;
                    }
                    case 4: {
                        addressType = AddressTypeEnum.EXTENDED_ACCESSORY;
                        break;
                    }
                }
                initialAddress = new AddressData(addressData.getAddress(), addressType);
            }
            locoController.start(initialAddress, null);
        }
    }

    public void openPomDialog(FeedbackAddressData addressData) {
        LOGGER.info("Open the POM dialog, addressData: {}", (Object)addressData);
        CommandStationNodeInterface node = NodeUtils.findRelatedCommandStationNode((Iterable)this.mainModel.getNodeProvider().getNodes(), (NodeInterface)this.getSelectedNode());
        if (node != null) {
            ApplicationContext applicationContext = DefaultApplicationContext.getInstance();
            org.springframework.context.ApplicationContext ctx = (org.springframework.context.ApplicationContext)applicationContext.get("SpringContext", org.springframework.context.ApplicationContext.class);
            PomProgrammerControllerFactory pomProgrammerControllerFactory = (PomProgrammerControllerFactory)ctx.getBean(PomProgrammerControllerFactory.class);
            PomProgrammerController pomProgrammerController = pomProgrammerControllerFactory.createPomProgrammerController(node, (JFrame)JOptionPane.getFrameForComponent((Component)this.feedbackPortListPanel), new Point(0, 0));
            pomProgrammerController.addPomProgrammerControllerListener((PomProgrammerControllerListener)new /* Unavailable Anonymous Inner Class!! */);
            AddressData initialAddress = null;
            if (addressData != null) {
                initialAddress = new AddressData(addressData.getAddress(), AddressTypeEnum.LOCOMOTIVE_FORWARD);
            }
            DockingDesktop desktop = (DockingDesktop)DefaultApplicationContext.getInstance().get("desktop", DockingDesktop.class);
            pomProgrammerController.start(desktop, initialAddress);
        }
    }

    private NodeLabels getNodeLabels() {
        WizardLabelFactory wizardLabelFactory = this.wizardLabelWrapper.getWizardLabelFactory();
        NodeLabels nodeLabels = wizardLabelFactory.loadLabels(Long.valueOf(this.mainModel.getSelectedNode().getUniqueId()), new String[0]);
        return nodeLabels;
    }

    private void saveLabels() {
        try {
            long uniqueId = this.mainModel.getSelectedNode().getUniqueId();
            this.wizardLabelWrapper.saveNodeLabels(Long.valueOf(uniqueId));
        }
        catch (Exception e) {
            LOGGER.warn("Save accessory labels failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @EventListener(value={LabelsChangedEvent.class})
    public void labelsChangedEvent(LabelsChangedEvent labelsChangedEvent) {
        LOGGER.info("The labels have changed, node: {}", (Object)labelsChangedEvent);
        if (this.feedbackPortListPanel != null) {
            SwingUtilities.invokeLater(() -> this.feedbackPortListPanel.refreshView());
        }
    }
}

