/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import java.util.List;
import org.apache.commons.lang3.time.StopWatch;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.CvDefinitionRequestListener;
import org.bidib.wizard.api.service.node.NodeService;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.mvc.main.controller.MainController;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.component.DefaultBusyFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainCvDefinitionRequestListener
implements CvDefinitionRequestListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainCvDefinitionRequestListener.class);
    private final MainModel mainModel;
    private final NodeService nodeService;
    private final String connectionId;
    private StatusBar statusBar;
    private DefaultBusyFrame frame;

    public MainCvDefinitionRequestListener(MainModel mainModel, NodeService nodeService, String connectionId, StatusBar statusBar, DefaultBusyFrame frame) {
        this.mainModel = mainModel;
        this.nodeService = nodeService;
        this.connectionId = connectionId;
        this.statusBar = statusBar;
        this.frame = frame;
    }

    public List<ConfigurationVariable> loadCvValues(List<ConfigurationVariable> configVariables) {
        LOGGER.info("Load CV definition values!");
        StopWatch sw = new StopWatch();
        sw.start();
        boolean cursorChanged = false;
        try {
            cursorChanged = this.frame.setBusy(true);
            NodeInterface selectedNode = this.mainModel.getSelectedNode();
            this.nodeService.queryConfigVariables(this.connectionId, selectedNode, configVariables);
            LOGGER.debug("Update model with configuration variables: {}", configVariables);
            selectedNode.updateConfigVariableValues(configVariables, true);
            if (cursorChanged) {
                this.frame.setBusy(false);
            }
            sw.stop();
            LOGGER.info("Load CV values has finished! Total loading duration: {}", (Object)sw);
            this.statusBar.setStatusText(String.format(Resources.getString(MainController.class, (String)"loadCvFinished"), sw), -1);
            return configVariables;
        }
        catch (RuntimeException ex) {
            LOGGER.warn("Load CV values has failed!", (Throwable)ex);
            this.statusBar.setStatusText(String.format(Resources.getString(MainController.class, (String)"loadCvFailed"), new Object[0]), -2);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeCvValues(List<ConfigurationVariable> cvList) {
        StopWatch sw;
        block3: {
            LOGGER.info("Write CV definition values!");
            sw = new StopWatch();
            sw.start();
            boolean cursorChanged = false;
            try {
                cursorChanged = this.frame.setBusy(true);
                NodeInterface selectedNode = this.mainModel.getSelectedNode();
                List configVars = this.nodeService.setConfigVariables(this.connectionId, selectedNode, cvList);
                selectedNode.updateConfigVariableValues(configVars, false);
                if (!cursorChanged) break block3;
            }
            catch (Throwable throwable) {
                if (cursorChanged) {
                    this.frame.setBusy(false);
                }
                sw.stop();
                LOGGER.info("Write CV values has finished! Total writing duration: {}", (Object)sw);
                this.statusBar.setStatusText(String.format(Resources.getString(MainController.class, (String)"writeCvFinished"), sw), -1);
                throw throwable;
            }
            this.frame.setBusy(false);
        }
        sw.stop();
        LOGGER.info("Write CV values has finished! Total writing duration: {}", (Object)sw);
        this.statusBar.setStatusText(String.format(Resources.getString(MainController.class, (String)"writeCvFinished"), sw), -1);
    }
}

