/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view;

import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.enums.DetachedState;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.api.model.Flag;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.MacroRef;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.NodeListProvider;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.service.node.BoosterService;
import org.bidib.wizard.api.service.node.CommandStationService;
import org.bidib.wizard.api.service.node.NodeService;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.api.utils.XmlLocaleUtils;
import org.bidib.wizard.client.common.mvc.firmware.controller.FirmwareController;
import org.bidib.wizard.client.common.mvc.firmware.controller.listener.FirmwareControllerListener;
import org.bidib.wizard.client.common.view.BidibNodeNameUtils;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeModelRegistry;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.config.AccessoryControllerFactory;
import org.bidib.wizard.config.DccAdvControllerFactory;
import org.bidib.wizard.config.DmxModelerControllerFactory;
import org.bidib.wizard.config.FeaturesControllerFactory;
import org.bidib.wizard.config.FirmwareControllerFactory;
import org.bidib.wizard.config.LocoControllerFactory;
import org.bidib.wizard.config.LocoTableControllerFactory;
import org.bidib.wizard.config.PomProgrammerControllerFactory;
import org.bidib.wizard.config.PtProgrammerControllerFactory;
import org.bidib.wizard.core.labels.BidibLabelUtils;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.dcca.client.controller.DccAdvController;
import org.bidib.wizard.dialog.NodeDetailsDialog;
import org.bidib.wizard.firmwarerepo.core.FirmwareRepoService;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.mvc.accessory.controller.AccessoryController;
import org.bidib.wizard.mvc.accessory.controller.listener.AccessoryControllerListener;
import org.bidib.wizard.mvc.dmx.controller.DmxModelerController;
import org.bidib.wizard.mvc.features.controller.FeaturesController;
import org.bidib.wizard.mvc.features.controller.listener.FeaturesControllerListener;
import org.bidib.wizard.mvc.loco.controller.LocoController;
import org.bidib.wizard.mvc.locolist.controller.LocoTableController;
import org.bidib.wizard.mvc.main.controller.MainController;
import org.bidib.wizard.mvc.main.controller.MainControllerInterface;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.MainNodeListActionListener;
import org.bidib.wizard.mvc.main.view.MainView;
import org.bidib.wizard.mvc.main.view.component.BulkSwitchNodeOperationsDialog;
import org.bidib.wizard.mvc.main.view.exchange.NodeExchangeHelper;
import org.bidib.wizard.mvc.main.view.exchange.SaveConfigOnNodeHelper;
import org.bidib.wizard.mvc.main.view.panel.NodeListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.NodeListActionListener;
import org.bidib.wizard.mvc.pom.controller.PomProgrammerController;
import org.bidib.wizard.mvc.pom.controller.listener.PomProgrammerControllerListener;
import org.bidib.wizard.mvc.pt.controller.PtProgrammerController;
import org.bidib.wizard.mvc.pt.controller.listener.PtProgrammerControllerListener;
import org.bidib.wizard.mvc.pt.view.PtConfirmDialog;
import org.bidib.wizard.utils.FileUtils;
import org.oxbow.swingbits.dialog.task.TaskDialogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MainNodeListActionListener
implements NodeListActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainNodeListActionListener.class);
    private String nodeDescription;
    private final MainView view;
    private final MainModel model;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private CommandStationService commandStationService;
    @Autowired
    private SwitchingNodeService switchingNodeService;
    @Autowired
    private BoosterService boosterService;
    @Autowired
    private LocoControllerFactory locoControllerFactory;
    @Autowired
    private LocoTableControllerFactory locoTableControllerFactory;
    @Autowired
    private FirmwareControllerFactory firmwareControllerFactory;
    @Autowired
    private PtProgrammerControllerFactory ptProgrammerControllerFactory;
    @Autowired
    private PomProgrammerControllerFactory pomProgrammerControllerFactory;
    @Autowired
    private AccessoryControllerFactory accessoryControllerFactory;
    @Autowired
    private DmxModelerControllerFactory dmxModelerControllerFactory;
    @Autowired
    private DccAdvControllerFactory dccAdvControllerFactory;
    @Autowired
    private FeaturesControllerFactory featuresControllerFactory;
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    @Autowired
    private CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry;
    @Autowired
    private ConsoleService consoleService;
    @Autowired
    private StatusBar statusBar;
    @Autowired
    private FirmwareRepoService firmwareRepoService;
    private static final String WORKING_DIR_EXCEL_EXCHANGE_KEY = "excelExchange";

    public MainNodeListActionListener(MainView view, MainModel model) {
        this.view = view;
        this.model = model;
        this.nodeDescription = Resources.getString(MainController.class, (String)"nodeDescription");
    }

    private void setWaitCursor() {
        this.view.setBusy(true);
    }

    private void setDefaultCursor() {
        this.view.setBusy(false);
    }

    private FileFilter getNodeFilter() {
        FileNameExtensionFilter nodeFilter = new FileNameExtensionFilter(this.nodeDescription, "nodex");
        return nodeFilter;
    }

    public void enableAddressMessages(NodeInterface node) {
        List<Feature> features = Arrays.asList(new Feature(9, node.isAddressMessagesEnabled() != false ? 1 : 0));
        this.nodeService.setFeatures("main", node, features);
    }

    public void enableDccStart(NodeInterface node) {
        List<Feature> features = Arrays.asList(new Feature(65, node.isDccStartEnabled() != false ? 1 : 0));
        this.nodeService.setFeatures("main", node, features);
    }

    public void enableExternalStart(NodeInterface node) {
        List<Feature> features = Arrays.asList(new Feature(64, node.isExternalStartEnabled() != false ? 1 : 0));
        this.nodeService.setFeatures("main", node, features);
    }

    public void enableFeedbackMessages(NodeInterface node) {
        List<Feature> features = Arrays.asList(new Feature(1, node.isFeedbackMessagesEnabled() != false ? 1 : 0));
        this.nodeService.setFeatures("main", node, features);
    }

    public void disableFeedbackMirror(NodeInterface node, boolean disable) {
        this.nodeService.setFeedbackMirrorDisabled("main", node, disable);
    }

    public void enableKeyMessages(NodeInterface node) {
        List<Feature> features = Arrays.asList(new Feature(51, node.isKeyMessagesEnabled() != false ? 1 : 0));
        this.nodeService.setFeatures("main", node, features);
    }

    public void features(NodeInterface node) {
        this.setWaitCursor();
        FeaturesController featuresController = this.featuresControllerFactory.createFeaturesController(node, (JFrame)this.view.getFrame(), this.settingsService.getWizardSettings());
        featuresController.addFeaturesControllerListener((FeaturesControllerListener)new /* Unavailable Anonymous Inner Class!! */);
        featuresController.start();
    }

    public void exportNode(NodeInterface node) {
        LOGGER.info("export node: {}", (Object)node);
        NodeExchangeHelper helper = new NodeExchangeHelper();
        String lang = XmlLocaleUtils.getXmlLocaleVendorCV();
        helper.exportNode(this.view.getFrame(), node, this.settingsService, this.nodeService, this.switchingNodeService, this.wizardLabelWrapper, this.cvDefinitionTreeModelRegistry, this.getNodeFilter(), this.statusBar, lang);
    }

    public void importNode(NodeInterface node) {
        NodeExchangeHelper helper = new NodeExchangeHelper();
        helper.importNode(this.view.getFrame(), node, this.settingsService, this.nodeService, this.switchingNodeService, this.cvDefinitionTreeModelRegistry, this.getNodeFilter(), this.wizardLabelWrapper, this.statusBar, (NodeListActionListener)this);
    }

    public void firmwareUpdate(NodeInterface node) {
        SoftwareVersion newFirmware = node.getUpdateFirmwareVersion();
        LOGGER.info("Show the firmware update dialog for node: {}, newFirmware: {}", (Object)node, (Object)newFirmware);
        FirmwareController firmwareController = this.firmwareControllerFactory.createFirmwareController(this.firmwareRepoService, node, (JFrame)this.view.getFrame());
        firmwareController.addFirmwareControllerListener((FirmwareControllerListener)new /* Unavailable Anonymous Inner Class!! */);
        firmwareController.start(newFirmware);
    }

    public void identify(NodeInterface node) {
        this.nodeService.identify("main", node, node.getIdentifyState());
    }

    public void dccAdvView(NodeInterface node) {
        DccAdvController dccAdvController = this.dccAdvControllerFactory.createController(node, this.view.getDesktop());
        dccAdvController.start();
    }

    public void ping(NodeInterface node, byte data) {
        this.nodeService.ping("main", node, data);
    }

    public void enableNode(NodeInterface node) {
        this.nodeService.enable("main", node);
    }

    public void disableNode(NodeInterface node) {
        this.nodeService.disable("main", node);
    }

    public Long readUniqueId(NodeInterface node) {
        return this.nodeService.readUniqueId("main", node);
    }

    public void detachAttachNode(NodeInterface node, boolean detach) {
        try {
            LOGGER.info("detachAttachNode, node: {}, detach: {}", (Object)node, (Object)detach);
            Long uniqueId = this.settingsService.getNetBidibSettings().getNetBidibUniqueId();
            if (detach) {
                this.nodeService.detach("main", node, uniqueId);
                node.setDetachedState(DetachedState.DETACHED);
            } else {
                this.nodeService.attach("main", node, uniqueId);
                node.setDetachedState(DetachedState.ATTACHED);
            }
        }
        catch (RuntimeException ex) {
            String message = ex.getMessage();
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(null), Resources.getString(MainNodeListActionListener.class, (String)"localLogoffRejected.error.message", (Object[])new Object[]{message}), Resources.getString(MainNodeListActionListener.class, (String)"localLogoffRejected.error.title"), 0);
        }
    }

    public void labelChanged(NodeInterface node, String label) {
        LOGGER.info("The label has changed, node: {}, label: {}", (Object)node, (Object)label);
        int stringSize = node.getNode().getStringSize();
        if (stringSize > 0) {
            String userName = label;
            if (label.length() > stringSize) {
                userName = label.substring(0, stringSize);
                LOGGER.info("Shrinked node string from '{}' to:' {}'", (Object)label, (Object)userName);
            }
            LOGGER.info("Set the new username on node: {}", (Object)userName);
            this.nodeService.setNodeDetails("main", node, userName);
        }
        try {
            NodeLabels nodeLabels = this.getNodeLabels(node);
            BidibLabelUtils.replaceNodeLabel((NodeLabels)nodeLabels, (String)label);
            this.saveLabels(node);
        }
        catch (InvalidConfigurationException ex) {
            LOGGER.warn("Save node labels failed.", (Throwable)ex);
            String labelPath = ex.getReason();
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(null), Resources.getString(NodeExchangeHelper.class, (String)"labelfileerror.message", (Object[])new Object[]{labelPath}), Resources.getString(NodeExchangeHelper.class, (String)"labelfileerror.title"), 0);
        }
    }

    public void loco(NodeInterface node) {
        LOGGER.info("Open the loco controller, node: {}", (Object)node);
        try {
            LocoController locoController = this.locoControllerFactory.createLocoController(node.getCommandStationNode(), (JFrame)this.view.getFrame(), this.model.getNodeProvider());
            locoController.start(null, null);
        }
        catch (Exception ex) {
            LOGGER.warn("Create loco controller failed.", (Throwable)ex);
        }
    }

    public void dccAccessory(NodeInterface node, int x, int y) {
        AccessoryController accessoryController = this.accessoryControllerFactory.createAccessoryController(node, (JFrame)this.view.getFrame(), new Point(x, y));
        accessoryController.addAccessoryControllerListener((AccessoryControllerListener)new /* Unavailable Anonymous Inner Class!! */);
        accessoryController.start();
    }

    public void locoCv(NodeInterface node, int x, int y) {
        PomProgrammerController pomProgrammerController = this.pomProgrammerControllerFactory.createPomProgrammerController(node.getCommandStationNode(), (JFrame)this.view.getFrame(), new Point(x, y));
        pomProgrammerController.addPomProgrammerControllerListener((PomProgrammerControllerListener)new /* Unavailable Anonymous Inner Class!! */);
        pomProgrammerController.start(this.view.getDesktop(), null);
    }

    public void locoCvPt(NodeInterface node, int x, int y) {
        this.setWaitCursor();
        if (!this.settingsService.getWizardSettings().isPtModeDoNotConfirmSwitch()) {
            PtConfirmDialog ptConfirmDialog = new PtConfirmDialog(node, this.settingsService, new Point(x, y));
            if (2 == ptConfirmDialog.getResult()) {
                LOGGER.info("User cancelled ptConfirmDialog.");
                this.setDefaultCursor();
                return;
            }
        } else {
            LOGGER.info("Switch to PT programming is disabled by user!");
        }
        this.setDefaultCursor();
        PtProgrammerController ptProgrammerController = this.ptProgrammerControllerFactory.createPtProgrammerController(node, (JFrame)this.view.getFrame(), new Point(x, y));
        ptProgrammerController.addPtProgrammerControllerListener((PtProgrammerControllerListener)new /* Unavailable Anonymous Inner Class!! */);
        ptProgrammerController.start(this.view.getDesktop());
    }

    public void nodeDetails(NodeInterface node, int x, int y) {
        new NodeDetailsDialog(node, x, y);
    }

    public void bulkSwitchDialog(NodeInterface node, int x, int y) {
        BulkSwitchNodeOperationsDialog dialog = new BulkSwitchNodeOperationsDialog(this.view.getDesktop(), node, this.nodeService, this.switchingNodeService, this.boosterService, this.settingsService, this.consoleService);
        dialog.showDialog();
    }

    public void saveOnNode(NodeInterface node, Map<String, Object> params) {
        LOGGER.info("Save the configuration to the node: {}", (Object)node);
        SaveConfigOnNodeHelper configOnNodeHelper = new SaveConfigOnNodeHelper();
        configOnNodeHelper.saveOnNode(this.model.getConnectionId(), this.nodeService, this.switchingNodeService, node, params);
    }

    public void dmxModeler(NodeInterface node) {
        this.setWaitCursor();
        LOGGER.info("Open the DMX modeler for node: {}", (Object)node);
        try {
            DmxModelerController dmxModelerController = this.dmxModelerControllerFactory.createDmxModelerController(node, (JFrame)this.view.getFrame());
            dmxModelerController.start(this.view.getDesktop(), (NodeListProvider)this.model);
        }
        catch (Exception ex) {
            LOGGER.warn("Open DMX modeler failed.", (Throwable)ex);
            JOptionPane.showMessageDialog((Component)this.view.getFrame(), "Open DMX modeler failed.", "Open DMX modeler", 0);
        }
        finally {
            this.setDefaultCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void locoList(NodeInterface node) {
        this.setWaitCursor();
        LOGGER.info("Open the loco table for node: {}", (Object)node);
        try {
            ApplicationContext applicationContext = DefaultApplicationContext.getInstance();
            MainControllerInterface mainController = (MainControllerInterface)applicationContext.get("mainController", MainControllerInterface.class);
            LocoTableController locoTableController = (LocoTableController)applicationContext.get("locoTableController", LocoTableController.class);
            if (locoTableController == null) {
                LOGGER.info("Create new locoTableController instance and register in context.");
                locoTableController = this.locoTableControllerFactory.createLocoTableController(node, (JFrame)this.view.getFrame());
                applicationContext.register("locoTableController", (Object)locoTableController);
            }
            locoTableController.start(this.view.getDesktop(), mainController);
            locoTableController.setSelectedNode(node);
        }
        catch (Exception ex) {
            LOGGER.warn("Open loco table failed.", (Throwable)ex);
            JOptionPane.showMessageDialog((Component)this.view.getFrame(), "Open loco table failed.", "Open loco table", 0);
        }
        finally {
            this.setDefaultCursor();
        }
    }

    public void reset(NodeInterface node) {
        LOGGER.info("Reset the node: {}", (Object)node);
        this.nodeService.reset("main", node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDocumentation(NodeInterface node) {
        if (node != null) {
            try {
                this.setWaitCursor();
                LOGGER.info("Generate documentation for node: {}", (Object)node);
                String bidibNodeFilesDescription = Resources.getString(NodeListPanel.class, (String)"bidibNodeFilesDescription");
                FileNameExtensionFilter bidibNodesFilter = new FileNameExtensionFilter(bidibNodeFilesDescription, "xlsx");
                Object defaultFileName = node.toString() + ".xlsx";
                if (StringUtils.isNotBlank((CharSequence)node.getNode().getStoredString(1))) {
                    defaultFileName = node.getNode().getStoredString(1) + ".xlsx";
                }
                defaultFileName = FileUtils.escapeInvalidFilenameCharacters((String)defaultFileName, (String)"_");
                WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
                String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_EXCEL_EXCHANGE_KEY);
                6 dialog = new /* Unavailable Anonymous Inner Class!! */;
                dialog.showDialog();
            }
            catch (Exception ex) {
                LOGGER.warn("Generate documentation failed.", (Throwable)ex);
            }
            finally {
                this.setDefaultCursor();
            }
        }
    }

    public void deleteNodeLabels(NodeInterface node) {
        if (node != null) {
            NodeLabels nodeLabels = this.getNodeLabels(node);
            String label = BidibNodeNameUtils.prepareLabel((NodeInterface)node, (NodeLabels)nodeLabels, (boolean)false, (boolean)false).getNodeLabel();
            boolean delete = TaskDialogs.ask((Window)JOptionPane.getFrameForComponent((Component)this.view.getFrame()), (String)Resources.getString(MainNodeListActionListener.class, (String)"deleteLabels"), (String)Resources.getString(MainNodeListActionListener.class, (String)"deleteLabelsOfNode", (Object[])new Object[]{label}));
            if (delete) {
                this.wizardLabelWrapper.deleteNodeLabels(Long.valueOf(node.getUniqueId()));
                for (Accessory accessory : node.getAccessories()) {
                    accessory.setLabel(null);
                    for (MacroRef aspect : accessory.getAspects()) {
                        aspect.setLabel(null);
                    }
                }
                for (Macro macro : node.getMacros()) {
                    macro.setLabel(null);
                }
                for (Flag flag : node.getFlags()) {
                    flag.setLabel(null);
                }
                for (Port port : node.getPorts()) {
                    port.setLabel(null);
                }
                node.setLabel(null);
            }
        }
    }

    private NodeLabels getNodeLabels(NodeInterface node) {
        WizardLabelFactory wizardLabelFactory = this.wizardLabelWrapper.getWizardLabelFactory();
        NodeLabels nodeLabels = wizardLabelFactory.loadLabels(Long.valueOf(node.getUniqueId()), new String[0]);
        return nodeLabels;
    }

    private void saveLabels(NodeInterface node) {
        try {
            long uniqueId = node.getUniqueId();
            this.wizardLabelWrapper.saveNodeLabels(Long.valueOf(uniqueId));
        }
        catch (Exception e) {
            LOGGER.warn("Save accessory labels failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void reloadNode(NodeInterface node) {
        LOGGER.info("Reload the node configuration: {}", (Object)node);
        this.nodeService.reloadNode("main", node);
    }
}

