/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.FeedbackAddressData;
import org.bidib.jbidibc.messages.enums.FeatureEnum;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.FeedbackPortListener;
import org.bidib.wizard.api.model.listener.PortListListener;
import org.bidib.wizard.client.common.model.SimplePortTableModel;
import org.bidib.wizard.client.common.model.listener.PortModelListener;
import org.bidib.wizard.client.common.table.PortTable;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.bidib.wizard.mvc.main.controller.FeedbackPortPanelController;
import org.bidib.wizard.mvc.main.controller.listener.FeedbackPortPanelListener;
import org.bidib.wizard.mvc.main.model.FeedbackPortModel;
import org.bidib.wizard.mvc.main.model.FeedbackPortTableModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.SimplePortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabComponentCreator;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.bidib.wizard.mvc.main.view.table.FeedbackPortTableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedbackPortListPanel
extends SimplePortListPanel<FeedbackPortStatus, FeedbackPort, FeedbackPortListener, PortModelListener<FeedbackPort>>
implements TabVisibilityProvider,
TabPanelProvider,
TabComponentCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedbackPortListPanel.class);
    private static final long serialVersionUID = 1L;
    private final FeedbackPortPanelListener controller;
    private final TabVisibilityListener tabVisibilityListener;

    public FeedbackPortListPanel(FeedbackPortPanelController controller, FeedbackPortTableModel tableModel, FeedbackPortModel feedbackPortModel, MainModel model, TabVisibilityListener tabVisibilityListener) {
        super((SimplePortTableModel)tableModel, Resources.getString(FeedbackPortListPanel.class, (String)"emptyTable"));
        this.controller = controller;
        this.tabVisibilityListener = tabVisibilityListener;
        LOGGER.debug("Create new FeedbackPortListPanel.");
        this.table.setDefaultCellRenderer((TableCellRenderer)new FeedbackPortTableCellRenderer());
        this.table.setDefaultEditor(FeedbackPort.class, (TableCellEditor)new /* Unavailable Anonymous Inner Class!! */);
        this.table.setRowHeight(100);
        this.table.setTableHeader(null);
        feedbackPortModel.addPortListListener((PortListListener)this);
    }

    protected PortTable createPortTable(SimplePortTableModel<FeedbackPortStatus, FeedbackPort, PortModelListener<FeedbackPort>> tableModel, String emptyTableText) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public JPanel getComponent() {
        return this;
    }

    public Object getCreator() {
        return this;
    }

    public boolean equals(Object other) {
        TabComponentCreator creator;
        return other instanceof TabComponentCreator && (creator = (TabComponentCreator)other).getCreator() instanceof FeedbackPortListPanel;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void listChanged() {
        LOGGER.info("List has changed, remove all rows and add rows again.");
        this.tableModel.setRowCount(0);
        List ports = this.getPorts();
        ((FeedbackPortTableModel)this.tableModel).addRows(ports);
        this.tabVisibilityListener.setTabVisible((Component)this, this.isTabVisible());
    }

    protected List<FeedbackPort> getPorts() {
        NodeInterface node = this.controller.getSelectedNode();
        if (node != null) {
            return node.getFeedbackPorts();
        }
        return Collections.emptyList();
    }

    public boolean isTabVisible() {
        NodeInterface node = this.controller.getSelectedNode();
        if (node != null) {
            int feedbackSize = Feature.getIntFeatureValue((Collection)node.getNode().getFeatures(), (int)FeatureEnum.FEATURE_BM_SIZE.getNumber());
            boolean isTabVisible = feedbackSize > 0;
            LOGGER.debug("Check if tab is visible: {}", (Object)isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    public Class<?> getPortClass() {
        return FeedbackPort.class;
    }

    private void fireOpenLocoDialog(FeedbackAddressData addressData) {
        this.controller.openLocoDialog(addressData);
    }

    private void fireOpenPomDialog(FeedbackAddressData addressData) {
        this.controller.openPomDialog(addressData);
    }

    public void refreshView() {
        this.listChanged();
    }
}

