/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.statusbar;

import com.jidesoft.status.LabelStatusBarItem;
import com.jidesoft.status.MemoryStatusBarItem;
import com.jidesoft.status.ProgressStatusBarItem;
import com.jidesoft.status.ResizeStatusBarItem;
import com.jidesoft.status.StatusBarItem;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.utils.PortingUtils;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.common.PreferencesPortType;
import org.bidib.wizard.api.notification.ConnectionAction;
import org.bidib.wizard.api.notification.TimeEvent;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.common.model.settings.ConnectionConfiguration;
import org.bidib.wizard.core.model.connection.DefaultBidibConnection;
import org.bidib.wizard.core.model.settings.GlobalSettings;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.core.utils.AopUtils;
import org.bidib.wizard.model.ports.event.LineStatusEvent;
import org.bidib.wizard.model.ports.event.StatusEvent;
import org.bidib.wizard.mvc.main.model.StatusModel;
import org.bidib.wizard.mvc.main.view.panel.listener.ModelClockStatusListener;
import org.bidib.wizard.mvc.main.view.panel.listener.StatusListener;
import org.bidib.wizard.mvc.main.view.statusbar.ConnectionStatusBarItem;
import org.bidib.wizard.mvc.main.view.statusbar.DefaultJideStatusBar;
import org.bidib.wizard.mvc.main.view.statusbar.DigitalClockStatusBarItem;
import org.bidib.wizard.mvc.main.view.statusbar.StatusButtonStatusBarItem;
import org.bidib.wizard.mvc.main.view.statusbar.WizardStatusBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class DefaultJideStatusBar
implements StatusBar {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJideStatusBar.class);
    private JLabel statusLabel;
    private DigitalClockStatusBarItem modelClock;
    private DefaultOverlayable overlayLedPanel;
    private ConnectionStatusBarItem ledPanel;
    private StatusButtonStatusBarItem statusButtonPanel;
    private Timer cleanTimer;
    private LabelStatusBarItem connectionProviderLabel;
    private WizardStatusBar statusBar;
    private ProgressStatusBarItem progress;
    private final StatusModel statusModel;
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private ConnectionService connectionService;
    @Autowired
    private ApplicationContext applicationContext;
    private CompositeDisposable compDisposable = new CompositeDisposable();

    public DefaultJideStatusBar(StatusModel statusModel) {
        this.statusModel = statusModel;
    }

    public void initialize() {
        this.statusBar = new WizardStatusBar();
        this.progress = new /* Unavailable Anonymous Inner Class!! */;
        this.progress.setCancelCallback((ProgressStatusBarItem.CancelCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.statusBar.add((Component)this.progress, (Object)"vary");
        Map statusBarItems = this.applicationContext.getBeansOfType(StatusBarItem.class);
        for (StatusBarItem statusBarItem : statusBarItems.values()) {
            LOGGER.info("Add statusBarItem: {}", (Object)statusBarItem);
            this.statusBar.add((Component)statusBarItem, (Object)"flexible");
        }
        Color color = UIManager.getColor("StatusBarSimulationLabel.textcolor");
        JLabel simulationLabel = new JLabel("Simulation", 0);
        Font oldFont = simulationLabel.getFont();
        simulationLabel.setFont(oldFont.deriveFont(1, oldFont.getSize2D() + 2.0f));
        simulationLabel.setForeground(color);
        PortingUtils.removeFocus((JComponent)simulationLabel);
        this.ledPanel = new ConnectionStatusBarItem(this.statusModel);
        this.ledPanel.setPreferredWidth(170);
        this.overlayLedPanel = new DefaultOverlayable((JComponent)this.ledPanel, (JComponent)simulationLabel);
        this.statusBar.add((Component)this.overlayLedPanel, (Object)"flexible");
        this.connectionProviderLabel = new LabelStatusBarItem();
        this.connectionProviderLabel.setPreferredWidth(70);
        this.statusBar.add((Component)this.connectionProviderLabel, (Object)"flexible");
        this.statusButtonPanel = new StatusButtonStatusBarItem(this.statusModel);
        this.statusButtonPanel.setPreferredWidth(40);
        this.statusBar.add((Component)this.statusButtonPanel, (Object)"fix");
        this.updateSelectedPort(this.connectionProviderLabel);
        this.setTimeStatusButtonEnabled();
        LOGGER.info("Create the digital clock.");
        this.modelClock = new DigitalClockStatusBarItem(this.settingsService);
        this.modelClock.setPreferredWidth(100);
        this.statusBar.add((Component)this.modelClock, (Object)"flexible");
        this.modelClock.setToolTipText(Resources.getString(StatusBar.class, (String)"modeltime"));
        MemoryStatusBarItem memoryItem = new MemoryStatusBarItem();
        this.statusBar.add((Component)memoryItem, (Object)"flexible");
        this.statusBar.add((Component)new ResizeStatusBarItem(), (Object)"fix");
        this.modelClock.setEnabled(this.settingsService.getGlobalSettings().isModelTimeEnabled());
        this.statusModel.setRunning(this.settingsService.getGlobalSettings().isModelTimeEnabled());
        this.statusModel.addModelClockStatusListener((ModelClockStatusListener)this.modelClock);
        this.statusModel.addStatusListener((org.bidib.wizard.api.model.listener.StatusListener)new /* Unavailable Anonymous Inner Class!! */);
        this.statusButtonPanel.addStatusListener((StatusListener)new /* Unavailable Anonymous Inner Class!! */);
        try {
            GlobalSettings gs = (GlobalSettings)AopUtils.getTargetObject((Object)this.settingsService.getGlobalSettings());
            gs.addPropertyChangeListener("selectedPortType", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
            gs.addPropertyChangeListener("selectedSerialPortProvider", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
            gs.addPropertyChangeListener("modelTimeEnabled", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception ex) {
            LOGGER.warn("Add property change listeners failed.", (Throwable)ex);
        }
        this.updateSelectedPort(this.connectionProviderLabel);
        Disposable dispTimeEvents = this.connectionService.subscribeTimeEvents(te -> {
            LOGGER.debug("Received a time event: {}", te);
            if ("main".equals(te.getConnectionId())) {
                this.setModelTime(te);
            }
        }, error -> LOGGER.warn("The time event signalled a failure: {}", error));
        this.compDisposable.add(dispTimeEvents);
        Disposable dispStatusEvents = this.connectionService.subscribeStatusEvents(se -> {
            LOGGER.debug("Received a connection status event: {}", se);
            if ("main".equals(se.getConnectionId())) {
                this.setConnectionStatus(se);
            }
        }, error -> LOGGER.warn("The status event signalled a failure: {}", error));
        this.compDisposable.add(dispStatusEvents);
        Disposable dispConnectionActions = this.connectionService.subscribeConnectionActions(ca -> {
            if ("main".equals(ca.getConnectionId())) {
                this.processConnectionAction(ca);
            }
        }, error -> LOGGER.warn("The connection actions signalled a failure: {}", error));
        this.compDisposable.add(dispConnectionActions);
        this.statusModel.addPropertyChangeListener("running", evt -> {
            boolean isRunning = this.statusModel.isRunning();
            LOGGER.info("The running property has changed, isRunning: {}", (Object)isRunning);
            boolean isConnected = this.statusModel.isCd();
            boolean isModelTimeEnabled = this.settingsService.getGlobalSettings().isModelTimeEnabled();
            if (isConnected && isModelTimeEnabled) {
                boolean running = this.statusModel.isRunning();
                LOGGER.info("Send the model clock, running: {}", (Object)running);
                this.connectionService.setModelTimeEnabled("main", running);
            } else {
                this.connectionService.setModelTimeEnabled("main", false);
            }
        });
    }

    private void setTimeStatusButtonEnabled() {
        PreferencesPortType selectedPortType = ConnectionConfiguration.toPreferencesPortType((List)this.settingsService.getGlobalSettings().getConnectionConfigurations(), (String)"main");
        boolean isTunneled = PreferencesPortType.checkSelectedPortTypeIsTunnel((PreferencesPortType)selectedPortType);
        this.statusButtonPanel.setEnabled(!isTunneled);
    }

    private void updateSelectedPort(LabelStatusBarItem connectionProviderLabel) {
        this.updateSelectedPort(connectionProviderLabel, null);
    }

    private void updateSelectedPort(LabelStatusBarItem connectionProviderLabel, Integer baudrate) {
        try {
            boolean simulationMode;
            String connectionName;
            PreferencesPortType selectedPortType = ConnectionConfiguration.toPreferencesPortType((List)this.settingsService.getGlobalSettings().getConnectionConfigurations(), (String)"main");
            LOGGER.info("The selectedPortType to use: {}, baudrate: {}", (Object)selectedPortType, (Object)baudrate);
            String connectionProvider = this.evaluateConnectionProviderLabel(selectedPortType);
            connectionProviderLabel.setText(connectionProvider);
            String string = connectionName = selectedPortType != null ? selectedPortType.getConnectionName() : null;
            if (StringUtils.isNotBlank((CharSequence)connectionProvider)) {
                if (baudrate != null) {
                    connectionProviderLabel.setToolTipText(connectionProvider + " - " + connectionName + " - baud: " + (Serializable)(baudrate == 1000000 ? "1M" : baudrate));
                } else {
                    connectionProviderLabel.setToolTipText(connectionProvider + " - " + connectionName);
                }
            }
            this.ledPanel.setEnabled(!(simulationMode = PreferencesPortType.isSimulation((PreferencesPortType)selectedPortType)));
            this.overlayLedPanel.setOverlayVisible(simulationMode);
            boolean isTunneled = PreferencesPortType.checkSelectedPortTypeIsTunnel((PreferencesPortType)selectedPortType);
            this.statusButtonPanel.setEnabled(!isTunneled);
        }
        catch (Exception ex) {
            LOGGER.warn("Change display connection provider failed.", (Throwable)ex);
        }
    }

    public JComponent getComponent() {
        if (this.statusBar == null) {
            this.initialize();
        }
        return this.statusBar;
    }

    private void setConnectionStatus(StatusEvent se) {
        if (se instanceof LineStatusEvent) {
            LineStatusEvent lse = (LineStatusEvent)se;
            this.statusModel.setCts(lse.isCTS());
        }
    }

    public void setStatusText(String message) {
        LOGGER.debug("Set status message: {}", (Object)message);
        this.setStatusText(message, -1);
    }

    private void processConnectionAction(ConnectionAction ca) {
        String messageKey;
        LOGGER.info("Process the connection action, connectionId: {}, messageKey: {}, context: {}", new Object[]{ca.getConnectionId(), ca.getMessageKey(), ca.getContext()});
        switch (messageKey = ca.getMessageKey()) {
            case "bidib-connect-with-baudrate": {
                Integer baudrate = (Integer)ca.getContext().get("baudrate", Integer.class, null);
                SwingUtilities.invokeLater(() -> {
                    String statusText = Resources.getString(DefaultBidibConnection.class, (String)messageKey, (Object[])new Object[]{baudrate});
                    this.setStatusText(statusText, -1);
                    this.updateSelectedPort(this.connectionProviderLabel, baudrate);
                });
                break;
            }
            case "bidib-reconnect-with-next-baudrate": {
                Integer nextBaudrate = (Integer)ca.getContext().get("baudrate", Integer.class, null);
                SwingUtilities.invokeLater(() -> {
                    String statusText = Resources.getString(DefaultBidibConnection.class, (String)messageKey, (Object[])new Object[]{nextBaudrate});
                    this.setStatusText(statusText, -1);
                });
                break;
            }
        }
    }

    public synchronized void setStatusText(String message, int seconds) {
        LOGGER.info("Set the status text: {}, seconds: {}", (Object)message, (Object)seconds);
        if (this.cleanTimer != null) {
            LOGGER.info("Stop the clean timer.");
            this.cleanTimer.stop();
            this.cleanTimer = null;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateStatusText(message, seconds);
        } else {
            try {
                SwingUtilities.invokeLater((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Exception ex) {
                LOGGER.warn("Update status text failed.", (Throwable)ex);
            }
        }
    }

    private void updateStatusText(String message, int seconds) {
        switch (seconds) {
            case -2: {
                this.statusLabel.setForeground(Color.RED);
                break;
            }
            case -1: {
                this.statusLabel.setForeground(Color.BLACK);
                break;
            }
            default: {
                this.statusLabel.setForeground(Color.RED);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)message)) {
            this.progress.setStatus(message);
        } else {
            this.progress.setStatus(null);
        }
        if (seconds > 0) {
            this.cleanTimer = new Timer(seconds * 1000, (ActionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.cleanTimer.setRepeats(false);
            this.cleanTimer.start();
        }
    }

    public void setModelTime(TimeEvent timeEvent) {
        this.modelClock.setModelTime(timeEvent);
    }

    private String evaluateConnectionProviderLabel(PreferencesPortType selectedPortType) {
        String serialProviderLabel = null;
        if (selectedPortType != null && selectedPortType.getConnectionPortType() != null) {
            switch (10.$SwitchMap$org$bidib$wizard$api$model$common$PreferencesPortType$ConnectionPortType[selectedPortType.getConnectionPortType().ordinal()]) {
                case 1: {
                    serialProviderLabel = "SerOverTcp";
                    break;
                }
                case 2: 
                case 3: {
                    serialProviderLabel = this.settingsService.getMiscSettings().getSelectedSerialPortProvider();
                    break;
                }
                case 4: {
                    serialProviderLabel = "NetBidib";
                    break;
                }
                case 5: {
                    serialProviderLabel = "Speedometer";
                    break;
                }
                default: {
                    serialProviderLabel = "Sim";
                }
            }
        }
        return serialProviderLabel;
    }

    public void setProgress(String message, boolean finished) {
        this.progress.setProgressStatus(message);
        if (!finished) {
            this.progress.setProgressStatus(message);
            this.progress.setProgress(10);
        } else {
            this.progress.setDefaultStatus(message);
            this.progress.setProgress(100);
            this.progress.showStatus();
        }
    }

    public void addStatusBarItem(StatusBarItem statusBarItem, Object constraints, int index) {
        this.statusBar.add((Component)statusBarItem, constraints, index);
    }

    public void removeStatusBarItem(StatusBarItem statusBarItem) {
        this.statusBar.remove(statusBarItem.getName());
    }
}

