package org.bidib.wizard.mvc.main.dockable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

import org.bidib.wizard.client.common.text.WizardComponentFactory;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;

public class MyTextEditor extends JPanel implements Dockable {

    private DockKey key;

    // private JTextArea textArea;
    private JTextField textArea;

    public MyTextEditor(int index) {
        key = new DockKey("textEditor" + index);
        setLayout(new BorderLayout());
        // textArea = new JTextArea("A Text Area");
        // textArea = new JTextField("A Text Area");

        final ValueModel valueModel = new ValueHolder("Test");
        textArea = WizardComponentFactory.createTextField(valueModel, false);
        JScrollPane jsp = new JScrollPane(textArea);
        jsp.setPreferredSize(new Dimension(200, 400));
        add(jsp, BorderLayout.CENTER);
    }

    @Override
    public DockKey getDockKey() {
        return key;
    }

    @Override
    public Component getComponent() {
        return this;
    }

}
