/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.client.spring;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.swing.FolderChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.utils.WizardUtils;
import org.bidib.wizard.common.utils.ImageUtils;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.config.ConfigDataEnvironmentUpdateListener;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class SettingsLocationEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    public static final int ORDER = -2147483641;
    private final Log logger;
    private final ConfigurableBootstrapContext bootstrapContext;
    private final ConfigDataEnvironmentUpdateListener environmentUpdateListener;
    public static final String WIZARD_2_1_CONFIG_FILE_NAME = "wizard21";
    private static final String WIZARD_SETTINGSFILE_LOCATION_REFERENCE_WIZARD_2_0 = "wizard2.properties";
    private static final String WIZARD_SETTINGSFILE_LOCATION_REFERENCE_WIZARD_2_1 = "wizard21.properties";
    private static final String WIZARD_SETTINGSFILE_LOCATION_PROPERTY = "wizard.settings.file-location";
    private static final String WIZARD_DEVELOPER_MODE_ENABLED_PROPERTY = "wizard.settings.developer-mode-enabled";
    private static final String WIZARD_CONFIGURATION_FILE_LOCATION_PROPERTY = "wizard.configuration.file-location";
    private static final String WIZARD_2_0_PROPERTIES_FILE_NAME = "wizard.yml";
    private static final String WIZARD_2_1_PROPERTIES_FILE_NAME = "wizard21.yml";
    static final String WIZARDMODULE_2_0_FILENAME_WILDCARD = "wizardmodule_*.yml";
    static final String WIZARDMODULE_2_1_FILENAME_WILDCARD = "wizardmodule21_*.yml";
    static final String WIZARD_2_0_NETBIDIB_PAIRING_STORE_FILENAME = "netBiDiBPairingStore-BiDiB-Wizard2.bidib";
    private String wizardConfigurationFileLocationReference;
    private Boolean developerModeEnabled = Boolean.FALSE;

    public SettingsLocationEnvironmentPostProcessor(DeferredLogFactory logFactory, ConfigurableBootstrapContext bootstrapContext) {
        this(logFactory, bootstrapContext, null);
    }

    private SettingsLocationEnvironmentPostProcessor(DeferredLogFactory logFactory, ConfigurableBootstrapContext bootstrapContext, ConfigDataEnvironmentUpdateListener environmentUpdateListener) {
        this.logger = logFactory.getLog(this.getClass());
        this.bootstrapContext = bootstrapContext;
        this.environmentUpdateListener = environmentUpdateListener;
    }

    public int getOrder() {
        return -2147483641;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        this.postProcessEnvironment(environment, application.getResourceLoader(), application.getAdditionalProfiles());
    }

    void postProcessEnvironment(ConfigurableEnvironment environment, ResourceLoader resourceLoader, Collection<String> additionalProfiles) {
        try {
            this.wizardConfigurationFileLocationReference = environment.getProperty(WIZARD_SETTINGSFILE_LOCATION_PROPERTY, "${user.home}/.bidib");
            this.wizardConfigurationFileLocationReference = environment.resolvePlaceholders(this.wizardConfigurationFileLocationReference);
            this.logger.info((Object)("Location of settings file location reference: " + this.wizardConfigurationFileLocationReference));
            resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
            boolean copyWizardSettingsFiles = false;
            File file = new File(this.wizardConfigurationFileLocationReference, WIZARD_SETTINGSFILE_LOCATION_REFERENCE_WIZARD_2_1);
            if (!file.exists()) {
                this.logger.info((Object)"The settings file location reference was not found.");
                File fileWizard20 = new File(this.wizardConfigurationFileLocationReference, WIZARD_SETTINGSFILE_LOCATION_REFERENCE_WIZARD_2_0);
                if (fileWizard20.exists()) {
                    FileUtils.copyFile((File)fileWizard20, (File)file);
                    copyWizardSettingsFiles = true;
                } else {
                    this.selectLocation(environment, file);
                }
            }
            if (file.exists()) {
                this.logger.info((Object)"The settings file location reference was found.");
                try (FileInputStream is = new FileInputStream(file);){
                    Properties props = new Properties();
                    props.load(is);
                    this.wizardConfigurationFileLocationReference = props.getProperty(WIZARD_SETTINGSFILE_LOCATION_PROPERTY);
                    this.developerModeEnabled = Boolean.parseBoolean(props.getProperty(WIZARD_DEVELOPER_MODE_ENABLED_PROPERTY, "false"));
                    this.logger.info((Object)("Read wizardSettingsFileLocationReference from location: " + file.getPath() + ", wizardConfigurationFileLocationReference: " + this.wizardConfigurationFileLocationReference + ", developerModeEnabled: " + this.developerModeEnabled));
                    File location = new File(this.wizardConfigurationFileLocationReference);
                    if (!location.exists()) {
                        try {
                            FileUtils.forceMkdir((File)location);
                        }
                        catch (Exception ex) {
                            this.logger.warn((Object)"Create directory for wizardSettingsFiles failed.", (Throwable)ex);
                        }
                    }
                }
                catch (Exception ex) {
                    this.logger.warn((Object)("Failed to read the wizardSettingsFileLocationReference from location: " + file.getPath()), (Throwable)ex);
                    throw new RuntimeException("Failed to read the wizardSettingsFileLocationReference from location: " + file.getPath());
                }
            }
            environment.getSystemProperties().put(WIZARD_CONFIGURATION_FILE_LOCATION_PROPERTY, this.wizardConfigurationFileLocationReference);
            environment.getSystemProperties().put(WIZARD_DEVELOPER_MODE_ENABLED_PROPERTY, this.developerModeEnabled);
            if (copyWizardSettingsFiles) {
                this.copyWizardSettingsFiles(resourceLoader, file, this.wizardConfigurationFileLocationReference);
            }
        }
        catch (Exception ex) {
            this.logger.warn((Object)"Fetch the location of settings file location reference failed.", (Throwable)ex);
        }
    }

    private void selectLocation(ConfigurableEnvironment environment, File file) {
        String userHome = environment.resolvePlaceholders("${user.home}");
        this.logger.info((Object)"Select the location for wizard settings files.");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            this.logger.warn((Object)"Set look and feel failed", (Throwable)ex);
        }
        boolean foundAndUseOldLocation = false;
        boolean copyWizardConfigFromOldLocation = false;
        try {
            File oldWizardConfigurationFile = new File(userHome, ".bidib/wizard21.yml");
            if (oldWizardConfigurationFile.exists()) {
                this.logger.info((Object)("Found the wizard21.yml in the old default directory: " + oldWizardConfigurationFile.getPath()));
                int result = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(null), Resources.getString(SettingsLocationEnvironmentPostProcessor.class, (String)"keep-old-location.message", (Object[])new Object[]{oldWizardConfigurationFile.getParentFile().getPath()}), Resources.getString(SettingsLocationEnvironmentPostProcessor.class, (String)"keep-old-location.title"), 0, 3);
                if (result == 0) {
                    this.logger.info((Object)"User accepted to use old configuration location.");
                    this.wizardConfigurationFileLocationReference = oldWizardConfigurationFile.getParentFile().getPath();
                    this.logger.info((Object)("Found and use the configuration from the old location: " + this.wizardConfigurationFileLocationReference));
                    foundAndUseOldLocation = true;
                } else {
                    this.logger.info((Object)"User declined to use old configuration location.");
                    copyWizardConfigFromOldLocation = true;
                }
            }
        }
        catch (Exception ex) {
            this.logger.warn((Object)"Check if the wizard21.yml exists in the 'old default directory' failed.", (Throwable)ex);
        }
        if (!foundAndUseOldLocation) {
            File defaultDirectory = new File(userHome, WizardUtils.getDefaultConfigSubDir());
            this.logger.info((Object)("Prepared the default location directory: " + defaultDirectory.getPath()));
            this.logger.info((Object)"Prepare and show the settings location dialog.");
            SettingsLocationDialog chooser = new SettingsLocationDialog(null, this.logger, defaultDirectory, location -> {
                this.wizardConfigurationFileLocationReference = location.getPath();
                if (!location.exists()) {
                    this.logger.info((Object)("The selected location does not exist and will be created: " + this.wizardConfigurationFileLocationReference));
                    try {
                        FileUtils.forceMkdir((File)location);
                    }
                    catch (Exception ex) {
                        this.logger.warn((Object)"Create directory for wizardSettingsFiles failed.", (Throwable)ex);
                    }
                } else {
                    this.logger.info((Object)("The selected location does exist: " + this.wizardConfigurationFileLocationReference));
                }
            });
            chooser.setVisible(null);
            this.logger.info((Object)("Use the wizardSettingsFileLocationReference: " + this.wizardConfigurationFileLocationReference));
        }
        if (!file.getParentFile().exists()) {
            try {
                FileUtils.forceMkdir((File)file.getParentFile());
            }
            catch (Exception ex) {
                this.logger.warn((Object)"Create directory for wizardSettingsFileLocationReference failed.", (Throwable)ex);
            }
        }
        try (FileOutputStream os = new FileOutputStream(file);){
            Properties props = new Properties();
            props.put(WIZARD_SETTINGSFILE_LOCATION_PROPERTY, this.wizardConfigurationFileLocationReference);
            props.store(os, "Added by Wizard 2");
            this.logger.info((Object)("Wrote wizardSettingsFileLocationReference to location: " + file.getPath()));
        }
        catch (Exception ex) {
            this.logger.warn((Object)("Write the wizardSettingsFileLocationReference failed: " + String.valueOf(file)), (Throwable)ex);
            throw new RuntimeException("Write the wizardSettingsFileLocationReference failed: " + String.valueOf(file));
        }
        if (copyWizardConfigFromOldLocation) {
            try {
                File oldDirectory = new File(userHome, ".bidib");
                File newLocationConfigurationFile = new File(this.wizardConfigurationFileLocationReference, WIZARD_2_1_PROPERTIES_FILE_NAME);
                if (!newLocationConfigurationFile.exists()) {
                    this.logger.info((Object)"copy the existing wizard configuration files to the new location.");
                    int result = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(null), Resources.getString(SettingsLocationEnvironmentPostProcessor.class, (String)"copy-config-from-old-location.message", (Object[])new Object[]{oldDirectory.getPath()}), Resources.getString(SettingsLocationEnvironmentPostProcessor.class, (String)"copy-config-from-old-location.title"), 0, 3);
                    if (result == 0) {
                        this.logger.info((Object)"User accepted to copy existing configuration files.");
                        File oldWizardConfigurationFile = new File(oldDirectory, WIZARD_2_1_PROPERTIES_FILE_NAME);
                        this.copyFile(oldWizardConfigurationFile, newLocationConfigurationFile);
                        WildcardFileFilter fileFilter = WildcardFileFilter.builder().setWildcards(new String[]{WIZARDMODULE_2_1_FILENAME_WILDCARD}).get();
                        File[] files = oldDirectory.listFiles((FileFilter)fileFilter);
                        if (files != null && files.length > 0) {
                            for (File sourceFile : files) {
                                File targetFile = new File(this.wizardConfigurationFileLocationReference, sourceFile.getName());
                                this.copyFile(sourceFile, targetFile);
                            }
                        } else {
                            this.logger.info((Object)"No wizard module configuration files found.");
                        }
                    } else {
                        this.logger.info((Object)"User declined to copy existing configuration files.");
                    }
                } else {
                    this.logger.info((Object)"The wizard configuration file exists in the new location already. Skip copy existing files.");
                }
            }
            catch (Exception ex) {
                this.logger.warn((Object)("Write the wizardSettingsFileLocationReference failed: " + String.valueOf(file)), (Throwable)ex);
            }
        }
    }

    private void copyWizardSettingsFiles(ResourceLoader resourceLoader, File file, String wizardConfigurationFileLocationReference) {
        this.logger.info((Object)"Copy the wizard settings files.");
        File configDirectory = new File(wizardConfigurationFileLocationReference);
        File oldWizardConfigurationFile = new File(configDirectory, WIZARD_2_0_PROPERTIES_FILE_NAME);
        File newWizardConfigurationFile = new File(configDirectory, WIZARD_2_1_PROPERTIES_FILE_NAME);
        this.logger.info((Object)("Copy wizard settings file: " + String.valueOf(oldWizardConfigurationFile) + " --> " + String.valueOf(newWizardConfigurationFile)));
        this.copyFile(oldWizardConfigurationFile, newWizardConfigurationFile);
        WildcardFileFilter fileFilter = WildcardFileFilter.builder().setWildcards(new String[]{WIZARDMODULE_2_0_FILENAME_WILDCARD}).get();
        File[] files = configDirectory.listFiles((FileFilter)fileFilter);
        if (files != null && files.length > 0) {
            for (File sourceFile : files) {
                String oldName = sourceFile.getName();
                String newName = oldName.replace("wizardmodule_", "wizardmodule21_");
                this.logger.info((Object)("Copy module settings file: " + (String)oldName + " --> " + newName));
                File targetFile = new File(configDirectory, newName);
                this.copyFile(sourceFile, targetFile);
            }
        } else {
            this.logger.info((Object)"No wizard module configuration files found.");
        }
        YamlPropertySourceLoader loader = new YamlPropertySourceLoader();
        try {
            String pairingStoreLocation = null;
            Resource wizardYamlResource = resourceLoader.getResource("file:" + newWizardConfigurationFile.getPath().replaceAll("\\\\", "/"));
            List propertySources = loader.load(WIZARD_2_1_PROPERTIES_FILE_NAME, wizardYamlResource);
            for (PropertySource ps : propertySources) {
                if (!ps.containsProperty("netBidibSettings.pairingStoreLocation")) continue;
                Object pairingStoreLocationSource = ps.getProperty("netBidibSettings.pairingStoreLocation");
                this.logger.info((Object)("Found pairingStore location: " + String.valueOf(pairingStoreLocationSource)));
                pairingStoreLocation = (String)pairingStoreLocationSource;
                break;
            }
            if (StringUtils.isNotBlank(pairingStoreLocation)) {
                this.logger.info((Object)("Copy pairingStore from: " + pairingStoreLocation));
                File pairingStoreFileWizard20 = new File(pairingStoreLocation, WIZARD_2_0_NETBIDIB_PAIRING_STORE_FILENAME);
                File pairingStoreFileWizard21 = new File(pairingStoreLocation, "netBiDiBPairingStore-BiDiB-Wizard21.bidib");
                this.copyFile(pairingStoreFileWizard20, pairingStoreFileWizard21);
            }
        }
        catch (Exception ex) {
            this.logger.warn((Object)"Copy netBiDiB paringStore failed.", (Throwable)ex);
        }
    }

    private void copyFile(File source, File target) {
        try (FileInputStream sourceStream = new FileInputStream(source);
             FileOutputStream targetStream = new FileOutputStream(target);){
            IOUtils.copy((InputStream)sourceStream, (OutputStream)targetStream);
        }
        catch (Exception ex) {
            this.logger.warn((Object)("Copy configuration file failed: " + String.valueOf(source)), (Throwable)ex);
        }
    }

    private static class SettingsLocationDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, max(200dlu;pref), 3dlu, pref";
        private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref";
        private final Log logger;
        private final Consumer<File> locationConsumer;

        public SettingsLocationDialog(Frame frame, final Log logger, final File defaultDirectory, Consumer<File> locationConsumer) {
            super(frame, Resources.getString(SettingsLocationEnvironmentPostProcessor.class, (String)"title"), true);
            this.logger = logger;
            this.locationConsumer = locationConsumer;
            this.setIconImage(ImageUtils.createImageIcon(SettingsLocationDialog.class, (String)"/icons/wizard-logo2-48x48.png").getImage());
            this.getContentPane().setLayout(new BorderLayout());
            FormBuilder builder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel(new JPanel());
            builder.border((Border)Paddings.DIALOG);
            int row = 1;
            JLabel configurationFilesLocationLabel = new JLabel(Resources.getString(SettingsLocationEnvironmentPostProcessor.class, (String)"configuration-files-location"));
            builder.add((Component)configurationFilesLocationLabel).xy(1, row);
            final JTextField textConfigurationFilesLocation = new JTextField();
            textConfigurationFilesLocation.setText(defaultDirectory.getPath());
            builder.add((Component)textConfigurationFilesLocation).xyw(1, row += 2, 3);
            JButton chooserButton = new JButton(Resources.getString(SettingsLocationEnvironmentPostProcessor.class, (String)"choose"));
            chooserButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    logger.info((Object)"Show the FolderChooser.");
                    try {
                        FolderChooser chooser = new FolderChooser();
                        chooser.setSelectedFolder(defaultDirectory.getParentFile());
                        chooser.setRecentListVisible(false);
                        chooser.setDialogTitle(Resources.getString(SettingsLocationEnvironmentPostProcessor.class, (String)"choose-configuration-location"));
                        int returnVal = chooser.showOpenDialog((Component)this);
                        logger.info((Object)("The returnVal: " + returnVal));
                        if (returnVal == 0) {
                            File settingsLocation = chooser.getSelectedFile();
                            logger.info((Object)("Selected settingsLocation: " + settingsLocation.getPath()));
                            textConfigurationFilesLocation.setText(settingsLocation.getPath());
                        }
                    }
                    catch (Exception ex) {
                        logger.warn((Object)"Show folder chooser failed.", (Throwable)ex);
                    }
                    catch (Error err) {
                        logger.warn((Object)"Show folder chooser failed.", (Throwable)err);
                    }
                }
            });
            builder.add((Component)chooserButton).xy(5, row);
            row += 2;
            JButton continueButton = new JButton(Resources.getString(SettingsLocationEnvironmentPostProcessor.class, (String)"continue"));
            continueButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File settingsLocation = new File(textConfigurationFilesLocation.getText());
                    this.setVisible(false);
                    this.fireContinue(settingsLocation);
                }
            });
            JButton cancel = new JButton(Resources.getString(SettingsLocationEnvironmentPostProcessor.class, (String)"cancel"));
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setVisible(false);
                    this.fireCancel();
                }
            });
            JPanel buttons = new ButtonBarBuilder().addGlue().addButton(new JComponent[]{continueButton, cancel}).build();
            builder.add((Component)buttons).xyw(1, row, 5);
            this.getContentPane().add(builder.build());
            this.pack();
        }

        public void setVisible(Frame frame) {
            this.setLocationRelativeTo(frame);
            this.setMinimumSize(this.getSize());
            this.setVisible(true);
        }

        private void fireContinue(File settingsLocation) {
            this.logger.info((Object)"Continue operation.");
            this.locationConsumer.accept(settingsLocation);
        }

        private void fireCancel() {
            this.logger.warn((Object)"Cancel operation and exit application.");
            System.exit(1);
        }
    }
}

