/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.dialog;

import com.jgoodies.forms.FormsSetup;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.dialog.EscapeDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PairingDialog
extends EscapeDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PairingDialog.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 10dlu, fill:50dlu:grow";
    private int result = 2;
    private Consumer<Boolean> pairingCallback;
    private Timer pairingCountDown;
    private int remainingPairingTime = 30;
    private final JProgressBar progressBar;
    private final PairingDialogType pairingDialogType;

    public PairingDialog(Component parent, PairingDialogType pairingDialogType, Context context, boolean modal, Consumer<Boolean> pairingCallback) {
        super(JOptionPane.getFrameForComponent(parent), Resources.getString(PairingDialog.class, (String)"dialogTitle"), modal);
        this.pairingCallback = pairingCallback;
        this.pairingDialogType = pairingDialogType;
        this.setDefaultCloseOperation(1);
        this.getContentPane().setLayout(new BorderLayout());
        FormBuilder builder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows("p, 10dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p", new Object[0]);
        builder.border((Border)Paddings.DIALOG);
        LOGGER.info("Provided context: {}", (Object)context);
        Integer pairingTimeout = (Integer)context.get("PAIRING_TIMEOUT", Integer.class, (Object)30);
        this.remainingPairingTime = pairingTimeout;
        String dialogMessageTemplate = PairingDialogType.PairingRequired == pairingDialogType ? "dialogMessageParingRequired" : "dialogMessageParingRequested";
        JLabel messageLabel = FormsSetup.getComponentFactoryDefault().createTitle(Resources.getString(PairingDialog.class, (String)dialogMessageTemplate));
        this.progressBar = new JProgressBar(0, this.remainingPairingTime);
        this.pairingCountDown = new Timer(1000, evt -> {
            --this.remainingPairingTime;
            this.progressBar.setValue(this.remainingPairingTime);
            this.progressBar.setString(String.format("%ds", this.remainingPairingTime));
            if (this.remainingPairingTime == 0) {
                try {
                    LOGGER.info("The pairing timer has elapsed.");
                    this.fireCancel();
                }
                catch (Exception ex) {
                    LOGGER.warn("Stop timer failed.", (Throwable)ex);
                }
            }
        });
        this.pairingCountDown.setRepeats(true);
        int row = 1;
        builder.add((Component)messageLabel).xyw(1, row, 3);
        builder.add(Resources.getString(((Object)((Object)this)).getClass(), (String)"remaining-time"), new Object[0]).xyw(1, row += 2, 3);
        builder.add((Component)this.progressBar).xyw(1, row += 2, 3);
        this.progressBar.setStringPainted(true);
        this.progressBar.setValue(this.remainingPairingTime);
        this.progressBar.setString(String.format("%ds", this.remainingPairingTime));
        builder.add(Resources.getString(PairingDialog.class, (String)"productName"), new Object[0]).xy(1, row += 2);
        builder.add((String)context.get("DESCRIPTOR_PROD_STRING", String.class, (Object)""), new Object[0]).xy(3, row);
        builder.add(Resources.getString(PairingDialog.class, (String)"userName"), new Object[0]).xy(1, row += 2);
        builder.add((String)context.get("DESCRIPTOR_USER_STRING", String.class, (Object)""), new Object[0]).xy(3, row);
        builder.add(Resources.getString(PairingDialog.class, (String)"uniqueId"), new Object[0]).xy(1, row += 2);
        Long uniqueId = (Long)context.get("DESCRIPTOR_UID", Long.class, null);
        String uniqueIdString = ByteUtils.getUniqueIdAsString((Long)uniqueId);
        builder.add(uniqueIdString != null ? uniqueIdString : "", new Object[0]).xy(3, row);
        builder.add(Resources.getString(PairingDialog.class, (String)"requestorName"), new Object[0]).xy(1, row += 2);
        builder.add((String)context.get("REQUESTOR_NAME", String.class, (Object)""), new Object[0]).xy(3, row);
        JButton pairButton = new JButton(Resources.getString(PairingDialog.class, (String)"pair"));
        pairButton.addActionListener(evt -> this.firePair());
        JButton cancel = new JButton(Resources.getString(PairingDialog.class, (String)"cancel"));
        if (pairingCallback == null) {
            cancel.setEnabled(false);
        }
        cancel.addActionListener(evt -> this.fireCancel());
        JPanel buttons = null;
        buttons = PairingDialogType.PairingRequired == pairingDialogType ? new ButtonBarBuilder().addGlue().addButton((JComponent)cancel).build() : new ButtonBarBuilder().addGlue().addButton(new JComponent[]{pairButton, cancel}).build();
        builder.add((Component)buttons).xyw(1, row += 2, 3);
        this.getContentPane().add(builder.build());
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setMinimumSize(this.getSize());
    }

    public void setVisible(boolean visible) {
        LOGGER.info("Set the pairing dialog visible: {}", (Object)visible);
        if (!visible) {
            if (this.pairingCountDown != null) {
                try {
                    this.pairingCountDown.stop();
                }
                catch (Exception ex) {
                    LOGGER.warn("Stop pairing countdown timer failed.", (Throwable)ex);
                }
                this.pairingCountDown = null;
            }
            this.performWindowClosingAction();
        } else if (this.pairingCountDown != null) {
            this.pairingCountDown.start();
        }
        super.setVisible(visible);
        if (!visible) {
            this.dispose();
        }
    }

    protected void performWindowClosingAction() {
        if (this.pairingCallback != null) {
            LOGGER.info("Call cancel on pairing callback on window closing.");
            try {
                this.pairingCallback.accept(Boolean.FALSE);
            }
            catch (Exception ex) {
                LOGGER.warn("Call cancel on pairingCallback failed.", (Throwable)ex);
            }
            this.pairingCallback = null;
        }
    }

    protected void performCancelAction(KeyEvent e) {
        LOGGER.info("Dialog was closed with ESC.");
        this.fireCancel();
    }

    private void firePair() {
        LOGGER.info("Accept the pairing process.");
        if (this.pairingCallback != null) {
            try {
                this.pairingCallback.accept(Boolean.TRUE);
            }
            catch (Exception ex) {
                LOGGER.warn("Call cancelCallback failed.", (Throwable)ex);
            }
            this.pairingCallback = null;
        }
        this.fireClose();
    }

    private void fireCancel() {
        LOGGER.info("Cancel the pairing process.");
        this.performWindowClosingAction();
        this.fireClose();
    }

    private void fireClose() {
        LOGGER.info("Close the dialog.");
        if (this.pairingCountDown != null) {
            try {
                LOGGER.info("Stop the pairing countdown timer.");
                this.pairingCountDown.stop();
            }
            catch (Exception ex) {
                LOGGER.warn("Stop pairing countdown timer failed.", (Throwable)ex);
            }
            this.pairingCountDown = null;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.setVisible(false);
        } else {
            SwingUtilities.invokeLater(() -> this.setVisible(false));
        }
    }

    public int getResult() {
        return this.result;
    }

    public PairingDialogType getPairingDialogType() {
        return this.pairingDialogType;
    }

    public void signalPaired() {
        LOGGER.info("Signal the paired state.");
        this.firePair();
    }

    public void clearPairingCallback() {
        LOGGER.info("Clear the pairing callback.");
        this.pairingCallback = null;
    }

    public static enum PairingDialogType {
        PairingRequired,
        PairingRequested;

    }
}

