/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.main;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.common.utils.ImageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.scheduling.annotation.EnableAsync;

@SpringBootApplication(scanBasePackages={"org.bidib.wizard.core.model", "org.bidib.wizard.core.service", "org.bidib.wizard.core.config", "org.bidib.wizard.common.context", "org.bidib.wizard.config", "org.bidib.wizard.startup", "org.bidib.wizard.discovery.config"})
@EnableAsync(proxyTargetClass=true)
public class BiDiBWizardStandaloneApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(BiDiBWizardStandaloneApplication.class);

    public static void main(String[] args) {
        String preferencesPath;
        Locale locale = Locale.getDefault();
        LOGGER.info("Current locale: {}", (Object)locale);
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.addAll(Arrays.asList(args));
        System.setProperty("javax.xml.accessExternalSchema", "file");
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Class[0]).sources(new Class[]{BiDiBWizardStandaloneApplication.class}).headless(false).web(WebApplicationType.NONE).properties(new String[]{"wizard-app-type=standalone"});
        if (!"restartedMain".equals(Thread.currentThread().getName())) {
            Optional<String> wizardConfigFileName = argsList.stream().filter(val -> val.startsWith("--wizard.settings.file-name")).findFirst();
            if (wizardConfigFileName.isPresent()) {
                LOGGER.info("Keep the provided data from args: {}", (Object)wizardConfigFileName.get());
                String fileName = wizardConfigFileName.get().split("=")[1];
                fileName = FilenameUtils.getBaseName((String)fileName);
                LOGGER.info("Add the fileName: {}", (Object)fileName);
                builder.properties(new String[]{"spring.config.name=application," + fileName});
            } else {
                builder.properties(new String[]{"spring.config.name=application,wizard21"});
            }
            Optional<String> wizardConfigFileLocation = argsList.stream().filter(val -> val.startsWith("--wizard.settings.file-location")).findFirst();
            if (wizardConfigFileLocation.isPresent()) {
                LOGGER.info("Keep the provided data from args: {}", (Object)wizardConfigFileLocation.get());
                Object location = wizardConfigFileLocation.get().split("=")[1];
                location = ((String)location).replaceAll("\\\\", "/");
                if (!((String)location).endsWith("/")) {
                    location = (String)location + "/";
                }
                LOGGER.info("Set the optional additional-location: {}", location);
                builder.properties(new String[]{"spring.config.additional-location=optional:file:///" + (String)location});
            }
        }
        if (StringUtils.isBlank((CharSequence)(preferencesPath = System.getProperty("bidib.preferencesPath"))) && StringUtils.isBlank((CharSequence)(preferencesPath = System.getenv("bidib.preferencesPath")))) {
            preferencesPath = System.getProperty("user.home");
            System.setProperty("bidib.preferencesPath", preferencesPath);
        }
        try {
            builder.run(argsList.toArray(new String[0]));
        }
        catch (Exception ex) {
            LOGGER.warn("Start application failed.", (Throwable)ex);
            try {
                SwingUtilities.invokeAndWait(() -> {
                    try {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                    catch (Exception ex1) {
                        LOGGER.warn("Set system look and feel failed.", (Throwable)ex1);
                    }
                    JFrame frame = new JFrame("BiDiB-Wizard");
                    frame.setDefaultCloseOperation(3);
                    try {
                        frame.setIconImage(ImageUtils.createImageIcon(BiDiBWizardStandaloneApplication.class, (String)"/icons/wizard-logo2-48x48.png").getImage());
                    }
                    catch (Exception ex2) {
                        LOGGER.warn("Load application icon failed.");
                    }
                    frame.setLocationRelativeTo(null);
                    frame.setVisible(true);
                    JOptionPane.showMessageDialog(frame, "Start application failed.\r\nCheck configuration files (*.yml).\r\nReason: " + ex.getMessage().replaceAll("(.{100})", "$1\n"), "BiDiB-Wizard", 0);
                });
            }
            catch (Exception ex1) {
                LOGGER.warn("Show exception dialog failed.", (Throwable)ex1);
            }
            System.exit(1);
        }
    }
}

