/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.backup.controller;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.RelativeDockablePosition;
import com.vlsolutions.swing.docking.event.DockableStateChangeEvent;
import com.vlsolutions.swing.docking.event.DockableStateChangeListener;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.jbidibc.core.schema.BidibFactory;
import org.bidib.jbidibc.core.schema.bidib2.BiDiB;
import org.bidib.jbidibc.exchange.vendorcv.VendorCvData;
import org.bidib.jbidibc.exchange.vendorcv.VendorCvFactory;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.helpers.DefaultContext;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.MacroSaveState;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.NodeListProvider;
import org.bidib.wizard.api.model.NodeProvider;
import org.bidib.wizard.api.model.listener.DefaultNodeListListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.service.node.NodeService;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.api.utils.XmlLocaleUtils;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.client.common.view.DockUtils;
import org.bidib.wizard.client.common.view.cvdef.CvContainer;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeModelRegistry;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.client.common.view.statusbar.StatusBarPublisher;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.common.utils.SearchPathUtils;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.mvc.backup.controller.listener.BackupControllerListener;
import org.bidib.wizard.mvc.backup.model.BackupTableModel;
import org.bidib.wizard.mvc.backup.model.NodeBackupModel;
import org.bidib.wizard.mvc.backup.view.BackupView;
import org.bidib.wizard.mvc.main.view.exchange.NodeExchangeHelper;
import org.bidib.wizard.utils.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BackupController
implements BackupControllerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackupController.class);
    private final DockingDesktop desktop;
    private DockableStateChangeListener dockableStateChangeListener;
    private final Supplier<NodeProvider> nodeProviderSupplier;
    private final NodeListProvider nodeListProvider;
    private BackupView backupView;
    private BackupTableModel backupTableModel;
    @Autowired
    private ConnectionService connectionService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private SwitchingNodeService switchingNodeService;
    @Autowired
    private StatusBar statusBar;
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    private final NodeListListener nodeListListener;
    private final ScheduledExecutorService backupWorkers = Executors.newScheduledThreadPool(5, new ThreadFactoryBuilder().setNameFormat("backupWorkers-thread-%d").build());
    private CompositeDisposable compDispNodes;
    private final Supplier<String> connectionId;

    public BackupController(DockingDesktop desktop, Supplier<NodeProvider> nodeProviderSupplier, NodeListProvider nodeListProvider, Supplier<String> connectionId) {
        this.desktop = desktop;
        this.nodeProviderSupplier = nodeProviderSupplier;
        this.nodeListProvider = nodeListProvider;
        this.connectionId = connectionId;
        this.nodeListListener = new DefaultNodeListListener(){

            public void listNodeAdded(NodeInterface node) {
                LOGGER.info("The nodelist has a new node: {}", (Object)node);
                BackupController.this.nodeNew(node);
            }

            public void listNodeRemoved(NodeInterface node) {
                LOGGER.info("The nodelist has a node removed: {}", (Object)node);
                BackupController.this.nodeLost(node);
            }
        };
    }

    public void start() {
        LOGGER.info("Start the BackupController.");
        String searchKey = "backupView";
        LOGGER.info("Search for view with key: {}", (Object)searchKey);
        Dockable view = this.desktop.getContext().getDockableByKey(searchKey);
        if (view != null) {
            LOGGER.info("Select the existing backup view.");
            DockUtils.selectWindow((Dockable)view);
            return;
        }
        this.createDockable();
    }

    public Dockable createDockable() {
        LOGGER.info("Create new BackupView.");
        if (this.backupView != null) {
            LOGGER.info("Select the existing booster table view.");
            DockUtils.selectWindow((Dockable)this.backupView);
            return this.backupView;
        }
        this.compDispNodes = new CompositeDisposable();
        this.backupTableModel = new BackupTableModel((StatusBarPublisher<String, Integer>)((StatusBarPublisher)(text, duration) -> {
            if (duration != null) {
                this.statusBar.setStatusText(text, duration.intValue());
            } else {
                this.statusBar.setStatusText(text);
            }
        }));
        this.backupView = new BackupView(this, this.backupTableModel, this.settingsService, (StatusBarPublisher<String, Integer>)((StatusBarPublisher)(text, duration) -> {
            if (duration != null) {
                this.statusBar.setStatusText(text, duration.intValue());
            } else {
                this.statusBar.setStatusText(text);
            }
        }));
        if (this.desktop.getDockables().length > 1) {
            for (DockableState dockableState : this.desktop.getDockables()) {
                Dockable dock = dockableState.getDockable();
                if (!dock.getDockKey().equals((Object)DockKeys.DOCKKEY_TAB_PANEL)) continue;
                LOGGER.info("Found tabPanel and add backup view next to tabPanel.");
                this.desktop.createTab(dock, (Dockable)this.backupView, 2, true);
                break;
            }
        } else {
            LOGGER.info("No dockables found. Add backup view to right.");
            this.desktop.addDockable((Dockable)this.backupView, RelativeDockablePosition.RIGHT);
        }
        this.nodeListProvider.addNodeListListener(this.nodeListListener);
        this.dockableStateChangeListener = new DockableStateChangeListener(){

            public void dockableStateChanged(DockableStateChangeEvent event) {
                if (event.getNewState().getDockable().equals((Object)BackupController.this.backupView) && event.getNewState().isClosed()) {
                    LOGGER.info("BackupView was closed, free resources.");
                    try {
                        BackupController.this.desktop.removeDockableStateChangeListener(BackupController.this.dockableStateChangeListener);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Remove dockableStateChangeListener from desktop failed: " + String.valueOf(BackupController.this.dockableStateChangeListener), (Throwable)ex);
                    }
                    finally {
                        BackupController.this.dockableStateChangeListener = null;
                    }
                    try {
                        BackupController.this.nodeListProvider.removeNodeListListener(BackupController.this.nodeListListener);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Remove nodeList listener failed.", (Throwable)ex);
                    }
                    if (BackupController.this.compDispNodes != null) {
                        LOGGER.info("Dispose the node subscription.");
                        BackupController.this.compDispNodes.dispose();
                        BackupController.this.compDispNodes = null;
                    }
                    BackupController.this.backupView = null;
                    BackupController.this.backupTableModel = null;
                }
            }
        };
        this.desktop.addDockableStateChangeListener(this.dockableStateChangeListener);
        try {
            Disposable disp = this.connectionService.subscribeConnectionStatusChanges(connectionInfo -> {
                if (connectionInfo.getConnectionId().equals(this.connectionId.get())) {
                    LOGGER.info("Current state: {}", (Object)connectionInfo.getConnectionState());
                    switch (connectionInfo.getConnectionState().getActualPhase()) {
                        case CONNECTED: {
                            LOGGER.info("The communication was opened.");
                            break;
                        }
                        case DISCONNECTED: {
                            LOGGER.info("The communication was closed.");
                            LinkedList<NodeBackupModel> nodeBackups = new LinkedList<NodeBackupModel>(this.backupTableModel.getNodes());
                            for (NodeBackupModel nodeBackup : nodeBackups) {
                                this.backupTableModel.removeNode(nodeBackup.getNode());
                            }
                            break;
                        }
                    }
                }
            }, error -> LOGGER.warn("The connection status change caused an error.", error), () -> LOGGER.info("The subscription to connection status changes has completed."));
            this.compDispNodes.add(disp);
            NodeProvider nodeProvider = this.nodeProviderSupplier.get();
            if (CollectionUtils.isNotEmpty((Collection)nodeProvider.getNodes())) {
                LOGGER.info("Add nodes to backup model.");
                LinkedList nodes = new LinkedList(nodeProvider.getNodes());
                for (NodeInterface node : nodes) {
                    this.backupTableModel.addNode(node, this.wizardLabelWrapper);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Register controller as connection status listener failed.", (Throwable)ex);
        }
        return this.backupView;
    }

    private void nodeNew(NodeInterface node) {
        LOGGER.info("New node in system detected: {}", (Object)node);
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalNewNode(node);
        } else {
            SwingUtilities.invokeLater(() -> this.internalNewNode(node));
        }
    }

    private void internalNewNode(NodeInterface node) {
        LOGGER.info("Add new node to table: {}", (Object)node);
        this.backupTableModel.addNode(node, this.wizardLabelWrapper);
    }

    private void nodeLost(NodeInterface node) {
        LOGGER.info("Remove node from model: {}", (Object)node);
        if (SwingUtilities.isEventDispatchThread()) {
            this.backupTableModel.removeNode(node);
        } else {
            SwingUtilities.invokeLater(() -> this.backupTableModel.removeNode(node));
        }
    }

    @Override
    public CompletableFuture<String> performBackup(String backupDir, List<NodeBackupModel> nodeBackupModels) {
        LOGGER.info("Perform backup, backupDir: {}", (Object)backupDir);
        LinkedList futures = new LinkedList();
        WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        NodeExchangeHelper helper = new NodeExchangeHelper();
        String lang = XmlLocaleUtils.getXmlLocaleVendorCV();
        boolean loadCvs = true;
        for (NodeBackupModel nodeBackupModel : nodeBackupModels) {
            CompletableFuture future = new CompletableFuture();
            Callable<NodeBackupModel> backup = () -> {
                NodeInterface node = nodeBackupModel.getNode();
                LOGGER.info("Perform backup for node: {}", (Object)node);
                SwingUtilities.invokeLater(() -> nodeBackupModel.setProgress(5));
                LOGGER.info("Load the CVs of the node before export: {}", (Object)node);
                long uniqueId = node.getUniqueId();
                CvContainer cvContainer = this.cvDefinitionTreeModelRegistry.getCvContainer(uniqueId);
                if (cvContainer == null) {
                    if (node.getVendorCV() == null) {
                        SwingUtilities.invokeLater(() -> nodeBackupModel.setProgress(7));
                        this.loadCvDefinition(node);
                    }
                    SwingUtilities.invokeLater(() -> nodeBackupModel.setProgress(20));
                    if (node.getVendorCV() != null) {
                        LOGGER.info("No cvContainer found but vendorCV available. Prepare the vendorCV tree for node: {}", (Object)node);
                        VendorCvData vendorCV = node.getVendorCV();
                        this.cvDefinitionTreeModelRegistry.prepareVendorCVTree(node, vendorCV, false);
                        cvContainer = this.cvDefinitionTreeModelRegistry.getCvContainer(uniqueId);
                    }
                }
                List configurationVariables = null;
                if (cvContainer != null) {
                    configurationVariables = cvContainer.getConfigVariables();
                }
                if (CollectionUtils.isNotEmpty(configurationVariables)) {
                    configurationVariables = configurationVariables.stream().distinct().collect(Collectors.toList());
                    ConfigurationVariable.sortCvVariables(configurationVariables);
                    LOGGER.info("Load CV from node");
                    try {
                        List queriedConfigurationVariables = this.nodeService.queryConfigVariables(this.connectionId.get(), node, configurationVariables);
                        LOGGER.info("Current queried configurationVariables: {}", (Object)queriedConfigurationVariables);
                        node.setConfigVariables(queriedConfigurationVariables);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Query configuration variables from node failed.", (Throwable)ex);
                        future.completeExceptionally(ex);
                        return nodeBackupModel;
                    }
                } else {
                    LOGGER.warn("No configuration variables available to load from node: {}", (Object)node);
                }
                if (node.hasUnloadedMacros()) {
                    LOGGER.info("The current node has unloaded macros: {}", (Object)node);
                    SwingUtilities.invokeLater(() -> nodeBackupModel.setProgress(30));
                    try {
                        for (Macro macro : node.getMacros()) {
                            if (macro.getMacroSaveState() == MacroSaveState.PERMANENTLY_STORED_ON_NODE) continue;
                            LOGGER.info("Load macro content for macro: {}", (Object)macro);
                            NodeUtils.loadMacroContentFromNode(this.connectionId.get(), this.nodeService, this.switchingNodeService, node, macro);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Load macro content from node failed.", (Throwable)ex);
                        future.completeExceptionally(ex);
                        return nodeBackupModel;
                    }
                } else {
                    LOGGER.info("The current node has no unloaded macros: {}", (Object)node);
                }
                try {
                    BiDiB bidib = helper.prepareBiDiB(node, this.cvDefinitionTreeModelRegistry, lang, false, this.wizardLabelWrapper);
                    String fileName = NodeExchangeHelper.prepareFileName(wizardSettings, node);
                    LOGGER.info("Prepared backup fileName: {}, backupDir: {}", (Object)fileName, (Object)backupDir);
                    SwingUtilities.invokeLater(() -> nodeBackupModel.setProgress(50));
                    File backupFile = new File(backupDir, fileName);
                    BidibFactory.saveBiDiB((BiDiB)bidib, (File)backupFile, (boolean)false);
                    LOGGER.info("Save node state passed, fileName: {}", (Object)fileName);
                    SwingUtilities.invokeLater(() -> nodeBackupModel.setProgress(100));
                }
                catch (Exception ex) {
                    LOGGER.warn("Failed to prepare backup and save to file.", (Throwable)ex);
                    future.completeExceptionally(ex);
                    return nodeBackupModel;
                }
                future.complete(nodeBackupModel);
                return nodeBackupModel;
            };
            futures.add(future);
            this.backupWorkers.submit(backup);
        }
        CompletableFuture[] cfs = futures.toArray(new CompletableFuture[0]);
        CompletionStage result = CompletableFuture.allOf(cfs).thenApply(ignored -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
        CompletableFuture<String> res = new CompletableFuture<String>();
        ((CompletableFuture)((CompletableFuture)result).whenComplete((o, th) -> {
            LOGGER.info("The backup has finished.");
            if (th != null) {
                LOGGER.info("The backup result has signalled an error.");
                res.completeExceptionally((Throwable)th);
            } else {
                res.complete("ok");
            }
        })).join();
        LOGGER.info("The backup has finished with result: {}", (Object)result);
        LOGGER.info("Return with result: {}", res);
        return res;
    }

    private void loadCvDefinition(NodeInterface node) {
        VendorCvData vendorCV = null;
        if (node != null) {
            DefaultContext context = new DefaultContext();
            try {
                StopWatch sw = StopWatch.createStarted();
                String installationPath = this.settingsService.getInstallationPath();
                LOGGER.info("Current installation path: {}", (Object)installationPath);
                File file = new File(installationPath);
                file = new File(file.getAbsoluteFile(), "data/BiDiBNodeVendorData");
                String userHome = System.getProperty("user.home");
                File searchPathUserHomeWizard = new File(userHome, ".BiDiBWizard/data/BiDiBNodeVendorData");
                String labelPath = this.settingsService.getMiscSettings().getBidibConfigDir();
                File searchPathLabelPath = new File(labelPath, "data/BiDiBNodeVendorData");
                vendorCV = VendorCvFactory.getCvDefinition((Node)node.getNode(), (Context)context, SearchPathUtils::lookupFilesInClasspath, (String[])new String[]{searchPathLabelPath.getAbsolutePath(), file.getAbsolutePath(), "classpath:/bidib", searchPathUserHomeWizard.getAbsolutePath()});
                sw.stop();
                LOGGER.info("Load vendorCV data took: {}", (Object)sw.toString());
            }
            catch (Exception ex) {
                LOGGER.warn("Get CV definition for node failed.", (Throwable)ex);
            }
            if (vendorCV != null) {
                LOGGER.info("Set the vendorCv for node: {}", (Object)node);
                node.setVendorCV(vendorCV);
            }
        }
    }
}

