/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.locolist.controller;

import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.RelativeDockablePosition;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import com.vlsolutions.swing.docking.event.DockableStateChangeEvent;
import com.vlsolutions.swing.docking.event.DockableStateChangeListener;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.CommandStationPom;
import org.bidib.jbidibc.messages.enums.CsQueryTypeEnum;
import org.bidib.jbidibc.messages.enums.DirectionEnum;
import org.bidib.jbidibc.messages.enums.PomAcknowledge;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.helpers.DefaultContext;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.CommandStationNodeInterface;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.DefaultNodeListListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.notification.LocoListChangeAction;
import org.bidib.wizard.api.service.core.LocoService;
import org.bidib.wizard.api.service.node.CommandStationService;
import org.bidib.wizard.api.utils.NodeUtils;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.client.common.view.DockUtils;
import org.bidib.wizard.config.LocoControllerFactory;
import org.bidib.wizard.config.PomProgrammerControllerFactory;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.core.service.node.BidibNodeService;
import org.bidib.wizard.model.locolist.LocoListModel;
import org.bidib.wizard.model.status.SpeedSteps;
import org.bidib.wizard.mvc.common.DialogRegistry;
import org.bidib.wizard.mvc.loco.controller.LocoController;
import org.bidib.wizard.mvc.locolist.controller.listener.LocoTableControllerListener;
import org.bidib.wizard.mvc.locolist.model.LocoLibraryModel;
import org.bidib.wizard.mvc.locolist.model.LocoTableModel;
import org.bidib.wizard.mvc.locolist.view.LocoEditDialog;
import org.bidib.wizard.mvc.locolist.view.LocoTableView;
import org.bidib.wizard.mvc.main.controller.MainControllerInterface;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.pom.controller.PomProgrammerController;
import org.bidib.wizard.mvc.pom.controller.listener.PomProgrammerControllerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class LocoTableController
implements LocoTableControllerListener,
PropertyChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocoTableController.class);
    private final JFrame parent;
    private final MainModel mainModel;
    private MainControllerInterface mainController;
    private LocoTableView locoTableView;
    private LocoTableModel locoTableModel;
    private final NodeInterface selectedNode;
    @Autowired
    private BidibNodeService bidibNodeService;
    @Autowired
    private ConnectionService connectionService;
    @Autowired
    private CommandStationService commandStationService;
    @Autowired
    private LocoService locoService;
    private LocoLibraryModel locoLibrary;
    private final Supplier<String> connectionId;
    private final CompositeDisposable disp = new CompositeDisposable();
    private final DockingDesktop desktop;
    private DockableStateChangeListener dockableStateChangeListener;
    private final ApplicationContext applicationContext;
    private CompositeDisposable compDisp;
    private final ScheduledExecutorService locoLibraryWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("locoLibraryWorkers-thread-%d").build());

    public LocoTableController(NodeInterface node, DockingDesktop desktop, JFrame parent, MainModel mainModel, Supplier<String> connectionId, ApplicationContext applicationContext) {
        this.parent = parent;
        this.desktop = desktop;
        this.mainModel = mainModel;
        this.connectionId = connectionId;
        this.applicationContext = applicationContext;
        this.selectedNode = node;
    }

    public void start(MainControllerInterface mainController) {
        String searchKey = this.prepareDockTabName(this.selectedNode);
        LOGGER.info("Search for view with key: {}", (Object)searchKey);
        for (DockableState dockable : this.desktop.getContext().getDockables()) {
            DockKey dockKey = dockable.getDockable().getDockKey();
            if (!"LocoTableView".equals(dockKey.getKey()) || !searchKey.equals(dockKey.getName())) continue;
            LOGGER.info("Select the existing loco list table view.");
            DockUtils.selectWindow((Dockable)dockable.getDockable());
            return;
        }
        this.mainController = mainController;
        LOGGER.info("Create new LocoTableView.");
        this.compDisp = new CompositeDisposable();
        this.locoTableModel = new LocoTableModel(this);
        this.locoTableView = new LocoTableView(this, this.locoTableModel, searchKey);
        DockableState[] dockables = this.desktop.getDockables();
        LOGGER.info("Current dockables: {}", new Object[]{dockables});
        if (dockables.length > 1) {
            DockableState boosterTableView = null;
            for (DockableState dockable : dockables) {
                if (!DockKeys.DOCKKEY_BOOSTER_TABLE_VIEW.equals((Object)dockable.getDockable().getDockKey())) continue;
                LOGGER.info("Found the booster table view dockable.");
                boosterTableView = dockable;
                break;
            }
            Dockable dock = this.desktop.getDockables()[1].getDockable();
            if (boosterTableView != null) {
                LOGGER.info("Add the loco panel view to the booster table view panel.");
                dock = boosterTableView.getDockable();
                TabbedDockableContainer container = DockingUtilities.findTabbedDockableContainer((Dockable)dock);
                int order = 0;
                if (container != null) {
                    order = container.getTabCount();
                }
                LOGGER.info("Add new loco panel at order: {}", (Object)order);
                this.desktop.createTab(dock, (Dockable)this.locoTableView, order, true);
                this.desktop.setDockableHeight((Dockable)this.locoTableView, 0.3);
            } else {
                this.desktop.split(dock, (Dockable)this.locoTableView, DockingConstants.SPLIT_RIGHT);
                this.desktop.setDockableHeight((Dockable)this.locoTableView, 0.3);
            }
        } else {
            this.desktop.addDockable((Dockable)this.locoTableView, RelativeDockablePosition.RIGHT);
        }
        DefaultNodeListListener nodeListListener = new DefaultNodeListListener(){

            public void listNodeAdded(NodeInterface node) {
                LOGGER.info("The nodelist has a new node: {}", (Object)node);
            }

            public void listNodeRemoved(NodeInterface node) {
                LOGGER.info("The nodelist has a node removed: {}", (Object)node);
                LocoTableController.this.nodeLost(node);
            }
        };
        this.mainController.addNodeListListener((NodeListListener)nodeListListener);
        try {
            Disposable dispConnStatus = this.connectionService.subscribeConnectionStatusChanges(connectionInfo -> {
                if (connectionInfo.getConnectionId().equals(this.connectionId.get())) {
                    LOGGER.info("Current state: {}", (Object)connectionInfo.getConnectionState());
                    switch (connectionInfo.getConnectionState().getActualPhase()) {
                        case CONNECTED: {
                            LOGGER.info("The communication was opened.");
                            break;
                        }
                        case DISCONNECTED: {
                            LOGGER.info("The communication was closed. Remove all locos from the table.");
                            SwingUtilities.invokeLater(() -> this.cleanup());
                            break;
                        }
                    }
                }
            }, error -> LOGGER.warn("The connection status change caused an error.", error));
            this.disp.add(dispConnStatus);
        }
        catch (Exception ex) {
            LOGGER.warn("Register controller as connection status listener failed.", (Throwable)ex);
        }
        this.dockableStateChangeListener = new DockableStateChangeListener(){
            final /* synthetic */ NodeListListener val$nodeListListener;
            final /* synthetic */ MainControllerInterface val$mainController;
            {
                this.val$nodeListListener = nodeListListener;
                this.val$mainController = mainControllerInterface;
            }

            public void dockableStateChanged(DockableStateChangeEvent event) {
                if (event.getNewState().getDockable().equals((Object)LocoTableController.this.locoTableView) && event.getNewState().isClosed()) {
                    LOGGER.info("LocoTableView was closed, free resources.");
                    LocoTableController.this.cleanup();
                    try {
                        LocoTableController.this.desktop.removeDockableStateChangeListener(LocoTableController.this.dockableStateChangeListener);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Remove dockableStateChangeListener from desktop failed: " + String.valueOf(LocoTableController.this.dockableStateChangeListener), (Throwable)ex);
                    }
                    finally {
                        LocoTableController.this.dockableStateChangeListener = null;
                    }
                    try {
                        if (this.val$nodeListListener != null) {
                            this.val$mainController.removeNodeListListener(this.val$nodeListListener);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Unregister controller as node listener failed.", (Throwable)ex);
                    }
                }
            }
        };
        this.desktop.addDockableStateChangeListener(this.dockableStateChangeListener);
    }

    private String prepareDockTabName(NodeInterface node) {
        if (node != null) {
            return Resources.getString(LocoTableView.class, (String)"title") + " - " + this.prepareNodeLabel(node);
        }
        return Resources.getString(LocoTableView.class, (String)"title");
    }

    private String prepareNodeLabel(NodeInterface node) {
        String productString;
        String nodeLabel = node.getLabel();
        if (StringUtils.isBlank((CharSequence)nodeLabel) && StringUtils.isNotBlank((CharSequence)(productString = node.getNode().getStoredString(0)))) {
            nodeLabel = productString;
        }
        return nodeLabel;
    }

    private void cleanup() {
        if (this.compDisp != null) {
            LOGGER.info("Dispose the subscription to locoList actions.");
            this.compDisp.dispose();
            this.compDisp = null;
        }
        this.locoTableModel.removeAllLocos();
        LOGGER.info("Close the locoTableView.");
        this.desktop.close((Dockable)this.locoTableView);
    }

    private void nodeLost(NodeInterface node) {
        if (node != null && node.equals((Object)this.selectedNode)) {
            LOGGER.info("The selected node was removed. Clear the list of loco for node: {}", (Object)node);
            SwingUtils.executeInEDT(() -> this.cleanup());
        }
    }

    public void queryLocoList() {
        LOGGER.info("Query the locoList of the selected node: {}", (Object)this.selectedNode);
        if (this.selectedNode != null && org.bidib.jbidibc.messages.utils.NodeUtils.hasCommandStationFunctions((long)this.selectedNode.getUniqueId())) {
            this.locoTableModel.setCsNodeSelected(true);
            if (this.locoTableView != null) {
                List locoList = this.locoService.loadLocoList(this.connectionId.get(), this.selectedNode.getCommandStationNode());
                this.locoTableModel.setLocoListModel(locoList);
                Disposable dispConnectionActions = this.locoService.subscribeLocoListActions(ca -> {
                    if (this.connectionId.get().equals(ca.getConnectionId())) {
                        this.processLocoListAction((LocoListChangeAction)ca);
                    }
                }, error -> LOGGER.warn("The locoList actions signalled a failure: {}", error));
                this.compDisp.add(dispConnectionActions);
                this.queryCommandStationValue(this.selectedNode, CsQueryTypeEnum.LOCO_LIST, null);
            }
        } else {
            this.locoTableModel.setCsNodeSelected(false);
        }
    }

    private void processLocoListAction(LocoListChangeAction ca) {
        if (this.selectedNode.getUniqueId() == ca.getUniqueId().longValue()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Forward the locoListChangeAction to locoTableModel, current node: {}, source node: {}", (Object)ByteUtils.formatHexUniqueId((long)this.selectedNode.getUniqueId()), (Object)ByteUtils.formatHexUniqueId((Long)ca.getUniqueId()));
            }
            SwingUtilities.invokeLater(() -> this.locoTableModel.processLocoAction(ca));
        } else if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Discard change action for another commandStation node: {}", (Object)ByteUtils.formatHexUniqueId((Long)ca.getUniqueId()));
        }
    }

    @Override
    public void queryCommandStationList(CsQueryTypeEnum csQueryType, Integer locoAddress) {
        LOGGER.info("Remove all locos from table before query the loco list from command station, locoAddress: {}", (Object)locoAddress);
        this.queryCommandStationValue(this.selectedNode, csQueryType, locoAddress);
    }

    private void queryCommandStationValue(NodeInterface node, CsQueryTypeEnum csQueryType, Integer locoAddress) {
        LOGGER.info("Query the loco list from command station, csQueryType: {}, locoAddress: {}", (Object)csQueryType, (Object)locoAddress);
        if (node != null && node.getCommandStationNode() != null) {
            try {
                this.locoService.queryLocoListFromCommandStation(this.connectionId.get(), node.getCommandStationNode(), csQueryType, locoAddress);
            }
            catch (Exception ex) {
                LOGGER.warn("Query the loco list from command station failed.", (Throwable)ex);
            }
        } else {
            LOGGER.warn("No command station node available.");
        }
    }

    @Override
    public void pushLocoToMouse(int entryId, int speedSteps, int address, String locoName) {
        if (entryId < 0 && entryId > 7) {
            throw new IllegalArgumentException("entryId is limited to values between 0..7");
        }
        int maxWidth = 10;
        String vendorName = String.format("XP_LOC_%d/8", entryId);
        String vendorValue = String.format("%d\\%d\\%s", speedSteps, address, StringUtils.truncate((String)locoName, (int)maxWidth));
        if (this.selectedNode != null) {
            try {
                LinkedList<ConfigurationVariable> cvList = new LinkedList<ConfigurationVariable>();
                cvList.add(new ConfigurationVariable(vendorName, vendorValue));
                List configVars = this.bidibNodeService.setConfigVariables(this.connectionId.get(), this.selectedNode, cvList);
                if (CollectionUtils.isEmpty((Collection)configVars)) {
                    LOGGER.warn("No changed CV values returned. Notify the user.");
                    throw new RuntimeException("No changed CV values returned. Push loco data to mouse failed.");
                }
                LOGGER.info("Received configVars: {}", (Object)configVars);
            }
            catch (Exception ex) {
                LOGGER.warn("Push the loco name to the mouse failed.", (Throwable)ex);
            }
        }
    }

    @Override
    public void setLocoLibraryModel(LocoLibraryModel locoLibrary) {
        if (this.locoLibrary != null) {
            this.locoLibrary.removePropertyChangeListener("pushToMouse", this);
        }
        this.locoLibrary = locoLibrary;
        if (this.locoLibrary != null) {
            this.locoLibrary.addPropertyChangeListener("pushToMouse", this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (Boolean.TRUE.equals(evt.getNewValue())) {
            LOGGER.info("The push to mouse is now enabled. Start the process to publish the loco library.");
            if (this.locoLibrary != null) {
                int delay = 200;
                this.locoLibraryWorker.schedule(() -> {
                    LOGGER.info("Start push loco library to mouse.");
                    try {
                        this.locoLibrary.setExecutionStatus("Start push loco library to mouse.");
                        this.locoLibrary.setExecutionResult(LocoLibraryModel.ExecutionResult.PENDING);
                        int entryId = 0;
                        for (LocoListModel locoModel : this.locoLibrary.getLocoList()) {
                            LOGGER.info("Push loco data to mouse, loco: {}, entryId: {}", (Object)locoModel, (Object)entryId);
                            if (locoModel != null) {
                                String locoName = StringUtils.isNotBlank((CharSequence)locoModel.getLocoName()) ? locoModel.getLocoName() : Integer.toString(locoModel.getAddress());
                                this.locoLibrary.setExecutionStatus("Push loco: " + locoName);
                                this.pushLocoToMouse(entryId, SpeedSteps.valueOf((SpeedSteps)locoModel.getSpeedSteps()), locoModel.getAddress(), locoName);
                                LOGGER.info("Wait after push.");
                                try {
                                    Thread.sleep(50L);
                                }
                                catch (InterruptedException ex) {
                                    LOGGER.warn("Wait 50ms after push the loco to the mouse was interrupted.", (Throwable)ex);
                                }
                            } else {
                                LOGGER.info("No loco at index: {}", (Object)entryId);
                            }
                            ++entryId;
                        }
                        LOGGER.info("Finished push loco library to mouse.");
                        this.locoLibrary.setExecutionStatus("Finished push loco library to mouse.");
                        this.locoLibrary.setExecutionResult(LocoLibraryModel.ExecutionResult.PASSED);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Push loco library to mouse failed.", (Throwable)ex);
                        this.locoLibrary.setExecutionResult(LocoLibraryModel.ExecutionResult.FAILED);
                    }
                    finally {
                        this.locoLibrary.setPushToMouse(false);
                    }
                }, (long)delay, TimeUnit.MILLISECONDS);
            } else {
                LOGGER.info("The push to mouse is not enabled.");
            }
        }
    }

    @Override
    public void openLocoDialog(LocoListModel locoModel) {
        LOGGER.info("Open the loco dialog for locoModel: {}", (Object)locoModel);
        if (this.selectedNode != null && this.selectedNode.getCommandStationNode() != null) {
            LocoControllerFactory locoControllerFactory = (LocoControllerFactory)this.applicationContext.getBean(LocoControllerFactory.class);
            DialogRegistry dialogRegistry = (DialogRegistry)this.applicationContext.getBean(DialogRegistry.class);
            LocoController locoController = locoControllerFactory.createLocoController(this.selectedNode.getCommandStationNode(), (JFrame)JOptionPane.getFrameForComponent(this.parent), this.mainModel.getNodeProvider(), dialogRegistry);
            AddressData initialAddress = null;
            if (locoModel != null) {
                initialAddress = new AddressData(locoModel.getAddress(), locoModel.getDirection() == DirectionEnum.FORWARD ? AddressTypeEnum.LOCOMOTIVE_FORWARD : AddressTypeEnum.LOCOMOTIVE_BACKWARD);
            }
            locoController.start(initialAddress, locoModel != null ? locoModel.getSpeedSteps() : null, locoModel);
        }
    }

    @Override
    public void openPomDialog(LocoListModel locoModel) {
        LOGGER.info("Open the POM dialog, locoModel: {}", (Object)locoModel);
        CommandStationNodeInterface node = NodeUtils.findFirstCommandStationNode((Iterable)this.mainModel.getNodeProvider().getNodes());
        if (node != null) {
            PomProgrammerControllerFactory pomProgrammerControllerFactory = (PomProgrammerControllerFactory)this.applicationContext.getBean(PomProgrammerControllerFactory.class);
            DialogRegistry dialogRegistry = (DialogRegistry)this.applicationContext.getBean(DialogRegistry.class);
            PomProgrammerController pomProgrammerController = pomProgrammerControllerFactory.createPomProgrammerController(node, dialogRegistry, (JFrame)JOptionPane.getFrameForComponent(this.parent), new Point(0, 0));
            pomProgrammerController.addPomProgrammerControllerListener(new PomProgrammerControllerListener(){

                @Override
                public void sendRequest(CommandStationNodeInterface node, PomAddressData locoAddress, CommandStationPom opCode, int cvNumber, int cvValue) {
                    LOGGER.info("Send POM request.");
                    PomAcknowledge pomAck = LocoTableController.this.commandStationService.sendCvPomRequest(LocoTableController.this.connectionId.get(), node, locoAddress, opCode, cvNumber, cvValue);
                    LOGGER.info("Received pomAck: {}", (Object)pomAck);
                }

                @Override
                public void close() {
                }
            });
            AddressData initialAddress = null;
            if (locoModel != null) {
                initialAddress = new AddressData(locoModel.getAddress(), locoModel.getDirection() == DirectionEnum.FORWARD ? AddressTypeEnum.LOCOMOTIVE_FORWARD : AddressTypeEnum.LOCOMOTIVE_BACKWARD);
            }
            pomProgrammerController.start(this.desktop, initialAddress);
        }
    }

    @Override
    public void deleteLoco(LocoListModel locoModel) {
        LOGGER.info("Delete the loco, locoModel: {}", (Object)locoModel);
        CommandStationNodeInterface node = NodeUtils.findFirstCommandStationNode((Iterable)this.mainModel.getNodeProvider().getNodes());
        if (node != null) {
            DefaultContext context = new DefaultContext();
            Integer locoAddress = locoModel.getAddress();
            SpeedSteps speedSteps = locoModel.getSpeedSteps();
            this.commandStationService.clearLoco(this.connectionId.get(), node, locoAddress.intValue(), speedSteps, (Context)context);
            this.locoService.deleteLoco(this.connectionId.get(), node, locoAddress.intValue());
        } else {
            LOGGER.warn("No command station node available.");
        }
    }

    @Override
    public void editLoco(LocoListModel locoModel) {
        LocoEditDialog locoEditDialog = new LocoEditDialog(JOptionPane.getFrameForComponent(this.parent), "LocoEdit", locoModel);
        locoEditDialog.showDialog(llm -> {
            LOGGER.info("Save is called for locoModel: {}", llm);
            this.locoTableView.getComponent().repaint();
        });
    }

    @Override
    public void addLoco() {
    }
}

