/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.locolist.view;

import com.jgoodies.binding.adapter.AbstractTableAdapter;
import com.jgoodies.binding.list.SelectionInList;
import org.bidib.jbidibc.messages.enums.DirectionEnum;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.model.locolist.LocoListModel;
import org.bidib.wizard.model.status.SpeedSteps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoTableTableModel
extends AbstractTableAdapter<LocoListModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocoTableTableModel.class);
    private static final long serialVersionUID = 1L;
    public static final int COLUMN_ADDRESS = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_SPEED = 2;
    public static final int COLUMN_DIRECTION = 3;
    public static final int COLUMN_SPEEDSTEPS = 4;
    public static final int COLUMN_FUNCTIONS_LIGHT = 5;
    public static final int COLUMN_FUNCTIONS_1_TO_4 = 6;
    public static final int COLUMN_FUNCTIONS_5_TO_12 = 7;
    public static final int COLUMN_FUNCTIONS_13_TO_20 = 8;
    public static final int COLUMN_FUNCTIONS_21_TO_28 = 9;
    public static final int COLUMN_PORT_INSTANCE = 10;
    private static final String[] COLUMNNAMES = new String[]{Resources.getString(LocoTableTableModel.class, (String)"address"), Resources.getString(LocoTableTableModel.class, (String)"name"), Resources.getString(LocoTableTableModel.class, (String)"speed"), Resources.getString(LocoTableTableModel.class, (String)"direction"), Resources.getString(LocoTableTableModel.class, (String)"speedSteps"), Resources.getString(LocoTableTableModel.class, (String)"functionsLight"), Resources.getString(LocoTableTableModel.class, (String)"functions1To4"), Resources.getString(LocoTableTableModel.class, (String)"functions5To12"), Resources.getString(LocoTableTableModel.class, (String)"functions13To20"), Resources.getString(LocoTableTableModel.class, (String)"functions21To28")};

    public LocoTableTableModel(SelectionInList<LocoListModel> boosterList) {
        super(boosterList, COLUMNNAMES);
        LOGGER.info("Current listModel: {}", (Object)this.getListModel());
    }

    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return Boolean.class;
            }
            case 4: {
                return SpeedSteps.class;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return Integer.class;
            }
        }
        return Object.class;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        LocoListModel loco = (LocoListModel)this.getRow(rowIndex);
        switch (columnIndex) {
            case 0: {
                return loco.getAddress();
            }
            case 1: {
                return loco.getLocoName();
            }
            case 2: {
                return loco.getSpeed() * (loco.getDirection() == DirectionEnum.FORWARD ? 1 : -1);
            }
            case 3: {
                return loco.getDirection() == DirectionEnum.FORWARD ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return loco.getSpeedSteps();
            }
            case 5: {
                return loco.getFunctions(0) & 0x10;
            }
            case 6: {
                return loco.getFunctions(0) & 0xF;
            }
            case 7: {
                return loco.getFunctions(1) & 0xFF;
            }
            case 8: {
                return loco.getFunctions(2) & 0xFF;
            }
            case 9: {
                return loco.getFunctions(3) & 0xFF;
            }
        }
        return null;
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        LocoListModel loco = (LocoListModel)this.getRow(rowIndex);
        switch (columnIndex) {
            case 1: {
                String locoName = value != null ? value.toString() : "";
                loco.setLocoName(locoName);
                break;
            }
        }
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }
}

