/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.locolist.view.wizard;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jidesoft.dialog.PageEvent;
import com.jidesoft.dialog.PageListener;
import com.jidesoft.wizard.WelcomeWizardPage;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.LocoLibraryFactory;
import org.bidib.jbidibc.core.schema.locolibrary.v1_0.LocoLibrary;
import org.bidib.jbidibc.core.schema.locolibrary.v1_0.LocoLibraryEntryType;
import org.bidib.jbidibc.messages.DccAddressType;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.core.dialog.FileDialog;
import org.bidib.wizard.model.locolist.LocoListModel;
import org.bidib.wizard.model.status.SpeedSteps;
import org.bidib.wizard.mvc.locolist.model.LocoLibraryModel;
import org.bidib.wizard.mvc.locolist.model.LocoTableModel;
import org.oxbow.swingbits.dialog.task.TaskDialog;
import org.oxbow.swingbits.dialog.task.TaskDialogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectLocoPage
extends WelcomeWizardPage {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectLocoPage.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 10dlu, pref:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "pref";
    private final LocoTableModel locoTableModel;
    private final LocoLibraryModel locoLibrary;
    private JComboBox<LocoListModel>[] locoCombos;
    private static final String SUFFIX_XML = "xml";

    public SelectLocoPage(LocoTableModel locoTableModel, LocoLibraryModel locoLibrary) {
        super(Resources.getString(SelectLocoPage.class, (String)"title"), Resources.getString(SelectLocoPage.class, (String)"description"));
        this.locoTableModel = locoTableModel;
        this.locoLibrary = locoLibrary;
    }

    protected void initContentPane() {
        super.initContentPane();
        FormBuilder builder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel(new JPanel());
        ArrayList<LocoListModel> locos = new ArrayList<LocoListModel>();
        locos.add(null);
        locos.addAll(this.locoTableModel.getLocos());
        this.locoCombos = new JComboBox[8];
        int row = 3;
        for (int index = 0; index < 8; ++index) {
            JComboBox<LocoListModel> comboLoco = new JComboBox<LocoListModel>(locos.toArray(new LocoListModel[0]));
            comboLoco.setRenderer(new LocoListRenderer());
            this.locoCombos[index] = comboLoco;
            builder.appendRows("3dlu, pref", new Object[0]);
            builder.add(Integer.toString(index), new Object[0]).xy(1, row);
            builder.add(comboLoco).xy(3, row);
            row += 2;
        }
        JButton loadButton = new JButton(Resources.getString(((Object)((Object)this)).getClass(), (String)"load"));
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectLocoPage.this.fireLoad();
            }
        });
        JButton saveButton = new JButton(Resources.getString(((Object)((Object)this)).getClass(), (String)"save"));
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectLocoPage.this.fireSave();
            }
        });
        JPanel buttons = new ButtonBarBuilder().addGlue().addButton(new JComponent[]{loadButton, saveButton}).build();
        builder.appendRows("9dlu, pref", new Object[0]);
        builder.add((Component)buttons).xyw(1, row, 3);
        this.addComponent(builder.build(), true);
        this.addPageListener(new PageListener(){

            public void pageEventFired(PageEvent e) {
                switch (e.getID()) {
                    case 3200: {
                        JButton button;
                        if (!(e.getSource() instanceof JButton) || !"NEXT".equals((button = (JButton)e.getSource()).getName())) break;
                        LOGGER.info("The next button was pressed, start publishing the loco list to the mouse.");
                        SelectLocoPage.this.locoLibrary.setPushToMouse(false);
                        SelectLocoPage.this.locoLibrary.getLocoList().clear();
                        for (JComboBox<LocoListModel> combo : SelectLocoPage.this.locoCombos) {
                            Object selectedItem = combo.getSelectedItem();
                            if (selectedItem instanceof LocoListModel) {
                                LocoListModel locoModel = (LocoListModel)selectedItem;
                                SelectLocoPage.this.locoLibrary.getLocoList().add(locoModel);
                                continue;
                            }
                            SelectLocoPage.this.locoLibrary.getLocoList().add(null);
                        }
                        LOGGER.info("Filled loco library and trigger push.");
                        SelectLocoPage.this.locoLibrary.setPushToMouse(true);
                        break;
                    }
                }
            }
        });
    }

    protected void fireSave() {
        LocoLibrary locoLibrary = new LocoLibrary();
        int index = 0;
        for (JComboBox<LocoListModel> combo : this.locoCombos) {
            Object selectedItem = combo.getSelectedItem();
            if (selectedItem instanceof LocoListModel) {
                LocoListModel locoModel = (LocoListModel)selectedItem;
                LocoLibraryEntryType locoListEntry = new LocoLibraryEntryType();
                locoListEntry.setIndex(index);
                locoListEntry.setAddress(locoModel.getAddress());
                locoListEntry.setName(locoModel.getLocoName());
                locoListEntry.setSpeedSteps(SpeedSteps.valueOf((SpeedSteps)locoModel.getSpeedSteps()));
                locoLibrary.getLocoList().add(locoListEntry);
            }
            ++index;
        }
        final File[] libraryFile = new File[1];
        XmlFileFilter ff = new XmlFileFilter();
        String defaultFilename = "locoLibrary-1.0.xml";
        String workingDirectory = null;
        FileDialog dialog = new FileDialog((Component)((Object)this), 1, workingDirectory, defaultFilename, new FileFilter[]{ff}){

            public void approve(String selectedFile) {
                selectedFile = this.makeSureFileNameHasExtension(selectedFile, SelectLocoPage.SUFFIX_XML);
                File file = new File(selectedFile);
                LOGGER.info("User selected file to save the loco library: {}", (Object)file);
                libraryFile[0] = file;
            }
        };
        dialog.showDialog();
        if (libraryFile[0] != null) {
            try {
                LocoLibraryFactory.saveLocoLibrary((LocoLibrary)locoLibrary, (File)libraryFile[0]);
            }
            catch (Exception ex) {
                LOGGER.warn("Save loco library failed.", (Throwable)ex);
                TaskDialogs.build((Window)JOptionPane.getFrameForComponent((Component)((Object)this)), (String)Resources.getString(SelectLocoPage.class, (String)"save-failed.instruction"), (String)ex.getMessage()).title(Resources.getString(SelectLocoPage.class, (String)"save-failed.title")).icon((Icon)TaskDialog.StandardIcon.WARNING).inform();
            }
        }
    }

    protected void fireLoad() {
        final File[] libraryFile = new File[1];
        XmlFileFilter ff = new XmlFileFilter();
        String workingDirectory = null;
        FileDialog dialog = new FileDialog((Component)((Object)this), 0, workingDirectory, null, new FileFilter[]{ff}){

            public void approve(String selectedFile) {
                File file = new File(selectedFile);
                LOGGER.info("User selected file to open the loco library: {}", (Object)file);
                libraryFile[0] = file;
            }
        };
        dialog.showDialog();
        if (libraryFile[0] != null) {
            try {
                for (JComboBox<LocoListModel> combo : this.locoCombos) {
                    combo.setSelectedItem(null);
                }
                LocoLibrary locoLibrary = LocoLibraryFactory.getLocoLibrary((File)libraryFile[0]);
                if (locoLibrary != null && CollectionUtils.isNotEmpty((Collection)locoLibrary.getLocoList())) {
                    LOGGER.info("Load the loco items.");
                    for (LocoLibraryEntryType locoListEntry : locoLibrary.getLocoList().stream().sorted((f1, f2) -> Integer.compare(f1.getIndex(), f2.getIndex())).collect(Collectors.toList())) {
                        int index = locoListEntry.getIndex();
                        if (index <= -1 || index >= this.locoCombos.length) continue;
                        JComboBox<LocoListModel> combo = this.locoCombos[index];
                        int locoAddress = locoListEntry.getAddress();
                        boolean longAddress = locoAddress > DccAddressType.RCN211_MAX_SHORT_ADDRESS;
                        LocoListModel locoModel = new LocoListModel(locoAddress, longAddress, UUID.randomUUID().toString());
                        locoModel.setLocoName(locoListEntry.getName());
                        locoModel.setSpeedSteps(SpeedSteps.valueOf((int)locoListEntry.getSpeedSteps()));
                        combo.setSelectedItem(locoModel);
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Load loco library failed.", (Throwable)ex);
                TaskDialogs.build((Window)JOptionPane.getFrameForComponent((Component)((Object)this)), (String)Resources.getString(SelectLocoPage.class, (String)"load-failed.instruction"), (String)ex.getMessage()).title(Resources.getString(SelectLocoPage.class, (String)"load-failed.title")).icon((Icon)TaskDialog.StandardIcon.WARNING).inform();
            }
        }
    }

    private static final class LocoListRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private LocoListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof LocoListModel) {
                LocoListModel locoModel = (LocoListModel)value;
                this.setText(Integer.toString(locoModel.getAddress()) + " : " + (StringUtils.isNotBlank((CharSequence)locoModel.getLocoName()) ? locoModel.getLocoName() : Integer.toString(locoModel.getAddress())));
            } else {
                this.setText(" ");
            }
            return comp;
        }
    }

    private final class XmlFileFilter
    extends FileFilter {
        private XmlFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            boolean result = false;
            if (file != null) {
                String extension;
                if (file.isDirectory()) {
                    result = true;
                } else if (file.toString() != null && SelectLocoPage.SUFFIX_XML.equalsIgnoreCase(extension = FilenameUtils.getExtension((String)file.toString()))) {
                    result = true;
                }
            }
            return result;
        }

        @Override
        public String getDescription() {
            return Resources.getString(SelectLocoPage.class, (String)"filter") + " (*.xml)";
        }
    }
}

