/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.DccAddressType;
import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.CommandStationPom;
import org.bidib.jbidibc.messages.enums.DirectionEnum;
import org.bidib.jbidibc.messages.enums.PomAcknowledge;
import org.bidib.jbidibc.messages.enums.PomAddressTypeEnum;
import org.bidib.jbidibc.messages.enums.PomOperation;
import org.bidib.jbidibc.messages.enums.PomProgState;
import org.bidib.jbidibc.messages.event.AbstractBidibMessageEvent;
import org.bidib.jbidibc.messages.event.OccupancyCvMessageEvent;
import org.bidib.jbidibc.messages.event.OccupancyDynStateMessageEvent;
import org.bidib.jbidibc.messages.event.OccupancySpeedMessageEvent;
import org.bidib.jbidibc.messages.exception.NoAnswerException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.helpers.DefaultContext;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.wizard.api.model.CommandStationNodeInterface;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.DefaultNodeListListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.service.console.ConsoleColor;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.service.core.LocoService;
import org.bidib.wizard.api.service.node.CommandStationService;
import org.bidib.wizard.api.service.node.NodeService;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.core.model.connection.MessageAdapter;
import org.bidib.wizard.core.model.connection.MessageEventConsumer;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.model.loco.LocoModel;
import org.bidib.wizard.model.loco.listener.LocoModelListener;
import org.bidib.wizard.model.locolist.LocoListModel;
import org.bidib.wizard.model.status.CommandStationStatus;
import org.bidib.wizard.model.status.DirectionStatus;
import org.bidib.wizard.model.status.RfBasisMode;
import org.bidib.wizard.model.status.SpeedLevel;
import org.bidib.wizard.model.status.SpeedSteps;
import org.bidib.wizard.mvc.console.controller.ConsoleController;
import org.bidib.wizard.mvc.loco.controller.LocoControlListener;
import org.bidib.wizard.mvc.loco.model.LocoConfigModel;
import org.bidib.wizard.mvc.loco.model.SpeedometerModel;
import org.bidib.wizard.mvc.loco.model.SpeedometerProgBeanModel;
import org.bidib.wizard.mvc.loco.model.command.PomRequestProcessor;
import org.bidib.wizard.mvc.loco.model.command.SpeedometerPomCommand;
import org.bidib.wizard.mvc.loco.view.PomProgrammerRequestListener;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.LocoPanelView;
import org.bidib.wizard.mvc.pom.model.PomProgrammerModel;
import org.bidib.wizard.mvc.pom.model.ProgCommandAwareBeanModel;
import org.bidib.wizard.mvc.pom.model.command.PomOperationCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LocoPanelController {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocoPanelController.class);
    private final MainModel mainModel;
    private final LocoConfigModel locoConfigModel = new LocoConfigModel();
    private final SpeedometerModel speedometerModel = new SpeedometerModel();
    private LocoModelListener locoModelListener;
    private LocoPanelView locoPanelView;
    @Autowired
    private ConnectionService connectionService;
    @Autowired
    private CommandStationService commandStationService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private ConsoleService consoleService;
    @Autowired
    private LocoService locoService;
    private MessageAdapter messageAdapter;
    private final ScheduledExecutorService pomRequestProcessorWorker;
    private final LocoModel locoModel;
    private final Supplier<String> connectionId;

    public LocoPanelController(MainModel mainModel, Supplier<String> connectionId) {
        this.mainModel = mainModel;
        this.connectionId = connectionId;
        this.locoModel = new LocoModel(null);
        this.pomRequestProcessorWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("pomRequestProcessorWorkers-thread-%d").build());
    }

    public LocoPanelView createPanel() {
        NodeInterface node = this.mainModel.getSelectedNode();
        LOGGER.info("Create the LocoView panel, selected node: {}", (Object)node);
        if (node != null) {
            if (ProductUtils.isRFBasisNode((long)node.getUniqueId()) || ProductUtils.isSpeedometer((long)node.getUniqueId())) {
                LOGGER.info("The default speed steps for the decoders on the RF Basis Node or Speedometer is 128.");
                this.locoConfigModel.setSpeedSteps(SpeedSteps.DCC128);
                this.locoConfigModel.setCarControlEnabled(true);
            } else {
                this.locoConfigModel.setSpeedSteps(SpeedSteps.DCC128);
                this.locoConfigModel.setCarControlEnabled(false);
            }
        } else {
            LOGGER.info("No node selected while create the LocoView panel. Do not initialize the speed steps.");
        }
        this.messageAdapter = new MessageAdapter(this.connectionService, this.connectionId, "locoPanel"){

            protected void prepareMessageMap(Map<Class<? extends AbstractBidibMessageEvent>, MessageEventConsumer<AbstractBidibMessageEvent, NodeInterface>> messageActionMap) {
                LOGGER.info("Prepare the message map.");
                messageActionMap.put(OccupancyCvMessageEvent.class, (MessageEventConsumer<AbstractBidibMessageEvent, NodeInterface>)((MessageEventConsumer)(evt, node) -> {
                    OccupancyCvMessageEvent event = (OccupancyCvMessageEvent)evt;
                    byte[] address = event.getAddress();
                    PomAddressData decoderAddress = event.getAddressData();
                    int cvNumber = event.getCvNumber();
                    int cvData = event.getCvValue();
                    LOGGER.debug("CV was received, node addr: {}, decoder address: {}, cvNumber: {}, cvData: {}", new Object[]{address, decoderAddress, cvNumber, cvData});
                    LocoPanelController.this.updatePomProgState(PomProgState.POM_PROG_OKAY, decoderAddress, cvNumber, cvData);
                }));
                messageActionMap.put(OccupancyDynStateMessageEvent.class, (MessageEventConsumer<AbstractBidibMessageEvent, NodeInterface>)((MessageEventConsumer)(evt, node) -> {
                    OccupancyDynStateMessageEvent event = (OccupancyDynStateMessageEvent)evt;
                    AddressData decoderAddress = event.getDecoderAddress();
                    int dynNumber = event.getDynNumber();
                    int dynValue = event.getDynValue();
                    LOGGER.debug("dynState, decoderAddress: {}, dynNumber: {}, dynValue: {}", new Object[]{decoderAddress, dynNumber, dynValue});
                    SwingUtilities.invokeLater(() -> {
                        if (LocoPanelController.this.locoModel.getAddress() != null && decoderAddress.getAddress() == LocoPanelController.this.locoModel.getAddress().intValue() && dynNumber == 3) {
                            LOGGER.info("The dynState is forwarded to loco model.");
                            LocoPanelController.this.locoModel.setDynStateEnergy(dynValue);
                            if (LocoPanelController.this.speedometerModel.isActive()) {
                                LOGGER.info("Update the DYN_STATE in speedometer model.");
                                LocoPanelController.this.speedometerModel.setDynStateEnergy(dynValue);
                            } else {
                                LOGGER.info("Speedometer model is not in state active.");
                            }
                        } else {
                            LOGGER.debug("The dynState ist not forwarded to model");
                        }
                    });
                }));
                messageActionMap.put(OccupancySpeedMessageEvent.class, (MessageEventConsumer<AbstractBidibMessageEvent, NodeInterface>)((MessageEventConsumer)(evt, node) -> {
                    OccupancySpeedMessageEvent event = (OccupancySpeedMessageEvent)evt;
                    AddressData addressData = event.getAddressData();
                    int speed = event.getSpeed();
                    LOGGER.debug("Update the reported speed: {}", (Object)speed);
                    SwingUtilities.invokeLater(() -> {
                        if (LocoPanelController.this.locoModel.getAddress() != null && addressData.getAddress() == LocoPanelController.this.locoModel.getAddress().intValue()) {
                            if (LocoPanelController.this.speedometerModel.isActive()) {
                                LOGGER.info("Update the reported speed in speedometer model: {}", (Object)speed);
                                LocoPanelController.this.speedometerModel.setReportedSpeed(speed);
                                Integer scale = LocoPanelController.this.speedometerModel.getCv37Scale();
                                if (scale == null) {
                                    scale = 1;
                                }
                                double factor = (double)(scale * 3600) / 1000000.0;
                                LOGGER.debug("Current scale: {}, factor: {}", (Object)scale, (Object)factor);
                                ConsoleController.ensureConsoleVisible();
                                if (scale > 1) {
                                    LocoPanelController.this.consoleService.addConsoleLine(ConsoleColor.blue, "Current reported speed: " + speed + " mm/s -> " + (int)((double)speed * factor) + " km/h");
                                } else {
                                    LocoPanelController.this.consoleService.addConsoleLine(ConsoleColor.blue, "Current reported speed: " + speed + " mm/s");
                                }
                            } else {
                                LOGGER.debug("Speedometer model is not in state active.");
                                LocoPanelController.this.locoModel.setReportedSpeed(Integer.valueOf(speed));
                            }
                        } else {
                            LOGGER.debug("Reported speed: {}, address does not match.", (Object)speed);
                        }
                    });
                }));
            }

            protected void onDisconnect() {
                super.onDisconnect();
            }
        };
        LOGGER.info("Set the node in the messageAdapter: {}", (Object)node);
        this.messageAdapter.setNode(node);
        SwingUtilities.invokeLater(() -> this.messageAdapter.start());
        PomProgrammerRequestListener pomProgrammerRequestListener = new PomProgrammerRequestListener(){

            @Override
            public void sendRequest(PomAddressData decoderAddress, PomOperation operation, int cvNumber, int cvValue) {
                LOGGER.info("Send the POM request.");
                CommandStationPom opCode = CommandStationPom.valueOf((byte)ByteUtils.getLowByte((int)operation.getType()));
                NodeInterface selectedNode = LocoPanelController.this.mainModel.getSelectedNode();
                if (selectedNode != null && selectedNode.getCommandStationNode() != null) {
                    CommandStationNodeInterface commandStationNode = selectedNode.getCommandStationNode();
                    PomAcknowledge pomAck = LocoPanelController.this.commandStationService.sendCvPomRequest(LocoPanelController.this.connectionId.get(), commandStationNode, decoderAddress, opCode, cvNumber, cvValue);
                    LOGGER.debug("Received pomAck: {}", (Object)pomAck);
                } else {
                    LOGGER.warn("No command station node selected.");
                }
            }
        };
        LocoControlListener locoControlListener = new LocoControlListener(){

            @Override
            public void setSpeed(SpeedLevel speedLevel) {
                LocoPanelController.this.setSpeed(speedLevel);
            }

            @Override
            public void setFunction(int index, boolean value) {
            }

            @Override
            public void setBinaryState(int state, boolean value) {
            }

            @Override
            public void setSpeedSteps(SpeedSteps speedSteps) {
                LocoPanelController.this.setSpeedSteps(speedSteps);
            }

            @Override
            public void clearLoco() {
            }
        };
        this.locoPanelView = new LocoPanelView(this.locoModel, this.speedometerModel, pomProgrammerRequestListener, this.settingsService, locoControlListener, newLocoAddress -> this.changeLocoAddress((Integer)newLocoAddress));
        this.locoModelListener = new LocoModelListener(){

            public void functionChanged(int index, boolean value) {
                NodeInterface selectedNode = LocoPanelController.this.mainModel.getSelectedNode();
                if (selectedNode != null && selectedNode.getCommandStationNode() != null) {
                    if (LocoPanelController.this.locoModel == null) {
                        LOGGER.warn("No locoModel and therefore address available.");
                        return;
                    }
                    int functionGroupIndex = 0;
                    if (index < 5) {
                        functionGroupIndex = 0;
                    } else if (index < 9) {
                        functionGroupIndex = 1;
                    } else if (index < 13) {
                        functionGroupIndex = 2;
                    } else if (index < 21) {
                        functionGroupIndex = 3;
                    } else if (index < 29) {
                        functionGroupIndex = 4;
                    } else {
                        LOGGER.warn("Function > 28 uses binary state operation.");
                        this.binaryStateChanged(index, value);
                        return;
                    }
                    BitSet activeFunctions = new BitSet(functionGroupIndex + 1);
                    LOGGER.debug("functions have changed, functionGroupIndex: {}", (Object)functionGroupIndex);
                    activeFunctions.set(functionGroupIndex, true);
                    CommandStationNodeInterface commandStationNode = selectedNode.getCommandStationNode();
                    DefaultContext context = new DefaultContext();
                    LocoPanelController.this.registerActiveRfBasis((Context)context);
                    SpeedLevel speedLevel = new SpeedLevel(null, LocoPanelController.this.locoModel.getSpeedSteps(), DirectionStatus.valueOf((DirectionEnum)LocoPanelController.this.locoModel.getDirection()));
                    LocoPanelController.this.locoService.setSpeed(LocoPanelController.this.connectionId.get(), commandStationNode, LocoPanelController.this.locoModel.getAddress().intValue(), speedLevel, activeFunctions, LocoPanelController.this.locoModel.getFunctions(), (Context)context);
                } else {
                    LOGGER.warn("No command station node selected.");
                }
            }

            public void binaryStateChanged(int stateNumber, boolean value) {
                LOGGER.info("Send the binary state, address: {}, stateNumber: {}, value: {}", new Object[]{LocoPanelController.this.locoModel.getAddress(), stateNumber, value});
                if (LocoPanelController.this.locoModel.getAddress() == null) {
                    LOGGER.warn("No address available.");
                    return;
                }
                NodeInterface selectedNode = LocoPanelController.this.mainModel.getSelectedNode();
                if (selectedNode != null && selectedNode.getCommandStationNode() != null) {
                    CommandStationNodeInterface commandStationNode = selectedNode.getCommandStationNode();
                    DefaultContext context = new DefaultContext();
                    if (stateNumber < 512 && stateNumber > 517) {
                        LocoPanelController.this.registerActiveRfBasis((Context)context);
                    }
                    LocoPanelController.this.locoModel.incCounterCsBinState();
                    LocoPanelController.this.commandStationService.setBinaryState(LocoPanelController.this.connectionId.get(), commandStationNode, LocoPanelController.this.locoModel.getAddress().intValue(), stateNumber, value, (Context)context);
                } else {
                    LOGGER.warn("No node selected.");
                }
            }
        };
        this.locoModel.addLocoModelListener(this.locoModelListener);
        this.speedometerModel.addPropertyChangeListener("speedMeasurementStage", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SpeedometerModel.SpeedMeasurementStage stage = LocoPanelController.this.speedometerModel.getSpeedMeasurementStage();
                LOGGER.info("The speedmeasurement stage has changed: {}, active: {}", (Object)stage, (Object)LocoPanelController.this.speedometerModel.isActive());
                NodeInterface selectedNode = LocoPanelController.this.mainModel.getSelectedNode();
                if (selectedNode != null && selectedNode.getCommandStationNode() != null) {
                    CommandStationNodeInterface commandStationNode = selectedNode.getCommandStationNode();
                    switch (stage) {
                        case WAIT_FOR_CAR_SPEED_AND_BATTERY_RESPONSE: {
                            LOGGER.info("Activate lights and send speed 0 to decoder with address: {}", (Object)LocoPanelController.this.locoModel.getAddress());
                            LocoPanelController.this.speedometerModel.setSpeed(null);
                            LocoPanelController.this.speedometerModel.setDynStateEnergy(null);
                            LocoPanelController.this.changeLightsAndSpeed(commandStationNode, true);
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException ex) {
                                LOGGER.warn("Wait between to lights failed.", (Throwable)ex);
                            }
                            LocoPanelController.this.changeLightsAndSpeed(commandStationNode, false);
                            LocoPanelController.this.triggerSpeedRequest(10);
                            break;
                        }
                        case READ_CURRENT_CV_VALUES: {
                            LOGGER.info("Current stage is READ_CURRENT_CV_VALUES.");
                            LocoPanelController.this.fireReadCvValues();
                            break;
                        }
                        case WRITE_CV_VALUES: {
                            LOGGER.info("Current stage is WRITE_CV_VALUES.");
                            LocoPanelController.this.fireWriteCvValues();
                            break;
                        }
                        case SET_MOTOR_PID_SOFT: {
                            LOGGER.info("Current stage is SET_MOTOR_PID_SOFT.");
                            LocoPanelController.this.triggerSetMotorPID(selectedNode);
                            break;
                        }
                        case START_MEASUREMENT: {
                            LOGGER.info("Current stage is START_MEASUREMENT.");
                            LocoPanelController.this.triggerMeasurement(selectedNode, LocoPanelController.this.speedometerModel.getCv37Scale(), true, true);
                            break;
                        }
                        case SET_SPEED_MAX: {
                            LOGGER.info("Current stage is SET_SPEED_MAX.");
                            LocoPanelController.this.triggerSpeedRequest(126);
                            break;
                        }
                        case ABORTED: {
                            LOGGER.info("Current stage is ABORTED.");
                            LocoPanelController.this.triggerSpeedRequest(0);
                            LocoPanelController.this.waitBetweenCommands(10);
                            LocoPanelController.this.triggerMeasurement(selectedNode, null, false, false);
                            break;
                        }
                        case FINISHED: {
                            LOGGER.info("Current stage is FINISHED.");
                            LocoPanelController.this.triggerSpeedRequest(0);
                            LocoPanelController.this.waitBetweenCommands(10);
                            LocoPanelController.this.triggerMeasurement(selectedNode, null, false, false);
                            break;
                        }
                        case STOP_FOR_USER_INTERACTION: {
                            LOGGER.info("Current stage is STOP_FOR_USER_INTERACTION.");
                            LocoPanelController.this.triggerSpeedRequest(0);
                            LocoPanelController.this.waitBetweenCommands(10);
                            LocoPanelController.this.triggerMeasurement(selectedNode, null, false, false);
                            break;
                        }
                        case MEASURE_ON: {
                            LocoPanelController.this.triggerMeasurement(selectedNode, 1, true, false);
                            break;
                        }
                        case MEASURE_OFF: {
                            LocoPanelController.this.triggerMeasurement(selectedNode, 1, false, false);
                            break;
                        }
                        default: {
                            LOGGER.warn("unhandled stage: {}", (Object)stage);
                            break;
                        }
                    }
                } else {
                    LOGGER.warn("No node selected.");
                }
            }
        });
        this.mainModel.addNodeListListener((NodeListListener)new DefaultNodeListListener(){

            public void listChanged() {
            }

            public void nodeChanged(NodeInterface node) {
                NodeInterface selectedNode = LocoPanelController.this.mainModel.getSelectedNode();
                LOGGER.info("The selected node has changed, selectedNode: {}", (Object)selectedNode);
                LocoPanelController.this.speedometerModel.clearValues();
                LocoPanelController.this.locoPanelView.clearModelValues();
                if (selectedNode != null) {
                    if (ProductUtils.isRFBasisNode((long)selectedNode.getUniqueId()) || ProductUtils.isSpeedometer((long)selectedNode.getUniqueId())) {
                        LOGGER.info("The default speed steps for the decoders on the RF Basis Node or Speedometer is 128.");
                        LocoPanelController.this.locoModel.setSpeedSteps(SpeedSteps.DCC128);
                        LocoPanelController.this.locoConfigModel.setCarControlEnabled(true);
                    } else {
                        LocoPanelController.this.locoModel.setSpeedSteps(SpeedSteps.DCC128);
                        LocoPanelController.this.locoConfigModel.setCarControlEnabled(false);
                    }
                    LOGGER.info("Set the selected node in the messageAdapter: {}", (Object)selectedNode);
                    LocoPanelController.this.messageAdapter.setNode(selectedNode);
                    if (selectedNode.getCommandStationNode() != null) {
                        try {
                            CompositeDisposable disp = new CompositeDisposable();
                            Disposable dispCsState = selectedNode.getCommandStationNode().subscribeSubjectCommandStationState(csState -> {
                                LOGGER.debug("Current command station state: {}", csState);
                                if (ProductUtils.isSpeedometer((long)selectedNode.getUniqueId()) && CommandStationStatus.isOffState((CommandStationStatus)csState)) {
                                    LOGGER.info("Switch the command station of speedometer on.");
                                    LocoPanelController.this.commandStationService.setCommandStationState(LocoPanelController.this.connectionId.get(), selectedNode.getCommandStationNode(), CommandStationStatus.GO);
                                }
                                disp.dispose();
                            }, error -> {
                                LOGGER.warn("Get the current command station state failed.");
                                disp.dispose();
                            }, () -> LOGGER.warn("Get the current command station state subscription has completed, node: {}", (Object)node));
                            disp.add(dispCsState);
                            LocoPanelController.this.commandStationService.queryCommandStationState(LocoPanelController.this.connectionId.get(), selectedNode.getCommandStationNode());
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Get command station state failed.", (Throwable)ex);
                        }
                    } else {
                        LOGGER.debug("The current node is not a command station node.");
                    }
                } else {
                    LOGGER.debug("No node selected.");
                }
            }
        });
        return this.locoPanelView;
    }

    private void changeLocoAddress(Integer locoAddress) {
        LOGGER.info("Change the locoAddress: {}", (Object)locoAddress);
        if (locoAddress != null) {
            NodeInterface selectedNode = this.mainModel.getSelectedNode();
            if (selectedNode != null && selectedNode.getCommandStationNode() != null) {
                boolean longAddress = locoAddress > DccAddressType.RCN211_MAX_SHORT_ADDRESS;
                LocoListModel locoListModel = this.locoService.getOrCreateLoco(this.connectionId.get(), selectedNode.getCommandStationNode(), locoAddress.intValue(), longAddress);
                this.locoModel.setLocoListModel(locoListModel);
            } else {
                LOGGER.warn("Selected node is not a command station: {}", (Object)selectedNode);
                this.locoModel.setLocoListModel(null);
            }
        } else {
            this.locoModel.setLocoListModel(null);
        }
        this.locoModel.setReportedCellNumber(null);
    }

    private void setSpeed(SpeedLevel speedLevel) {
        block6: {
            LOGGER.info("Set loco speedLevel: {}", (Object)speedLevel);
            if (speedLevel != null) {
                try {
                    NodeInterface selectedNode = this.mainModel.getSelectedNode();
                    if (selectedNode != null && selectedNode.getCommandStationNode() != null && this.locoModel.getAddress() != null) {
                        LOGGER.debug("The speed in LocoModel has changed. Set the new speed value: {}", (Object)speedLevel);
                        CommandStationNodeInterface commandStationNode = selectedNode.getCommandStationNode();
                        DefaultContext context = new DefaultContext();
                        this.registerActiveRfBasis((Context)context);
                        this.locoService.setSpeed(this.connectionId.get(), commandStationNode, this.locoModel.getAddress().intValue(), speedLevel, null, null, (Context)context);
                        break block6;
                    }
                    LOGGER.debug("No node selected or address is not available.");
                }
                catch (NoAnswerException ex) {
                    LOGGER.warn("Set speed failed.", (Throwable)ex);
                }
                catch (Exception ex) {
                    LOGGER.warn("Set speed failed.", (Throwable)ex);
                }
            } else {
                LOGGER.info("No speed value delivered.");
            }
        }
    }

    private void setSpeedSteps(SpeedSteps speedSteps) {
        LOGGER.info("Set the speedSteps: {}, locoModel: {}", (Object)speedSteps, (Object)this.locoModel);
        this.locoModel.setSpeedSteps(speedSteps);
    }

    private void triggerSetMotorPID(NodeInterface selectedNode) {
        LOGGER.info("Set the motor PID values.");
    }

    private void triggerMeasurement(NodeInterface selectedNode, Integer scale, boolean activate, boolean sendMaxSpeed) {
        LOGGER.info("Trigger the measurement, scale: {}, activate: {}", (Object)scale, (Object)activate);
        ArrayList<ConfigurationVariable> cvList = new ArrayList<ConfigurationVariable>();
        cvList.add(new ConfigurationVariable("Scale", scale != null ? scale.toString() : "-1"));
        cvList.add(new ConfigurationVariable("SpeedMeasurement", activate ? "MS 1" : "MS 0"));
        LOGGER.info("Prepared cvList to send: {}", cvList);
        List configVars = this.nodeService.setConfigVariables(this.connectionId.get(), selectedNode, cvList);
        LOGGER.info("Returned configVars: {}", (Object)configVars);
        if (activate && sendMaxSpeed) {
            LOGGER.info("Activate sets the new stage to SET_SPEED_MAX.");
            SwingUtilities.invokeLater(() -> this.speedometerModel.setSpeedMeasurementStage(SpeedometerModel.SpeedMeasurementStage.SET_SPEED_MAX));
        }
    }

    private void triggerSpeedRequest(int speed) {
        LOGGER.info("Set the speed to: {}", (Object)speed);
        try {
            this.locoModel.setSpeed(Integer.valueOf(speed));
            this.locoPanelView.addLogMessage("Set the speed value to {}.", speed);
        }
        catch (NoAnswerException ex) {
            LOGGER.warn("Set speed failed.", (Throwable)ex);
        }
        catch (Exception ex) {
            LOGGER.warn("Set speed failed.", (Throwable)ex);
        }
    }

    private void updatePomProgState(PomProgState pomProgState, PomAddressData decoderAddress, int cvNumber, int cvValue) {
        if (this.speedometerModel != null) {
            PomProgrammerModel pomProgrammerModel = this.speedometerModel.getPomProgrammerModel();
            if (pomProgrammerModel != null) {
                pomProgrammerModel.updatePomProgResult(pomProgState, decoderAddress, cvNumber, cvValue);
            } else {
                LOGGER.warn("No pomProgrammerModel available in speedoMeterModel.");
            }
        }
    }

    private void changeLightsAndSpeed(CommandStationNodeInterface selectedNode, boolean lightsOn) {
        LOGGER.info("Change the lights value and set speed to 0, lightsOn: {}", (Object)lightsOn);
        if (this.locoModel.getAddress() == null) {
            LOGGER.warn("No address available.");
            return;
        }
        int functionGroupIndex = 0;
        BitSet activeFunctions = new BitSet(functionGroupIndex + 1);
        activeFunctions.set(functionGroupIndex, true);
        BitSet functions = new BitSet(29);
        functions.set(0, lightsOn ? 1 : 0);
        Integer speed = 0;
        DefaultContext context = new DefaultContext();
        this.registerActiveRfBasis((Context)context);
        SpeedLevel speedLevel = new SpeedLevel(speed, this.locoModel.getSpeedSteps(), DirectionStatus.FORWARD);
        this.locoService.setSpeed(this.connectionId.get(), selectedNode, this.locoModel.getAddress().intValue(), speedLevel, activeFunctions, functions, (Context)context);
    }

    private void waitBetweenCommands(int delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait between commands was interrupted.", (Throwable)ex);
        }
    }

    private void fireReadCvValues() {
        LOGGER.info("Read the values from the decoder.");
        ArrayList<SpeedometerPomCommand> pomProgCommands = new ArrayList<SpeedometerPomCommand>();
        Integer dccAddress = this.locoModel.getAddress();
        LOGGER.info("Prepared DCC address: {}", (Object)dccAddress);
        if (dccAddress == null) {
            LOGGER.warn("No dccAddress available.");
            return;
        }
        PomAddressData addressData = new PomAddressData(dccAddress.intValue(), PomAddressTypeEnum.LOCOMOTIVE);
        LOGGER.info("Prepared addressData for CV read: {}", (Object)addressData);
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 2, ByteUtils.getLowByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 5, ByteUtils.getLowByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 37, ByteUtils.getHighByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 111, ByteUtils.getHighByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 35, ByteUtils.getHighByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 36, ByteUtils.getHighByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 59, ByteUtils.getHighByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 111, ByteUtils.getHighByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 61, ByteUtils.getHighByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 62, ByteUtils.getHighByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 63, ByteUtils.getHighByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 7, ByteUtils.getHighByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 109, ByteUtils.getHighByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 110, ByteUtils.getHighByte((int)0)));
        SingleObserver<String> completeAction = this.speedometerModel.getCompleteAction();
        this.speedometerModel.setCompleteAction(null);
        PomRequestProcessor<SpeedometerProgBeanModel> pomRequestProcessor = this.speedometerModel.getPomRequestProcessor();
        this.pomRequestProcessorWorker.schedule(() -> pomRequestProcessor.submitProgCommands(pomProgCommands, completeAction), 0L, TimeUnit.MILLISECONDS);
    }

    private void fireWriteCvValues() {
        LOGGER.info("Write the values to the decoder.");
        List<PomOperationCommand<? extends ProgCommandAwareBeanModel>> pomProgCommands = this.speedometerModel.getPomProgCommands();
        this.speedometerModel.setPomProgCommands(null);
        SingleObserver<String> completeAction = this.speedometerModel.getCompleteAction();
        this.speedometerModel.setCompleteAction(null);
        LOGGER.info("Current pomProgCommands: {}", pomProgCommands);
        PomRequestProcessor<SpeedometerProgBeanModel> pomRequestProcessor = this.speedometerModel.getPomRequestProcessor();
        this.pomRequestProcessorWorker.schedule(() -> pomRequestProcessor.submitProgCommands(pomProgCommands, completeAction), 0L, TimeUnit.MILLISECONDS);
    }

    private void registerActiveRfBasis(Context context) {
        if (this.locoConfigModel.isCarControlEnabled() && this.locoModel.getActiveBase() != null) {
            RfBasisMode activeRfBase = this.locoModel.getActiveBase();
            if (activeRfBase.getBaseNumber() != null) {
                int activeBaseNumber = activeRfBase.getBaseNumber();
                NodeInterface rfBasisNode = this.mainModel.getNodeProvider().getNodes().stream().filter(bidibNode -> ProductUtils.isRFBasisNode((long)bidibNode.getUniqueId()) && bidibNode.getBaseNumber() == activeBaseNumber).findFirst().orElse(null);
                if (rfBasisNode != null) {
                    LOGGER.info("Found the active rfBasisNode: {}", (Object)rfBasisNode);
                    context.register("activeRfBasis", (Object)rfBasisNode.getNode());
                } else {
                    LOGGER.warn("No active rfBasisNode found for activeBaseNumber: {}", (Object)activeBaseNumber);
                }
            } else {
                LOGGER.info("No base number for active rf base available.");
            }
        }
    }
}

