/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bidib.jbidibc.messages.enums.LcMacroState;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.wizard.api.event.MacroChangedEvent;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.MacroSaveState;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.function.Function;
import org.bidib.wizard.api.model.function.PortAction;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.client.common.view.DefaultBusyFrame;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.common.labels.DefaultWizardLabelFactory;
import org.bidib.wizard.common.labels.LabelsChangedEvent;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.mvc.main.controller.listener.MacroPanelListener;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.MacroListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

public class MacroPanelController
implements MacroPanelListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MacroPanelController.class);
    private final MainModel mainModel;
    private final StatusBar statusBar;
    private MacroListPanel macroListPanel;
    @Autowired
    private SwitchingNodeService switchingNodeService;
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    @Autowired
    private DefaultWizardLabelFactory bidibLabelFactory;
    private final Supplier<String> connectionId;

    public MacroPanelController(MainModel mainModel, Supplier<String> connectionId, StatusBar statusBar) {
        this.mainModel = mainModel;
        this.connectionId = connectionId;
        this.statusBar = statusBar;
        AnnotationProcessor.process((Object)this);
    }

    public MacroListPanel createMacroListPanel(TabVisibilityListener tabVisibilityListener) {
        this.macroListPanel = new MacroListPanel(this, this.mainModel, tabVisibilityListener, this.settingsService, this.wizardLabelWrapper, this.bidibLabelFactory, this.statusBar);
        this.macroListPanel.setMacroPanelListener(this);
        this.macroListPanel.addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    DefaultTableModel macroList = (DefaultTableModel)e.getSource();
                    try {
                        DefaultBusyFrame.setWaitCursor((Component)MacroPanelController.this.macroListPanel.getComponent());
                        int selectedRow = e.getFirstIndex();
                        if (selectedRow > -1) {
                            Object value = macroList.getValueAt(selectedRow, 0);
                            LOGGER.info("The selected macro has changed: {}, selectedRow: {}", value, (Object)selectedRow);
                            if (!(value instanceof Macro)) {
                                LOGGER.info("Discard change of label.");
                                return;
                            }
                            Macro macro = (Macro)value;
                            if (macro != null) {
                                if (macro.getMacroSaveState() == MacroSaveState.NOT_LOADED_FROM_NODE) {
                                    LOGGER.info("Load the macro content from the node.");
                                    try {
                                        macro = MacroPanelController.this.switchingNodeService.getMacroContent(MacroPanelController.this.connectionId.get(), MacroPanelController.this.mainModel.getSelectedNode().getSwitchingNode(), macro);
                                        MacroPanelController.this.mainModel.setSelectedMacro(macro);
                                    }
                                    catch (InvalidConfigurationException ex) {
                                        LOGGER.warn("Restore macro content failed.", (Throwable)ex);
                                        macro.setContainsError(true);
                                        MacroPanelController.this.mainModel.setSelectedMacro(macro);
                                        MacroPanelController.this.mainModel.setNodeHasError(MacroPanelController.this.mainModel.getSelectedNode(), true);
                                    }
                                    catch (Exception ex) {
                                        LOGGER.warn("Get the content of the selected macro failed.", (Throwable)ex);
                                    }
                                } else {
                                    MacroPanelController.this.mainModel.setSelectedMacro(macro);
                                }
                            }
                        }
                    }
                    finally {
                        DefaultBusyFrame.setDefaultCursor((Component)MacroPanelController.this.macroListPanel.getComponent());
                    }
                }
            }
        });
        this.mainModel.addNodeSelectionListener(selectedNode -> {
            LOGGER.info("Selected node changed: {}", (Object)selectedNode);
            this.macroListPanel.selectedNodeChanged(selectedNode);
        });
        return this.macroListPanel;
    }

    public <E extends Port<?>> void movePortsInAllMacros(MainModel model, NodeInterface node, E port, List<E> allPorts, int portsCount, IntFunction<Integer> portNumCalculator) {
        this.movePortsInMacros(model, node, port, allPorts, portsCount, portNumCalculator);
    }

    public <E extends Port<?>> void movePortsInMacros(MainModel model, NodeInterface node, E port, List<E> allPorts, int portsCount, IntFunction<Integer> portNumCalculator) {
        LcOutputType outputType = Port.getPortType(port);
        for (Macro macro : node.getMacros()) {
            this.processMacro(model, node, macro, outputType, port, allPorts, portsCount, portNumCalculator);
        }
    }

    protected <E extends Port<?>> void processMacro(MainModel model, NodeInterface node, Macro macro, LcOutputType outputType, E port, List<E> allPorts, int portsCount, IntFunction<Integer> portNumCalculator) {
        ArrayList<MacroStepPortEntry> portsToMove = new ArrayList<MacroStepPortEntry>();
        for (Function step : macro.getFunctions()) {
            PortAction portAction;
            if (!(step instanceof PortAction) || !Port.getPortType((Port)(portAction = (PortAction)step).getPort()).equals((Object)outputType) || portAction.getPort().getId() < port.getId()) continue;
            LOGGER.info("Add port to move: {}", (Object)portAction.getPort());
            MacroStepPortEntry entry = new MacroStepPortEntry(portAction.getPort(), portAction);
            portsToMove.add(entry);
        }
        if (CollectionUtils.isNotEmpty(portsToMove)) {
            LOGGER.info("Found macro steps to manipulate: {}", portsToMove);
            for (MacroStepPortEntry entry : portsToMove) {
                Port<?> currentPort = entry.getPort();
                int portNum = currentPort.getId();
                int replacedPortNum = portNumCalculator.apply(portNum);
                LOGGER.info("Current 'old' port with portNum: {}, replacedPortNum: {}", (Object)portNum, (Object)replacedPortNum);
                Port replacedPort = PortListUtils.findPortByPortNumber(allPorts, (int)replacedPortNum);
                if (replacedPort != null) {
                    LOGGER.info("Set the replaced port: {}, portNum: {}", (Object)replacedPort, (Object)replacedPort.getId());
                    entry.getStep().setPort(replacedPort);
                    continue;
                }
                LOGGER.info("Replaced port is not available, replacedPortNum: {}", (Object)replacedPortNum);
            }
            this.switchingNodeService.saveMacro(this.connectionId.get(), node.getSwitchingNode(), macro);
        } else {
            LOGGER.info("No ports to move in macros found.");
        }
    }

    @Override
    public void storeMacroOnNode(Macro macro) {
        LOGGER.info("Store the macro on the node: {}", (Object)macro);
        Macro macroClone = Macro.cloneMacro((Macro)macro);
        this.switchingNodeService.saveMacro(this.connectionId.get(), this.mainModel.getSelectedNode().getSwitchingNode(), macroClone);
    }

    @Override
    public LcMacroState reloadMacro(Macro macro) {
        LcMacroState lcMacroState = this.switchingNodeService.reloadMacro(this.connectionId.get(), this.mainModel.getSelectedNode().getSwitchingNode(), macro);
        return lcMacroState;
    }

    @Override
    public LcMacroState saveMacro(Macro macro) {
        Macro macroClone = Macro.cloneMacro((Macro)macro);
        LcMacroState lcMacroState = this.switchingNodeService.saveMacro(this.connectionId.get(), this.mainModel.getSelectedNode().getSwitchingNode(), macroClone);
        return lcMacroState;
    }

    @Override
    public LcMacroState startMacro(Macro macro, boolean transferBeforeStart) {
        LcMacroState lcMacroState = this.switchingNodeService.startMacro(this.connectionId.get(), this.mainModel.getSelectedNode().getSwitchingNode(), macro, transferBeforeStart);
        return lcMacroState;
    }

    @Override
    public LcMacroState stopMacro(Macro macro) {
        LcMacroState lcMacroState = this.switchingNodeService.stopMacro(this.connectionId.get(), this.mainModel.getSelectedNode().getSwitchingNode(), macro);
        return lcMacroState;
    }

    @Override
    public void transferMacro(Macro macro) {
        Macro macroClone = Macro.cloneMacro((Macro)macro);
        this.switchingNodeService.transferMacro(this.connectionId.get(), this.mainModel.getSelectedNode().getSwitchingNode(), macroClone);
    }

    @EventListener(value={LabelsChangedEvent.class})
    public void labelsChangedEvent(LabelsChangedEvent labelsChangedEvent) {
        LOGGER.info("The labels have changed, node: {}", (Object)labelsChangedEvent);
        if (this.macroListPanel != null) {
            SwingUtilities.invokeLater(() -> this.macroListPanel.refreshView());
        }
    }

    @EventListener(value={MacroChangedEvent.class})
    public void macroChangedEvent(MacroChangedEvent macroChangedEvent) {
        LOGGER.info("The macros have changed, node: {}", (Object)macroChangedEvent);
        if (this.macroListPanel != null) {
            SwingUtilities.invokeLater(() -> this.macroListPanel.notifyMacrosChanged());
        }
    }

    private static final class MacroStepPortEntry {
        private PortAction<BidibStatus, Port<?>> step;
        private Port<?> port;

        public MacroStepPortEntry(Port<?> port, PortAction<BidibStatus, Port<?>> step) {
            this.port = port;
            this.step = step;
        }

        public Port<?> getPort() {
            return this.port;
        }

        public PortAction<BidibStatus, Port<?>> getStep() {
            return this.step;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

