/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.MapUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortConfigKeys;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.port.BytePortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.SwitchingNodeInterface;
import org.bidib.wizard.api.model.listener.DefaultNodeListListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.model.listener.SoundPortListener;
import org.bidib.wizard.api.script.Scripting;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.api.utils.PortUtils;
import org.bidib.wizard.common.labels.BidibLabelUtils;
import org.bidib.wizard.common.labels.LabelsChangedEvent;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.script.DefaultScriptContext;
import org.bidib.wizard.common.script.common.WaitCommand;
import org.bidib.wizard.common.script.engine.ScriptEngine;
import org.bidib.wizard.common.script.switching.PortScripting;
import org.bidib.wizard.common.script.switching.SoundPortCommand;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.PortTypeAware;
import org.bidib.wizard.model.ports.SoundPort;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.SoundPortStatus;
import org.bidib.wizard.mvc.main.controller.wrapper.NodePortWrapper;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.SoundPortTableModel;
import org.bidib.wizard.mvc.main.model.listener.SoundPortModelListener;
import org.bidib.wizard.mvc.main.view.exchange.NodeExchangeHelper;
import org.bidib.wizard.mvc.main.view.panel.SoundPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

public class SoundPortPanelController
implements PortScripting {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoundPortPanelController.class);
    private final MainModel mainModel;
    private SoundPortListPanel soundPortListPanel;
    private final Map<NodeInterface, NodePortWrapper> testToggleRegistry = new LinkedHashMap<NodeInterface, NodePortWrapper>();
    @Autowired
    private SwitchingNodeService switchingNodeService;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    @Autowired
    private ConsoleService consoleService;
    private final Subject<PortConfigChangeEvent> portConfigChangeEventSubject;
    private CompositeDisposable compDisp;
    private final Supplier<String> connectionId;

    public SoundPortPanelController(MainModel mainModel, Supplier<String> connectionId) {
        this.mainModel = mainModel;
        this.connectionId = connectionId;
        this.compDisp = new CompositeDisposable();
        this.portConfigChangeEventSubject = PublishSubject.create().toSerialized();
    }

    public SoundPortListPanel createPanel(TabVisibilityListener tabVisibilityListener) {
        final SoundPortTableModel tableModel = new SoundPortTableModel();
        tableModel.setPortListener(new SoundPortModelListener(){

            public void labelChanged(SoundPort port, String label) {
                port.setLabel(label);
                try {
                    NodeLabels nodeLabels = SoundPortPanelController.this.getNodeLabels();
                    BidibLabelUtils.replaceLabel((NodeLabels)nodeLabels, (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.soundPort, (int)port.getId(), (String)port.getLabel());
                    SoundPortPanelController.this.saveLabels();
                }
                catch (InvalidConfigurationException ex) {
                    LOGGER.warn("Save switch port labels failed.", (Throwable)ex);
                    String labelPath = ex.getReason();
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(null), Resources.getString(NodeExchangeHelper.class, (String)"labelfileerror.message", (Object[])new Object[]{labelPath}), Resources.getString(NodeExchangeHelper.class, (String)"labelfileerror.title"), 0);
                }
            }

            public void configChanged(SoundPort port, PortConfigKeys ... portConfigKeys) {
                LOGGER.info("The port value are changed for port: {}, portConfigKeys: {}", (Object)port, (Object)portConfigKeys);
                LinkedHashMap<Byte, BytePortConfigValue> values = new LinkedHashMap<Byte, BytePortConfigValue>();
                List soundPorts = SoundPortPanelController.this.mainModel.getSelectedNode().getSoundPorts();
                SoundPort soundPort = (SoundPort)PortListUtils.findPortByPortNumber((List)soundPorts, (int)port.getId());
                block5: for (PortConfigKeys key : portConfigKeys) {
                    if (!soundPort.isPortConfigKeySupported(key)) {
                        LOGGER.info("Unsupported port config key detected: {}", (Object)key);
                        continue;
                    }
                    switch (key) {
                        case BIDIB_PCFG_TICKS: {
                            int pulseTime = port.getPulseTime();
                            values.put((byte)11, new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)pulseTime))));
                            continue block5;
                        }
                        default: {
                            LOGGER.warn("Unsupported port config key detected: {}", (Object)key);
                        }
                    }
                }
                if (MapUtils.isNotEmpty(values)) {
                    try {
                        LOGGER.info("Set the port params: {}", values);
                        SoundPortPanelController.this.switchingNodeService.setPortConfig(SoundPortPanelController.this.connectionId.get(), SoundPortPanelController.this.mainModel.getSelectedNode().getSwitchingNode(), (Port)port, null, values);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Set the soundPort parameters failed.", (Throwable)ex);
                        SoundPortPanelController.this.mainModel.setNodeHasError(SoundPortPanelController.this.mainModel.getSelectedNode(), true);
                    }
                } else {
                    LOGGER.info("No config values to save available.");
                }
            }

            public void changePortType(LcOutputType portType, Port<? extends BidibStatus> port) {
                LOGGER.info("The port type will change to: {}, port: {}", (Object)portType, port);
                HashMap values = new HashMap();
                SoundPortPanelController.this.switchingNodeService.setPortConfig(SoundPortPanelController.this.connectionId.get(), SoundPortPanelController.this.mainModel.getSelectedNode().getSwitchingNode(), port, portType, values);
            }

            @Override
            public void testButtonPressed(SoundPort port, SoundPortStatus newStatus) {
                LOGGER.info("The test button was pressed for port: {}", (Object)port);
                NodeInterface node = SoundPortPanelController.this.mainModel.getSelectedNode();
                if (SoundPortStatus.TEST != port.getStatus()) {
                    SoundPortPanelController.this.stopTestToggleTask(node, (Port<?>)port);
                    SoundPort soundPort = port;
                    SoundPortPanelController.this.switchingNodeService.setPortStatus(SoundPortPanelController.this.connectionId.get(), node.getSwitchingNode(), (Port)soundPort);
                } else {
                    SoundPortPanelController.this.addTestToggleTask(node, (Port<?>)port);
                }
            }
        });
        final SoundPortListPanel soundPortListPanel = new SoundPortListPanel(this, tableModel, this.mainModel, tabVisibilityListener, this.portConfigChangeEventSubject);
        soundPortListPanel.setPortListener(new SoundPortListener(){

            public Class<?> getPortClass() {
                return SoundPort.class;
            }

            public void labelChanged(SoundPort port, String label) {
                LOGGER.info("The label has been changed by nodeScript, port: {}, label: {}", (Object)port, (Object)label);
                NodeLabels nodeLabels = SoundPortPanelController.this.getNodeLabels();
                BidibLabelUtils.replaceLabel((NodeLabels)nodeLabels, (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.soundPort, (int)port.getId(), (String)port.getLabel());
                SoundPortPanelController.this.saveLabels();
                soundPortListPanel.repaint();
            }

            public void statusChanged(NodeInterface node, SoundPort port) {
                LOGGER.debug("Status of sound port has changed, port: {}", (Object)port);
            }

            public void valuesChanged(SoundPort port, PortConfigKeys ... portConfigKeys) {
                LOGGER.info("The port value are changed for port: {}", (Object)port);
                LinkedHashMap values = new LinkedHashMap();
                for (PortConfigKeys key : portConfigKeys) {
                    switch (key) {
                        default: 
                    }
                    LOGGER.warn("Unsupported port config key detected: {}", (Object)key);
                }
                SoundPortPanelController.this.switchingNodeService.setPortConfig(SoundPortPanelController.this.connectionId.get(), SoundPortPanelController.this.mainModel.getSelectedNode().getSwitchingNode(), (Port)port, null, values);
            }

            public void testButtonPressed(NodeInterface node, SoundPort port, SoundPortStatus newStatus) {
                LOGGER.info("The test button was pressed for port: {}, newStatus: {}", (Object)port, (Object)newStatus);
                if (SoundPortStatus.TEST != port.getStatus()) {
                    SoundPortPanelController.this.stopTestToggleTask(node, (Port<?>)port);
                    SoundPort soundPort = new SoundPort();
                    soundPort.setId(port.getId());
                    soundPort.setStatus((BidibStatus)((SoundPortStatus)PortUtils.getOppositeStatus((BidibStatus)newStatus)));
                    SoundPortPanelController.this.switchingNodeService.setPortStatus(SoundPortPanelController.this.connectionId.get(), node.getSwitchingNode(), (Port)soundPort);
                } else {
                    SoundPortPanelController.this.addTestToggleTask(node, (Port<?>)port);
                }
            }

            public void configChanged(NodeInterface node, SoundPort port) {
                LOGGER.info("The configuration of the port has changed: {}", (Object)port);
                SwingUtilities.invokeLater(() -> tableModel.notifyPortConfigChanged(port));
            }

            public void changePortType(LcOutputType portType, SoundPort port) {
                LOGGER.info("The port type will change to: {}, port: {}", (Object)portType, (Object)port);
                LinkedHashMap values = new LinkedHashMap();
                SoundPortPanelController.this.switchingNodeService.setPortConfig(SoundPortPanelController.this.connectionId.get(), SoundPortPanelController.this.mainModel.getSelectedNode().getSwitchingNode(), (Port)port, portType, values);
            }
        });
        this.mainModel.addNodeListListener((NodeListListener)new DefaultNodeListListener(){

            public void nodeWillChange(NodeInterface node) {
                LOGGER.info("The selected node will change!");
                try {
                    LinkedList<NodeInterface> nodes = new LinkedList<NodeInterface>();
                    for (NodeInterface currentNode : SoundPortPanelController.this.testToggleRegistry.keySet()) {
                        nodes.add(currentNode);
                    }
                    LOGGER.info("Found nodes to stop the test toggle task: {}", nodes);
                    for (NodeInterface currentNode : nodes) {
                        SoundPortPanelController.this.stopTestToggleTask(currentNode, null);
                    }
                    LOGGER.info("Stop the test toggle task passed for nodes: {}", nodes);
                }
                catch (Exception ex) {
                    LOGGER.warn("Stop test toggle tasks failed.", (Throwable)ex);
                }
            }

            public void nodeChanged(NodeInterface node) {
                super.nodeChanged(node);
                LOGGER.info("The selected node has been changed: {}", (Object)node);
                SoundPortPanelController.this.compDisp.dispose();
                SoundPortPanelController.this.compDisp.clear();
                SoundPortPanelController.this.compDisp = new CompositeDisposable();
                if (node != null) {
                    SoundPortPanelController.this.addSoundPortModelListener(node);
                }
            }
        });
        this.soundPortListPanel = soundPortListPanel;
        NodeInterface selectedNode = this.mainModel.getSelectedNode();
        if (selectedNode != null) {
            this.addSoundPortModelListener(selectedNode);
        }
        return soundPortListPanel;
    }

    public void addTestToggleTask(NodeInterface node, Port<?> port) {
        LOGGER.info("Add test toggle task for node: {}, port: {}", (Object)node, port);
        NodePortWrapper nodePortWrapper = this.testToggleRegistry.remove(node);
        ScriptEngine scriptEngine = null;
        if (nodePortWrapper != null) {
            scriptEngine = nodePortWrapper.removePort(port);
        }
        if (scriptEngine != null) {
            LOGGER.info("Found a node scripting engine in the registry: {}", scriptEngine);
            try {
                scriptEngine.stopScript(Long.valueOf(2000L));
            }
            catch (Exception ex) {
                LOGGER.warn("Stop script failed.", (Throwable)ex);
            }
        }
        DefaultScriptContext context = new DefaultScriptContext();
        context.register("selectedNode", (Object)node);
        context.register("mainModel", (Object)this.mainModel);
        scriptEngine = new ScriptEngine((Scripting)this, (ApplicationContext)context);
        LinkedList<Object> scriptCommands = new LinkedList<Object>();
        SoundPortCommand spc = new SoundPortCommand(this.consoleService);
        spc.parse("sound " + port.getId() + " PLAY");
        scriptCommands.add(spc);
        WaitCommand wc = new WaitCommand(this.consoleService);
        wc.parse("wait 2000");
        scriptCommands.add(wc);
        spc = new SoundPortCommand(this.consoleService);
        spc.parse("sound " + port.getId() + " STOP");
        scriptCommands.add(spc);
        wc = new WaitCommand(this.consoleService);
        wc.parse("wait 2000");
        scriptCommands.add(wc);
        LOGGER.info("Prepared list of commands: {}", scriptCommands);
        scriptEngine.setScriptCommands(scriptCommands);
        scriptEngine.setScriptRepeating(true);
        if (nodePortWrapper == null) {
            LOGGER.info("Create new NodePortWrapper for node: {}", (Object)node);
            nodePortWrapper = new NodePortWrapper(node);
        }
        LOGGER.info("Put script engine in registry for node: {}", (Object)node);
        nodePortWrapper.addPort(port, (ScriptEngine<PortScripting>)scriptEngine);
        this.testToggleRegistry.put(node, nodePortWrapper);
        scriptEngine.startScript();
    }

    public void stopTestToggleTask(NodeInterface node, Port<?> port) {
        LOGGER.info("Stop test toggle task for node: {}, port: {}", (Object)node, port);
        NodePortWrapper nodePortWrapper = this.testToggleRegistry.get(node);
        if (nodePortWrapper != null) {
            HashSet toRemove = new HashSet();
            if (port != null) {
                toRemove.add(port);
            } else {
                toRemove.addAll(nodePortWrapper.getKeySet());
            }
            for (Port port2 : toRemove) {
                ScriptEngine<PortScripting> engine = nodePortWrapper.removePort(port2);
                if (engine != null) {
                    LOGGER.info("Found a node scripting engine in the registry: {}", engine);
                    try {
                        engine.stopScript(Long.valueOf(2000L));
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Stop script failed.", (Throwable)ex);
                    }
                    continue;
                }
                LOGGER.warn("No scripting engine found for node: {}", (Object)node);
            }
            if (nodePortWrapper.isEmpty()) {
                LOGGER.info("No more ports registered for node: {}", (Object)node);
                this.testToggleRegistry.remove(node);
            }
        }
    }

    public void sendPortStatusAction(SwitchingNodeInterface node, LcOutputType lcOutputType, int port, BidibStatus portStatus) {
        LOGGER.info("Sound action on the port: {}, portStatus: {}", (Object)port, (Object)portStatus);
        try {
            SwitchingNodeInterface selectedNode = node != null ? node : this.mainModel.getSelectedNode().getSwitchingNode();
            SoundPortStatus soundPortStatus = (SoundPortStatus)portStatus;
            SoundPort soundPortPort = new SoundPort();
            soundPortPort.setId(port);
            soundPortPort.setStatus((BidibStatus)soundPortStatus);
            this.switchingNodeService.setPortStatus(this.connectionId.get(), selectedNode, (Port)soundPortPort);
        }
        catch (Exception ex) {
            LOGGER.warn("Activate sound port failed.", (Throwable)ex);
        }
    }

    public void sendPortValueAction(SwitchingNodeInterface node, LcOutputType lcOutputType, int port, int portValue) {
    }

    private NodeLabels getNodeLabels() {
        WizardLabelFactory wizardLabelFactory = this.wizardLabelWrapper.getWizardLabelFactory();
        NodeLabels nodeLabels = wizardLabelFactory.loadLabels(Long.valueOf(this.mainModel.getSelectedNode().getUniqueId()), new String[0]);
        return nodeLabels;
    }

    private void saveLabels() {
        try {
            long uniqueId = this.mainModel.getSelectedNode().getUniqueId();
            this.wizardLabelWrapper.saveNodeLabels(Long.valueOf(uniqueId));
        }
        catch (Exception e) {
            LOGGER.warn("Save backlight labels failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @EventListener(value={LabelsChangedEvent.class})
    public void labelsChangedEvent(LabelsChangedEvent labelsChangedEvent) {
        LOGGER.info("The labels have changed, node: {}", (Object)labelsChangedEvent);
        if (this.soundPortListPanel != null) {
            SwingUtilities.invokeLater(() -> this.soundPortListPanel.refreshView());
        }
    }

    private void addSoundPortModelListener(NodeInterface selectedNode) {
        LOGGER.info("Add sound port model listener for node: {}", (Object)selectedNode);
        Disposable disp = this.portConfigChangeEventSubject.subscribe(evt -> {
            LOGGER.info("Received event: {}", evt);
            PortTypeAware port = evt.getPort();
            try {
                SoundPort soundPort = new SoundPort();
                soundPort.setId(port.getPortNumber().intValue());
                LOGGER.info("Prepared sound port: {}", (Object)soundPort);
                this.switchingNodeService.setPortConfig(this.connectionId.get(), selectedNode.getSwitchingNode(), (Port)soundPort, null, evt.getPortConfig());
            }
            catch (Exception ex) {
                LOGGER.warn("Set the soundport config failed.", (Throwable)ex);
                selectedNode.setNodeHasError(true);
                selectedNode.setReasonData("Set the soundport config failed.");
            }
        });
        this.compDisp.add(disp);
    }
}

