/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller.docking;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableResolver;
import org.bidib.wizard.config.NodeListPanelFactory;
import org.bidib.wizard.mvc.booster.controller.BoosterTableController;
import org.bidib.wizard.mvc.console.controller.ConsoleController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class DefaultDockableResolver
implements DockableResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDockableResolver.class);
    @Autowired
    private ApplicationContext context;

    public Dockable resolveDockable(String keyName) {
        LOGGER.info("Resolve dockable with keyName: {}", (Object)keyName);
        Dockable dockable = null;
        switch (keyName) {
            case "ConsoleView": {
                ConsoleController consoleController = (ConsoleController)this.context.getBean(ConsoleController.class);
                dockable = consoleController.createDockable();
                break;
            }
            case "BoosterTableView": {
                BoosterTableController boosterTableController = (BoosterTableController)this.context.getBean(BoosterTableController.class);
                dockable = boosterTableController.createDockable();
                break;
            }
            case "nodeListPanel": {
                NodeListPanelFactory nodeListPanelFactory = (NodeListPanelFactory)this.context.getBean(NodeListPanelFactory.class);
                dockable = nodeListPanelFactory.createDockable();
                break;
            }
            default: {
                LOGGER.info("Unresolved dockable with keyName: {}", (Object)keyName);
            }
        }
        LOGGER.info("The resolved dockable: {}", dockable);
        return dockable;
    }
}

