/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.model;

import com.jgoodies.binding.beans.Model;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.messages.FeedbackConfidenceData;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.FeedbackPortListener;
import org.bidib.wizard.api.model.listener.PortListListener;
import org.bidib.wizard.client.common.controller.FeedbackPortStatusChangeProvider;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.model.ports.Port;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedbackPortModel
extends Model
implements FeedbackPortStatusChangeProvider {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedbackPortModel.class);
    private NodeInterface selectedNode;
    private PropertyChangeListener pclFeedbackPorts;
    private PropertyChangeListener pclFeedbackPort;
    private final List<FeedbackPortListener> feedbackPortListeners = new LinkedList<FeedbackPortListener>();
    private final List<PortListListener> portListListeners = new LinkedList<PortListListener>();

    public FeedbackPortModel() {
        this.pclFeedbackPort = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LOGGER.debug("Property has changed, evt: {}", (Object)evt);
                if (evt instanceof IndexedPropertyChangeEvent) {
                    IndexedPropertyChangeEvent ipce = (IndexedPropertyChangeEvent)evt;
                    SwingUtilities.invokeLater(() -> {
                        int portId = ipce.getIndex();
                        NodeInterface node = (NodeInterface)ipce.getSource();
                        LOGGER.debug("The port status has changed: {}, emitting node: {}", (Object)portId, (Object)node);
                        if (node.equals((Object)FeedbackPortModel.this.selectedNode)) {
                            if (255 == portId) {
                                LOGGER.info("Received feedback port change for global detector.");
                            } else {
                                List feedbackPorts = FeedbackPortModel.this.selectedNode.getFeedbackPorts();
                                FeedbackPort port = (FeedbackPort)feedbackPorts.get(portId);
                                if (port != null) {
                                    for (FeedbackPortListener feedbackPortListener : FeedbackPortModel.this.feedbackPortListeners) {
                                        switch (ipce.getPropertyName()) {
                                            case "feedbackPortStatus": {
                                                feedbackPortListener.statusChanged(FeedbackPortModel.this.selectedNode, (Port)port);
                                                break;
                                            }
                                            case "feedbackPortAddresses": {
                                                List addresses = port.getAddresses();
                                                feedbackPortListener.addressesChanged(port, (Collection)addresses);
                                                break;
                                            }
                                            case "feedbackPortConfidence": {
                                                FeedbackConfidenceData confidence = port.getConfidence();
                                                feedbackPortListener.confidenceChanged(port, confidence);
                                                break;
                                            }
                                            case "feedbackPortDynStates": {
                                                Set dynStates = port.getDynStates();
                                                feedbackPortListener.dynStatesChanged(port, (Collection)dynStates);
                                                break;
                                            }
                                        }
                                    }
                                } else {
                                    LOGGER.warn("No feedback port found for portId: {}", (Object)portId);
                                }
                            }
                        }
                    });
                }
            }
        };
        this.pclFeedbackPorts = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LOGGER.info("Property has changed, evt: {}", (Object)evt);
                SwingUtilities.invokeLater(() -> {
                    for (PortListListener listener : FeedbackPortModel.this.portListListeners) {
                        LOGGER.info("Notify listener that the ports have changed: {}", (Object)listener);
                        listener.listChanged();
                    }
                });
            }
        };
    }

    public NodeInterface getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(NodeInterface selectedNode) {
        NodeInterface node;
        if (this.selectedNode != null) {
            node = this.selectedNode;
            LOGGER.trace("Remove pcl from previous selected node: {}", (Object)node);
            node.removePropertyChangeListener("feedbackPorts", this.pclFeedbackPorts);
            node.removePropertyChangeListener("feedbackPortStatus", this.pclFeedbackPort);
            node.removePropertyChangeListener("feedbackPortAddresses", this.pclFeedbackPort);
            node.removePropertyChangeListener("feedbackPortConfidence", this.pclFeedbackPort);
            node.removePropertyChangeListener("feedbackPortDynStates", this.pclFeedbackPort);
        }
        this.selectedNode = selectedNode;
        if (this.selectedNode != null) {
            node = this.selectedNode;
            LOGGER.trace("Add pcl to currently selected node: {}", (Object)node);
            node.addPropertyChangeListener("feedbackPorts", this.pclFeedbackPorts);
            node.addPropertyChangeListener("feedbackPortStatus", this.pclFeedbackPort);
            node.addPropertyChangeListener("feedbackPortAddresses", this.pclFeedbackPort);
            node.addPropertyChangeListener("feedbackPortConfidence", this.pclFeedbackPort);
            node.addPropertyChangeListener("feedbackPortDynStates", this.pclFeedbackPort);
        }
    }

    public void addFeedbackPortListener(FeedbackPortListener feedbackPortListener) {
        this.feedbackPortListeners.add(feedbackPortListener);
    }

    public void removeFeedbackPortListener(FeedbackPortListener feedbackPortListener) {
        this.feedbackPortListeners.remove(feedbackPortListener);
    }

    public void addPortListListener(PortListListener portListListener) {
        this.portListListeners.add(portListListener);
    }

    public void removePortListListener(PortListListener portListListener) {
        this.portListListeners.remove(portListListener);
    }
}

