/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.model;

import java.util.Collection;
import java.util.LinkedList;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Flag;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.listener.FlagListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlagTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(FlagTableModel.class);
    public static final int COLUMN_LABEL = 0;
    public static final int COLUMN_FLAG_INSTANCE = 1;
    private static final String[] COLUMN_NAMES = new String[]{Resources.getString(FlagTableModel.class, (String)"flag"), null};
    private final MainModel mainModel;
    private final Collection<FlagListener> flagListeners = new LinkedList<FlagListener>();

    public FlagTableModel(MainModel mainModel) {
        this.mainModel = mainModel;
        this.setColumnIdentifiers(COLUMN_NAMES);
    }

    public void addFlagListener(FlagListener l) {
        this.flagListeners.add(l);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 0;
    }

    public void addRow(Flag flag) {
        if (flag != null) {
            Object[] rowData = new Object[COLUMN_NAMES.length];
            rowData[0] = flag.getLabel();
            rowData[1] = flag;
            this.addRow(rowData);
        }
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        switch (column) {
            case 0: {
                if (value != null && StringUtils.isBlank((CharSequence)value.toString())) {
                    value = null;
                    LOGGER.info("Set the null value instead of empty string.");
                }
                super.setValueAt(value, row, column);
                Flag flag = (Flag)super.getValueAt(row, 1);
                flag.setLabel(value != null ? value.toString() : null);
                super.setValueAt(flag, row, 1);
                this.fireFlagLabelChanged(row);
            }
        }
    }

    private void fireFlagLabelChanged(int aspectId) {
        for (FlagListener l : this.flagListeners) {
            l.labelChanged(aspectId);
        }
    }
}

